<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BrikBrik extends Model
{
    protected $fillable = ['brik_project_id','brik_property_type_id','brik_type_id','brik_name','property_area','bedroom',	'bathroom',	'accomadation',	'brik_value',	'capital_gain',	'irr','pe_ratio','adults_capacity',	'children_capacity','infent_capacity','pet_capacity','brik_manager_id','brik_rent_cover_image','brik_rent_gallery_images', 'brik_invest_cover_image','brik_invest_gallery_images','per_night_inr', 'per_night_coin','total_coins_per_brik','managed_property'];

    protected $casts = [
        'brik_rent_gallery_images' => 'json',
        'brik_invest_gallery_images' => 'json',
    ];

    public function project()
    {
        return $this->belongsTo(BrikProject::class, 'brik_project_id');
    }

    public function type()
    {
        return $this->belongsTo(BrikType::class, 'brik_type_id');
    }

    public function propertyType()
    {
        return $this->belongsTo(BrikPropertyType::class, 'brik_property_type_id');
    }

    public function brikManager()
    {
        return $this->belongsTo(BrikManager::class, 'brik_manager_id');
    }

    public function amenities()
    {
        return $this->belongsToMany(BrikAmenity::class);
    }

    public function addOnServices()
    {
        return $this->belongsToMany(BrikAddonService::class);
    }

    
    public function brikunits()
    {
        return $this->hasMany(BrikUnit::class, 'brik_id');
    }

    

    public function childRecordCounts()
    {
        return $this->hasMany(BrikUnit::class, 'brik_id')->count();
    }


}
