<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BrikCity extends Model
{
    protected $fillable = ['brik_state_id',	'name',	'icon'];

    public function state()
    {
       return $this->belongsTo(BrikState::class, 'brik_state_id');
    }

    public function clients()
    {
        return $this->hasMany(Client::class, 'city_id');
    }

    public function projects()
    {
        return $this->hasMany(BrikProject::class, 'city_id');
    }

    public function childRecordCounts()
    {
        return $this->hasMany(BrikProject::class, 'city_id')->count();
    }
}


