<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BrikManager extends Model
{
    protected $fillable = ['name','image','designation','email','phone'];

    public function brik_managers()
    {
        return $this->hasMany(BrikBrik::class, 'brik_manager_id');
    }

    public function property_managers()
    {
        return $this->hasMany(BrikProject::class, 'project_manager_id');
    }

    public function relationship_managers()
    {
        return $this->hasMany(BrikOwner::class, 'relationship_manager_id');
    }

    public function childRecordCounts()
    {
        return $this->hasMany(BrikBrik::class, 'brik_manager_id')->count() + 
        $this->hasMany(BrikProject::class, 'project_manager_id')->count() +
        $this->hasMany(BrikOwner::class, 'relationship_manager_id')->count();
    }
}
