<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BrikOwner extends Model
{
    protected $fillable = ['invested_amount','ownership','ownership_outof','ownership_sq','ownership_number','brik_buy_date','spv','spv_formation_date','referrer_id','relationship_manager_id','remark','disabled','brik_id','owner_id','brik_unit_id'];

    public function brik_unit()
    {
        return $this->belongsTo(BrikUnit::class, 'brik_unit_id');
    }

    public function owner()
    {
        return $this->belongsTo(Client::class, 'owner_id');
    }

    public function referrer()
    {
        return $this->belongsTo(Client::class, 'referrer_id');
    }

    public function relationship_manager()
    {
        return $this->belongsTo(BrikManager::class, 'relationship_manager_id');
    }

    public function payment_plan()
    {
        return $this->hasOne(BrikPaymentmyplan::class, 'brik_owner_id');
    }

    public function annual_maintenances()
    {
        return $this->hasMany(BrikAnnualMaintenance::class, 'brik_owner_id');
    }

    public function referral_insentive()
    {
        return $this->hasOne(ReferralInsentive::class, 'brik_owner_id');
    }

    public function cash_wallet_transaction()
    {
        return $this->hasOne(CashWalletTransaction::class, 'brik_owner_id');
    }

    public function childRecordCounts()
    {
        return ($this->payment_plan()->count() + 
        $this->annual_maintenances()->count() + 
        $this->referral_insentive()->count() +
        $this->cash_wallet_transaction()->count());
    }


    protected static function booted()
    {
        static::created(function ($record) {
            
            $select_name = '';

            $owner = Client::find($record->owner_id);
            $brikunit = BrikUnit::find($record->brik_unit_id);
            if($owner && $brikunit){
                $select_name = $record->ownership_number.' - '.$owner->full_name.' - '.$brikunit->unit_name.' - '.$record->spv; 
            }else{
                $select_name = $record->ownership_number.' - '.$record->spv; 
            }

            BrikOwner::where('id', $record->id)->update(['select_name' => $select_name]);
        });

        static::updated(function ($record) {
            
            $select_name = '';

            $owner = Client::find($record->owner_id);
            $brikunit = BrikUnit::find($record->brik_unit_id);
            if($owner && $brikunit){
                $select_name = $record->ownership_number.' - '.$owner->full_name.' - '.$brikunit->unit_name.' - '.$record->spv; 
            }else{
                $select_name = $record->ownership_number.' - '.$record->spv; 
            }

            BrikOwner::where('id', $record->id)->update(['select_name' => $select_name]);
            
        });
    }
}
