<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BrikPaymentmyplan extends Model
{
    protected $fillable = ['invested_amount','brik_count','booking_amount','booking_amount_paid','gst_paid',	'payment_date','booking_amount_balance','plan_name','discount_booking','discount_brik','brik_sale_referal_discount','no_of_installments','plan_tenure','disclaimer','plan_details','brik_owner_id'];

    public function brik_owner(){
        return $this->belongsTo(BrikOwner::class, 'brik_owner_id');
    }

    protected static function booted()
    {
        static::created(function ($record) {
            
            $brik_owner = BrikOwner::find($record->brik_owner_id);
            $brik_owner->paymentmyplan_id = $record->id;
            $brik_owner->save();

            $payment = BrikPaymentmyplan::find($record->id);
            $payment->name = $brik_owner->select_name;
            $payment->save();

            if($record->no_of_installments){

                $i = 0;
                while($record->no_of_installments > $i){

                    $installments = new BrikInstallment;
                    $installments->payment_plan_id = $record->id;
                    $installments->installment = $i+1;
                    $installments->save();

                    $i++;
                }

            }

        });

        static::updated(function ($record) {
            
            // $brik_owner = BrikOwner::find($record->brik_owner_id);
            // $brik_owner->paymentmyplan_id = $record->id;
            // $brik_owner->save();
            
        });
    }
}
