<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BrikState extends Model
{
    protected $fillable = ['name'];

    public function cities()
    {
        return $this->hasMany(BrikCity::class, 'brik_state_id');
    }

    public function clients()
    {
        return $this->hasMany(Client::class, 'state_id');
    }

    public function projects()
    {
        return $this->hasMany(BrikProject::class, 'state_id');
    }


    public function childRecordCounts()
    {
        return $this->hasMany(BrikCity::class, 'brik_state_id')->count() + 
               $this->hasMany(BrikProject::class, 'state_id')->count();
    }
}
