<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CashWalletTransaction extends Model
{
    protected $fillable = ['client_id',	'amount', 'type', 'category', 'date', 'remark',	'signed_amount'	];

    public function client()
    {
        return $this->belongsTo(Client::class, 'client_id');
    }

    protected static function booted()
    {
        static::created(function ($record) {
           
            $sum = CashWalletTransaction::where('client_id', $record->client_id)->sum('signed_amount');
            $upd = Client::find($record->client_id);
            $upd->wallet_amount = $sum;
            $upd->save();
             
        });

        static::updated(function ($record) {

            $sum = CashWalletTransaction::where('client_id', $record->client_id)->sum('signed_amount');
            $upd = Client::find($record->client_id);
            $upd->wallet_amount = $sum;
            $upd->save();

        });

        static::deleted(function ($record) {

            $sum = CashWalletTransaction::where('client_id', $record->client_id)->sum('signed_amount');
            $upd = Client::find($record->client_id);
            $upd->wallet_amount = $sum;
            $upd->save();
            
        });

        
    }
}
