<?php

namespace App\Models;

use Laravel\Passport\HasApiTokens;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Model;

class Client extends Authenticatable
{
    use HasApiTokens;

    protected $fillable = ['first_name','last_name','dob','address','state','city','pin','email','mobile','otp','gender','image','is_owner'];


    // public function state()
    // {
    //     return $this->belongsTo(BrikState::class, 'state_id');
    // }

    // public function city()
    // {
    //     return $this->belongsTo(BrikCity::class, 'city_id');
    // }

    public function bank()
    {
        return $this->hasOne(ClientBankDetail::class, 'client_id');
    }

    public function nominee()
    {
        return $this->hasOne(ClientNomineeDetail::class, 'client_id');
    }

    public function identities()
    {
        return $this->hasMany(ClientIdDetail::class, 'client_id');
    }

    public function brikowners()
    {
        return $this->hasMany(BrikOwner::class, 'owner_id');
    }

    public function childRecordCounts()
    {
        return $this->hasMany(BrikOwner::class, 'owner_id')->count();
    }


}
