<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class InvestPropertyDetail extends Model
{
    protected $fillable = ['brik_project_id','brik_id','description','invest_portal_display_name','slug','property_area','bedroom',	'bathroom',	'possession_status','target_rental_yield','status','booking_amount','brik_value','capital_gain','irr','pe_ratio','adults_capacity',	'children_capacity','cover_image','gallery_images','about_property','payment_plan','bifurcation_of_unit_cost','status'];

    protected $casts = [
        'gallery_images' => 'json',
        'payment_plan' => 'json',
        'bifurcation_of_unit_cost' => 'json',
        'metadata' => 'json'
    ];

    public function project()
    {
        return $this->belongsTo(BrikProject::class, 'brik_project_id');
    }

    public function brik()
    {
        return $this->belongsTo(BrikBrik::class, 'brik_id');
    }

    public function amenities()
    {
        return $this->belongsToMany(BrikAmenity::class);
    }

    public function invest_metadata()
    {
        return $this->hasOne(InvestPropertyMetadataDetail::class, 'invest_property_detail_id');
    }
}
