<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RentPromotionSetting extends Model
{
    
    protected $fillable = ['name', 'text','image','url','active'];

    protected static function booted()
    {
        static::created(function ($record) {
            if($record->active){
                RentPromotionSetting::where('id', '!=', $record->id)->update(['active' => 0]);
             }
        });

        static::updated(function ($record) {
            if($record->active){
                RentPromotionSetting::where('id', '!=', $record->id)->update(['active' => 0]);
             }
        });
    }
}
