<!DOCTYPE html>
<html lang="en">
  <head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <title>Installment Payment Confirmation Email</title>
    <style media="all" type="text/css">
      /* -------------------------------------
    GLOBAL RESETS
------------------------------------- */

      body {
        font-family: Helvetica, sans-serif;
        -webkit-font-smoothing: antialiased;
        font-size: 16px;
        line-height: 1.3;
        -ms-text-size-adjust: 100%;
        -webkit-text-size-adjust: 100%;
      }

      table {
        border-collapse: separate;
        mso-table-lspace: 0pt;
        mso-table-rspace: 0pt;
        width: 100%;
      }

      table td {
        font-family: Helvetica, sans-serif;
        font-size: 16px;
        vertical-align: top;
      }
      /* -------------------------------------
    BODY & CONTAINER
------------------------------------- */

      body {
        background-color: #f4f5f6;
        margin: 0;
        padding: 0;
      }

      .body {
        background-color: #f4f5f6;
        width: 100%;
      }

      .container {
        margin: 0 auto !important;
        max-width: 600px;
        padding: 0;
        padding-top: 24px;
        width: 600px;
      }

      .content {
        box-sizing: border-box;
        display: block;
        margin: 0 auto;
        max-width: 600px;
        padding: 0;
      }
      /* -------------------------------------
    HEADER, FOOTER, MAIN
------------------------------------- */

      .main {
        background: #ffffff;
        border: 1px solid #eaebed;
        border-radius: 16px;
        width: 100%;
      }

      .wrapper {
        box-sizing: border-box;
        padding: 24px;
      }

      .footer {
        clear: both;
        padding-top: 24px;
        text-align: center;
        width: 100%;
      }

      .footer td,
      .footer p,
      .footer span,
      .footer a {
        color: #9a9ea6;
        font-size: 16px;
        text-align: center;
      }
      /* -------------------------------------
    TYPOGRAPHY
------------------------------------- */

      p {
        font-family: Helvetica, sans-serif;
        font-size: 16px;
        font-weight: normal;
        margin: 0;
        margin-bottom: 16px;
      }

      a {
        color: #0867ec;
        text-decoration: underline;
      }
      /* -------------------------------------
    BUTTONS
------------------------------------- */

      .btn {
        box-sizing: border-box;
        min-width: 100% !important;
        width: 100%;
      }

      .btn > tbody > tr > td {
        padding-bottom: 16px;
      }

      .btn table {
        width: auto;
      }

      .btn table td {
        background-color: #ffffff;
        border-radius: 4px;
        text-align: center;
      }

      .btn a {
        background-color: #ffffff;
        border: solid 2px #0867ec;
        border-radius: 4px;
        box-sizing: border-box;
        color: #0867ec;
        cursor: pointer;
        display: inline-block;
        font-size: 16px;
        font-weight: bold;
        margin: 0;
        padding: 12px 24px;
        text-decoration: none;
        text-transform: capitalize;
      }

      .btn-primary table td {
        background-color: #0867ec;
      }

      .btn-primary a {
        background-color: #0867ec;
        border-color: #0867ec;
        color: #ffffff;
      }

      @media all {
        .btn-primary table td:hover {
          background-color: #ec0867 !important;
        }
        .btn-primary a:hover {
          background-color: #ec0867 !important;
          border-color: #ec0867 !important;
        }
      }

      /* -------------------------------------
    OTHER STYLES THAT MIGHT BE USEFUL
------------------------------------- */

      .last {
        margin-bottom: 0;
      }

      .first {
        margin-top: 0;
      }

      .align-center {
        text-align: center;
      }

      .align-right {
        text-align: right;
      }

      .align-left {
        text-align: left;
      }

      .text-link {
        color: #0867ec !important;
        text-decoration: underline !important;
      }

      .clear {
        clear: both;
      }

      .mt0 {
        margin-top: 0;
      }

      .mb0 {
        margin-bottom: 0;
      }

      .preheader {
        color: transparent;
        display: none;
        height: 0;
        max-height: 0;
        max-width: 0;
        opacity: 0;
        overflow: hidden;
        mso-hide: all;
        visibility: hidden;
        width: 0;
      }

      .powered-by a {
        text-decoration: none;
      }

      /* -------------------------------------
    RESPONSIVE AND MOBILE FRIENDLY STYLES
------------------------------------- */

      @media only screen and (max-width: 640px) {
        .main p,
        .main td,
        .main span {
          font-size: 16px !important;
        }
        .wrapper {
          padding: 8px !important;
        }
        .content {
          padding: 0 !important;
        }
        .container {
          padding: 0 !important;
          padding-top: 8px !important;
          width: 100% !important;
        }
        .main {
          border-left-width: 0 !important;
          border-radius: 0 !important;
          border-right-width: 0 !important;
        }
        .btn table {
          max-width: 100% !important;
          width: 100% !important;
        }
        .btn a {
          font-size: 16px !important;
          max-width: 100% !important;
          width: 100% !important;
        }
      }
      /* -------------------------------------
    PRESERVE THESE STYLES IN THE HEAD
------------------------------------- */

      @media all {
        .ExternalClass {
          width: 100%;
        }
        .ExternalClass,
        .ExternalClass p,
        .ExternalClass span,
        .ExternalClass font,
        .ExternalClass td,
        .ExternalClass div {
          line-height: 100%;
        }
        .apple-link a {
          color: inherit !important;
          font-family: inherit !important;
          font-size: inherit !important;
          font-weight: inherit !important;
          line-height: inherit !important;
          text-decoration: none !important;
        }
        #MessageViewBody a {
          color: inherit;
          text-decoration: none;
          font-size: inherit;
          font-family: inherit;
          font-weight: inherit;
          line-height: inherit;
        }
      }
    </style>
  </head>
  <body>
    <table
      role="presentation"
      border="0"
      cellpadding="0"
      cellspacing="0"
      class="body"
    >
      <tr>
        <td>&nbsp;</td>
        <td class="container">
          <div class="content">
            <!-- START CENTERED WHITE CONTAINER -->
            <span class="preheader"
              >A installment payment has been successfully confirmed.</span
            >
            <table
              role="presentation"
              border="0"
              cellpadding="0"
              cellspacing="0"
              class="main"
            >
              <!-- START MAIN CONTENT AREA -->
              <tr>
                <td class="wrapper">
                  <div style="padding-bottom: .4rem; text-align: center;">
                    <!-- <img src="" alt=""> -->
                    <span style="font-weight: 800;">BRIK itt</span>
                  </div>
                  <p>Dear {{$guest->print_name}},</p>
                  <p>
                    This is to acknowledge the receipt of a partial payment of ₹{{$installmentpay->paid_amount}} towards your installment for {{$installment->paymentPlan->brik_owner->brik_unit->project->project_name}}.
                  </p>
                  <p>
                    Please find the payment details below:
                  </p>
                  {{-- <table
                    role="presentation"
                    border="0"
                    cellpadding="0"
                    cellspacing="0"
                    class="btn btn-primary"
                  >
                    <tbody>
                      <tr>
                        <td align="left">
                          <table
                            role="presentation"
                            border="0"
                            cellpadding="0"
                            cellspacing="0"
                          >
                            <tbody>
                              <tr>
                                <td>
                                  <a href="http://htmlemail.io" target="_blank"
                                    >Call To Action</a
                                  >
                                </td>
                              </tr>
                            </tbody>
                          </table>
                        </td>
                      </tr>
                    </tbody>
                  </table> --}}

                {{--
                <h4><u>Guest Details</u></h4>
                <table
                    role="presentation"
                    cellpadding="0"
                    cellspacing="0"
                    style="border: 1px solid #ccc; border-radius: 12px;">
                        <!-- name  -->
                        <tr>
                        <th style="text-align: left; border-right: 1px solid #ccc; padding: .4rem; border-bottom: 1px solid #ccc;">Guest Name:</th>
                        <td style="padding: .4rem; border-bottom: 1px solid #ccc;">{{$guest->print_name}}</td>
                        </tr>
                        <!-- Email  -->
                        <tr>
                        <th style="text-align: left; border-right: 1px solid #ccc; padding: .4rem; border-bottom: 1px solid #ccc;">Email:</th>
                        <td style="padding: .4rem; border-bottom: 1px solid #ccc;">{{$guest->email}}</td>
                        </tr>
                        <!-- Phone  -->
                        <tr>
                        <th style="text-align: left; border-right: 1px solid #ccc; padding: .4rem; border-bottom: 1px solid #ccc;">Phone:</th>
                        <td style="padding: .4rem; border-bottom: 1px solid #ccc;">{{$guest->mobile}}</td>
                        </tr>

                </table>
                --}}

                <h4><u>Payment Details</u></h4>


                <table
                    role="presentation"
                    cellpadding="0"
                    cellspacing="0"
                    style="border: 1px solid #ccc; border-radius: 12px;margin-bottom: 15px;">


                        <!-- Project  -->
                        <tr>
                        <th style="width: 50%; text-align: left; border-right: 1px solid #ccc; padding: .4rem; border-bottom: 1px solid #ccc;">Project:</th>
                        <td style="padding: .4rem; border-bottom: 1px solid #ccc;">{{$installment->paymentPlan->brik_owner->brik_unit->project->project_name}}</td>
                        </tr>
                        <!-- Installment No.  -->
                        <tr>
                        <th style="width: 50%; text-align: left; border-right: 1px solid #ccc; padding: .4rem; border-bottom: 1px solid #ccc;">Installment no.:</th>
                        <td style="padding: .4rem; border-bottom: 1px solid #ccc;">{{$installment->installment}}</td>
                        </tr>
                        <!-- Amount Received  -->
                        <tr>
                        <th style="width: 50%; text-align: left; border-right: 1px solid #ccc; padding: .4rem; border-bottom: 1px solid #ccc;">Amount Received:</th>
                        <td style="padding: .4rem; border-bottom: 1px solid #ccc;">{{$installmentpay->paid_amount}}</td>
                        </tr>

                        <!-- Payment Date  -->
                        <tr>
                        <th style="width: 50%; text-align: left; border-right: 1px solid #ccc; padding: .4rem; border-bottom: 1px solid #ccc;">Payment Date:</th>
                        <td style="padding: .4rem; border-bottom: 1px solid #ccc;">{{date("d-m-Y", strtotime($installmentpay->date))}}</td>
                        </tr>

                        <!-- Pending Amount -->
                        <tr>
                        <th style="width: 50%; text-align: left; border-right: 1px solid #ccc; padding: .4rem; border-bottom: 1px solid #ccc;">Pending Amount:</th>
                        <td style="padding: .4rem; border-bottom: 1px solid #ccc;">{{$installment->balance_amount}}</td>
                        </tr>

                    </table>

                    <p>
                        We sincerely thank you for the payment. Kindly arrange to pay the remaining balance of ₹{{$installment->balance_amount}} at your earliest convenience.
                    </p>




                    <p>
                        If you have any questions or require further assistance, feel free to get in touch with us.
                    </p>

                    <p style="color: grey">
                        Warm regards,<br>
                        BRIK itt Proptech Pvt.Ltd.<br>
                        8 Flat-204 Tata Rio De Goa Near Mes College Dabolim-403726
                    </p>


                </td>
              </tr>
              <!-- END MAIN CONTENT AREA -->
            </table>

            <!-- START FOOTER -->
            <div class="footer">
              <table
                role="presentation"
                border="0"
                cellpadding="0"
                cellspacing="0"
              >
                <tr>
                  <td class="content-block">
                    <span>
                      BRIK itt Proptech Pvt.Ltd.
                    </span>
                    <br />
                    <span class="apple-link"
                      >8 Flat-204 Tata Rio De Goa Near Mes College Dabolim-403726</span
                    >
                    <br />
                    Our Email
                    <a href="mailto:reservations@brikitt.com">reservations@brikitt.com</a>.
                  </td>
                </tr>
                <tr>
                  <td class="content-block powered-by">
                    Phone <a href="tel:9219965827">+91 9219965827</a>
                    <!-- <br />
                    <span>
                      BRIK itt Proptech Pvt.Ltd.
                    </span> -->
                  </td>
                </tr>
              </table>
            </div>

            <!-- END FOOTER -->

            <!-- END CENTERED WHITE CONTAINER -->
          </div>
        </td>
        <td>&nbsp;</td>
      </tr>
    </table>
  </body>
</html>
