<?php

namespace App\Actions\Payment;

use App\Models\InvestPropertyBooking;

class InvestBookingPayment
{
    //public $mode = 1; // 1 if production
	public $tid;
	public $currency = 'INR';

    //Production
    // public $merchant_id = "3041703";
    // public $access_code = "AVTB71LC02BB06BTBB";
    // public $working_key = "36829F0B4D23BDF3A0B9BB812E9DE001";
    // public $url_domain = "https://secure.ccavenue.com";


    //Test
    public $merchant_id = "3041703";
    public $access_code = "ATRU06MF36AD27URDA";
    public $working_key = "4289B586DB04157D150FDB6906A0FB10";
    public $url_domain = "https://test.ccavenue.com";

	public $return_url;
	public $cancel_url;

	public function __construct(){
		$this->tid = (time() * 1000);
		$this->return_url = route('invest.paymentreturn');
		$this->cancel_url = route('invest.paymentcancel');
	}



    /*
* @param1 : Plain String
* @param2 : Working key provided by CCAvenue
* @return : Decrypted String
*/
public function encrypt($plainText,$key)
{
	$key = $this->hextobin(md5($key));
	$initVector = pack("C*", 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f);
	$openMode = openssl_encrypt($plainText, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $initVector);
	$encryptedText = bin2hex($openMode);
	return $encryptedText;
}

/*
* @param1 : Encrypted String
* @param2 : Working key provided by CCAvenue
* @return : Plain String
*/
public function decrypt($encryptedText,$key)
{
	$key = $this->hextobin(md5($key));
	$initVector = pack("C*", 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f);
	$encryptedText = $this->hextobin($encryptedText);
	$decryptedText = openssl_decrypt($encryptedText, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $initVector);
	return $decryptedText;
}

public function hextobin($hexString)
 {
	$length = strlen($hexString);
	$binString="";
	$count=0;
	while($count<$length)
	{
	    $subString =substr($hexString,$count,2);
	    $packedString = pack("H*",$subString);
	    if ($count==0)
	    {
			$binString=$packedString;
	    }

	    else
	    {
			$binString.=$packedString;
	    }

	    $count+=2;
	}
        return $binString;
  }

  public function generateLink($booking)
  {

	    $encrypted_data = $this->merchantdata($booking);


		$url = $this->url_domain.'/transaction/transaction.do?command=initiateTransaction&encRequest='.$encrypted_data.'&access_code='.$this->access_code;

		//dd($url);
		return $url;

  }

  public function merchantdata($booking)
  {

		$merchant_data ="tid={$this->tid}&merchant_id={$this->merchant_id}&order_id={$booking->order_no}&amount={$booking->amount}&currency={$this->currency}&redirect_url={$this->return_url}&cancel_url={$this->cancel_url}&language=EN&billing_name={$booking->name}&billing_address={$booking->city},{$booking->state}&billing_city={$booking->city}&billing_state={$booking->state}&billing_zip={$booking->zip_code}&billing_country=India&billing_tel={$booking->phone}&billing_email={$booking->email}&delivery_name={$booking->name}&delivery_address={$booking->city},{$booking->state}&delivery_city={$booking->city}&delivery_state={$booking->state}&delivery_zip={$booking->zip_code}&delivery_country=India&delivery_tel={$booking->phone}&merchant_param1=&merchant_param2=&merchant_param3=&merchant_param4=&merchant_param5=&promo_code=&customer_identifier=&integration_type=iframe_normal";

		//dd($merchant_data);

	    return $this->encrypt($merchant_data,$this->working_key);
  }

  public function paymentReturn($response)
  {
	$workingKey = $this->working_key;		//Working Key should be provided here.
	$encResponse = $response->encResp;			//This is the response sent by the CCAvenue Server
	$rcvdString = $this->decrypt($encResponse,$workingKey);		//Crypto Decryption used as per the specified working key.
	$order_status="";
    $order_no="";
    $order_tracking_id="";
	$decryptValues=explode('&', $rcvdString);
	$dataSize=sizeof($decryptValues);
    $msg = '';
    $status = false;

    for($i = 0; $i < $dataSize; $i++)
	{
		$information=explode('=',$decryptValues[$i]);

		if($i==3){
            $order_status=$information[1];
        }

        if($i==1){
            $order_tracking_id=$information[1];
        }

        if($i==0){
            $order_no=$information[1];
        }
    }

    if($order_status==="Success")
	{
		$msg = "The transaction has been done.";
        $status = true;

	}
	else if($order_status==="Aborted")
	{
		$msg = "The transaction has been aborted.";

	}
	else if($order_status==="Failure")
	{
		$msg = "The transaction has been declined.";
	}
	else
	{
		$msg = "Security Error. Illegal access detected";
    }

    $qry = InvestPropertyBooking::where('order_no', $order_no)->first();
    if($qry)
    {
        $upd = InvestPropertyBooking::find($qry->id);
        $upd->payment_status = $order_status;
        $upd->txn_no = $order_tracking_id;
        $upd->save();

        return $upd->id;
    }

    return null;

  }

  public function paymentCancel($response)
  {
	$workingKey = $this->working_key;		//Working Key should be provided here.
	$encResponse = $response->encResp;			//This is the response sent by the CCAvenue Server
	$rcvdString = $this->decrypt($encResponse,$workingKey);		//Crypto Decryption used as per the specified working key.
	$order_status="";
    $order_no="";
    $order_tracking_id="";
	$decryptValues=explode('&', $rcvdString);
    //dd($decryptValues);
	$dataSize=sizeof($decryptValues);
    $msg = '';
    $status = false;

    for($i = 0; $i < $dataSize; $i++)
	{
		$information=explode('=',$decryptValues[$i]);

		if($i==3){
            $order_status=$information[1];
        }

        if($i==1){
            $order_tracking_id=$information[1];
        }

        if($i==0){
            $order_no=$information[1];
        }
    }

    //dd($order_status);




    $qry = InvestPropertyBooking::where('order_no', $order_no)->first();
    if($qry)
    {
        $upd = InvestPropertyBooking::find($qry->id);
        $upd->payment_status = $order_status;
        $upd->txn_no = $order_tracking_id;
        $upd->save();

        return $upd->id;
    }

    return null;

  }


}
