<?php

namespace App\Actions\RU;

use App\Models\BookingBooking;
use Illuminate\Support\Facades\DB;
use App\Models\RentalsUnitedConfig;

class RU {

    private $username;
    private $password;
    private $owner_id;

    public function __construct()
    {
        $config = RentalsUnitedConfig::find(1);
        $this->username = $config->username;
        $this->password = $config->password;

        if(is_null($config->owner_id)){
            $owner_id = $this->getOwner();
            if($owner_id){
                $this->setOwner($owner_id);
            }
        }
    }

    // Check before booking
    public function isBookingDatesBlocked($pid, $from_date, $to_date)
    {
        $is_blocked = false;
        $ru = new RentalsUnited($this->username,$this->password);
        $avls = $ru->ListPropertyAvailabilityCalendar($pid, $from_date,$to_date);
        $xml = simplexml_load_string($avls['messages']);
        $result = XmlToJson::toArray($xml);
        if(array_key_exists("PropertyCalendar", $result)){
            if(array_key_exists("CalDay", $result["PropertyCalendar"])){
                foreach($result["PropertyCalendar"]["CalDay"] as $day){
                    if($day["IsBlocked"] == 'true'){
                        $is_blocked = true;
                        return $is_blocked;
                    }
                }
            }
        }
        return $is_blocked;
    }

    public function getPropertyPrices($pid, $from, $to)
    {
        $ru = new RentalsUnited($this->username,$this->password);
        $prices = $ru->ListPropertyPrices($pid, $from, $to);
        $xml = simplexml_load_string($prices['messages']);
        $results = XmlToJson::toArray($xml);
        return $results;
   }

    public function setPropertyPrices($pid, $from, $to, $price, $extra)
    {
        $ru = new RentalsUnited($this->username,$this->password);
        $prices = $ru->PushPropertyPrice($pid, $from, $to, $price, $extra);
        $xml = simplexml_load_string($prices['messages']);
        $results = XmlToJson::toArray($xml);
        if(array_key_exists("Status", $results)){

            if(array_key_exists("ID", $results["Status"])){
                if($results["Status"]["ID"] == 0){
                    return true;
                }
            }

        }

        return false;
   }



    public function booking($record)
    {

        $pid = $record["pid"];
        $from_date = $record["from_date"];
        $to_date = $record["to_date"];
        $num_guests = $record["num_guests"];
        $ru_price = $record["ru_price"];
        $client_price = $record["client_price"];
        $already_paid = $record["already_paid"];
        $name = $record["name"];
        $sur_name = $record["sur_name"];
        $email = $record["email"];
        $phone = $record["phone"];
        $address = $record["address"];

        $ru = new RentalsUnited($this->username,$this->password);
        $booking = $ru->PutConfirmedReservationMulti(
            $pid, $from_date, $to_date, $num_guests,
            $ru_price, $client_price, $already_paid,
            $name, $sur_name,
            $email, $phone, $address, $zipcode="", $countryId="",
            $skype_id="", $comments=""
          );
        $xml = simplexml_load_string($booking['messages']);
        $results = XmlToJson::toArray($xml);
        //dd($results);
        if(array_key_exists("Status", $results)){

            if(array_key_exists("ID", $results["Status"])){

                if($results["Status"]["ID"] == 0){

                    return [
                             "status_id" => 0,
                             "status_value" => $results["Status"]["value"],
                             "reservation_id" =>  $results["ReservationID"]
                            ];

                }elseif($results["Status"]["ID"] == 34){
                    // Need to set price to ru than hit booking
                    return [
                             "status_id" => 34,
                             "status_value" => $results["Status"]["value"],
                             "reservation_id" =>  null
                            ];

                }elseif($results["Status"]["ID"] == 3){
                    // Need to set price to ru than hit booking
                    return [
                             "status_id" => 3,
                             "status_value" => $results["Status"]["value"],
                             "reservation_id" =>  null
                            ];

                }
            }


        }

        return [
            "status_id" => null,
            "status_value" => null,
            "reservation_id" =>  null
           ];

    }

    public function coinBooking($booking){

        $ru_price = 0.1;
        $ru_set_property_price = $this->setPropertyPrices($booking->brik_unit->ru_property_id, $booking->date_check_in, $booking->date_check_out, $ru_price, 0);
        if($ru_set_property_price){

            $record = [
                "pid" => $booking->brik_unit->ru_property_id,
                "from_date" => $booking->date_check_in,
                "to_date" => $booking->date_check_out,
                "num_guests" => ($booking->adult + $booking->children),
                "ru_price" => $ru_price,
                "client_price" => 0,
                "already_paid" => $ru_price,
                "name" => $booking->client ? $booking->client->first_name : '',
                "sur_name" => $booking->client ? $booking->client->last_name : '',
                "email" => $booking->client ? ( $booking->client->email ? $booking->client->email : 'customer@brikitt.com' ) : 'customer@brikitt.com',
                "phone" => $booking->client ? $booking->client->phone : '',
                "address" => $booking->client ? $booking->client->address : '',
            ];

            $ru_reservation = $this->booking($record);

            $upd = BookingBooking::find($booking->id);
            $upd->ru_reservation_id = $ru_reservation["reservation_id"];
            $upd->ru_reservation_status = $ru_reservation["status_value"];
            $upd->save();

        }


    }

    public function amountBooking($booking){

        $record = [
            "pid" => $booking->brik_unit->ru_property_id,
            "from_date" => $booking->date_check_in,
            "to_date" => $booking->date_check_out,
            "num_guests" => ($booking->adult + $booking->children),
            "ru_price" => (float)$booking->net_payable_amount,
            "client_price" => 0,
            "already_paid" => (float)$booking->net_payable_amount,
            "name" => $booking->client ? $booking->client->first_name : '',
            "sur_name" => $booking->client ? $booking->client->last_name : '',
            "email" => $booking->client ? ( $booking->client->email ? $booking->client->email : 'customer@brikitt.com' ) : 'customer@brikitt.com',
            "phone" => $booking->client ? $booking->client->phone : '',
            "address" => $booking->client ? $booking->client->address : '',
        ];

        $ru_reservation = $this->booking($record);
        if($ru_reservation["status_id"] == 0){
            $upd = BookingBooking::find($booking->id);
            $upd->ru_reservation_id = $ru_reservation["reservation_id"];
            $upd->ru_reservation_status = $ru_reservation["status_value"];
            $upd->save();
        }else if($ru_reservation["status_id"] == 34 || $ru_reservation["status_id"] == 3){
            DB::table('ru_errors')->insert([
                 "booking_id" => $booking->id,
                 "status_id" => $ru_reservation["status_id"],
                 "errors" => $ru_reservation["status_value"],
                ]);
            $price_amount = (float)($booking->payable_amount / $booking->booking_night_counts);
            $ru_set_property_price = $this->setPropertyPrices($booking->brik_unit->ru_property_id, $booking->date_check_in, $booking->date_check_out, $price_amount, 0);
            if($ru_set_property_price){
                $ru_reservation = $this->booking($record);
                if($ru_reservation["status_id"] == 0){

                    $upd = BookingBooking::find($booking->id);
                    $upd->ru_reservation_id = $ru_reservation["reservation_id"];
                    $upd->ru_reservation_status = $ru_reservation["status_value"];
                    $upd->save();

                }
            }
        }


    }

    public function getReservations($from_dt, $to_dt)
    {
        $res = [];
        $ru = new RentalsUnited($this->username,$this->password);
        $reservations = $ru->ListReservations($from_dt, $to_dt);
        $xml = simplexml_load_string($reservations['messages']);
        $results = XmlToJson::toArray($xml);

        if(array_key_exists("Status", $results)){

            if(array_key_exists("ID", $results["Status"])){

                if($results["Status"]["ID"] != 0){

                    return $res;

                }
            }
        }

        if(array_key_exists("Reservations", $results)){

            try{

                if(array_key_exists(0, $results["Reservations"]["Reservation"]))
                {

                    $res = $results["Reservations"]["Reservation"];

                }else{

                    $res[0] = $results["Reservations"]["Reservation"];
                }

            }catch(\Exception $e){
                $res = [];
            }

        }

        return $res;

    }

	public function cancelBooking($booking){

        if($booking->ru_reservation_id){

            $ru = new RentalsUnitedBase($this->username,$this->password);
            $booking = $ru->cancelBooking($booking->ru_reservation_id);
            $xml = simplexml_load_string($booking['messages']);

            $results = XmlToJson::toArray($xml);

            if(array_key_exists("Status", $results))
            {
                if(array_key_exists("ID", $results["Status"])){

                    if($results["Status"]["ID"] == 0){
                        return true;
                    }

                }
            }

        }

        return false;

    }

    private function getOwner()
    {
        $owner_id = null;
        $ru = new RentalsUnitedBase($this->username,$this->password);
        $owners = $ru->getOwners();
        $xml = simplexml_load_string($owners['messages']);
        $results = XmlToJson::toArray($xml);
        if (array_key_exists("Owners", $results)){
            if (array_key_exists("Owner", $results["Owners"])){
                if (array_key_exists("OwnerID", $results["Owners"]["Owner"])){
                    $owner_id =  $results["Owners"]["Owner"]["OwnerID"];
                }
            }
        }
        return $owner_id;
    }

    private function setOwner($owner_id)
    {
        $config = RentalsUnitedConfig::find(1);
        $config->owner_id = $owner_id;
        $config->save();
    }

    public function setRLNM(){

        $ru = new RentalsUnitedBase($this->username,$this->password);
        $reg = $ru->registerLNM();
        $xml = simplexml_load_string($reg['messages']);

        $results = XmlToJson::toArray($xml);
        dd($results);
    }


}
