<?php

namespace App\Actions\RU;

class XmlToJson {  
  
  
    public static function toArray($xml) 
    {
        $result = [];

        // Handle namespaces (attributes)
        foreach ($xml->getNamespaces(true) as $prefix => $namespace) {
            foreach ($xml->attributes($namespace) as $attrName => $attrValue) {
                $key = $prefix ? "$prefix:$attrName" : $attrName;
                $result[$key] = (string)$attrValue;
            }
        }

        // Handle default attributes
        foreach ($xml->attributes() as $attrName => $attrValue) {
            $result[$attrName] = (string)$attrValue;
        }

        // Handle children (including namespaces)
        $children = [];
        foreach ($xml->getNamespaces(true) as $prefix => $namespace) {
            foreach ($xml->children($namespace) as $child) {
                $children[] = $child;
            }
        }

        foreach ($xml->children() as $child) {
            $children[] = $child;
        }

        foreach ($children as $child) {
            $childName = $child->getName();
            $childArray = self::toArray($child);

            if (isset($result[$childName])) {
                if (!is_array($result[$childName]) || !array_key_exists(0, $result[$childName])) {
                    $result[$childName] = [$result[$childName]];
                }
                $result[$childName][] = $childArray;
            } else {
                $result[$childName] = $childArray;
            }
        }

        // Handle CDATA or text value
        $textContent = trim((string)$xml);
        if (!count($children) && $textContent !== '') {
            if (empty($result)) {
                return $textContent;
            } else {
                $result['value'] = $textContent;
            }
        }

        return $result;
    }

    public function throwResponse($x)
    {
        $xml = simplexml_load_string($x['messages']);
        $array = [$xml->getName() => $this->toArray($xml)];
        $json = json_encode($array, JSON_PRETTY_PRINT);

        return json_decode($json);
    }

}