<?php

namespace App\Actions\Utility;

use App\Models\BrikUnit;
use GuzzleHttp\Client;
use GuzzleHttp\Psr7\Request;
use App\Models\RuPropertyPrice;

class BookingDynamicPrice
{
    
	public $brik_unit_id;
	public $checkin_dt;
	public $checkout_dt;
	public $result = [];

	public function __construct($brik_unit_id, $checkin_dt, $checkout_dt)
	{
		$this->brik_unit_id = $brik_unit_id;
		$this->checkin_dt = $checkin_dt;
		$this->checkout_dt = $checkout_dt;
	}
	
    public function extractDates()
    {
		$start_ts = strtotime($this->checkin_dt);
        $end_ts = strtotime($this->checkout_dt);
       
        $booking_dates = [];
        $booking_dates[] = $this->checkin_dt;
        $startdt = $this->checkin_dt;

        while ($start_ts < $end_ts)
        {
            $date = date("Y-m-d", strtotime("+1 day". $startdt));
            $booking_dates[] = $date;
            $startdt = $date;
            $start_ts = strtotime($date);
        }

        $this->result =  $booking_dates;

		return $this;
    }

	public function groupDatesWithPrice()
	{
		$booking_days = [];

		if(count($this->result) > 0)
		{
			$loop_cnt = count($this->result) - 1;
			$i = 0;
			while($loop_cnt > $i){
				$booking_days[] = [
					"from" => $this->result[$i],
					"to" => $this->result[$i + 1],
					"price" => $this->getPrice($this->result[$i])
				];
				$i++;
			}
		}

		$this->result =  $booking_days;
		return $this;
	}

	public function oldfinalGrouping()
	{
		if(count($this->result) == 1){
			$this->result = [
				[
					"from" => $this->result[0]["from"],
					"to" => $this->result[0]["to"],
					"price" => $this->result[0]["price"],
				]
			];

			return $this;
		}
		
		$arr = [];
		$temp = [];
		$tempcnt = [];
		$tempprice = [];
		$permanentres = [];
		$i = 0;
		foreach($this->result as $res)
		{

			if($i == 0){

				$temp[$i] = $res;
				$tempprice[$i] = (float)$res["price"];
				$tempcnt[$i] = $i;
				
				$arr = [
						"from" => $temp[min($tempcnt)]["from"],
						"to" => $temp[max($tempcnt)]["to"],
						"price" => $temp[min($tempcnt)]["price"],
					   ];

			}else{
				
				
                
				$unique_price = array_values(array_unique($tempprice));

				if(count($unique_price) == 1){

                    
						if($unique_price[0] == $res["price"]){

							$temp[$i] = $res;
							$tempprice[$i] = $res["price"];
							$tempcnt[$i] = $i;

							$arr = [
								"from" => $temp[min($tempcnt)]["from"],
								"to" => $temp[max($tempcnt)]["to"],
								"price" => $temp[min($tempcnt)]["price"],
							];

						}else{
							//dump($i, $arr);
							$permanentres[] = $arr;

							$temp = [];
							$tempprice = [];
							$tempcnt = [];

							$temp[$i] = $res;
							$tempprice[$i] = $res["price"];
							$tempcnt[$i] = $i;

						}
				}
			}

			if($i == (count($this->result) - 1)){
				$arr = [
					"from" => $temp[min($tempcnt)]["from"],
					"to" => $temp[max($tempcnt)]["to"],
					"price" => $temp[min($tempcnt)]["price"],
				];
				//dump($i, $arr);
				$permanentres[] = $arr;
			}
			
			
			$i++;
		};

		$this->result = $permanentres;
		//dd($this->result);
		return $this;
	}
	
	public function finalGrouping() 
	{

		$input = $this->result;
		if (empty($input)) {
			return [];
		}

		$result = [];
		$currentGroup = $input[0];

		for ($i = 1, $len = count($input); $i < $len; $i++) {
			$current = $input[$i];

			// Compare price after casting both to string for uniformity
			if (floatval($current['price']) === floatval($currentGroup['price'])) { 
			//if ((string)$current['price'] === (string)$currentGroup['price']) {
				// Extend the end date of the current group
				$currentGroup['to'] = $current['to'];
			} else {
				// Save the current group and start a new one
				$result[] = $currentGroup;
				$currentGroup = $current;
			}
		}

		// Append the last group
		$result[] = $currentGroup;
		$this->result = $result;
		return $this;
    }

	public function addDaysAndPrice(){

		$new = [];
		$i = 0;
		foreach($this->result as $res){

			//dd($res);
			$days = $this->countDays($res["from"],$res["to"]);
			$booking_price = $days * $res["price"];

			$new[$i] = $res;
			$new[$i]["nights"] = $days;
			$new[$i]["booking_price"] = $booking_price;

			$i++;
		}

		$this->result = $new;
		return $this;

	}

	public function get(){
		return $this->result;
	}

	public function sum(){
		$sum = 0;
		foreach($this->result as $res){
			$sum = $sum + $res["booking_price"];
		}
		return $sum;
	}

	protected function getPrice($date){

		$ru_price = RuPropertyPrice::where('brik_unit_id', $this->brik_unit_id)
		->where('from_date','<=', $date)->where('to_date', '>=', $date);

		if($ru_price->count() > 0){
			return $ru_price->first()->price;
		}

		$unit = BrikUnit::find($this->brik_unit_id);

		if($unit){
			if($unit->per_night_inr){
				return $unit->per_night_inr;
			}
		}

		return null;

	}

	protected function countDays($fromdate,$todate)
    {
        $from = strtotime($fromdate);
        $to = strtotime($todate);
        $diff = round(($to - $from) / (60 * 60 * 24));

        if($from === $to){
            return 1;
        }else{
            return (int)$diff;
        }
    }

    
}