<?php

namespace App\Actions\Utility;

use App\Models\BrikBrik;
use App\Models\BrikUnit;
use App\Models\BrikOwner;

class EditPageHeaderNames
{
    
   public static function brikUnit($id)
   {
      //   BRIKitt Majestic Nirvana - 2BHK - Platinum Leisure - 505
       $string = 'Edit Unit Number';
       $paymentplan = BrikUnit::with(['project','brik','brik.propertyType','brik.type','spv'])->find($id);

       
         try{
            
            $project_name = $paymentplan->project->project_name;
            $type = $paymentplan->brik->propertyType->name;
            $category = $paymentplan->brik->type->name;
            $unit_number = $paymentplan->unit_number;
            $spv_name = $paymentplan->spv->spv_name;

            $string = $project_name.' '.$type.'('.$category.') - '.$unit_number.' - '.$spv_name;
         }catch(\Exception $e){
            $string = 'Edit Unit Number';
         }
      

       return $string;

   }

   public static function brikBrik($id)
   {
      //   BRIKitt Majestic Nirvana - 2BHK - Platinum Leisure - 505
       $string = 'Edit Unit Type';
       $paymentplan = BrikBrik::with(['project','propertyType','type'])->find($id);
       
       
         try{
            
            $project_name = $paymentplan->project->project_name;
            $type = $paymentplan->propertyType->name;
            $category = $paymentplan->type->name;

            $string = $project_name.' '.$type.'('.$category.')';
         }catch(\Exception $e){
            $string = 'Edit Brik Type';
           
         }
      

       return $string;

   }

   public static function brikowner($id)
   {
      //BRK00001 - Gaurav Mukherjee(9893586005) - BRIKitt Aquamarine 1BHK - 806 - Cloudtop Retreat Private Limited
       $string = 'Edit Brik Owner';
       $brikowner = BrikOwner::with(['owner', 'brik_unit','brik_unit.project','brik_unit.brik','brik_unit.brik.propertyType','brik_unit.brik.type','brik_unit.spv'])->find($id);

       
         try{
            $ownership_number = $brikowner->ownership_number;
            $owner_name = $brikowner->owner->print_name;
            $owner_email = $brikowner->owner->email;
            $project_name = $brikowner->brik_unit->project->project_name;
            $type = $brikowner->brik_unit->brik->propertyType->name;
            $category = $brikowner->brik_unit->brik->type->name;
            $unit_number = $brikowner->brik_unit->unit_number;
            $spv_name = $brikowner->brik_unit->spv->spv_name;

            $string = $ownership_number.' - '.$owner_name.'('.$owner_email.') - '.$project_name.' '.$type.'('.$category.') - '.$unit_number.' - '.$spv_name;
         }catch(\Exception $e){
            $string = 'Edit Brik Owner';
         }
      

       return $string;
   }

   

    
}