<?php

namespace App\Actions\Utility;

use App\Models\BrikBrik;
use App\Models\BrikOwner;
use App\Models\BrikPaymentmyplan;
use App\Models\BrikUnit;

class SelectDymanicNames
{

   public static function brikowner()
   {
      //BRK00001 - Gaurav Mukherjee(9893586005) - BRIKitt Aquamarine 1BHK - 806 - Cloudtop Retreat Private Limited
       $res = [];
       $brikowners = BrikOwner::with(['owner', 'brik_unit','brik_unit.project','brik_unit.brik','brik_unit.brik.propertyType','brik_unit.brik.type','brik_unit.spv'])->get();

       foreach($brikowners as $brikowner){

         try{
            $ownership_number = $brikowner->ownership_number;
            $owner_name = $brikowner->owner ? $brikowner->owner->print_name : '';
            $owner_email = $brikowner->owner ? $brikowner->owner->email : '';

            $project_name = $brikowner->brik_unit ? ( $brikowner->brik_unit->project ? $brikowner->brik_unit->project->project_name : '') : '';

            $type = $brikowner->brik_unit ? ( $brikowner->brik_unit->brik ? $brikowner->brik_unit->brik->propertyType->name : '') : '';

            $category = $brikowner->brik_unit ? ( $brikowner->brik_unit->type ? $brikowner->brik_unit->brik->type->name : '') : '';

            $unit_number = $brikowner->brik_unit ? $brikowner->brik_unit->unit_number : '';

            $spv_name = $brikowner->brik_unit ? ( $brikowner->brik_unit->spv ? $brikowner->brik_unit->spv->spv_name : '' ) : '';

            $res[$brikowner->id] = $ownership_number.' - '.$owner_name.'('.$owner_email.') - '.$project_name.' '.$type.'('.$category.') - '.$unit_number.' - '.$spv_name;
         }catch(\Exception $e){
            continue;
         }

       }

       return $res;
   }

   public static function brikowner_paymentplan($planid)
   {
      //BRK00001 - Gaurav Mukherjee(9893586005) - BRIKitt Aquamarine 1BHK - 806 - Cloudtop Retreat Private Limited
       $res = [];

       if (is_null($planid)) {

         $brikowners = BrikOwner::with(['owner', 'brik_unit','brik_unit.project','brik_unit.brik','brik_unit.brik.propertyType','brik_unit.brik.type','brik_unit.spv'])->whereNull('paymentmyplan_id')->orderBy('id', 'DESC')->get();

      }else{


         $brikowners = BrikOwner::with(['owner', 'brik_unit','brik_unit.project','brik_unit.brik','brik_unit.brik.propertyType','brik_unit.brik.type','brik_unit.spv'])->where('paymentmyplan_id', $planid)->orderBy('id', 'DESC')->get();

      }



       foreach($brikowners as $brikowner){
         try{
            $ownership_number = $brikowner->ownership_number;
            $owner_name = $brikowner->owner->print_name;
            $owner_email = $brikowner->owner->email;
            $project_name = $brikowner->brik_unit->project->project_name;
            $type = $brikowner->brik_unit->brik->propertyType->name;
            $category = $brikowner->brik_unit->brik->type->name;
            $unit_number = $brikowner->brik_unit->unit_number;
            $spv_name = $brikowner->brik_unit->spv->spv_name;

            $res[$brikowner->id] = $ownership_number.' - '.$owner_name.'('.$owner_email.') - '.$project_name.' '.$type.'('.$category.') - '.$unit_number.' - '.$spv_name;
         }catch(\Exception $e){
            continue;
         }
       }

       return $res;
   }

   public static function paymentPlan()
   {
      //BRK00001 - Gaurav Mukherjee(9893586005) - BRIKitt Aquamarine 1BHK - 806 - Cloudtop Retreat Private Limited
       $res = [];
       $paymentplans = BrikPaymentmyplan::with(['brik_owner','brik_owner.owner', 'brik_owner.brik_unit','brik_owner.brik_unit.project','brik_owner.brik_unit.brik','brik_owner.brik_unit.brik.propertyType','brik_owner.brik_unit.brik.type','brik_owner.brik_unit.spv'])->get();

       foreach($paymentplans as $paymentplan){
         try{
            $ownership_number = $paymentplan->brik_owner->ownership_number;
            $owner_name = $paymentplan->brik_owner->owner->print_name;
            $owner_email = $paymentplan->brik_owner->owner->email;
            $project_name = $paymentplan->brik_owner->brik_unit->project->project_name;
            $type = $paymentplan->brik_owner->brik_unit->brik->propertyType->name;
            $category = $paymentplan->brik_owner->brik_unit->brik->type->name;
            $unit_number = $paymentplan->brik_owner->brik_unit->unit_number;
            $spv_name = $paymentplan->brik_owner->brik_unit->spv->spv_name;

            $res[$paymentplan->id] = $ownership_number.' - '.$owner_name.'('.$owner_email.') - '.$project_name.' '.$type.'('.$category.') - '.$unit_number.' - '.$spv_name;
         }catch(\Exception $e){
            continue;
         }
       }

       return $res;

   }

   public static function brikUnit()
   {
      //   BRIKitt Majestic Nirvana - 2BHK - Platinum Leisure - 505
      $res = [];
       //$paymentplans = BrikUnit::with(['project','brik','brik.propertyType','brik.type'])->get();
	   $paymentplans = BrikUnit::whereNotNull('booking_portal_display_name')->get();

       foreach($paymentplans as $paymentplan){
         try{

            // $project_name = $paymentplan->project->project_name;
            // $type = $paymentplan->brik->propertyType->name;
            // $category = $paymentplan->brik->type->name;
            // $unit_number = $paymentplan->unit_number;
            // $spv_name = $paymentplan->spv->spv_name;

            // $res[$paymentplan->id] = $project_name.' '.$type.'('.$category.') - '.$unit_number.' - '.$spv_name;
			
			$res[$paymentplan->id] = $paymentplan->booking_portal_display_name;

         }catch(\Exception $e){
            continue;
         }
       }

       return $res;

   }

   public static function brikBrik()
   {
      //   BRIKitt Majestic Nirvana - 2BHK - Platinum Leisure - 505
      $res = [];
       $paymentplans = BrikBrik::with(['project','propertyType','type'])->get();

       foreach($paymentplans as $paymentplan){
         try{

            $project_name = $paymentplan->project->project_name;
            $type = $paymentplan->propertyType->name;
            $category = $paymentplan->type->name;

            $res[$paymentplan->id] = $project_name.' '.$type.'('.$category.')';
         }catch(\Exception $e){
            continue;
         }
       }

       return $res;

   }

   public static function brik_project($project_id)
   {
      //   BRIKitt Majestic Nirvana - 2BHK - Platinum Leisure - 505
      // BrikBrik::query()->where('brik_project_id', $get('project_id'))->pluck('brik_name', 'id')
       $res = [];
       $paymentplans = BrikBrik::with(['project','propertyType','type'])
       ->where('brik_project_id', $project_id)
       ->get();

       foreach($paymentplans as $paymentplan){
         try{

            $project_name = $paymentplan->project->project_name;
            $type = $paymentplan->propertyType->name;
            $category = $paymentplan->type->name;

            $res[$paymentplan->id] = $project_name.' '.$type.'('.$category.')';
         }catch(\Exception $e){
            continue;
         }
       }

       return $res;

   }





}
