<?php

namespace App\Console\Commands;

use App\Models\BrikAmenity;
use Exception;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class MigrateBooking extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */

    protected $signature = 'app:migrate-booking';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
       $this->info('Code execution started.');


       //$this->updateOldBookingToBrikUnitNo();
       //$this->updateOldBookingToClientId();
       $this->bookingentry();


       $this->info('Code execution ended.');


    }

    public function bookingentry()
    {
        $bookings = DB::connection('brik_it')->table('booking_booking')->whereNotNull('new_brik_unit_id')->whereNotNull('client_id')->get();

        foreach($bookings as $booking)
        {
            $this->booking($booking);
        }

    }

    public function booking($booking)
    {
        // $old_booking_status = active, initiated, cancel

        if($booking->booking_status == 'active'){
            $new_booking_status = 'Active';
        }else if($booking->booking_status == 'initiated'){
            $new_booking_status = 'Initiated';
        }else if($booking->booking_status == 'cancel'){
            $new_booking_status = 'Cancel';
        }


        $date_blocked_from = $booking->date_check_in;
        $date_blocked_to = date("Y-m-d",strtotime("-1 day ".$booking->date_check_out));

        $booking_req_data = [
            "brik_unit_id" => $booking->new_brik_unit_id,
            "booking_from_date" => $booking->date_check_in,
            "booking_to_date" => $booking->date_check_out,
            "date_blocked_from" => $date_blocked_from,
            "date_blocked_to" => $date_blocked_to,
            "booking_status" => $new_booking_status,
            "is_complimentary" => $booking->is_complimentary,
            "ru_sync_required" => 0,
            "is_synced" => 0
        ];

        if($booking->new_booking_request_id){
            DB::connection('briklaravelolddata')->table('booking_booking_requests')->where('id', $booking->new_booking_request_id)->update($booking_req_data);

            $new_booking_request_id = $booking->new_booking_request_id;

        }else{
            $new_booking_request_id =  DB::connection('briklaravelolddata')->table('booking_booking_requests')->insertGetId($booking_req_data);
        }

        $booking_days = $this->countDays($booking->date_check_in,$booking->date_check_out);

        if($booking->amount_paid > 0){
            $pay_by = 'Amount';
        }

        if($booking->no_coins_used > 0){
            $pay_by = 'Coin';
        }else{
            $pay_by = 'Amount';
        }

        if($pay_by == 'Coin'){

            $coins_per_night = ( $booking->no_coins_used / $booking_days );
            $price_per_night = null;
            $booking_cost_in_rupee = null;
            $booking_cost_in_coin = $booking->no_coins_used;
            $payable_amount = 0;
            $gst_amount = null;
            $net_payable_amount = null;
            $paid_amount = 0;
            $balance_amount = null;

        }

        if($pay_by == 'Amount'){

            $coins_per_night = null;
            $price_per_night = ($booking->amount_paid / $booking_days );
            $booking_cost_in_rupee = $booking->amount_paid;
            $booking_cost_in_coin = null;
            $payable_amount = $booking->amount_paid;
            $gst_amount = 0;
            $net_payable_amount = $booking->amount_paid;
            $paid_amount = $booking->amount_paid;
            $balance_amount = 0;

        }



        $booking_data = [

            "booking_request_id" => $new_booking_request_id,
            "price_per_night" => $price_per_night,
            "coins_per_night" => $coins_per_night,
            "date_check_in" => $booking->date_check_in,
            "date_check_out" => $booking->date_check_out,
            "booking_night_counts" => $booking_days,
            "booking_cost_in_rupee" => $booking_cost_in_rupee,
            "booking_cost_in_coin" => $booking_cost_in_coin,
            "brik_coupon_id" => null,
            "coupon_amount" => 0,
            "payable_amount" => $payable_amount,
            "gst_amount" => $gst_amount,
            "net_payable_amount" => $net_payable_amount,
            "paid_amount" => $paid_amount,
            "balance_amount" => $balance_amount,
            "pay_by" => $pay_by,
            "adult" => $booking->adult,
            "children"=> $booking->children,
            "infants" => 0,
            "pets" => 0,
            "booking_status" => $new_booking_status,
            "order_id" => null,
            "pay_order_id" => null,
            "deducted_coins" => null,
            "deducted_amount" => null,
            "refunded_coins" => null,
            "refunded_amount" => null,
            "cf_order_id" => null,
            "cf_order_status" => null,
            "brik_unit_id" => $booking->new_brik_unit_id,
            "client_id" => $booking->client_id,
            "user_id" => null,
            "ru_reservation_id" => null,
            "ru_reservation_status" => null,
            "booking_from" => 'Portal'
        ];

        if($booking->new_booking_request_id){
            DB::connection('briklaravelolddata')->table('booking_bookings')->where('booking_request_id', $booking->new_booking_request_id)->update($booking_data);

            $new_booking_id = DB::connection('briklaravelolddata')->table('booking_bookings')->where('booking_request_id', $booking->new_booking_request_id)->first()->id;

        }else{
            $new_booking_id =  DB::connection('briklaravelolddata')->table('booking_bookings')->insertGetId($booking_data);
        }

        if($pay_by == 'Amount'){

            $booking_details_data = [
                "booking_id" => $new_booking_id,
                "from_date" => $booking->date_check_in,
                "to_date" => $booking->date_check_out,
                "price" => $price_per_night,
                "nights" => $booking_days,
                "booking_price" => $payable_amount
            ];

            if($booking->new_booking_request_id){
                DB::connection('briklaravelolddata')->table('booking_booking_details')->where('booking_id', $new_booking_id)->update($booking_details_data);

            }else{
                DB::connection('briklaravelolddata')->table('booking_booking_details')->insertGetId($booking_details_data);
            }
        }

        $this->info('Booking record inserted Booking ID : '.$booking->id);
    }

    public function updateOldBookingToClientId()
    {
        $bookings = DB::connection('brik_it')->table('booking_booking')->whereNotNull('new_brik_unit_id')->get();
        foreach($bookings as $booking){

            $client_id = null;

            if(!is_null($booking->user_id)){

                $user = DB::connection('brik_it')->table('identity_user')->where('id', $booking->user_id)->first();

                if($user){
                    if($user->client_id)
                    {
                        $client_id = $user->client_id;

                    }else{
                        // create new client
                        $client_id = $this->owner($user);
                    }

                }


            }else{

                if(!is_null($booking->booking_portal_user_id )){

                    $user = DB::connection('brik_it')->table('identity_bookingportalusers')->where('id', $booking->booking_portal_user_id)->first();

                    if($user)
                    {
                        if($user->client_id)
                        {
                            $client_id = $user->client_id;

                        }else{
                            // create new client
                            $client_id = $this->portaluser($user);
                        }
                    }
                }


            }




            DB::connection('brik_it')->table('booking_booking')->where('id', $booking->id)->update(["client_id" => $client_id]);

        }
    }

    public function updateOldBookingToBrikUnitNo()
    {
        $bookings = DB::connection('brik_it')->table('booking_booking')->whereNotNull('spv_id_id')->get();
        foreach($bookings as $booking){

            $new_brik_unit_id = null;
            $spv = DB::connection('brik_it')->table('brik_spvinfo')->where('id', $booking->spv_id_id)->first();

            if($spv){
                $new_brik_unit_id = $spv->new_unit_number_id;
            }

            DB::connection('brik_it')->table('booking_booking')->where('id', $booking->id)->update(["new_brik_unit_id" => $new_brik_unit_id]);

        }
    }



    public function owner($owner)
    {
        $marital_status = null;
        if($owner->marital_status == 'Single'){
            $marital_status = 'Unmarried';
        }else if($owner->marital_status == 'Married'){
            $marital_status = 'Married';
        }

        $profile_pic = $this->putImage($owner->profile_pic,'images/clients/profile/');

        $ownerdata = [
            "first_name" => $owner->first_name,
            "last_name" => $owner->last_name,
            "dob" => $owner->dob,
            "address" => $owner->house_number.' '.$owner->street,
            "state" => $owner->state,
            "city" => $owner->city,
            "pin" => $owner->pincode,
            "email" => $owner->email,
            "mobile" => $owner->mobile_number,
            "otp" => null,
            "profession" => $owner->occupation,
            "emergency_phone" => null,
            "marital_status" => $marital_status,
            "anniversary_date" => $owner->anniversary_date,
            "gender" => null,
            "image" => $profile_pic,
            "coins" => 0,
            "wallet_amount" => 0,
            "is_owner" => 0,
        ];

        if($owner->client_id){
            DB::connection('briklaravelolddata')->table('clients')->where('id', $owner->client_id)->update($ownerdata);
            return $owner->client_id;
        }else{
            return DB::connection('briklaravelolddata')->table('clients')->insertGetId($ownerdata);
        }
    }

    public function portaluser($owner)
    {
        $first_name = null;
        $last_name = null;

        if($owner->name){
            $name = explode(" ", $owner->name);

            if (array_key_exists(0, $name)) {
                $first_name = $name[0];
            }

            if (array_key_exists(1, $name)) {
                $last_name = $name[0];
            }
        }


        $profile_pic = $this->putImage($owner->profile_pic,'images/clients/profile/');

        $ownerdata = [
            "first_name" => $first_name,
            "last_name" => $last_name,
            "dob" => $owner->dob,
            "address" => null,
            "state" => null,
            "city" => null,
            "pin" => null,
            "email" => $owner->email,
            "mobile" => $owner->mobile_number,
            "otp" => null,
            "profession" => null,
            "emergency_phone" => null,
            "marital_status" => null,
            "anniversary_date" => null,
            "gender" => $owner->gender,
            "image" => $profile_pic,
            "coins" => 0,
            "wallet_amount" => 0,
            "is_owner" => 0,
        ];

        if($owner->client_id){
            DB::connection('briklaravelolddata')->table('clients')->where('id', $owner->client_id)->update($ownerdata);
            return $owner->client_id;
        }else{
            return DB::connection('briklaravelolddata')->table('clients')->insertGetId($ownerdata);
        }
    }



    // DB::connection('brik_it')->table('brik_brik')->
    // DB::connection('briklaravelolddata')->table('spvs')

    // $spvdata = [
    //         "spv_name" => $spv->spv_name,
    //         "spv_formation_date" => $spv->spv_formation_date,
    //         "bank_name" => $spv->bank_name,
    //         "bank_account_holder_name" => $spv->bank_account_holder_name,
    //         "bank_account_number" => $spv->bank_account_holder_name,
    //         "ifsc_code" => $spv->ifsc_code,
    //         "pan_card" => $spv->pan_card,
    //         "coi_number" => $spv->coi_number,
    //         "pan_card_file"  => null,
    //         "tan_card_file" => null,
    //         "coi_file" => null,
    //         "online_payment" => 0,
    //         "cashfree_app_id" => null,
    //         "cashfree_app_secret" => null,
    //         "account_statement" => null,
    //         "balance_sheet" => null,
    //         "profit_loss"  => null,
    //     ];

    public function entry()
    {

        $briks = DB::connection('brik_it')->table('brik_brik')->where('done', 0)->get();
        foreach($briks as $brik){

            //try{

                $new_unit_number_id = $this->unitnumber($brik);

                DB::connection('brik_it')->table('brik_brik')->where('id', $brik->id)->update(["done" => 1]);

                $this->info('Unit number Inserted. brik Id '.$brik->id);

            // }catch(\Exception $e){
            //     $this->info('Project Insert Error. Project Id '.$project->project_id);
            // }

        }
    }



    public function putImage($pullimageuri,$putpath)
    {
        if($pullimageuri){

            $pullserver = 'https://brikkit-prod-docs.s3.amazonaws.com/media/';
            $pullimagepath = $pullserver.$pullimageuri;

            $extension = $this->getImageExtension($pullimagepath);

            $imagename = $putpath.uniqid();
            $putimage = $imagename.'.'.$extension;
            $putimagepath = storage_path('app\public\\').$imagename.'.'.$extension;

            $imageData = file_get_contents($pullimagepath);
            if ($imageData !== false) {
                file_put_contents($putimagepath, $imageData);

                return $putimage;
            }
        }


        return null;
    }

    public function getImageExtension($url)
    {
        $cleanUrl = parse_url($url, PHP_URL_PATH);
        $extension = pathinfo($cleanUrl, PATHINFO_EXTENSION);

        return $extension; // Output: jpg
    }


    protected function countDays($fromdate,$todate)
    {
        $from = strtotime($fromdate);
        $to = strtotime($todate);
        $diff = round(($to - $from) / (60 * 60 * 24));

        if($from === $to){
            return 1;
        }else{
            return (int)$diff;
        }
    }


}
