<?php

namespace App\Console\Commands;

use App\Models\BrikAmenity;
use Exception;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class MigrateBrik extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */

    protected $signature = 'app:migrate-brik';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
       $this->info('Code execution started.');

       //$this->spventry();
       //$this->unittypeentry();


       $this->info('Code execution ended.');


    }

    public function unittypeentry()
    {

        $briks = DB::connection('brik_it_new')->table('brik_brik')->where('done', 0)->get();
        foreach($briks as $brik){

            //try{

                $briklaravel_unit_type_id = $this->unittype($brik);

                DB::connection('brik_it_new')->table('brik_brik')->where('id', $brik->id)->update(
                    [
                        "briklaravel_unit_type_id" => $briklaravel_unit_type_id,
                        "done" => 1
                    ]
                );

                $this->info('Unit type Inserted. brik Id '.$brik->id);

            // }catch(\Exception $e){
            //     $this->info('Project Insert Error. Project Id '.$project->project_id);
            // }

        }
    }

    public function entry()
    {

        $briks = DB::connection('brik_it')->table('brik_brik')->where('done', 0)->get();
        foreach($briks as $brik){

            //try{

                $new_unit_number_id = $this->unitnumber($brik);

                DB::connection('brik_it')->table('brik_brik')->where('id', $brik->id)->update(["done" => 1]);

                $this->info('Unit number Inserted. brik Id '.$brik->id);

            // }catch(\Exception $e){
            //     $this->info('Project Insert Error. Project Id '.$project->project_id);
            // }

        }
    }

    public function projectmarking()
    {
        // SELECT `location`, count(*) FROM `brik_brik` GROUP BY `location`
        $locations = DB::connection('brik_it')->table('brik_brik')->select('location')->groupBy('location')->get();

        $i = 1;
        foreach($locations as $location){

            DB::connection('brik_it')->table('brik_brik')->where('location', $location->location)->update(['project_id' =>  $i]);

            $i++;
        }

    }

    public function unittypemarking()
    {

        $unittypes = DB::connection('brik_it')->table('brik_brik')->groupBy('new_project_id','property_type','bedroom','property_area')->get();

        $i = 1;
        foreach($unittypes as $unittype){

            DB::connection('brik_it')->table('brik_brik')->where('property_type', $unittype->property_type)
            ->where('new_project_id', $unittype->new_project_id)
            ->where('bedroom', $unittype->bedroom)
            ->where('property_area', $unittype->property_area)
            ->update(['unit_type_id' =>  $i]);

            $i++;
        }

    }

    public function spvmarking()
    {
        // SELECT `location`, count(*) FROM `brik_brik` GROUP BY `location`
        $spvs = DB::connection('brik_it')->table('brik_spvinfo')->select('bank_account_number')->whereNotNull('bank_account_number')
                ->groupBy('bank_account_number')->get();
        //dd($spvs);
        $i = 1;
        foreach($spvs as $spv){

            try{
                DB::connection('brik_it')->table('brik_spvinfo')->where('bank_account_number', $spv->bank_account_number)->update(['spv_id' =>  $i]);
                $this->info('entry done');
            }catch(\Exception $e){
                $this->info('entry error on id '.$spv->bank_account_number);
                continue;
            }


            $i++;
        }

    }

    public function brikSpvMapping()
    {
        $briks = DB::connection('brik_it')->table('brik_brik')->get();

        foreach($briks as $brik){

           $brikspv = DB::connection('brik_it')->table('brik_spvinfo')->where('brik_id', $brik->id)->first();

           if($brikspv){

                DB::connection('brik_it')->table('brik_brik')->where('id', $brik->id)->update(["new_spv_id" => $brikspv->new_spv_id]);

           }
        }
    }

    public function spvnameupdate()
    {
        $spvs = DB::connection('briklaravelolddata')->table('spvs')->get();
        foreach($spvs as $spv)
        {
            DB::connection('briklaravelolddata')->table('spvs')->where('id', $spv->id)->update(["spv_name" => $spv->bank_account_holder_name]);
        }

    }

    public function spv($spv)
    {

        $spvdata = [
            "spv_name" => $spv->spv_name,
            "spv_formation_date" => $spv->spv_formation_date,
            "bank_name" => $spv->bank_name,
            "bank_account_holder_name" => $spv->bank_account_holder_name,
            "bank_account_number" => $spv->bank_account_number,
            "ifsc_code" => $spv->ifsc_code,
            "pan_card" => $spv->pan_card,
            "coi_number" => $spv->coi_number,
            "pan_card_file"  => null,
            "tan_card_file" => null,
            "coi_file" => null,
            "online_payment" => 0,
            "cashfree_app_id" => null,
            "cashfree_app_secret" => null,
            "account_statement" => null,
            "balance_sheet" => null,
            "profit_loss"  => null,
        ];

        if($spv->new_spv_id){
            DB::connection('brik_it_brikittdevelopment')->table('spvs')->where('id', $spv->new_spv_id)->update($spvdata);
            return $spv->new_spv_id;
        }else{
            return DB::connection('brik_it_brikittdevelopment')->table('spvs')->insertGetId($spvdata);
        }
    }

    public function project($brik)
    {
        $state_id = 1;
        $city_id = 1;

        $project_manager_id = $this->projectManager($brik);
        $cancellation_policy_id = $this->cancellationPolicy($brik);
        $house_rules_id = $this->houseRule($brik);
        $pets_friendly_id = $this->petsFreindly($brik);
        $safety_and_property_id = $this->safetyAndProperty($brik);

        $projectdata = [

            "project_name" => $brik->property_name,
            "invest_description" => null,
            "rent_description" => $brik->description,
            "pets_allowed" => $brik->pets_allowed,
            "address" => $brik->location,
            "state_id" => $state_id,
            "city_id" => $city_id,
            "pin" => null,
            "project_manager_id" => $project_manager_id,
            "lat" => $brik->lat,
            "lng" => $brik->lng,
            "cancellation_policy_id" => $cancellation_policy_id,
            "house_rules_id" => $house_rules_id,
            "pets_friendly_id" => $pets_friendly_id,
            "safety_and_property_id" => $safety_and_property_id

        ];



        if($brik->new_project_id){
            DB::connection('briklaravelolddata')->table('brik_projects')->where('id', $brik->new_project_id)->update($projectdata);
            return $brik->new_project_id;
        }else{
            return DB::connection('briklaravelolddata')->table('brik_projects')->insertGetId($projectdata);
        }

    }

    public function unittype($brik)
    {
        $type_id = $this->brikType($brik);
        $property_type_id = $this->brikPropertyType($brik);
        $brik_name = null; //$this->getBrikName($brik);

        $brikdata = [

            "brik_project_id" => $brik->briklaravel_project_id,
            "brik_property_type_id" => $property_type_id,
            "brik_type_id" => $type_id,
            "brik_name" => $brik_name,
            "property_area" => $brik->property_area,
            "bedroom" => $brik->bedroom,
            "bathroom" => $brik->bathroom,
            "accomadation" => $brik->accomadation,
            "brik_value" => $brik->brik_value,
            "capital_gain" => $brik->capital_gain,
            "irr" => $brik->irr,
            "pe_ratio" => $brik->pe_ratio,
            "adults_capacity" => $brik->adults_capacity ? $brik->adults_capacity : 0,
            "children_capacity" => $brik->children_capacity ? $brik->children_capacity : 0,
            "infent_capacity" => 0,
            "pet_capacity" => 0,
            "per_night_inr" => $brik->per_night_inr,
            "per_night_coin" => $brik->per_night_coin,
            "total_coins_per_brik" => $brik->total_coins_per_brik,

        ];


        if($brik->briklaravel_unit_type_id){
            DB::connection('brik_it_brikittdevelopment')->table('brik_briks')->where('id', $brik->briklaravel_unit_type_id)->update($brikdata);
            return $brik->briklaravel_unit_type_id;
        }else{
            return DB::connection('brik_it_brikittdevelopment')->table('brik_briks')->insertGetId($brikdata);
        }

    }

    public function unitnumber($brik)
    {
        $spv = $this->getSpv($brik);
        $project = DB::connection('brik_it_brikittdevelopment')->table('brik_projects')->where('id', $brik->new_project_id)->first();
        $city_id = $project ? $project->city_id : null;

        $rent_cover_image = $this->getRentCoverImage($spv);
        $invest_cover_image = $this->getInvestCoverImage($brik);
        $gallery_images = $this->getGalleryImages($brik);

        $brikdata = [

            "booking_portal_display_name" => $spv ? $spv->spv_name : null,
            "ru_property_id" => null,
            "spv_id" => $brik->new_spv_id,
            "brik_id" => $brik->new_unit_type_id,
            "project_id" => $brik->new_project_id,
            "property_area" => $brik->property_area,
            "brik_value" => $brik->brik_value,
            "capital_gain" => $brik->capital_gain,
            "irr" => $brik->irr,
            "pe_ratio" => $brik->pe_ratio,
            "per_night_inr" => $brik->per_night_inr,
            "per_night_coin" => $brik->per_night_coin,
            "total_coins_per_brik" => $brik->total_coins_per_brik,
            "rent_cover_image" => $rent_cover_image,
            "rent_gallery_images" => $gallery_images,
            "invest_cover_image" => $invest_cover_image,
            "invest_gallery_images" => $gallery_images,
            "unit_name" => null,
            "unit_number" => $spv ? $spv->unit_number : null,
            "city_id" => $city_id,
            "adults_capacity" => $brik->adults_capacity ? $brik->adults_capacity : 0,
            "children_capacity" => $brik->children_capacity ? $brik->children_capacity : 0,
            "infent_capacity" => 0,
            "pet_capacity" => 0,
            "property_view" => $brik->property_view,
            "possession" => $spv->possession_status,
            "date_of_possession" => $spv->date_of_possession,
            "managed_property" => $brik->managed_property ? $brik->managed_property : 0,
            "rent_active" => $spv->active ? $spv->active : 0,
            "invest_active" => $brik->active ? $brik->active : 0,
            "newly_launched" => 0,
            "property_video" => null,
            "view_360" => null,
            "rating" => 5

        ];



        if($brik->new_unit_number_id){
            DB::connection('briklaravelolddata')->table('brik_units')->where('id', $brik->new_unit_number_id)->update($brikdata);
            return $brik->new_unit_number_id;
        }else{
            return DB::connection('briklaravelolddata')->table('brik_units')->insertGetId($brikdata);
        }

    }

    public function spventry()
    {
        $new_spvs = DB::connection('brik_it_new')->table('brik_spvinfo')->whereNull('new_spv_id')->get();

        foreach($new_spvs as $new_spv){

           $laravel_spv = DB::connection('brik_it_brikittdevelopment')->table('spvs')->where('bank_account_number', $new_spv->bank_account_number)->first();

           if($laravel_spv){

            DB::connection('brik_it_new')->table('brik_spvinfo')->where('id', $new_spv->id)->update(['new_spv_id' => $laravel_spv->id]);

           }else{
             $laravel_spv_id = $this->spv($new_spv);
             DB::connection('brik_it_new')->table('brik_spvinfo')->where('id', $new_spv->id)->update(['new_spv_id' => $laravel_spv_id]);
           }

        }
    }

    public function matchunitnumber()
    {
        $briks = DB::connection('brik_it')->table('brik_brik')->get();

        $i = 1;
        foreach($briks as $brik)
        {
            DB::connection('brik_it')->table('brik_brik')->where('id', $brik->id)->update(["new_unit_number_id" => $i]);

            $i++;
        }
    }



    public function projectManager($brik)
    {
        if($brik->brik_manager){
            $manager = DB::connection('briklaravelolddata')->table('brik_managers')->where('name', $brik->brik_manager)->first();

            if($manager){
                return $manager->id;
            }else{

                $image = $this->putImage($brik->brik_manager_image,'images/employee/');

                $managerdata = [

                    "name" => $brik->brik_manager,
                    "image" => $image ,
                    "designation" => 'Manager',
                    "email" => null,
                    "phone" => $brik->brik_manager_contact,

                ];

                return DB::connection('briklaravelolddata')->table('brik_managers')->insertGetId($managerdata);
            }
        }
    }

    public function cancellationPolicy($brik)
    {
        if($brik->cancellation_policy_id){

          $policy =  DB::connection('brik_it')->table('brik_cancellationpolicy')->where('id', $brik->cancellation_policy_id)->first();

          if($policy){

            $chk = DB::connection('briklaravelolddata')->table('brik_cancellation_policies')->where('title', $policy->title);

            if($chk->count() == 0){

                $policydata = [
                    "title" => $policy->title,
                    "cancellation_policy" => $policy->cancellationPolicy,
                ];

                return DB::connection('briklaravelolddata')->table('brik_cancellation_policies')->insertGetId($policydata);
            }else{
                return $chk->first()->id;
            }

          }
        }

        return null;
    }

    public function houseRule($brik)
    {
        if($brik->house_rules_id ){

          $rule =  DB::connection('brik_it')->table('brik_houserule')->where('id', $brik->house_rules_id)->first();

          if($rule){

            $chk = DB::connection('briklaravelolddata')->table('brik_houserules')->where('title', $rule->title);

            if($chk->count() == 0){

                $ruledata = [
                    "title" => $rule->title,
                    "rule" => $rule->rule,
                ];

                return DB::connection('briklaravelolddata')->table('brik_houserules')->insertGetId($ruledata);
            }else{
                return $chk->first()->id;
            }

          }
        }

        return null;
    }

    public function petsFreindly($brik)
    {
        if($brik->pets_friendly_id ){

          $rule =  DB::connection('brik_it')->table('brik_petsfriendly')->where('id', $brik->pets_friendly_id)->first();

          if($rule){

            $chk = DB::connection('briklaravelolddata')->table('brik_petsfriendlies')->where('title', $rule->title);

            if($chk->count() == 0){

                $ruledata = [
                    "title" => $rule->title,
                    "pets_friendly" => $rule->petsFriendly,
                ];

                return DB::connection('briklaravelolddata')->table('brik_petsfriendlies')->insertGetId($ruledata);
            }else{
                return $chk->first()->id;
            }

          }
        }

        return null;
    }

    public function safetyAndProperty($brik)
    {
        if($brik->safety_and_property_id ){

          $rule =  DB::connection('brik_it')->table('brik_safetyandproperty')->where('id', $brik->safety_and_property_id)->first();

          if($rule){

            $chk = DB::connection('briklaravelolddata')->table('brik_safetyandproperties')->where('title', $rule->title);

            if($chk->count() == 0){

                $ruledata = [
                    "title" => $rule->title,
                    "safety_and_property" => $rule->safetyAndProperty,
                ];

                return DB::connection('briklaravelolddata')->table('brik_safetyandproperties')->insertGetId($ruledata);
            }else{
                return $chk->first()->id;
            }

          }
        }

        return null;
    }

    public function brikPropertyType($brik)
    {
        if($brik->bedroom == 1){
            return 1;
        }else if($brik->bedroom == 2){
            return 2;
        }else if($brik->bedroom == 3){
            return 3;
        }else{
            return null;
        }
    }

    public function brikType($brik)
    {
        if($brik->property_type){
            $chk = DB::connection('brik_it_brikittdevelopment')->table('brik_types')->where('name', $brik->property_type);
            if($chk->count() > 0){
                return $chk->first()->id;
            }else{
                return DB::connection('brik_it_brikittdevelopment')->table('brik_types')->insertGetId(["name" => $brik->property_type]);
            }
        }
        return null;
    }

    public function putImage($pullimageuri,$putpath)
    {
        if($pullimageuri){

            $pullserver = 'https://brikkit-prod-docs.s3.amazonaws.com/media/';
            $pullimagepath = $pullserver.$pullimageuri;

            $extension = $this->getImageExtension($pullimagepath);

            $imagename = $putpath.uniqid();
            $putimage = $imagename.'.'.$extension;
            $putimagepath = storage_path('app\public\\').$imagename.'.'.$extension;

            $imageData = file_get_contents($pullimagepath);
            if ($imageData !== false) {
                file_put_contents($putimagepath, $imageData);

                return $putimage;
            }
        }


        return null;
    }

    public function getImageExtension($url)
    {
        $cleanUrl = parse_url($url, PHP_URL_PATH);
        $extension = pathinfo($cleanUrl, PATHINFO_EXTENSION);

        return $extension; // Output: jpg
    }

    public function getSpv($brik)
    {
        return DB::connection('brik_it_new')->table('brik_spvinfo')->where('brik_id', $brik->id)->first();
    }

    public function getRentCoverImage($spv)
    {
        if($spv->spv_cover_image){
            return $this->putImage($spv->spv_cover_image,'images/brik/');
        }
        return null;
    }

    public function getInvestCoverImage($brik)
    {
        if($brik->brik_cover_image){
            return $this->putImage($brik->brik_cover_image,'images/brik/');
        }
        return null;
    }

    public function getGalleryImages($brik)
    {
        $res = [];
        $images = DB::connection('brik_it')->table('brik_brikimage')->where('brik_id', $brik->id)->get();

        foreach($images as $image)
        {
            $image = $this->putImage($image->image,'images/brik/');
            if($image){
                $res[] = $image;
            }
        }

        return json_encode($res);

    }



}
