<?php

namespace App\Console\Commands;

use App\Models\BrikAmenity;
use Exception;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class MigrateBrikNew extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */

    protected $signature = 'app:migrate-brik-new';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {

       $this->info('Code execution started.');

        //$this->brikItNewSpvInfo();
        //$this->newunitentries();
        //$this->updateBrikOwnerunitid();
        $this->newupdateBrikOwnerunitid();


       $this->info('Code execution ended.');


    }

    public function brikItNewSpvInfo()
    {
        $new_spvs = DB::connection('brik_it_new')->table('brik_spvinfo')->get();
        foreach($new_spvs as $new_spv){
            $old_spv = DB::connection('brik_it')->table('brik_spvinfo')->where('id', $new_spv->id)->first();

            if($old_spv){
                DB::connection('brik_it_new')->table('brik_spvinfo')->where('id', $new_spv->id)->update(
                    [
                        "spv_id" => $old_spv->spv_id,
                        "new_spv_id" => $old_spv->new_spv_id,
                        "new_unit_number_id" => $old_spv->new_unit_number_id,
                        "need_remove" => $old_spv->need_remove,
                    ]
                );
            }

        }
    }

    public function entry()
    {

        $spvs = DB::connection('brik_it')->table('brik_spvinfo')->whereNull('new_unit_number_id')->get();
        foreach($spvs as $spv){

            //try{

                $new_unit_number_id = $this->unitnumber($spv);

                DB::connection('brik_it')->table('brik_spvinfo')->where('id', $spv->id)->update(["new_unit_number_id" => $new_unit_number_id]);

                $this->info('Unit number Inserted. Spv Id '.$spv->id);

            // }catch(\Exception $e){
            //     $this->info('Project Insert Error. Project Id '.$project->project_id);
            // }

        }
    }

    public function projectentry()
    {

        $projects = DB::connection('brik_it')->table('brik_brik')
                ->whereNotNull("brik_project_id")
                ->whereNull('briklaravel_project_id')
                ->orderBy("brik_project_id", 'ASC')
                ->groupBy("brik_project_id")
                ->get();

        foreach($projects as $project){

            //try{

                $briklaravel_project_id = $this->project($project);

                DB::connection('brik_it')->table('brik_brik')
                ->where("brik_project_id", $project->brik_project_id)
                ->update(["briklaravel_project_id" => $briklaravel_project_id]);

                $this->info('Project Inserted. Brik Project Id '.$project->brik_project_id);

            // }catch(\Exception $e){
            //     $this->info('Project Insert Error. Project Id '.$project->project_id);
            // }

        }
    }

    public function unittypeentry()
    {

        $unittypes = DB::connection('brik_it')->table('brik_brik')
                ->whereNotNull("brik_unit_type_id")
                ->whereNull('briklaravel_unit_type_id')
                ->orderBy("brik_unit_type_id", 'ASC')
                ->groupBy("brik_unit_type_id")
                ->get();

        foreach($unittypes as $unittype)
        {

            $briklaravel_unit_type_id = $this->unittype($unittype);

                DB::connection('brik_it')->table('brik_brik')
                ->where("brik_unit_type_id", $unittype->brik_unit_type_id)
                ->update(["briklaravel_unit_type_id" => $briklaravel_unit_type_id]);

                $this->info('Unit Type Inserted. Brik Unit type Id '.$unittype->brik_unit_type_id);
        }
    }

    public function spvaccountnoupdate()
    {
        // SELECT `location`, count(*) FROM `brik_brik` GROUP BY `location`
        $spvs = DB::connection('brik_it')->table('brik_spvinfo')->groupBy('new_spv_id')->get();
        //dd($spvs);
        $i = 1;
        foreach($spvs as $spv){

            try{
                DB::connection('briklaravelolddata')->table('spvs')->where('id', $spv->new_spv_id)->update(["bank_account_number" => $spv->bank_account_number]);
                $this->info('entry done');
            }catch(\Exception $e){
                $this->info('entry error on id '.$spv->new_spv_id);
                continue;
            }


            $i++;
        }

    }

    public function projectmarking()
    {
        // SELECT `location`, count(*) FROM `brik_brik` GROUP BY `location`
        $locations = DB::connection('brik_it')->table('brik_brik')->select('location')->groupBy('location')->get();

        $i = 1;
        foreach($locations as $location){

            DB::connection('brik_it')->table('brik_brik')->where('location', $location->location)->update(['project_id' =>  $i]);

            $i++;
        }

    }

    public function unittypemarking()
    {

        $unittypes = DB::connection('brik_it')->table('brik_brik')
                     ->whereNotNull("brik_project_id")
                     ->groupBy('brik_project_id','property_type','bedroom','property_area','brik_value')->orderBy('brik_project_id', 'ASC')->get();

        //dd($unittypes->count());

        $i = 1;
        foreach($unittypes as $unittype){

            DB::connection('brik_it')->table('brik_brik')
            ->where('property_type', $unittype->property_type)
            ->where('brik_project_id', $unittype->brik_project_id)
            ->where('bedroom', $unittype->bedroom)
            ->where('property_area', $unittype->property_area)
            ->where('brik_value', $unittype->brik_value)
            ->update(['brik_unit_type_id' =>  $i]);

            $i++;
        }

    }

    public function spvmarking()
    {
        // SELECT `location`, count(*) FROM `brik_brik` GROUP BY `location`
        $spvs = DB::connection('brik_it')->table('brik_spvinfo')->select('bank_account_number')->whereNotNull('bank_account_number')
                ->groupBy('bank_account_number')->get();
        //dd($spvs);
        $i = 1;
        foreach($spvs as $spv){

            try{
                DB::connection('brik_it')->table('brik_spvinfo')->where('bank_account_number', $spv->bank_account_number)->update(['spv_id' =>  $i]);
                $this->info('entry done');
            }catch(\Exception $e){
                $this->info('entry error on id '.$spv->bank_account_number);
                continue;
            }


            $i++;
        }

    }

    public function brikSpvMapping()
    {
        $briks = DB::connection('brik_it')->table('brik_brik')->get();

        foreach($briks as $brik){

           $brikspv = DB::connection('brik_it')->table('brik_spvinfo')->where('brik_id', $brik->id)->first();

           if($brikspv){

                DB::connection('brik_it')->table('brik_brik')->where('id', $brik->id)->update(["new_spv_id" => $brikspv->new_spv_id]);

           }
        }
    }

    public function spvnameupdate()
    {
        $spvs = DB::connection('briklaravelolddata')->table('spvs')->get();
        foreach($spvs as $spv)
        {
            DB::connection('briklaravelolddata')->table('spvs')->where('id', $spv->id)->update(["spv_name" => $spv->bank_account_holder_name]);
        }

    }

    public function spv($spv)
    {

        $spvdata = [
            "spv_name" => $spv->spv_name,
            "spv_formation_date" => $spv->spv_formation_date,
            "bank_name" => $spv->bank_name,
            "bank_account_holder_name" => $spv->bank_account_holder_name,
            "bank_account_number" => $spv->bank_account_holder_name,
            "ifsc_code" => $spv->ifsc_code,
            "pan_card" => $spv->pan_card,
            "coi_number" => $spv->coi_number,
            "pan_card_file"  => null,
            "tan_card_file" => null,
            "coi_file" => null,
            "online_payment" => 0,
            "cashfree_app_id" => null,
            "cashfree_app_secret" => null,
            "account_statement" => null,
            "balance_sheet" => null,
            "profit_loss"  => null,
        ];

        if($spv->new_spv_id){
            DB::connection('briklaravelolddata')->table('spvs')->where('id', $spv->new_spv_id)->update($spvdata);
            return $spv->new_spv_id;
        }else{
            return DB::connection('briklaravelolddata')->table('spvs')->insertGetId($spvdata);
        }
    }

    public function project($brik)
    {
        $state_id = 1;
        $city_id = 1;

        $project_manager_id = $this->projectManager($brik);
        $cancellation_policy_id = $this->cancellationPolicy($brik);
        $house_rules_id = $this->houseRule($brik);
        $pets_friendly_id = $this->petsFreindly($brik);
        $safety_and_property_id = $this->safetyAndProperty($brik);

        $projectdata = [

            "project_name" => $brik->property_name,
            "invest_description" => null,
            "invest_description" => $brik->description,
            "rent_description" => $brik->description,
            "pets_allowed" => $brik->pets_allowed,
            "address" => $brik->location,
            "state_id" => $state_id,
            "city_id" => $city_id,
            "pin" => null,
            "project_manager_id" => $project_manager_id,
            "lat" => $brik->lat,
            "lng" => $brik->lng,
            "cancellation_policy_id" => $cancellation_policy_id,
            "house_rules_id" => $house_rules_id,
            "pets_friendly_id" => $pets_friendly_id,
            "safety_and_property_id" => $safety_and_property_id

        ];



        if($brik->briklaravel_project_id){

            DB::connection('briklaravelolddata')->table('brik_projects')
            ->where('id', $brik->briklaravel_project_id )
            ->update($projectdata);

            return $brik->briklaravel_project_id;

        }else{
            return DB::connection('briklaravelolddata')->table('brik_projects')->insertGetId($projectdata);
        }

    }

    public function unittype($brik)
    {
        $type_id = $this->brikType($brik);
        $property_type_id = $this->brikPropertyType($brik);
        $brik_name = null; //$this->getBrikName($brik);

        $brikdata = [

            "brik_project_id" => $brik->briklaravel_project_id,
            "brik_property_type_id" => $property_type_id,
            "brik_type_id" => $type_id,
            "brik_name" => $brik_name,
            "property_area" => $brik->property_area,
            "bedroom" => $brik->bedroom,
            "bathroom" => $brik->bathroom,
            "accomadation" => $brik->accomadation,
            "brik_value" => $brik->brik_value,
            "capital_gain" => $brik->capital_gain,
            "irr" => $brik->irr,
            "pe_ratio" => $brik->pe_ratio,
            "adults_capacity" => $brik->adults_capacity ? $brik->adults_capacity : 0,
            "children_capacity" => $brik->children_capacity ? $brik->children_capacity : 0,
            "infent_capacity" => 0,
            "pet_capacity" => 0,
            "per_night_inr" => $brik->per_night_inr,
            "per_night_coin" => $brik->per_night_coin,
            "total_coins_per_brik" => $brik->total_coins_per_brik,

        ];


        if($brik->briklaravel_unit_type_id){
            DB::connection('briklaravelolddata')->table('brik_briks')->where('id', $brik->briklaravel_unit_type_id)->update($brikdata);
            return $brik->briklaravel_unit_type_id;
        }else{
            return DB::connection('briklaravelolddata')->table('brik_briks')->insertGetId($brikdata);
        }

    }

    public function newunitentries()
    {
        $spvs = DB::connection('brik_it_new')->table('brik_spvinfo')->whereNull('new_unit_number_id')->get();

        foreach($spvs as $spv)
        {
           $new_unit_number_id = $this->unitnumber($spv);
           DB::connection('brik_it_new')->table('brik_spvinfo')->where('id', $spv->id)->update([
              "new_unit_number_id" => $new_unit_number_id
           ]);
        }
    }

    public function unitnumber($spv)
    {
        $brik = DB::connection('brik_it_new')->table('brik_brik')->where('id', $spv->brik_id)->first();
        $project = DB::connection('brik_it_brikittdevelopment')->table('brik_projects')->where('id', $brik->briklaravel_project_id)->first();
        $city_id = $project ? $project->city_id : null;

        $rent_cover_image = $this->getRentCoverImage($spv);
        $invest_cover_image = $this->getInvestCoverImage($brik);
        $gallery_images = $this->getGalleryImages($spv);

        $brikdata = [

            "booking_portal_display_name" => $spv ? $spv->spv_name : null,
            "ru_property_id" => null,
            "spv_id" => $brik->new_spv_id,
            "brik_id" => $brik->briklaravel_unit_type_id,
            "project_id" => $brik->briklaravel_project_id,
            "property_area" => $brik->property_area,
            "brik_value" => $brik->brik_value,
            "capital_gain" => $brik->capital_gain,
            "irr" => $brik->irr,
            "pe_ratio" => $brik->pe_ratio,
            "per_night_inr" => $brik->per_night_inr,
            "per_night_coin" => $brik->per_night_coin,
            "total_coins_per_brik" => $brik->total_coins_per_brik,
            "rent_cover_image" => $rent_cover_image,
            "rent_gallery_images" => $gallery_images,
            "invest_cover_image" => $invest_cover_image,
            "invest_gallery_images" => $gallery_images,
            "unit_name" => null,
            "unit_number" => $spv ? $spv->unit_number : null,
            "city_id" => $city_id,
            "adults_capacity" => $brik->adults_capacity ? $brik->adults_capacity : 0,
            "children_capacity" => $brik->children_capacity ? $brik->children_capacity : 0,
            "infent_capacity" => 0,
            "pet_capacity" => 0,
            "property_view" => $brik->property_view,
            "possession" => $spv->possession_status,
            "date_of_possession" => $spv->date_of_possession,
            "managed_property" => $brik->managed_property ? $brik->managed_property : 0,
            "rent_active" => $spv->active ? $spv->active : 0,
            "invest_active" => $brik->active ? $brik->active : 0,
            "newly_launched" => 0,
            "property_video" => null,
            "view_360" => null,
            "rating" => 5

        ];



        if($spv->new_unit_number_id){
            DB::connection('brik_it_brikittdevelopment')->table('brik_units')->where('id', $spv->new_unit_number_id)->update($brikdata);
            return $spv->new_unit_number_id;
        }else{
            return DB::connection('brik_it_brikittdevelopment')->table('brik_units')->insertGetId($brikdata);
        }

    }

    public function removeUnwantedUnitNumbers()
    {
        $units = DB::connection('brik_it')->table('brik_spvinfo')->where("need_remove", 1)->get();

        foreach($units as $unit){
            DB::connection('briklaravelolddata')->table('brik_units')->where("id", $unit->new_unit_number_id)->delete();
        }
    }

    public function updateUnitNumberprojectandunittype()
    {
        $units = DB::connection('brik_it')->table('brik_spvinfo')->where("need_remove", 0)->get();

        foreach($units as $unit){

            $brik = DB::connection('brik_it')->table('brik_brik')->where('id', $unit->brik_id)->first();

            DB::connection('briklaravelolddata')->table('brik_units')->where("id", $unit->new_unit_number_id)
            ->update(["project_id" => $brik->briklaravel_project_id, "brik_id" => $brik->briklaravel_unit_type_id]);
        }
    }

    public function updateBrikOwnerunitid()
    {
        $owners = DB::connection('brik_it_new')->table('brik_brikowner')->get();

        foreach($owners as $owner){

           $spvinfo = DB::connection('brik_it_new')->table('brik_spvinfo')->where('id', $owner->spv_id)->first();

           DB::connection('brik_it_new')->table('brik_brikowner')->where('id', $owner->id)->update(["new_brik_unit_id" => $spvinfo->new_unit_number_id]);

        }
    }

    public function newupdateBrikOwnerunitid()
    {
        $owners = DB::connection('brik_it_new')->table('brik_brikowner')->get();

        foreach($owners as $owner){


           DB::connection('brik_it_brikittdevelopment')->table('brik_owners')->where('id', $owner->new_ownership_id)->update(["brik_unit_id" => $owner->new_brik_unit_id]);

        }
    }

    public function matchunitnumber()
    {
        $briks = DB::connection('brik_it')->table('brik_brik')->get();

        $i = 1;
        foreach($briks as $brik)
        {
            DB::connection('brik_it')->table('brik_brik')->where('id', $brik->id)->update(["new_unit_number_id" => $i]);

            $i++;
        }
    }



    public function projectManager($brik)
    {
        if($brik->brik_manager){
            $manager = DB::connection('briklaravelolddata')->table('brik_managers')->where('name', $brik->brik_manager)->first();

            if($manager){
                return $manager->id;
            }else{

                $image = $this->putImage($brik->brik_manager_image,'images/employee/');

                $managerdata = [

                    "name" => $brik->brik_manager,
                    "image" => $image ,
                    "designation" => 'Manager',
                    "email" => null,
                    "phone" => $brik->brik_manager_contact,

                ];

                return DB::connection('briklaravelolddata')->table('brik_managers')->insertGetId($managerdata);
            }
        }
    }

    public function cancellationPolicy($brik)
    {
        if($brik->cancellation_policy_id){

          $policy =  DB::connection('brik_it')->table('brik_cancellationpolicy')->where('id', $brik->cancellation_policy_id)->first();

          if($policy){

            $chk = DB::connection('briklaravelolddata')->table('brik_cancellation_policies')->where('title', $policy->title);

            if($chk->count() == 0){

                $policydata = [
                    "title" => $policy->title,
                    "cancellation_policy" => $policy->cancellationPolicy,
                ];

                return DB::connection('briklaravelolddata')->table('brik_cancellation_policies')->insertGetId($policydata);
            }else{
                return $chk->first()->id;
            }

          }
        }

        return null;
    }

    public function houseRule($brik)
    {
        if($brik->house_rules_id ){

          $rule =  DB::connection('brik_it')->table('brik_houserule')->where('id', $brik->house_rules_id)->first();

          if($rule){

            $chk = DB::connection('briklaravelolddata')->table('brik_houserules')->where('title', $rule->title);

            if($chk->count() == 0){

                $ruledata = [
                    "title" => $rule->title,
                    "rule" => $rule->rule,
                ];

                return DB::connection('briklaravelolddata')->table('brik_houserules')->insertGetId($ruledata);
            }else{
                return $chk->first()->id;
            }

          }
        }

        return null;
    }

    public function petsFreindly($brik)
    {
        if($brik->pets_friendly_id ){

          $rule =  DB::connection('brik_it')->table('brik_petsfriendly')->where('id', $brik->pets_friendly_id)->first();

          if($rule){

            $chk = DB::connection('briklaravelolddata')->table('brik_petsfriendlies')->where('title', $rule->title);

            if($chk->count() == 0){

                $ruledata = [
                    "title" => $rule->title,
                    "pets_friendly" => $rule->petsFriendly,
                ];

                return DB::connection('briklaravelolddata')->table('brik_petsfriendlies')->insertGetId($ruledata);
            }else{
                return $chk->first()->id;
            }

          }
        }

        return null;
    }

    public function safetyAndProperty($brik)
    {
        if($brik->safety_and_property_id ){

          $rule =  DB::connection('brik_it')->table('brik_safetyandproperty')->where('id', $brik->safety_and_property_id)->first();

          if($rule){

            $chk = DB::connection('briklaravelolddata')->table('brik_safetyandproperties')->where('title', $rule->title);

            if($chk->count() == 0){

                $ruledata = [
                    "title" => $rule->title,
                    "safety_and_property" => $rule->safetyAndProperty,
                ];

                return DB::connection('briklaravelolddata')->table('brik_safetyandproperties')->insertGetId($ruledata);
            }else{
                return $chk->first()->id;
            }

          }
        }

        return null;
    }

    public function brikPropertyType($brik)
    {
        if($brik->bedroom == 1){
            return 1;
        }else if($brik->bedroom == 2){
            return 2;
        }else if($brik->bedroom == 3){
            return 3;
        }else{
            return null;
        }
    }

    public function brikType($brik)
    {
        if($brik->property_type){
            $chk = DB::connection('briklaravelolddata')->table('brik_types')->where('name', $brik->property_type);
            if($chk->count() > 0){
                return $chk->first()->id;
            }else{
                return DB::connection('briklaravelolddata')->table('brik_types')->insertGetId(["name" => $brik->property_type]);
            }
        }
        return null;
    }

    public function putImage($pullimageuri,$putpath)
    {
        if($pullimageuri){

            $pullserver = 'https://brikkit-prod-docs.s3.amazonaws.com/media/';
            $pullimagepath = $pullserver.$pullimageuri;

            $extension = $this->getImageExtension($pullimagepath);

            $imagename = $putpath.uniqid();
            $putimage = $imagename.'.'.$extension;
            $putimagepath = storage_path('app\public\\').$imagename.'.'.$extension;

            $imageData = file_get_contents($pullimagepath);
            if ($imageData !== false) {
                file_put_contents($putimagepath, $imageData);

                return $putimage;
            }
        }


        return null;
    }

    public function getImageExtension($url)
    {
        $cleanUrl = parse_url($url, PHP_URL_PATH);
        $extension = pathinfo($cleanUrl, PATHINFO_EXTENSION);

        return $extension; // Output: jpg
    }

    public function getSpv($brik)
    {
        return DB::connection('brik_it')->table('brik_spvinfo')->where('brik_id', $brik->id)->first();
    }

    public function getRentCoverImage($spv)
    {
        if($spv->spv_cover_image){
            return $this->putImage($spv->spv_cover_image,'images/brik/');
        }
        return null;
    }

    public function getInvestCoverImage($brik)
    {
        if($brik->brik_cover_image){
            return $this->putImage($brik->brik_cover_image,'images/brik/');
        }
        return null;
    }

    public function getGalleryImages($spv)
    {
        $res = [];
        $images = DB::connection('brik_it')->table('brik_brikimage')->where('spv_id', $spv->id)->get();

        foreach($images as $image)
        {
            $image = $this->putImage($image->image,'images/brik/');
            if($image){
                $res[] = $image;
            }
        }

        return json_encode($res);

    }



}
