<?php

namespace App\Console\Commands;

use App\Models\BrikAmenity;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class MigrateMasters extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */

    protected $signature = 'app:migrate-masters'; // Run Every 5 mins

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
       $this->info('Code execution started.');

       $this->amenities();
       $this->addonservices();

       $this->info('Code execution ended.');
    }

    public function addonservices()
    {
        $oldaddonservices = DB::connection('brik_it')->table('brik_addonservice')->where('done', 0)->get();
        foreach($oldaddonservices as $oldaddonservice){

            $insdata = [
                "feature" => $oldaddonservice->add_on_feature,
            ];

            DB::connection('briklaravelolddata')->table('brik_addon_services')->insert($insdata);
            DB::connection('brik_it')->table('brik_addonservice')->where('id', $oldaddonservice->id)->update(["done" => 1]);
            $this->info('Addonservice Inserted.');
        }
    }

    public function amenities()
    {
        $oldamenities = DB::connection('brik_it')->table('brik_amenity')->where('done', 0)->get();
        foreach($oldamenities as $oldamenity)
        {

            $image = $this->putImage($oldamenity->aminety_icon,'images/amenity/');

            $insdata = [
                "feature" => $oldamenity->amenity_feature,
                "icon" => $image,
            ];

            DB::connection('briklaravelolddata')->table('brik_amenities')->insert($insdata);
            DB::connection('brik_it')->table('brik_amenity')->where('id', $oldamenity->id)->update(["done" => 1]);
            $this->info('Amenity Inserted.');
        }
    }

    public function putImage($pullimageuri,$putpath)
    {
        if($pullimageuri){

            $pullserver = 'https://brikkit-prod-docs.s3.amazonaws.com/media/';
            $pullimagepath = $pullserver.$pullimageuri;

            $extension = $this->getImageExtension($pullimagepath);

            $imagename = $putpath.uniqid();
            $putimage = $imagename.'.'.$extension;
            $putimagepath = storage_path('app\public\\').$imagename.'.'.$extension;

            $imageData = file_get_contents($pullimagepath);
            if ($imageData !== false) {
                file_put_contents($putimagepath, $imageData);

                return $putimage;
            }
        }


        return null;
    }

    public function getImageExtension($url)
    {
        $cleanUrl = parse_url($url, PHP_URL_PATH);
        $extension = pathinfo($cleanUrl, PATHINFO_EXTENSION);

        return $extension; // Output: jpg
    }



}
