<?php

namespace App\Console\Commands;

use App\Models\BrikAmenity;
use Exception;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class MigrateOwner extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */

    protected $signature = 'app:migrate-owner';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
       $this->info('Code execution started.');

       //$this->clientidupdate();
       //$this->brikownermarking();
       //$this->brikownerentry();
       //$this->updateBrikOwnerInBrikittnew();
       //$this->brikownermarkinginownership();
       //$this->brikownermarkinginunitnumber();
       //$this->brikownershipentry();
       //$this->newinstallmentupdate();
       //$this->updateinstallmentpaymentflag();
       //$this->installmentpayments();
       //$this->ownershipupdate();
       //$this->payplanupdate();
       $this->amcupdate();


       $this->info('Code execution ended.');


    }

    public function clientidupdate()
    {
        $owners = DB::connection('brik_it_new')->table('identity_user')->get();
        foreach($owners as $owner){

            $old_owner = DB::connection('brik_it')->table('identity_user')->where('id', $owner->id)->first();

            if($old_owner){
                DB::connection('brik_it_new')->table('identity_user')->where('id', $owner->id)->update([
                    "client_id" => $old_owner->client_id,
                    "is_owner" => $old_owner->is_owner
                ]);
            }
        }
    }

    public function brikownernumberupdate()
    {
        $owners = DB::connection('briklaravelolddata')->table('brik_owners')->get();
        foreach($owners as $owner)
        {
            try{
                $ownership_sq = (int)filter_var($owner->ownership_number, FILTER_SANITIZE_NUMBER_INT);

                DB::connection('briklaravelolddata')->table('brik_owners')->where('id', $owner->id)->update(["ownership_sq" => $ownership_sq]);
            }catch(\Exception $e){
                continue;
            }

        }
    }

    public function installmententry()
    {

        $installments = DB::connection('brik_it')->table('brik_installments')->whereNull('new_installment_id')->get();
        foreach($installments as $installment){

            //try{

                $new_installment_id = $this->installment($installment);

                DB::connection('brik_it')->table('brik_installments')->where('id', $installment->id)->update(["new_installment_id" => $new_installment_id]);

                $this->info('installment Inserted. installment Id '.$installment->id);

            // }catch(\Exception $e){
            //     $this->info('Project Insert Error. Project Id '.$project->project_id);
            // }

        }
    }

    public function amcnewownerupdate()
    {

        $amcs = DB::connection('brik_it')->table('brik_annualmaintenance')->get();
        foreach($amcs as $amc){

            $owner = DB::connection('brik_it')->table('brik_brikowner')->where('id', $amc->brik_owner_id)->first();
            if($owner){

                DB::connection('brik_it')->table('brik_annualmaintenance')->where('id', $amc->id)->update(["new_brik_owner_id" => $owner->new_ownership_id]);

            }


            //try{

                // $new_installment_id = $this->installment($installment);

                // DB::connection('brik_it')->table('brik_brikowner')->where('id', $installment->id)->update(["new_installment_id" => $new_installment_id]);

                // $this->info('installment Inserted. installment Id '.$installment->id);

            // }catch(\Exception $e){
            //     $this->info('Project Insert Error. Project Id '.$project->project_id);
            // }

        }
    }

    public function amcentry()
    {

        $amcs = DB::connection('brik_it')->table('brik_annualmaintenance')->whereNull('new_amc_id')->get();
        foreach($amcs as $amc){


            // try{

                $new_amc_id = $this->amc($amc);

                DB::connection('brik_it')->table('brik_annualmaintenance')->where('id', $amc->id)->update(["new_amc_id" => $new_amc_id]);

                $this->info('AMC Inserted. AMC Id '.$amc->id);

            // }catch(\Exception $e){
            //     $this->info('Project Insert Error. Project Id '.$project->project_id);
            // }

        }
    }

    public function amc($amc)
    {
        //dd($installment);
       $payableamt = $amc->cost_per_year - $amc->annualMaintenance_referal_discount;

       // $balanceamt = $installment->installment_paid == 1 ? 0 : $payableamt;

        $amctdata = [
            "maintenance_year" => $amc->maintenance_year,
            "cost_per_year" => $amc->cost_per_year,
            "due_date" => $amc->due_date,
            "annual_maintenance_referal_discount" => $amc->annualMaintenance_referal_discount,
            "payable_amount" => $payableamt,
            "waived_off" => $amc->waived_off,
            "maintenance_paid" => $amc->maintenance_paid,
            "pay_order_id" => null,
            "cf_order_id" => null,
            "payment_status" => $amc->maintenance_paid == 1 ? 'PAID' : null,
            "payment_date" => $amc->payment_date,
            "payment_receipt" => null,
            "brik_owner_id" => $amc->new_brik_owner_id,
            "receipt_no_old"  => null,
        ];

        if($amc->new_amc_id){
            DB::connection('briklaravelolddata')->table('brik_annual_maintenances')->where('id', $amc->new_amc_id)->update($amctdata);
            return $amc->new_amc_id;
        }else{
            return DB::connection('briklaravelolddata')->table('brik_annual_maintenances')->insertGetId($amctdata);
        }
    }

    public function amcreceiptnoupdate()
    {
        $amcs = DB::connection('brik_it')->table('brik_annualmaintenance')->where('maintenance_paid', 1)->get();
        foreach($amcs as $amc){
            $rcpt = DB::connection('brik_it')->table('brik_paymentreceipt')->where('maintenance_id', $amc->id)->first();

            if($rcpt){
                $receipt_no = 'BRK_'.$rcpt->brik_owner_id.'_'.$rcpt->id;
                DB::connection('brik_it')->table('brik_annualmaintenance')->where('id', $amc->id)->update(['receipt_no' => $receipt_no]);
            }
        }
    }

    public function newamcreceiptnoupdate()
    {
        $amcs = DB::connection('brik_it')->table('brik_annualmaintenance')->where('maintenance_paid', 1)->get();
        foreach($amcs as $amc){

                DB::connection('briklaravelolddata')->table('brik_annual_maintenances')->where('id', $amc->new_amc_id)->update(['receipt_no_old' => $amc->receipt_no]);

        }
    }


    public function installment($installment)
    {
        //dd($installment);
        $payableamt = $installment->instalment_amount + $installment->interest_on_installment - $installment->installment_referal_discount;

        $balanceamt = $installment->installment_paid == 1 ? 0 : $payableamt;

        $installmentdata = [
            "installment" => $installment->installment,
            "installment_amount" => $installment->instalment_amount,
            "due_date" => $installment->due_date,
            "installment_referal_discount" => $installment->installment_referal_discount,
            "interest_on_installment" => $installment->interest_on_installment,
            "payable_amount" => $payableamt,
            "amount_paid" => $installment->amount_paid,
            "balance_amount" => $balanceamt,
            "installment_paid" => $installment->installment_paid,
            "paid_date" => $installment->paid_date,
            "pay_order_id" => null,
            "cf_order_id" => null,
            "payment_status" => $installment->installment_paid == 1 ? 'PAID' : null,
            "payment_plan_id" => $installment->payment_plan_id,
            "active" => 1,
            "receipt_no_old" => null,
        ];

        if($installment->new_installment_id){
            DB::connection('briklaravelolddata')->table('brik_installments')->where('id', $installment->new_installment_id)->update($installmentdata);
            return $installment->new_installment_id;
        }else{
            return DB::connection('briklaravelolddata')->table('brik_installments')->insertGetId($installmentdata);
        }
    }

    public function installmentreceipno()
    {
        $installments = DB::connection('brik_it')->table('brik_installments')->get();
        foreach($installments as $installment){
           $rec = DB::connection('brik_it')->table('brik_paymentreceipt')->where('installment_id', $installment->id)->first();
           if($rec){
             $receip_no = 'BRK_'.$rec->brik_owner_id.'_'.$rec->id;
             DB::connection('brik_it')->table('brik_installments')->where('id', $installment->id)->update(["receipt_no" => $receip_no]);
           }
        }
    }

    public function installmentpaymentplanupdate()
    {
        $installments = DB::connection('brik_it')->table('brik_installments')->get();
        foreach($installments as $installment){
           $pp = DB::connection('brik_it')->table('brik_paymentmyplan')->where('id', $installment->payment_plan_id)->first();
           if($pp){
            DB::connection('brik_it')->table('brik_installments')->where('id', $installment->id)->update(["new_payment_plan_id" => $pp->new_paymentmyplan_id]);
           }
        }
    }

    public function newinstallmentupdate()
    {
        $installments = DB::connection('brik_it_new')->table('brik_installments')->get();
        foreach($installments as $installment){

            DB::connection('brik_it_brikittdevelopment')->table('brik_installments')->where('id', $installment->new_installment_id)->update(["payment_plan_id" => $installment->new_payment_plan_id, "receipt_no_old" => $installment->receipt_no]);

        }
    }

    public function newinstallmentupdateamount()
    {
        $installments = DB::connection('briklaravelolddata')->table('brik_installments')->where('installment_paid', 1)->get();
        foreach($installments as $installment){

            DB::connection('briklaravelolddata')->table('brik_installments')->where('id', $installment->id)->update(["amount_paid" => $installment->payable_amount]);

        }
    }

    public function updateinstallmentpaymentflag()
    {
        $installments = DB::connection('brik_it_new')->table('brik_installments')->get();
        foreach($installments as $installment){

            DB::connection('brik_it_brikittdevelopment')->table('brik_installments')->where('id', $installment->new_installment_id)->update(
                [
                    "installment" => $installment->installment,
                    "installment_amount" => $installment->instalment_amount,
                    "due_date" => $installment->due_date,
                    "installment_paid" => $installment->installment_paid,
                    "amount_paid" => $installment->amount_paid,
                    "installment_referal_discount" => $installment->installment_referal_discount,
                    "interest_on_installment" => $installment->interest_on_installment,
                    "payable_amount" => ($installment->instalment_amount + $installment->interest_on_installment - $installment->installment_referal_discount)

                ]
            );

        }
    }



    public function installmentpayments()
    {
        $installments = DB::connection('brik_it_brikittdevelopment')->table('brik_installments')->where('installment_paid',1)->get();

        foreach($installments as $installment){

          $inst_pay = DB::connection('brik_it_brikittdevelopment')->table('brik_installment_payments')->where('brik_installment_id', $installment->id)->first();


            $data = [
                "brik_installment_id" => $installment->id,
                "paid_amount" => $installment->amount_paid ? $installment->amount_paid : 0,
                "date" => $installment->paid_date,
                "mail_sent" => 1
            ];

           if($inst_pay){
                DB::connection('brik_it_brikittdevelopment')->table('brik_installment_payments')->where('id', $inst_pay->id)->update($data);
           }else{
                DB::connection('brik_it_brikittdevelopment')->table('brik_installment_payments')->insert($data);
           }




        }
    }

    public function ownershipupdate()
    {
        $ownerships = DB::connection('brik_it_new')->table('brik_brikowner')->get();

        foreach($ownerships as $ownership){
            DB::connection('brik_it_brikittdevelopment')->table('brik_owners')->where('id', $ownership->new_ownership_id)->update([
              "invested_amount" => $ownership->invested_amount,
            ]);
        }
    }

    public function payplanupdate()
    {
        $payplans = DB::connection('brik_it_new')->table('brik_paymentmyplan')->get();

        foreach($payplans as $payplan){
            DB::connection('brik_it_brikittdevelopment')->table('brik_paymentmyplans')->where('id', $payplan->new_paymentmyplan_id)->update([
              "invested_amount" => $payplan->invested_amount,
              "booking_amount" => $payplan->booking_amount,
              "booking_amount_paid" => $payplan->booking_amount_paid,
              "payment_date" => $payplan->payment_date,
              "booking_amount_balance" => $payplan->booking_amount_balance,
              "discount_booking" => $payplan->discount_booking,
              "discount_brik" => $payplan->discount_brik,
            ]);
        }
    }

    public function amcupdate()
    {
        $amcs = DB::connection('brik_it_new')->table('brik_annualmaintenance')->get();

        foreach($amcs as $amc){
            DB::connection('brik_it_brikittdevelopment')->table('brik_annual_maintenances')->where('id', $amc->new_amc_id)->update([
              "cost_per_year" => $amc->cost_per_year,
              "payment_date" => $amc->payment_date,
              "due_date" => $amc->due_date,
              "waived_off" => $amc->waived_off,
              "annual_maintenance_referal_discount" => $amc->annualMaintenance_referal_discount,
              "payable_amount" => ($amc->cost_per_year - $amc->annualMaintenance_referal_discount),
              "maintenance_paid" => $amc->maintenance_paid,
            ]);
        }
    }

    public function brikownerentry()
    {

        $owners = DB::connection('brik_it_new')->table('identity_user')->where('is_owner', 1)->whereNull('client_id')->get();
        foreach($owners as $owner){

            //try{

                $new_owner_id = $this->brikowner($owner);

                DB::connection('brik_it_new')->table('identity_user')->where('id', $owner->id)->update(["client_id" => $new_owner_id]);

                $this->info('Brik Owner Inserted. Owner Id '.$owner->id);

            // }catch(\Exception $e){
            //     $this->info('Project Insert Error. Project Id '.$project->project_id);
            // }

        }
    }

    public function brikowner($owner)
    {
        $marital_status = null;
        if($owner->marital_status == 'Single'){
            $marital_status = 'Unmarried';
        }else if($owner->marital_status == 'Married'){
            $marital_status = 'Married';
        }

        $profile_pic = $this->putImage($owner->profile_pic,'images/clients/profile/');

        $ownerdata = [
            "first_name" => $owner->first_name,
            "last_name" => $owner->last_name,
            "dob" => $owner->dob,
            "address" => $owner->house_number.' '.$owner->street,
            "state" => $owner->state,
            "city" => $owner->city,
            "pin" => $owner->pincode,
            "email" => $owner->email,
            "mobile" => $owner->mobile_number,
            "otp" => null,
            "profession" => $owner->occupation,
            "emergency_phone" => null,
            "marital_status" => $marital_status,
            "anniversary_date" => $owner->anniversary_date,
            "gender" => null,
            "image" => $profile_pic,
            "coins" => 0,
            "wallet_amount" => 0,
            "is_owner" => 1,
        ];

        if($owner->client_id){
            DB::connection('brik_it_brikittdevelopment')->table('clients')->where('id', $owner->client_id)->update($ownerdata);
            return $owner->client_id;
        }else{
            return DB::connection('brik_it_brikittdevelopment')->table('clients')->insertGetId($ownerdata);
        }
    }

    public function updateBrikOwnerInBrikittnew()
    {
        $brikowners = DB::connection('brik_it_new')->table('brik_brikowner')->get();

        foreach($brikowners as $brikowner)
        {
            $oldbrikowner = DB::connection('brik_it')->table('brik_brikowner')->where('id', $brikowner->id)->first();

            if($oldbrikowner){
                DB::connection('brik_it_new')->table('brik_brikowner')->where('id', $brikowner->id)->update([
                    "new_owner_id" => $oldbrikowner->new_owner_id,
                    "new_brik_unit_id" => $oldbrikowner->new_brik_unit_id,
                    "new_ownership_id" => $oldbrikowner->new_ownership_id,
                ]);
            }
        }
    }

    public function brikownershipentry()
    {

        $owners = DB::connection('brik_it_new')->table('brik_brikowner')->whereNull('new_ownership_id')->get();
        foreach($owners as $owner){

            //try{

                $new_ownership_id = $this->brikownership($owner);

                DB::connection('brik_it_new')->table('brik_brikowner')->where('id', $owner->id)->update(["new_ownership_id" => $new_ownership_id]);

                $this->info('Brik Ownership Inserted. Brik Owner Id '.$owner->id);

            // }catch(\Exception $e){
            //     $this->info('Project Insert Error. Project Id '.$project->project_id);
            // }

        }
    }

    public function paymentplanentry()
    {

        $payplans = DB::connection('brik_it')->table('brik_paymentmyplan')->whereNull('new_paymentmyplan_id')->get();
        foreach($payplans as $payplan){

            //try{

                $new_paymentmyplan_id = $this->paymentplan($payplan);

                DB::connection('brik_it')->table('brik_paymentmyplan')->where('id', $payplan->id)->update(["new_paymentmyplan_id" => $new_paymentmyplan_id]);

                $this->info('Payment plan Inserted. Paymentplan Id '.$payplan->id);

            // }catch(\Exception $e){
            //     $this->info('Project Insert Error. Project Id '.$project->project_id);
            // }

        }
    }

    public function brikownership($ownership)
    {
        if($ownership->ownership){
            $ownershipstr = trim($ownership->ownership);
            $ownershiparr = explode("/", $ownershipstr);
            $ownership_fraction = $ownershiparr[0];
            $ownership_outof = $ownershiparr[1];
        }else{
            $ownership_fraction = 0;
            $ownership_outof = 11;
        }


        $ownershipdata = [
            "invested_amount" => $ownership->invested_amount,
            "ownership" => $ownership_fraction,
            "ownership_outof" => $ownership_outof,
            "ownership_sq" => floatval($ownership->ownership_number),
            "ownership_number" => $ownership->ownership_number,
            "brik_buy_date" => date("Y-m-d", strtotime($ownership->brik_buy_date)),
            //"spv",
            //"spv_formation_date",
            //"relationship_manager_id",
            "remark" => $ownership->remark,
            "disabled" => $ownership->disabled,
            "owner_id" => $ownership->new_owner_id,
            "brik_unit_id" => $ownership->new_brik_unit_id,
        ];

        if($ownership->new_ownership_id){
            DB::connection('brik_it_brikittdevelopment')->table('brik_owners')->where('id', $ownership->new_ownership_id)->update($ownershipdata);
            return $ownership->new_ownership_id;
        }else{
            return DB::connection('brik_it_brikittdevelopment')->table('brik_owners')->insertGetId($ownershipdata);
        }
    }

    public function paymentplanupdate()
    {

        $payplans = DB::connection('briklaravelolddata')->table('brik_paymentmyplans')->get();
        foreach($payplans as $payplan){

                $ownership = DB::connection('briklaravelolddata')->table('brik_owners')->where('id', $payplan->brik_owner_id)->first();
                $payment_date = date("Y-m-d", strtotime($payplan->payment_date));

                DB::connection('briklaravelolddata')->table('brik_paymentmyplans')->where('id', $payplan->id)->update(["brik_count" => $ownership->ownership, "payment_date" => $payment_date]);

                $this->info('Payment plan updated. Paymentplan Id '.$payplan->id);


        }
    }

    public function brikownerupdate()
    {

        $brikowners = DB::connection('briklaravelolddata')->table('brik_owners')->get();
        foreach($brikowners as $brikowner){

                $payplan = DB::connection('briklaravelolddata')->table('brik_paymentmyplans')->where('brik_owner_id', $brikowner->id)->first();

                if($payplan)
                {
                    DB::connection('briklaravelolddata')->table('brik_owners')->where('id', $brikowner->id)->update(["paymentmyplan_id" => $payplan->id]);

                   $this->info('Brik Owner updated. Brik Owner Id '.$brikowner->id);
                }else{
                    $this->info('Brik Owner payment plan not available. Brik Owner Id '.$brikowner->id);
                }



        }
    }

    public function brikownermarkinginownership()
    {
        $ownerships = DB::connection('brik_it_new')->table('brik_brikowner')->whereNull('new_owner_id')->get();
        foreach($ownerships as $ownership){

            $own = DB::connection('brik_it_new')->table('identity_user')->where('id', $ownership->owner_id)->first();
            if($own){

                if($own->client_id){
                    DB::connection('brik_it_new')->table('brik_brikowner')->where('id', $ownership->id)->update(["new_owner_id" => $own->client_id]);
                }
            }

        }
    }

    public function paymentplanUpdateNewOwnershipId()
    {
       $payplans = DB::connection('brik_it')->table('brik_paymentmyplan')->get();
        foreach($payplans as $payplan){

            $brikownership = DB::connection('brik_it')->table('brik_brikowner')->where('id', $payplan->brik_owner_id)->first();

            DB::connection('brik_it')->table('brik_paymentmyplan')->where('id', $payplan->id)->update(["new_brik_owner_id" => $brikownership->new_ownership_id]);

                $this->info('Updated Brik Owner Id '.$payplan->id);

        }
    }

    public function paymentplan($paymentplan)
    {
        $brikownership = DB::connection('brik_it')->table('brik_brikowner')->where('id', $paymentplan->brik_owner_id)->first();
        $no_of_installment = DB::connection('brik_it')->table('brik_installments')->where('payment_plan_id', $paymentplan->id)->count();

        $payplandata = [
            "invested_amount" => $brikownership->invested_amount,
            "brik_count" => null,
            "booking_amount" => $paymentplan->booking_amount,
            "booking_amount_paid" => $paymentplan->booking_amount_paid,
            "gst_paid" => $paymentplan->gst_paid ? $paymentplan->gst_paid : 0,
            "payment_date" => $paymentplan->payment_date,
            "booking_amount_balance" => $paymentplan->booking_amount_balance,
            "discount_booking" => $paymentplan->discount_booking,
            "discount_brik" => $paymentplan->discount_brik,
            "no_of_installments" => $no_of_installment,
            "brik_owner_id" => $paymentplan->new_brik_owner_id,
        ];

        if($paymentplan->new_paymentmyplan_id){
            DB::connection('briklaravelolddata')->table('brik_paymentmyplans')->where('id', $paymentplan->new_paymentmyplan_id)->update($payplandata);
            return $paymentplan->new_paymentmyplan_id;
        }else{
            return DB::connection('briklaravelolddata')->table('brik_paymentmyplans')->insertGetId($payplandata);
        }
    }

    public function brikownermarkinginunitnumber()
    {
        $briks = DB::connection('brik_it_new')->table('brik_brik')->get();
        foreach($briks as $brik){

            DB::connection('brik_it_new')->table('brik_brikowner')->where('brik_id', $brik->id)->update(["new_brik_unit_id" => $brik->new_unit_number_id]);

        }
    }

    public function brikownermarking()
    {
        // SELECT `location`, count(*) FROM `brik_brik` GROUP BY `location`
        $owners = DB::connection('brik_it_new')->table('brik_brikowner')->get();


        foreach($owners as $owner){

            DB::connection('brik_it_new')->table('identity_user')->where('id', $owner->owner_id)->update(['is_owner' =>  1]);

        }

    }

    public function unittypemarking()
    {

        $unittypes = DB::connection('brik_it')->table('brik_brik')->groupBy('new_project_id','property_type','bedroom','property_area')->get();

        $i = 1;
        foreach($unittypes as $unittype){

            DB::connection('brik_it')->table('brik_brik')->where('property_type', $unittype->property_type)
            ->where('new_project_id', $unittype->new_project_id)
            ->where('bedroom', $unittype->bedroom)
            ->where('property_area', $unittype->property_area)
            ->update(['unit_type_id' =>  $i]);

            $i++;
        }

    }

    public function spvmarking()
    {
        // SELECT `location`, count(*) FROM `brik_brik` GROUP BY `location`
        $spvs = DB::connection('brik_it')->table('brik_spvinfo')->select('bank_account_number')->whereNotNull('bank_account_number')
                ->groupBy('bank_account_number')->get();
        //dd($spvs);
        $i = 1;
        foreach($spvs as $spv){

            try{
                DB::connection('brik_it')->table('brik_spvinfo')->where('bank_account_number', $spv->bank_account_number)->update(['spv_id' =>  $i]);
                $this->info('entry done');
            }catch(\Exception $e){
                $this->info('entry error on id '.$spv->bank_account_number);
                continue;
            }


            $i++;
        }

    }

    public function brikSpvMapping()
    {
        $briks = DB::connection('brik_it')->table('brik_brik')->get();

        foreach($briks as $brik){

           $brikspv = DB::connection('brik_it')->table('brik_spvinfo')->where('brik_id', $brik->id)->first();

           if($brikspv){

                DB::connection('brik_it')->table('brik_brik')->where('id', $brik->id)->update(["new_spv_id" => $brikspv->new_spv_id]);

           }
        }
    }

    public function spvnameupdate()
    {
        $spvs = DB::connection('briklaravelolddata')->table('spvs')->get();
        foreach($spvs as $spv)
        {
            DB::connection('briklaravelolddata')->table('spvs')->where('id', $spv->id)->update(["spv_name" => $spv->bank_account_holder_name]);
        }

    }

    public function spv($spv)
    {

        $spvdata = [
            "spv_name" => $spv->spv_name,
            "spv_formation_date" => $spv->spv_formation_date,
            "bank_name" => $spv->bank_name,
            "bank_account_holder_name" => $spv->bank_account_holder_name,
            "bank_account_number" => $spv->bank_account_holder_name,
            "ifsc_code" => $spv->ifsc_code,
            "pan_card" => $spv->pan_card,
            "coi_number" => $spv->coi_number,
            "pan_card_file"  => null,
            "tan_card_file" => null,
            "coi_file" => null,
            "online_payment" => 0,
            "cashfree_app_id" => null,
            "cashfree_app_secret" => null,
            "account_statement" => null,
            "balance_sheet" => null,
            "profit_loss"  => null,
        ];

        if($spv->new_spv_id){
            DB::connection('briklaravelolddata')->table('spvs')->where('id', $spv->new_spv_id)->update($spvdata);
            return $spv->new_spv_id;
        }else{
            return DB::connection('briklaravelolddata')->table('spvs')->insertGetId($spvdata);
        }
    }

    public function project($brik)
    {
        $state_id = 1;
        $city_id = 1;

        $project_manager_id = $this->projectManager($brik);
        $cancellation_policy_id = $this->cancellationPolicy($brik);
        $house_rules_id = $this->houseRule($brik);
        $pets_friendly_id = $this->petsFreindly($brik);
        $safety_and_property_id = $this->safetyAndProperty($brik);

        $projectdata = [

            "project_name" => $brik->property_name,
            "invest_description" => null,
            "rent_description" => $brik->description,
            "pets_allowed" => $brik->pets_allowed,
            "address" => $brik->location,
            "state_id" => $state_id,
            "city_id" => $city_id,
            "pin" => null,
            "project_manager_id" => $project_manager_id,
            "lat" => $brik->lat,
            "lng" => $brik->lng,
            "cancellation_policy_id" => $cancellation_policy_id,
            "house_rules_id" => $house_rules_id,
            "pets_friendly_id" => $pets_friendly_id,
            "safety_and_property_id" => $safety_and_property_id

        ];



        if($brik->new_project_id){
            DB::connection('briklaravelolddata')->table('brik_projects')->where('id', $brik->new_project_id)->update($projectdata);
            return $brik->new_project_id;
        }else{
            return DB::connection('briklaravelolddata')->table('brik_projects')->insertGetId($projectdata);
        }

    }

    public function unittype($brik)
    {
        $type_id = $this->brikType($brik);
        $property_type_id = $this->brikPropertyType($brik);
        $brik_name = null; //$this->getBrikName($brik);

        $brikdata = [

            "brik_project_id" => $brik->new_project_id,
            "brik_property_type_id" => $property_type_id,
            "brik_type_id" => $type_id,
            "brik_name" => $brik_name,
            "property_area" => $brik->property_area,
            "bedroom" => $brik->bedroom,
            "bathroom" => $brik->bathroom,
            "accomadation" => $brik->accomadation,
            "brik_value" => $brik->brik_value,
            "capital_gain" => $brik->capital_gain,
            "irr" => $brik->irr,
            "pe_ratio" => $brik->pe_ratio,
            "adults_capacity" => $brik->adults_capacity ? $brik->adults_capacity : 0,
            "children_capacity" => $brik->children_capacity ? $brik->children_capacity : 0,
            "infent_capacity" => 0,
            "pet_capacity" => 0,
            "per_night_inr" => $brik->per_night_inr,
            "per_night_coin" => $brik->per_night_coin,
            "total_coins_per_brik" => $brik->total_coins_per_brik,

        ];


        if($brik->new_unit_type_id){
            DB::connection('briklaravelolddata')->table('brik_briks')->where('id', $brik->new_unit_type_id)->update($brikdata);
            return $brik->new_unit_type_id;
        }else{
            return DB::connection('briklaravelolddata')->table('brik_briks')->insertGetId($brikdata);
        }

    }

    public function unitnumber($brik)
    {
        $spv = $this->getSpv($brik);
        $project = DB::connection('briklaravelolddata')->table('brik_projects')->where('id', $brik->new_project_id)->first();
        $city_id = $project ? $project->city_id : null;

        $rent_cover_image = $this->getRentCoverImage($spv);
        $invest_cover_image = $this->getInvestCoverImage($brik);
        $gallery_images = $this->getGalleryImages($brik);

        $brikdata = [

            "booking_portal_display_name" => $spv ? $spv->spv_name : null,
            "ru_property_id" => null,
            "spv_id" => $brik->new_spv_id,
            "brik_id" => $brik->new_unit_type_id,
            "project_id" => $brik->new_project_id,
            "property_area" => $brik->property_area,
            "brik_value" => $brik->brik_value,
            "capital_gain" => $brik->capital_gain,
            "irr" => $brik->irr,
            "pe_ratio" => $brik->pe_ratio,
            "per_night_inr" => $brik->per_night_inr,
            "per_night_coin" => $brik->per_night_coin,
            "total_coins_per_brik" => $brik->total_coins_per_brik,
            "rent_cover_image" => $rent_cover_image,
            "rent_gallery_images" => $gallery_images,
            "invest_cover_image" => $invest_cover_image,
            "invest_gallery_images" => $gallery_images,
            "unit_name" => null,
            "unit_number" => $spv ? $spv->unit_number : null,
            "city_id" => $city_id,
            "adults_capacity" => $brik->adults_capacity ? $brik->adults_capacity : 0,
            "children_capacity" => $brik->children_capacity ? $brik->children_capacity : 0,
            "infent_capacity" => 0,
            "pet_capacity" => 0,
            "property_view" => $brik->property_view,
            "possession" => $spv->possession_status,
            "date_of_possession" => $spv->date_of_possession,
            "managed_property" => $brik->managed_property ? $brik->managed_property : 0,
            "rent_active" => $spv->active ? $spv->active : 0,
            "invest_active" => $brik->active ? $brik->active : 0,
            "newly_launched" => 0,
            "property_video" => null,
            "view_360" => null,
            "rating" => 5

        ];



        if($brik->new_unit_number_id){
            DB::connection('briklaravelolddata')->table('brik_units')->where('id', $brik->new_unit_number_id)->update($brikdata);
            return $brik->new_unit_number_id;
        }else{
            return DB::connection('briklaravelolddata')->table('brik_units')->insertGetId($brikdata);
        }

    }



    public function projectManager($brik)
    {
        if($brik->brik_manager){
            $manager = DB::connection('briklaravelolddata')->table('brik_managers')->where('name', $brik->brik_manager)->first();

            if($manager){
                return $manager->id;
            }else{

                $image = $this->putImage($brik->brik_manager_image,'images/employee/');

                $managerdata = [

                    "name" => $brik->brik_manager,
                    "image" => $image ,
                    "designation" => 'Manager',
                    "email" => null,
                    "phone" => $brik->brik_manager_contact,

                ];

                return DB::connection('briklaravelolddata')->table('brik_managers')->insertGetId($managerdata);
            }
        }
    }

    public function cancellationPolicy($brik)
    {
        if($brik->cancellation_policy_id){

          $policy =  DB::connection('brik_it')->table('brik_cancellationpolicy')->where('id', $brik->cancellation_policy_id)->first();

          if($policy){

            $chk = DB::connection('briklaravelolddata')->table('brik_cancellation_policies')->where('title', $policy->title);

            if($chk->count() == 0){

                $policydata = [
                    "title" => $policy->title,
                    "cancellation_policy" => $policy->cancellationPolicy,
                ];

                return DB::connection('briklaravelolddata')->table('brik_cancellation_policies')->insertGetId($policydata);
            }else{
                return $chk->first()->id;
            }

          }
        }

        return null;
    }

    public function houseRule($brik)
    {
        if($brik->house_rules_id ){

          $rule =  DB::connection('brik_it')->table('brik_houserule')->where('id', $brik->house_rules_id)->first();

          if($rule){

            $chk = DB::connection('briklaravelolddata')->table('brik_houserules')->where('title', $rule->title);

            if($chk->count() == 0){

                $ruledata = [
                    "title" => $rule->title,
                    "rule" => $rule->rule,
                ];

                return DB::connection('briklaravelolddata')->table('brik_houserules')->insertGetId($ruledata);
            }else{
                return $chk->first()->id;
            }

          }
        }

        return null;
    }

    public function petsFreindly($brik)
    {
        if($brik->pets_friendly_id ){

          $rule =  DB::connection('brik_it')->table('brik_petsfriendly')->where('id', $brik->pets_friendly_id)->first();

          if($rule){

            $chk = DB::connection('briklaravelolddata')->table('brik_petsfriendlies')->where('title', $rule->title);

            if($chk->count() == 0){

                $ruledata = [
                    "title" => $rule->title,
                    "pets_friendly" => $rule->petsFriendly,
                ];

                return DB::connection('briklaravelolddata')->table('brik_petsfriendlies')->insertGetId($ruledata);
            }else{
                return $chk->first()->id;
            }

          }
        }

        return null;
    }

    public function safetyAndProperty($brik)
    {
        if($brik->safety_and_property_id ){

          $rule =  DB::connection('brik_it')->table('brik_safetyandproperty')->where('id', $brik->safety_and_property_id)->first();

          if($rule){

            $chk = DB::connection('briklaravelolddata')->table('brik_safetyandproperties')->where('title', $rule->title);

            if($chk->count() == 0){

                $ruledata = [
                    "title" => $rule->title,
                    "safety_and_property" => $rule->safetyAndProperty,
                ];

                return DB::connection('briklaravelolddata')->table('brik_safetyandproperties')->insertGetId($ruledata);
            }else{
                return $chk->first()->id;
            }

          }
        }

        return null;
    }

    public function brikPropertyType($brik)
    {
        if($brik->bedroom == 1){
            return 1;
        }else if($brik->bedroom == 2){
            return 2;
        }else if($brik->bedroom == 3){
            return 3;
        }else{
            return null;
        }
    }

    public function brikType($brik)
    {
        if($brik->property_type){
            $chk = DB::connection('briklaravelolddata')->table('brik_types')->where('name', $brik->property_type);
            if($chk->count() > 0){
                return $chk->first()->id;
            }else{
                return DB::connection('briklaravelolddata')->table('brik_types')->insertGetId(["name" => $brik->property_type]);
            }
        }
        return null;
    }

    public function putImage($pullimageuri,$putpath)
    {
        if($pullimageuri){

            try
            {

                $pullserver = 'https://brikkit-prod-docs.s3.amazonaws.com/media/';
                $pullimagepath = $pullserver.$pullimageuri;

                $extension = $this->getImageExtension($pullimagepath);

                $imagename = $putpath.uniqid();
                $putimage = $imagename.'.'.$extension;
                $putimagepath = storage_path('app\public\\').$imagename.'.'.$extension;

                $imageData = file_get_contents($pullimagepath);
                if ($imageData !== false) {
                    file_put_contents($putimagepath, $imageData);

                    return $putimage;
                }
            }catch(\Exception $e){
                return null;
            }
        }


        return null;
    }

    public function getImageExtension($url)
    {
        $cleanUrl = parse_url($url, PHP_URL_PATH);
        $extension = pathinfo($cleanUrl, PATHINFO_EXTENSION);

        return $extension; // Output: jpg
    }

    public function getSpv($brik)
    {
        return DB::connection('brik_it')->table('brik_spvinfo')->where('brik_id', $brik->id)->first();
    }

    public function getRentCoverImage($spv)
    {
        if($spv->spv_cover_image){
            return $this->putImage($spv->spv_cover_image,'images/brik/');
        }
        return null;
    }

    public function getInvestCoverImage($brik)
    {
        if($brik->brik_cover_image){
            return $this->putImage($brik->brik_cover_image,'images/brik/');
        }
        return null;
    }

    public function getGalleryImages($brik)
    {
        $res = [];
        $images = DB::connection('brik_it')->table('brik_brikimage')->where('brik_id', $brik->id)->get();

        foreach($images as $image)
        {
            $image = $this->putImage($image->image,'images/brik/');
            if($image){
                $res[] = $image;
            }
        }

        return json_encode($res);

    }



}
