<?php

namespace App\Console\Commands;

use App\Models\BrikAmenity;
use Exception;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class MigrateOwnerCoin extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */

    protected $signature = 'app:migrate-owner-coin';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
       $this->info('Code execution started.');

       $owners = DB::table('brik_owners')->get();
       foreach($owners as $owner){

           $coins =  DB::table('brik_owners')->where('owner_id', $owner->owner_id)->sum('brik_owner_coin');
           DB::table('clients')->where('id', $owner->owner_id)->update(['coins' => $coins]);

       }


    //    foreach($this->records() as $record)
    //    {

    //         $coin = $record["COIN"] == '' ? 0 : (is_numeric($record["COIN"]) ? $record["COIN"] : 0);

    //         DB::table('brik_owners')->where('id', $record["ID"])->update(
    //             ["brik_owner_coin" => $coin]
    //         );



    //    }


       $this->info('Code execution ended.');


    }

    public function records(){
        return array(
	0 => array('S.NO.' => '1', 'ID' => '1', 'BRIK OWNER' => 'Kunal Gupta - kunalgupta24@gmail.com', 'UNIT NUMBER' => 'Tower-8-0304 3rd Floor', 'PROJECT' => 'Rio De Goa', 'SPV' => 'BRIKITT RIO PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AABCZ6471G', 'CIN NO.' => 'U93090UP2020PTC138840', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '927273', 'BOOKING AMOUNT PAID' => '109093', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 1018180', 'TOTAL INSTALLMENT PAID' => '1018180', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	1 => array('S.NO.' => '2', 'ID' => '2', 'BRIK OWNER' => 'Ved Parkash CHUGH - vp.chugh1@gmail.com', 'UNIT NUMBER' => 'Tower-8-0304 3rd Floor', 'PROJECT' => 'Rio De Goa', 'SPV' => 'BRIKITT RIO PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AABCZ6471G', 'CIN NO.' => 'U93090UP2020PTC138840', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '785000', 'BOOKING AMOUNT PAID' => '35000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	2 => array('S.NO.' => '3', 'ID' => '3', 'BRIK OWNER' => 'Jawahar Dodani - joe@joedodani.com', 'UNIT NUMBER' => 'Tower-8-0304 3rd Floor', 'PROJECT' => 'Rio De Goa', 'SPV' => 'BRIKITT RIO PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AABCZ6471G', 'CIN NO.' => 'U93090UP2020PTC138840', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '828091', 'BOOKING AMOUNT PAID' => '84093', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 743998', 'TOTAL INSTALLMENT PAID' => '743998', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '99182', 'COINS' => '540', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	3 => array('S.NO.' => '4', 'ID' => '4', 'BRIK OWNER' => 'Nuthan K N - nuthankn@gmail.com', 'UNIT NUMBER' => 'Tower-8-0304 3rd Floor', 'PROJECT' => 'Rio De Goa', 'SPV' => 'BRIKITT RIO PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AABCZ6471G', 'CIN NO.' => 'U93090UP2020PTC138840', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '128273', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	4 => array('S.NO.' => '5', 'ID' => '5', 'BRIK OWNER' => 'Mayank Ravindra Srivastava - mayankrsjobs@gmail.com', 'UNIT NUMBER' => 'Tower-8-0304 3rd Floor', 'PROJECT' => 'Rio De Goa', 'SPV' => 'BRIKITT RIO PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AABCZ6471G', 'CIN NO.' => 'U93090UP2020PTC138840', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '128273', 'COINS' => '360', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	5 => array('S.NO.' => '6', 'ID' => '6', 'BRIK OWNER' => 'Amitabh Bhadauria - bhadauria.amitabh@gmail.com', 'UNIT NUMBER' => 'Resale Brik\'s 00', 'PROJECT' => 'Resale Brik\'s', 'SPV' => '00', 'SPV ACCOUNT' => '00', 'IFSC' => '00', 'PAN CARD NO.' => '00', 'CIN NO.' => '00', 'BRIK VALUE' => '0', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '78273', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	6 => array('S.NO.' => '7', 'ID' => '7', 'BRIK OWNER' => 'Dr. Rajeev Agarwal - drrajeeva1@rediffmail.com', 'UNIT NUMBER' => 'Row-6/Block4/A-402', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '586364', 'BOOKING AMOUNT PAID' => '68182', 'INSTALLMENTS' => '(Total 32 Installments) Amount: 524182', 'TOTAL INSTALLMENT PAID' => '518182', 'TOTAL INSTALLMENT PENDING' => '6000', 'DISCOUNT ON BRIK' => '', 'COINS' => '270', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	7 => array('S.NO.' => '8', 'ID' => '8', 'BRIK OWNER' => 'Nagavenkata Ravi Kiran Juluru - ravikiranjuluru@gmail.com', 'UNIT NUMBER' => 'Row-6/Block4/A-402', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '586364', 'BOOKING AMOUNT PAID' => '68182', 'INSTALLMENTS' => '(Total 31 Installments) Amount: 518182', 'TOTAL INSTALLMENT PAID' => '518182', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	8 => array('S.NO.' => '9', 'ID' => '9', 'BRIK OWNER' => 'Girendra Singh - girendra1956@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '561364', 'BOOKING AMOUNT PAID' => '43182', 'INSTALLMENTS' => '(Total 14 Installments) Amount: 210735', 'TOTAL INSTALLMENT PAID' => '8650', 'TOTAL INSTALLMENT PENDING' => '202085', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	9 => array('S.NO.' => '10', 'ID' => '10', 'BRIK OWNER' => 'Rohit Agarwal - rohitagarwal3333@yahoo.com', 'UNIT NUMBER' => 'Row-6/Block4/A-402', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '579631', 'BOOKING AMOUNT PAID' => '68182', 'INSTALLMENTS' => '(Total 31 Installments) Amount: 511970', 'TOTAL INSTALLMENT PAID' => '511970', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '7089', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	10 => array('S.NO.' => '11', 'ID' => '11', 'BRIK OWNER' => 'Mayuri Mathur - mayuri.mathur26@gmail.com', 'UNIT NUMBER' => 'Row-6/Block4/A-402', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '586364', 'BOOKING AMOUNT PAID' => '68182', 'INSTALLMENTS' => '(Total 31 Installments) Amount: 518127', 'TOTAL INSTALLMENT PAID' => '518127', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	11 => array('S.NO.' => '12', 'ID' => '12', 'BRIK OWNER' => 'Priyanka Panigrahi - sdh396@gmail.com', 'UNIT NUMBER' => 'Row-6/Block4/A-402', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '586364', 'BOOKING AMOUNT PAID' => '68182', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 518182', 'TOTAL INSTALLMENT PAID' => '518182', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	12 => array('S.NO.' => '13', 'ID' => '13', 'BRIK OWNER' => 'Tonika Jain - roshandtn@yahoo.com', 'UNIT NUMBER' => 'Row-6/Block4/A-402', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '586364', 'BOOKING AMOUNT PAID' => '68182', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 518182', 'TOTAL INSTALLMENT PAID' => '458962', 'TOTAL INSTALLMENT PENDING' => '59220', 'DISCOUNT ON BRIK' => '', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	13 => array('S.NO.' => '14', 'ID' => '14', 'BRIK OWNER' => 'Vikash Kumar Jaiswal - vikjaiswal1@yahoo.co.in', 'UNIT NUMBER' => 'Row-6/Block4/A-402', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '586364', 'BOOKING AMOUNT PAID' => '68182', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 518182', 'TOTAL INSTALLMENT PAID' => '518182', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '360', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	14 => array('S.NO.' => '15', 'ID' => '15', 'BRIK OWNER' => 'Vijendra Pratap Singh - Vijendrapratapsingh@rediffmail.Com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	15 => array('S.NO.' => '16', 'ID' => '16', 'BRIK OWNER' => 'Ankit Agarwal - ankitagarwal235@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	16 => array('S.NO.' => '17', 'ID' => '17', 'BRIK OWNER' => 'Nidhi Agarwal - nidhiagarwal3480@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	17 => array('S.NO.' => '18', 'ID' => '18', 'BRIK OWNER' => 'Rajni Malhotra - vishhal9@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '590000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '59000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	18 => array('S.NO.' => '19', 'ID' => '19', 'BRIK OWNER' => 'Jitendra Pratap Singh - singh.p.jitendra@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '570000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 521000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '521000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	19 => array('S.NO.' => '20', 'ID' => '20', 'BRIK OWNER' => 'Vatan Kumar Gautam - vatarch24@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '450000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	20 => array('S.NO.' => '21', 'ID' => '21', 'BRIK OWNER' => 'Amit Manocha - reliveamitmanocha@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	21 => array('S.NO.' => '22', 'ID' => '22', 'BRIK OWNER' => 'Lovely Chhabra - lovely.chhabra5@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	22 => array('S.NO.' => '23', 'ID' => '23', 'BRIK OWNER' => 'Divya Asthana - divyaasthanaa@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	23 => array('S.NO.' => '24', 'ID' => '24', 'BRIK OWNER' => 'Aditya Pratap Singh - aditya.singh178@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	24 => array('S.NO.' => '25', 'ID' => '25', 'BRIK OWNER' => 'Neetu Singh - manendrasingh@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '570000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 521000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '371000', 'DISCOUNT ON BRIK' => '79000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	25 => array('S.NO.' => '26', 'ID' => '26', 'BRIK OWNER' => 'Devendra Dang - dangdeven@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '640000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 541000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '541000', 'DISCOUNT ON BRIK' => '', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	26 => array('S.NO.' => '27', 'ID' => '27', 'BRIK OWNER' => 'Ratna Dubey - ratna82@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '664050', 'BOOKING AMOUNT PAID' => '64050', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '450000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	27 => array('S.NO.' => '28', 'ID' => '28', 'BRIK OWNER' => 'Sarika Verma - madhukarvarma1120@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	28 => array('S.NO.' => '29', 'ID' => '29', 'BRIK OWNER' => 'Ranjana Singh - drranjanasingh78@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '450000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	29 => array('S.NO.' => '30', 'ID' => '30', 'BRIK OWNER' => 'Pradeep Kumar Bajpai - shuklatradingco@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	30 => array('S.NO.' => '31', 'ID' => '31', 'BRIK OWNER' => 'Anjula Gupta - pranjula@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	31 => array('S.NO.' => '32', 'ID' => '32', 'BRIK OWNER' => 'Anushka Sinha - anushkasinha341@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '450000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	32 => array('S.NO.' => '33', 'ID' => '33', 'BRIK OWNER' => 'Poonam Srivastava - poonamsri21@yahoo.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '450000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	33 => array('S.NO.' => '34', 'ID' => '34', 'BRIK OWNER' => 'P K Srivastava - mumpy@rediffmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '450000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	34 => array('S.NO.' => '35', 'ID' => '35', 'BRIK OWNER' => 'Pramila Gehani - gurnani.amit@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '570000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 521000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '521000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	35 => array('S.NO.' => '36', 'ID' => '36', 'BRIK OWNER' => 'Shivangi Arya - shivangidua71@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 525000', 'TOTAL INSTALLMENT PAID' => '75000', 'TOTAL INSTALLMENT PENDING' => '450000', 'DISCOUNT ON BRIK' => '75000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	36 => array('S.NO.' => '37', 'ID' => '37', 'BRIK OWNER' => 'Vinita Bharti - manidrshiv@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '450000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	37 => array('S.NO.' => '38', 'ID' => '38', 'BRIK OWNER' => 'Ahmad Imran Hanfi - draihanfi@yahoo.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '450000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	38 => array('S.NO.' => '39', 'ID' => '39', 'BRIK OWNER' => 'Nayan Gupta - akhinayan40@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '450000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	39 => array('S.NO.' => '40', 'ID' => '40', 'BRIK OWNER' => 'Seema Arora - utkarsharora6387555198@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	40 => array('S.NO.' => '41', 'ID' => '41', 'BRIK OWNER' => 'Pushpa Singh - brajeshpratap@yahoo.co.in', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	41 => array('S.NO.' => '42', 'ID' => '42', 'BRIK OWNER' => 'Rajan Kumar - kumarrajan27@rediffmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	42 => array('S.NO.' => '43', 'ID' => '43', 'BRIK OWNER' => 'Faisal Anwar Razzaqui - razzaqui.family@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '', 'TOTAL INSTALLMENT PAID' => '', 'TOTAL INSTALLMENT PENDING' => '', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	43 => array('S.NO.' => '44', 'ID' => '44', 'BRIK OWNER' => 'Sonam Gill - gillsonam01@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '', 'TOTAL INSTALLMENT PAID' => '', 'TOTAL INSTALLMENT PENDING' => '', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	44 => array('S.NO.' => '45', 'ID' => '45', 'BRIK OWNER' => 'Fatma Asna - fatmaasna01@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '', 'TOTAL INSTALLMENT PAID' => '', 'TOTAL INSTALLMENT PENDING' => '', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	45 => array('S.NO.' => '46', 'ID' => '46', 'BRIK OWNER' => 'Firoz Anwar - firoz.anwar6320@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '', 'TOTAL INSTALLMENT PAID' => '', 'TOTAL INSTALLMENT PENDING' => '', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	46 => array('S.NO.' => '47', 'ID' => '47', 'BRIK OWNER' => 'Rohit Kumar Verma - royal_mpcp@yahoo.co.in', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '400000', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	47 => array('S.NO.' => '48', 'ID' => '53', 'BRIK OWNER' => 'Mayank Ravindra Srivastava - mayankrsjobs@gmail.com', 'UNIT NUMBER' => 'Row-6/Block4/A-402', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '575364', 'BOOKING AMOUNT PAID' => '68182', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 507182', 'TOTAL INSTALLMENT PAID' => '507182', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '11000', 'COINS' => '360', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	48 => array('S.NO.' => '49', 'ID' => '54', 'BRIK OWNER' => 'Jawahar Dodani - joe@joedodani.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '550000', 'DISCOUNT ON BRIK' => '50000', 'COINS' => '540', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	49 => array('S.NO.' => '50', 'ID' => '56', 'BRIK OWNER' => 'Jitendra Dilip Meghrajani - jitendra.meghrajani@gmail.com', 'UNIT NUMBER' => 'Tower-8-0304 3rd Floor', 'PROJECT' => 'Rio De Goa', 'SPV' => 'BRIKITT RIO PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AABCZ6471G', 'CIN NO.' => 'U93090UP2020PTC138840', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	50 => array('S.NO.' => '51', 'ID' => '57', 'BRIK OWNER' => 'Dr. Rajeev Agarwal - drrajeeva1@rediffmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '450000', 'DISCOUNT ON BRIK' => '', 'COINS' => '270', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	51 => array('S.NO.' => '52', 'ID' => '58', 'BRIK OWNER' => 'Shalini Purushottam Modani - pmodani@gmail.com', 'UNIT NUMBER' => 'T7-206', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SE2BR SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6092B', 'CIN NO.' => 'U70109UP2022PTC157704', 'BRIK VALUE' => '1019909', 'INVESTMENT AMOUNT' => '719000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 670000', 'TOTAL INSTALLMENT PAID' => '356364', 'TOTAL INSTALLMENT PENDING' => '313636', 'DISCOUNT ON BRIK' => '100364', 'COINS' => '105', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	52 => array('S.NO.' => '53', 'ID' => '59', 'BRIK OWNER' => 'Shalini Purushottam Modani - pmodani@gmail.com', 'UNIT NUMBER' => 'Row-6/Block4/A-402', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '586364', 'BOOKING AMOUNT PAID' => '68182', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 518182', 'TOTAL INSTALLMENT PAID' => '399742', 'TOTAL INSTALLMENT PENDING' => '118440', 'DISCOUNT ON BRIK' => '', 'COINS' => '105', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	53 => array('S.NO.' => '54', 'ID' => '60', 'BRIK OWNER' => 'MANISH KUMAR TIWARI - manish.chem4u@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '', 'BOOKING AMOUNT PAID' => '', 'INSTALLMENTS' => '', 'TOTAL INSTALLMENT PAID' => '', 'TOTAL INSTALLMENT PENDING' => '', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	54 => array('S.NO.' => '55', 'ID' => '61', 'BRIK OWNER' => 'Tonika Jain - roshandtn@yahoo.com', 'UNIT NUMBER' => 'T7-206', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SE2BR SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6092B', 'CIN NO.' => 'U70109UP2022PTC157704', 'BRIK VALUE' => '1019909', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 670000', 'TOTAL INSTALLMENT PAID' => '596364', 'TOTAL INSTALLMENT PENDING' => '73636', 'DISCOUNT ON BRIK' => '80364', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	55 => array('S.NO.' => '56', 'ID' => '62', 'BRIK OWNER' => 'Sanjay Koul - sanjay.koul@timken.com', 'UNIT NUMBER' => 'T7-206', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SE2BR SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6092B', 'CIN NO.' => 'U70109UP2022PTC157704', 'BRIK VALUE' => '1019909', 'INVESTMENT AMOUNT' => '1498000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 670000', 'TOTAL INSTALLMENT PAID' => '633182', 'TOTAL INSTALLMENT PENDING' => '36818', 'DISCOUNT ON BRIK' => '80364', 'COINS' => '390', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	56 => array('S.NO.' => '57', 'ID' => '63', 'BRIK OWNER' => 'Lata Kapoor - 297latakapoor@gmail.com', 'UNIT NUMBER' => 'T7-206', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SE2BR SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6092B', 'CIN NO.' => 'U70109UP2022PTC157704', 'BRIK VALUE' => '1019909', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 676242', 'TOTAL INSTALLMENT PAID' => '536364', 'TOTAL INSTALLMENT PENDING' => '139878', 'DISCOUNT ON BRIK' => '80364', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	57 => array('S.NO.' => '58', 'ID' => '64', 'BRIK OWNER' => 'SANJAY RALHAN - ralhan2003@yahoo.com', 'UNIT NUMBER' => 'T7-206', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SE2BR SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6092B', 'CIN NO.' => 'U70109UP2022PTC157704', 'BRIK VALUE' => '1019909', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 682485', 'TOTAL INSTALLMENT PAID' => '476364', 'TOTAL INSTALLMENT PENDING' => '206121', 'DISCOUNT ON BRIK' => '80364', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	58 => array('S.NO.' => '59', 'ID' => '66', 'BRIK OWNER' => 'Dr. Shivendra Singh - ssshivendrabhu@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'Elite 165 Farm Resort', 'SPV' => 'ELITE 165 FARMS RESORT PVT LTD', 'SPV ACCOUNT' => '2.12125E+15', 'IFSC' => 'AUBL0002486', 'PAN CARD NO.' => 'AAGCE4883N', 'CIN NO.' => 'U55209UP2021PTC146678', 'BRIK VALUE' => '749000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '450000', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	59 => array('S.NO.' => '60', 'ID' => '67', 'BRIK OWNER' => 'Pourushassp Farokh Karkaria - pourushasppk@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '569000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 523829', 'TOTAL INSTALLMENT PAID' => '305272', 'TOTAL INSTALLMENT PENDING' => '218557', 'DISCOUNT ON BRIK' => '126336', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	60 => array('S.NO.' => '61', 'ID' => '68', 'BRIK OWNER' => 'Liane Ghosh - lianecabral@gmail.com', 'UNIT NUMBER' => 'Tower-8-0304 3rd Floor', 'PROJECT' => 'Rio De Goa', 'SPV' => 'BRIKITT RIO PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AABCZ6471G', 'CIN NO.' => 'U93090UP2020PTC138840', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 2 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '128273', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	61 => array('S.NO.' => '62', 'ID' => '69', 'BRIK OWNER' => 'Jamuna Mondal - we2gether.j@gmail.com', 'UNIT NUMBER' => 'Resale Brik\'s 00', 'PROJECT' => 'Resale Brik\'s', 'SPV' => '00', 'SPV ACCOUNT' => '00', 'IFSC' => '00', 'PAN CARD NO.' => '00', 'CIN NO.' => '00', 'BRIK VALUE' => '0', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 2 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '128273', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	62 => array('S.NO.' => '63', 'ID' => '70', 'BRIK OWNER' => 'Ashutosh Gupta - mint_ag@hotmail.com', 'UNIT NUMBER' => 'T7-206', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SE2BR SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6092B', 'CIN NO.' => 'U70109UP2022PTC157704', 'BRIK VALUE' => '1019909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '613182', 'TOTAL INSTALLMENT PENDING' => '36818', 'DISCOUNT ON BRIK' => '100364', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	63 => array('S.NO.' => '64', 'ID' => '71', 'BRIK OWNER' => 'Dr. Rajeev Agarwal - drrajeeva1@rediffmail.com', 'UNIT NUMBER' => 'T7-206', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SE2BR SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6092B', 'CIN NO.' => 'U70109UP2022PTC157704', 'BRIK VALUE' => '1019909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 631000', 'TOTAL INSTALLMENT PAID' => '551364', 'TOTAL INSTALLMENT PENDING' => '79636', 'DISCOUNT ON BRIK' => '100364', 'COINS' => '270', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	64 => array('S.NO.' => '65', 'ID' => '72', 'BRIK OWNER' => 'Rohit Gupta - meetrohit41@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-506', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '512000', 'TOTAL INSTALLMENT PENDING' => '138000', 'DISCOUNT ON BRIK' => '92182', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	65 => array('S.NO.' => '66', 'ID' => '73', 'BRIK OWNER' => 'Tarun Sanmotra - sanmotratarun@yahoo.com', 'UNIT NUMBER' => 'T3-201', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '529000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 480000', 'TOTAL INSTALLMENT PAID' => '451636', 'TOTAL INSTALLMENT PENDING' => '28364', 'DISCOUNT ON BRIK' => '67000', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	66 => array('S.NO.' => '67', 'ID' => '74', 'BRIK OWNER' => 'Tushar Gupta - tushar_gupta223@yahoo.com', 'UNIT NUMBER' => 'T3-201', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '529000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 480000', 'TOTAL INSTALLMENT PAID' => '451636', 'TOTAL INSTALLMENT PENDING' => '28364', 'DISCOUNT ON BRIK' => '67000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	67 => array('S.NO.' => '68', 'ID' => '75', 'BRIK OWNER' => 'Anirudh Choudhary - ani0020.ac@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-506', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '512000', 'TOTAL INSTALLMENT PENDING' => '138000', 'DISCOUNT ON BRIK' => '92182', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	68 => array('S.NO.' => '69', 'ID' => '76', 'BRIK OWNER' => 'Paras Mani - maniparas15@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-506', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '512000', 'TOTAL INSTALLMENT PENDING' => '138000', 'DISCOUNT ON BRIK' => '92182', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	69 => array('S.NO.' => '70', 'ID' => '77', 'BRIK OWNER' => 'Sudhaker Tripathi - sudhakert.2018@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 14 Installments) Amount: 970257', 'TOTAL INSTALLMENT PAID' => '149000', 'TOTAL INSTALLMENT PENDING' => '821257', 'DISCOUNT ON BRIK' => '92182', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	70 => array('S.NO.' => '71', 'ID' => '78', 'BRIK OWNER' => 'Jawahar Dodani - joe@joedodani.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '700000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 14 Installments) Amount: 1153562', 'TOTAL INSTALLMENT PAID' => '100000', 'TOTAL INSTALLMENT PENDING' => '1053562', 'DISCOUNT ON BRIK' => '87182', 'COINS' => '540', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	71 => array('S.NO.' => '72', 'ID' => '79', 'BRIK OWNER' => 'Aishwarya Madhumala Verma - ajayaryanverma17@gmail.com', 'UNIT NUMBER' => 'T3-201', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '499000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 450000', 'TOTAL INSTALLMENT PAID' => '352272', 'TOTAL INSTALLMENT PENDING' => '97728', 'DISCOUNT ON BRIK' => '97000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	72 => array('S.NO.' => '73', 'ID' => '80', 'BRIK OWNER' => 'Rohit Verma - rohitkverma72@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-506', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '512000', 'TOTAL INSTALLMENT PENDING' => '138000', 'DISCOUNT ON BRIK' => '92182', 'COINS' => '120', 'REFERRAL DISC' => '12930', 'COIN' => '', 'REFERRAL DISCOUNT' => '12930'),
	73 => array('S.NO.' => '74', 'ID' => '81', 'BRIK OWNER' => 'Man Singh - singh.man20@gmail.com', 'UNIT NUMBER' => 'T3-201', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '499000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 450000', 'TOTAL INSTALLMENT PAID' => '421636', 'TOTAL INSTALLMENT PENDING' => '28364', 'DISCOUNT ON BRIK' => '97000', 'COINS' => '116', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	74 => array('S.NO.' => '75', 'ID' => '82', 'BRIK OWNER' => 'Pavan Lohia - alankar22may@yahoo.com', 'UNIT NUMBER' => 'T3-201', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '499000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 450000', 'TOTAL INSTALLMENT PAID' => '393272', 'TOTAL INSTALLMENT PENDING' => '56728', 'DISCOUNT ON BRIK' => '97000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	75 => array('S.NO.' => '76', 'ID' => '83', 'BRIK OWNER' => 'Shubha Bisotra - shubha.bisotra@sbi.co.in', 'UNIT NUMBER' => 'T3-201', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '499000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 464358', 'TOTAL INSTALLMENT PAID' => '443272', 'TOTAL INSTALLMENT PENDING' => '21086', 'DISCOUNT ON BRIK' => '97000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	76 => array('S.NO.' => '77', 'ID' => '84', 'BRIK OWNER' => 'Bhavya Hasija - bhavyahasija@gmail.com', 'UNIT NUMBER' => 'T3-201', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '480000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 431000', 'TOTAL INSTALLMENT PAID' => '431000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '116000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	77 => array('S.NO.' => '78', 'ID' => '85', 'BRIK OWNER' => 'Tushar Gupta - tushargupta.7778@gmail.com', 'UNIT NUMBER' => 'Resale Brik\'s 00', 'PROJECT' => 'Resale Brik\'s', 'SPV' => '00', 'SPV ACCOUNT' => '00', 'IFSC' => '00', 'PAN CARD NO.' => '00', 'CIN NO.' => '00', 'BRIK VALUE' => '0', 'INVESTMENT AMOUNT' => '2199000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 2050000', 'TOTAL INSTALLMENT PAID' => '2050000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '15090', 'COINS' => '240', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	78 => array('S.NO.' => '79', 'ID' => '86', 'BRIK OWNER' => 'Neelam Rohilla - rohillaneelam91@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-506', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 620000', 'TOTAL INSTALLMENT PAID' => '512000', 'TOTAL INSTALLMENT PENDING' => '108000', 'DISCOUNT ON BRIK' => '87182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	79 => array('S.NO.' => '80', 'ID' => '87', 'BRIK OWNER' => 'Rajasekhar Nakula - raja.nukala10@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-506', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 14 Installments) Amount: 620000', 'TOTAL INSTALLMENT PAID' => '512000', 'TOTAL INSTALLMENT PENDING' => '108000', 'DISCOUNT ON BRIK' => '87182', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	80 => array('S.NO.' => '81', 'ID' => '88', 'BRIK OWNER' => 'Azra Mohamed Hussain Ansari - azrakhrd@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 14 Installments) Amount: 642022.13', 'TOTAL INSTALLMENT PAID' => '442000', 'TOTAL INSTALLMENT PENDING' => '200022.13', 'DISCOUNT ON BRIK' => '87182', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	81 => array('S.NO.' => '82', 'ID' => '89', 'BRIK OWNER' => 'Rohit Agarwal - rohitagarwal3333@yahoo.com', 'UNIT NUMBER' => 'T3-102', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '499000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 454692', 'TOTAL INSTALLMENT PAID' => '450000', 'TOTAL INSTALLMENT PENDING' => '4692', 'DISCOUNT ON BRIK' => '97000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	82 => array('S.NO.' => '83', 'ID' => '90', 'BRIK OWNER' => 'Jaspreet Pahwa - pahwa.jaspreet@gmail.com', 'UNIT NUMBER' => 'T3-102', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '529000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 513829', 'TOTAL INSTALLMENT PAID' => '351272', 'TOTAL INSTALLMENT PENDING' => '162557', 'DISCOUNT ON BRIK' => '67000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	83 => array('S.NO.' => '84', 'ID' => '91', 'BRIK OWNER' => 'Sanjib Saha - sanjib2me@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 14 Installments) Amount: 1120574', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1120574', 'DISCOUNT ON BRIK' => '87182', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	84 => array('S.NO.' => '85', 'ID' => '92', 'BRIK OWNER' => 'Vishal Kumar - vishalkr2u@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-505', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 620000', 'TOTAL INSTALLMENT PAID' => '512000', 'TOTAL INSTALLMENT PENDING' => '108000', 'DISCOUNT ON BRIK' => '87182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	85 => array('S.NO.' => '86', 'ID' => '93', 'BRIK OWNER' => 'Richa Singh - 92richasingh@gmail.com', 'UNIT NUMBER' => '00', 'PROJECT' => 'Liquidate Brik\'s', 'SPV' => 'In-Process', 'SPV ACCOUNT' => '', 'IFSC' => '', 'PAN CARD NO.' => '', 'CIN NO.' => '', 'BRIK VALUE' => '', 'INVESTMENT AMOUNT' => '529000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 484692', 'TOTAL INSTALLMENT PAID' => '480000', 'TOTAL INSTALLMENT PENDING' => '4692', 'DISCOUNT ON BRIK' => '67000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	86 => array('S.NO.' => '87', 'ID' => '94', 'BRIK OWNER' => 'Hemanshu P Shah - hps68@rediffmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-505', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 620000', 'TOTAL INSTALLMENT PAID' => '512000', 'TOTAL INSTALLMENT PENDING' => '108000', 'DISCOUNT ON BRIK' => '87182', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	87 => array('S.NO.' => '88', 'ID' => '95', 'BRIK OWNER' => 'Sulakshana Nagesh Gangolly - gn.sulakshana@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-506', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 620000', 'TOTAL INSTALLMENT PAID' => '512000', 'TOTAL INSTALLMENT PENDING' => '108000', 'DISCOUNT ON BRIK' => '87182', 'COINS' => '690', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	88 => array('S.NO.' => '89', 'ID' => '96', 'BRIK OWNER' => 'Sourabh Mandal - sourabh.man@gmail.com', 'UNIT NUMBER' => 'Unit number - 7', 'PROJECT' => 'Golden Sands', 'SPV' => 'ARO 2 BHK SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA7827N', 'CIN NO.' => 'U74999UP2022PTC161905', 'BRIK VALUE' => '2626182', 'INVESTMENT AMOUNT' => '1989270', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 1840270', 'TOTAL INSTALLMENT PAID' => '1840270', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	89 => array('S.NO.' => '90', 'ID' => '97', 'BRIK OWNER' => 'Shivani Sharma - star.geop@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-505', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 620000', 'TOTAL INSTALLMENT PAID' => '512000', 'TOTAL INSTALLMENT PENDING' => '108000', 'DISCOUNT ON BRIK' => '87182', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	90 => array('S.NO.' => '91', 'ID' => '98', 'BRIK OWNER' => 'Khushbu Nainesh Zawar - sailornainesh@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-505', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 620000', 'TOTAL INSTALLMENT PAID' => '547000', 'TOTAL INSTALLMENT PENDING' => '73000', 'DISCOUNT ON BRIK' => '87182', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	91 => array('S.NO.' => '92', 'ID' => '99', 'BRIK OWNER' => 'Shivani Sharma - star.geop@gmail.com', 'UNIT NUMBER' => 'T3-201', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '529000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 480000', 'TOTAL INSTALLMENT PAID' => '443272', 'TOTAL INSTALLMENT PENDING' => '36728', 'DISCOUNT ON BRIK' => '67000', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	92 => array('S.NO.' => '93', 'ID' => '100', 'BRIK OWNER' => 'Riddhiman Dutta - we2gether.riddhi@gmail.com', 'UNIT NUMBER' => 'T3-102', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '529000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 480000', 'TOTAL INSTALLMENT PAID' => '443272', 'TOTAL INSTALLMENT PENDING' => '36728', 'DISCOUNT ON BRIK' => '67000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	93 => array('S.NO.' => '94', 'ID' => '101', 'BRIK OWNER' => 'Shilpi Devi - rkgeopes@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-505', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 14 Installments) Amount: 620000', 'TOTAL INSTALLMENT PAID' => '477000', 'TOTAL INSTALLMENT PENDING' => '143000', 'DISCOUNT ON BRIK' => '87182', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	94 => array('S.NO.' => '95', 'ID' => '102', 'BRIK OWNER' => 'Shilpi Agarwal - shilagar@gmail.com', 'UNIT NUMBER' => 'Tower-8-0304 3rd Floor', 'PROJECT' => 'Rio De Goa', 'SPV' => 'BRIKITT RIO PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AABCZ6471G', 'CIN NO.' => 'U93090UP2020PTC138840', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '54', 'REFERRAL DISC' => '0', 'COIN' => '54', 'REFERRAL DISCOUNT' => '0'),
	95 => array('S.NO.' => '96', 'ID' => '103', 'BRIK OWNER' => 'Sulakshana Nagesh Gangolly - gn.sulakshana@gmail.com', 'UNIT NUMBER' => 'Row Villa No. 2', 'PROJECT' => 'MVR Casa Villa', 'SPV' => 'LUXE CA VILLA 3BHK PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAECL9764D', 'CIN NO.' => 'U70109UP2022PTC161805', 'BRIK VALUE' => '3243636', 'INVESTMENT AMOUNT' => '2075000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 15 Installments) Amount: 1926000', 'TOTAL INSTALLMENT PAID' => '1926000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '139090', 'COINS' => '690', 'REFERRAL DISC' => '0', 'COIN' => '270', 'REFERRAL DISCOUNT' => '0'),
	96 => array('S.NO.' => '97', 'ID' => '104', 'BRIK OWNER' => 'Vamsi Krishna Kaku - vamsikrishnakaku@gmail.com', 'UNIT NUMBER' => 'Row Villa No. 2', 'PROJECT' => 'MVR Casa Villa', 'SPV' => 'LUXE CA VILLA 3BHK PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAECL9764D', 'CIN NO.' => 'U70109UP2022PTC161805', 'BRIK VALUE' => '3243636', 'INVESTMENT AMOUNT' => '2075000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 1926000', 'TOTAL INSTALLMENT PAID' => '1926000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '420', 'REFERRAL DISC' => '0', 'COIN' => '270', 'REFERRAL DISCOUNT' => '0'),
	97 => array('S.NO.' => '98', 'ID' => '105', 'BRIK OWNER' => 'Krishna Mohan Prasad Kanoj - kanoj.krishna@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-506', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 620000', 'TOTAL INSTALLMENT PAID' => '512000', 'TOTAL INSTALLMENT PENDING' => '108000', 'DISCOUNT ON BRIK' => '87182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	98 => array('S.NO.' => '99', 'ID' => '106', 'BRIK OWNER' => 'Supriya Mudiraj Mirdoddi - supriya9494@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-505', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 620000', 'TOTAL INSTALLMENT PAID' => '547000', 'TOTAL INSTALLMENT PENDING' => '73000', 'DISCOUNT ON BRIK' => '87182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	99 => array('S.NO.' => '100', 'ID' => '107', 'BRIK OWNER' => 'LALITHA SOMANCHI - d.lalitha@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-505', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 620000', 'TOTAL INSTALLMENT PAID' => '512000', 'TOTAL INSTALLMENT PENDING' => '108000', 'DISCOUNT ON BRIK' => '87182', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	100 => array('S.NO.' => '101', 'ID' => '108', 'BRIK OWNER' => 'Amol Dayaram Rajguru - rajguruconstructions2007@gmail.com', 'UNIT NUMBER' => 'Tower 8 Block B306', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 14 Installments) Amount: 653600', 'TOTAL INSTALLMENT PAID' => '512000', 'TOTAL INSTALLMENT PENDING' => '141600', 'DISCOUNT ON BRIK' => '87182', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	101 => array('S.NO.' => '102', 'ID' => '109', 'BRIK OWNER' => 'Godavari . - godavari.dwivedi@gmail.com', 'UNIT NUMBER' => 'Resale Brik\'s 00', 'PROJECT' => 'Resale Brik\'s', 'SPV' => '00', 'SPV ACCOUNT' => '00', 'IFSC' => '00', 'PAN CARD NO.' => '00', 'CIN NO.' => '00', 'BRIK VALUE' => '0', 'INVESTMENT AMOUNT' => '2075000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 1926000', 'TOTAL INSTALLMENT PAID' => '1926000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '139090', 'COINS' => '420', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	102 => array('S.NO.' => '103', 'ID' => '110', 'BRIK OWNER' => 'Suja Das - sjds14@gmail.com', 'UNIT NUMBER' => 'T3-102', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '569000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 520000', 'TOTAL INSTALLMENT PAID' => '464000', 'TOTAL INSTALLMENT PENDING' => '56000', 'DISCOUNT ON BRIK' => '27000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	103 => array('S.NO.' => '104', 'ID' => '111', 'BRIK OWNER' => 'Kuldeep Kaur - kuldeepkbali82@gmail.com', 'UNIT NUMBER' => 'T3-102', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '569000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 520000', 'TOTAL INSTALLMENT PAID' => '464000', 'TOTAL INSTALLMENT PENDING' => '56000', 'DISCOUNT ON BRIK' => '27000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	104 => array('S.NO.' => '105', 'ID' => '112', 'BRIK OWNER' => 'Manju Pal - rkmpa36@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '569000', 'BOOKING AMOUNT PAID' => '69000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 536346', 'TOTAL INSTALLMENT PAID' => '329272', 'TOTAL INSTALLMENT PENDING' => '207074', 'DISCOUNT ON BRIK' => '27000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	105 => array('S.NO.' => '106', 'ID' => '113', 'BRIK OWNER' => 'Khushbu Nainesh Zawar - sailornainesh@gmail.com', 'UNIT NUMBER' => 'T7-206', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SE2BR SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6092B', 'CIN NO.' => 'U70109UP2022PTC157704', 'BRIK VALUE' => '1019909', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 670000', 'TOTAL INSTALLMENT PAID' => '670000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '200000', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	106 => array('S.NO.' => '107', 'ID' => '114', 'BRIK OWNER' => 'Vikash Kumar Jaiswal - vikjaiswal1@yahoo.co.in', 'UNIT NUMBER' => 'T3-102', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '569000', 'BOOKING AMOUNT PAID' => '69000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '467272', 'TOTAL INSTALLMENT PENDING' => '32728', 'DISCOUNT ON BRIK' => '126336', 'COINS' => '360', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	107 => array('S.NO.' => '108', 'ID' => '115', 'BRIK OWNER' => 'Armaan Ohri - armaanohri@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-506', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 700600', 'TOTAL INSTALLMENT PAID' => '206780', 'TOTAL INSTALLMENT PENDING' => '493820', 'DISCOUNT ON BRIK' => '42182', 'COINS' => '300', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	108 => array('S.NO.' => '109', 'ID' => '116', 'BRIK OWNER' => 'Arisetty Mohini Kumari - kams66@gmail.com', 'UNIT NUMBER' => 'Row Villa No. 2', 'PROJECT' => 'MVR Casa Villa', 'SPV' => 'LUXE CA VILLA 3BHK PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAECL9764D', 'CIN NO.' => 'U70109UP2022PTC161805', 'BRIK VALUE' => '3243636', 'INVESTMENT AMOUNT' => '2190000', 'BOOKING AMOUNT PAID' => '190000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 2000000', 'TOTAL INSTALLMENT PAID' => '2000000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '300000', 'COINS' => '420', 'REFERRAL DISC' => '0', 'COIN' => '270', 'REFERRAL DISCOUNT' => '0'),
	109 => array('S.NO.' => '110', 'ID' => '117', 'BRIK OWNER' => 'Sanjay Koul - sanjay.koul@timken.com', 'UNIT NUMBER' => 'Row Villa No. 2', 'PROJECT' => 'MVR Casa Villa', 'SPV' => 'LUXE CA VILLA 3BHK PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAECL9764D', 'CIN NO.' => 'U70109UP2022PTC161805', 'BRIK VALUE' => '3243636', 'INVESTMENT AMOUNT' => '2190000', 'BOOKING AMOUNT PAID' => '190000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1957000', 'TOTAL INSTALLMENT PAID' => '1957000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '343000', 'COINS' => '390', 'REFERRAL DISC' => '0', 'COIN' => '270', 'REFERRAL DISCOUNT' => '0'),
	110 => array('S.NO.' => '111', 'ID' => '118', 'BRIK OWNER' => 'Pallavi Santram Harde - pallavi051284@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-507', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 623565', 'TOTAL INSTALLMENT PAID' => '563565', 'TOTAL INSTALLMENT PENDING' => '60000', 'DISCOUNT ON BRIK' => '86272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	111 => array('S.NO.' => '112', 'ID' => '119', 'BRIK OWNER' => 'Ramesh J Shetty - shettyramesh22@gmail.com', 'UNIT NUMBER' => 'Tower-8-0304 3rd Floor', 'PROJECT' => 'Rio De Goa', 'SPV' => 'BRIKITT RIO PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AABCZ6471G', 'CIN NO.' => 'U93090UP2020PTC138840', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '900000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	112 => array('S.NO.' => '113', 'ID' => '120', 'BRIK OWNER' => 'Prajwal Vivek Darvekar - aardhvark@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-507', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '542000', 'TOTAL INSTALLMENT PENDING' => '108000', 'DISCOUNT ON BRIK' => '86272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	113 => array('S.NO.' => '114', 'ID' => '121', 'BRIK OWNER' => 'Lekha Chirag Shah - drlekha@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-507', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 670000', 'TOTAL INSTALLMENT PAID' => '562000', 'TOTAL INSTALLMENT PENDING' => '108000', 'DISCOUNT ON BRIK' => '42182', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	114 => array('S.NO.' => '115', 'ID' => '122', 'BRIK OWNER' => 'Tony Jose Chiriyankandath - tony.jose1808@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-507', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '100000', 'DISCOUNT ON BRIK' => '86272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	115 => array('S.NO.' => '116', 'ID' => '123', 'BRIK OWNER' => 'Abhijit Hari Thombre - abhijit911turbo@gmail.com', 'UNIT NUMBER' => 'T3-102', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '581000', 'BOOKING AMOUNT PAID' => '61000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 520000', 'TOTAL INSTALLMENT PAID' => '520000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '114336', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	116 => array('S.NO.' => '117', 'ID' => '124', 'BRIK OWNER' => 'Dr. Santosh Kamdolli - drsantk@gmail.com', 'UNIT NUMBER' => 'Row-8/Block 2/A-101', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '69000', 'INSTALLMENTS' => '(Total 30 Installments) Amount: 614251', 'TOTAL INSTALLMENT PAID' => '340000', 'TOTAL INSTALLMENT PENDING' => '274251', 'DISCOUNT ON BRIK' => '50000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	117 => array('S.NO.' => '118', 'ID' => '125', 'BRIK OWNER' => 'Sumalatha Kamireddy - prasad.chitikela@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-507', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '150000', 'DISCOUNT ON BRIK' => '86272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	118 => array('S.NO.' => '119', 'ID' => '126', 'BRIK OWNER' => 'Rosetta Anil Dsouza - anildsouza@magarpattacity.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-507', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '572000', 'TOTAL INSTALLMENT PENDING' => '78000', 'DISCOUNT ON BRIK' => '86272', 'COINS' => '270', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	119 => array('S.NO.' => '120', 'ID' => '127', 'BRIK OWNER' => 'Amina Fahad Kadri - akadri77000@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 751263.73', 'TOTAL INSTALLMENT PAID' => '247272', 'TOTAL INSTALLMENT PENDING' => '503991.73', 'DISCOUNT ON BRIK' => '96336', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	120 => array('S.NO.' => '121', 'ID' => '128', 'BRIK OWNER' => 'Gaurav Gupta - ya1gaurav@gmail.com', 'UNIT NUMBER' => 'T3-102', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 14 Installments) Amount: 520000', 'TOTAL INSTALLMENT PAID' => '330000', 'TOTAL INSTALLMENT PENDING' => '190000', 'DISCOUNT ON BRIK' => '96336', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	121 => array('S.NO.' => '122', 'ID' => '129', 'BRIK OWNER' => 'Lovkesh Srivastav - srilovkesh@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 25 Installments) Amount: 706876.4', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '706876.4', 'DISCOUNT ON BRIK' => '86272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	122 => array('S.NO.' => '123', 'ID' => '130', 'BRIK OWNER' => 'Poorva Bhadauriya - poorvasingh7489@gmail.com', 'UNIT NUMBER' => 'Row-8/Block 2/A-101', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 570000', 'TOTAL INSTALLMENT PAID' => '530000', 'TOTAL INSTALLMENT PENDING' => '40000', 'DISCOUNT ON BRIK' => '50000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	123 => array('S.NO.' => '124', 'ID' => '131', 'BRIK OWNER' => 'SHUBHANKAR KARMAKAR - lakshyaenterprises1930@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-507', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '729000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '572000', 'TOTAL INSTALLMENT PENDING' => '78000', 'DISCOUNT ON BRIK' => '106272', 'COINS' => '450', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	124 => array('S.NO.' => '125', 'ID' => '132', 'BRIK OWNER' => 'Anoop Singh - capital.ctc2016@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-507', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '572000', 'TOTAL INSTALLMENT PENDING' => '78000', 'DISCOUNT ON BRIK' => '86272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	125 => array('S.NO.' => '126', 'ID' => '133', 'BRIK OWNER' => 'Abhishek Kriplani - abhishek@nexgenmetaliks.com', 'UNIT NUMBER' => 'Resale Brik\'s 00', 'PROJECT' => 'Resale Brik\'s', 'SPV' => '00', 'SPV ACCOUNT' => '00', 'IFSC' => '00', 'PAN CARD NO.' => '00', 'CIN NO.' => '00', 'BRIK VALUE' => '0', 'INVESTMENT AMOUNT' => '2490000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 2200000', 'TOTAL INSTALLMENT PAID' => '2200000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '307272', 'COINS' => '420', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	126 => array('S.NO.' => '127', 'ID' => '134', 'BRIK OWNER' => 'Sangram Singh Tomar - sangramsingh.tomar@gmail.com', 'UNIT NUMBER' => 'Row Villa No. 2', 'PROJECT' => 'MVR Casa Villa', 'SPV' => 'LUXE CA VILLA 3BHK PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAECL9764D', 'CIN NO.' => 'U70109UP2022PTC161805', 'BRIK VALUE' => '3243636', 'INVESTMENT AMOUNT' => '2490000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 2200000', 'TOTAL INSTALLMENT PAID' => '2200000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '307272', 'COINS' => '420', 'REFERRAL DISC' => '0', 'COIN' => '270', 'REFERRAL DISCOUNT' => '0'),
	127 => array('S.NO.' => '128', 'ID' => '136', 'BRIK OWNER' => 'Sathyanand Maroju - anand31leo@gmail.com', 'UNIT NUMBER' => 'Row-8/Block 5/ B-201', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '660000', 'TOTAL INSTALLMENT PENDING' => '40000', 'DISCOUNT ON BRIK' => '36272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	128 => array('S.NO.' => '129', 'ID' => '137', 'BRIK OWNER' => 'Roshan G Patil - roshan.patil.g@gmail.com', 'UNIT NUMBER' => 'Row Villa No. 2', 'PROJECT' => 'MVR Casa Villa', 'SPV' => 'LUXE CA VILLA 3BHK PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAECL9764D', 'CIN NO.' => 'U70109UP2022PTC161805', 'BRIK VALUE' => '3243636', 'INVESTMENT AMOUNT' => '2490000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 2200000', 'TOTAL INSTALLMENT PAID' => '2200000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '307272', 'COINS' => '213', 'REFERRAL DISC' => '0', 'COIN' => '243', 'REFERRAL DISCOUNT' => '0'),
	129 => array('S.NO.' => '130', 'ID' => '138', 'BRIK OWNER' => 'Nitesh Rajkumar Pathak - nitesh.rap@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 583860', 'TOTAL INSTALLMENT PAID' => '210000', 'TOTAL INSTALLMENT PENDING' => '373860', 'DISCOUNT ON BRIK' => '100000', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	130 => array('S.NO.' => '131', 'ID' => '139', 'BRIK OWNER' => 'Nitesh Rajkumar Pathak - nitesh.rap@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 651988', 'TOTAL INSTALLMENT PAID' => '172000', 'TOTAL INSTALLMENT PENDING' => '479988', 'DISCOUNT ON BRIK' => '50000', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	131 => array('S.NO.' => '132', 'ID' => '140', 'BRIK OWNER' => 'Pradeep Hagalvadi Umesh - hu_pradeep@yahoo.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-507', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '540000', 'TOTAL INSTALLMENT PENDING' => '110000', 'DISCOUNT ON BRIK' => '86272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	132 => array('S.NO.' => '133', 'ID' => '141', 'BRIK OWNER' => 'Girish Madhukar Gavas - girish_gavas2001@yahoo.com', 'UNIT NUMBER' => 'Row-8/Block 5/ B-201', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '570000', 'TOTAL INSTALLMENT PENDING' => '80000', 'DISCOUNT ON BRIK' => '86272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	133 => array('S.NO.' => '134', 'ID' => '142', 'BRIK OWNER' => 'Charu Joshi - cdrdpjoshi@gmail.com', 'UNIT NUMBER' => 'Row Villa No. 2', 'PROJECT' => 'MVR Casa Villa', 'SPV' => 'LUXE CA VILLA 3BHK PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAECL9764D', 'CIN NO.' => 'U70109UP2022PTC161805', 'BRIK VALUE' => '3243636', 'INVESTMENT AMOUNT' => '2490000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 2200000', 'TOTAL INSTALLMENT PAID' => '2200000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '307272', 'COINS' => '420', 'REFERRAL DISC' => '0', 'COIN' => '390', 'REFERRAL DISCOUNT' => '0'),
	134 => array('S.NO.' => '135', 'ID' => '143', 'BRIK OWNER' => 'Deepak Shival - diipakshival@gmail.com', 'UNIT NUMBER' => 'Row-8/Block 5/ B-201', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '570000', 'TOTAL INSTALLMENT PENDING' => '80000', 'DISCOUNT ON BRIK' => '86272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	135 => array('S.NO.' => '136', 'ID' => '144', 'BRIK OWNER' => 'Praveen Singh - singh.praveen.off@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 844496', 'TOTAL INSTALLMENT PAID' => '120000', 'TOTAL INSTALLMENT PENDING' => '724496', 'DISCOUNT ON BRIK' => '86272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	136 => array('S.NO.' => '137', 'ID' => '145', 'BRIK OWNER' => 'Sanjay Hingorani - qcsagra@gmail.com', 'UNIT NUMBER' => 'Row-8/Block 5/ B-201', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '570000', 'TOTAL INSTALLMENT PENDING' => '80000', 'DISCOUNT ON BRIK' => '86272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	137 => array('S.NO.' => '138', 'ID' => '146', 'BRIK OWNER' => 'Anurag Gupta - anuraggupta612@gmail.com', 'UNIT NUMBER' => 'Row-8/Block 5/ B-201', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '540000', 'TOTAL INSTALLMENT PENDING' => '110000', 'DISCOUNT ON BRIK' => '86272', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	138 => array('S.NO.' => '139', 'ID' => '147', 'BRIK OWNER' => 'Pragya Sugandha - arpit.44@gmail.com', 'UNIT NUMBER' => 'Row-8/Block 5/ B-201', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '570000', 'TOTAL INSTALLMENT PENDING' => '80000', 'DISCOUNT ON BRIK' => '86272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	139 => array('S.NO.' => '140', 'ID' => '148', 'BRIK OWNER' => 'CWS Contacts Private Limited - cwscontacts@gmail.com', 'UNIT NUMBER' => 'Row-8/Block 5/ B-201', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '775030', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 676030', 'TOTAL INSTALLMENT PAID' => '676030', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '60242', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	140 => array('S.NO.' => '141', 'ID' => '149', 'BRIK OWNER' => 'Dheeraj Singh - dheeraj_20786@yahoo.com', 'UNIT NUMBER' => 'Row-8/Block 2/A-101', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 570000', 'TOTAL INSTALLMENT PAID' => '570000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '50000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	141 => array('S.NO.' => '142', 'ID' => '150', 'BRIK OWNER' => 'Sangram Shivaji Sawant - sangram_bvg@rediffmail.com', 'UNIT NUMBER' => 'Row-8/Block 2/A-101', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 18 Installments) Amount: 598611', 'TOTAL INSTALLMENT PAID' => '375000', 'TOTAL INSTALLMENT PENDING' => '223611', 'DISCOUNT ON BRIK' => '50000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	142 => array('S.NO.' => '143', 'ID' => '151', 'BRIK OWNER' => 'Aadarsh Rohira - aadarshrohira@gmail.com', 'UNIT NUMBER' => 'Row Villa No. 2', 'PROJECT' => 'MVR Casa Villa', 'SPV' => 'LUXE CA VILLA 3BHK PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAECL9764D', 'CIN NO.' => 'U70109UP2022PTC161805', 'BRIK VALUE' => '3243636', 'INVESTMENT AMOUNT' => '2481319', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 2200000', 'TOTAL INSTALLMENT PAID' => '2200000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '307272', 'COINS' => '420', 'REFERRAL DISC' => '0', 'COIN' => '270', 'REFERRAL DISCOUNT' => '0'),
	143 => array('S.NO.' => '144', 'ID' => '152', 'BRIK OWNER' => 'SAMPATHVRIDDI LLP - sampathvriddillp@gmail.com', 'UNIT NUMBER' => '302', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '900000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	144 => array('S.NO.' => '145', 'ID' => '153', 'BRIK OWNER' => 'Air Cmde Mohit Kumar Nayyar VM,VSM - mohitkumarnayyar@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-505', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '610000', 'TOTAL INSTALLMENT PENDING' => '90000', 'DISCOUNT ON BRIK' => '', 'COINS' => '330', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	145 => array('S.NO.' => '146', 'ID' => '154', 'BRIK OWNER' => 'Rajashri Jayaram Ferns - danferns28@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-505', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 728090.8', 'TOTAL INSTALLMENT PAID' => '470000', 'TOTAL INSTALLMENT PENDING' => '348090.8', 'DISCOUNT ON BRIK' => '', 'COINS' => '270', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	146 => array('S.NO.' => '147', 'ID' => '155', 'BRIK OWNER' => 'Dr. Jeevan Vutchula - drjeevan447@gmail.com', 'UNIT NUMBER' => 'Row-8/Block 5/ B-201', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '610000', 'TOTAL INSTALLMENT PENDING' => '90000', 'DISCOUNT ON BRIK' => '36272', 'COINS' => '270', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	147 => array('S.NO.' => '148', 'ID' => '156', 'BRIK OWNER' => 'Gadhvi Aniruddhsinh Kishorsinh - studioavishkar@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 20 Installments) Amount: 616818', 'TOTAL INSTALLMENT PAID' => '120000', 'TOTAL INSTALLMENT PENDING' => '496818', 'DISCOUNT ON BRIK' => '50000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	148 => array('S.NO.' => '149', 'ID' => '157', 'BRIK OWNER' => 'Armaan Ohri - armaanohri@gmail.com', 'UNIT NUMBER' => 'B1', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '700000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '247636', 'COINS' => '300', 'REFERRAL DISC' => '0', 'COIN' => '117', 'REFERRAL DISCOUNT' => '0'),
	149 => array('S.NO.' => '150', 'ID' => '158', 'BRIK OWNER' => 'Dr. Jeevan Vutchula - drjeevan447@gmail.com', 'UNIT NUMBER' => 'Unit number - 7', 'PROJECT' => 'Golden Sands', 'SPV' => 'ARO 2 BHK SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA7827N', 'CIN NO.' => 'U74999UP2022PTC161905', 'BRIK VALUE' => '2626182', 'INVESTMENT AMOUNT' => '1989270', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 1840270', 'TOTAL INSTALLMENT PAID' => '1840270', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '270', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	150 => array('S.NO.' => '151', 'ID' => '159', 'BRIK OWNER' => 'Ganesh M - glamourganesh@gmail.com', 'UNIT NUMBER' => 'Row-8/Block 5/ B-201', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '775030', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 687499', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '187499', 'DISCOUNT ON BRIK' => '60242', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	151 => array('S.NO.' => '152', 'ID' => '160', 'BRIK OWNER' => 'Rajashri Jayaram Ferns - danferns28@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '1989270', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 1996270', 'TOTAL INSTALLMENT PAID' => '570000', 'TOTAL INSTALLMENT PENDING' => '1426270', 'DISCOUNT ON BRIK' => '', 'COINS' => '270', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	152 => array('S.NO.' => '153', 'ID' => '161', 'BRIK OWNER' => 'Tanushree Saxena - tarun.sanmotra@gmail.com', 'UNIT NUMBER' => 'Row-8/Block 5/ B-201', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 676030', 'TOTAL INSTALLMENT PAID' => '520000', 'TOTAL INSTALLMENT PENDING' => '156030', 'DISCOUNT ON BRIK' => '36272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	153 => array('S.NO.' => '154', 'ID' => '162', 'BRIK OWNER' => 'Vikash Kumar Jaiswal - vikjaiswal1@yahoo.co.in', 'UNIT NUMBER' => 'Unit number - 7', 'PROJECT' => 'Golden Sands', 'SPV' => 'ARO 2 BHK SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA7827N', 'CIN NO.' => 'U74999UP2022PTC161905', 'BRIK VALUE' => '2626182', 'INVESTMENT AMOUNT' => '1989270', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 1860270', 'TOTAL INSTALLMENT PAID' => '1600000', 'TOTAL INSTALLMENT PENDING' => '260270', 'DISCOUNT ON BRIK' => '', 'COINS' => '360', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	154 => array('S.NO.' => '155', 'ID' => '163', 'BRIK OWNER' => 'Dr. Abhay Kumar Singh - abhay7075707@gmail.com', 'UNIT NUMBER' => 'Unit number - 7', 'PROJECT' => 'Golden Sands', 'SPV' => 'ARO 2 BHK SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA7827N', 'CIN NO.' => 'U74999UP2022PTC161905', 'BRIK VALUE' => '2626182', 'INVESTMENT AMOUNT' => '1989270', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 1840270', 'TOTAL INSTALLMENT PAID' => '1840270', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '540', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	155 => array('S.NO.' => '156', 'ID' => '164', 'BRIK OWNER' => 'Tkm Career And Global Private Limited - tkm111989@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '775030', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 987988', 'TOTAL INSTALLMENT PAID' => '190000', 'TOTAL INSTALLMENT PENDING' => '797988', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	156 => array('S.NO.' => '157', 'ID' => '165', 'BRIK OWNER' => 'Sunil Kumar R G - shiinesun10@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 902106', 'TOTAL INSTALLMENT PAID' => '18780', 'TOTAL INSTALLMENT PENDING' => '883326', 'DISCOUNT ON BRIK' => '50000', 'COINS' => '270', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	157 => array('S.NO.' => '158', 'ID' => '166', 'BRIK OWNER' => 'MS SUKANYA KANUMURI - sukanya.kanumuri@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-505', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '505000', 'TOTAL INSTALLMENT PENDING' => '195000', 'DISCOUNT ON BRIK' => '36272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	158 => array('S.NO.' => '159', 'ID' => '167', 'BRIK OWNER' => 'Rosetta Anil Dsouza - anildsouza@magarpattacity.com', 'UNIT NUMBER' => 'Unit number - 7', 'PROJECT' => 'Golden Sands', 'SPV' => 'ARO 2 BHK SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA7827N', 'CIN NO.' => 'U74999UP2022PTC161905', 'BRIK VALUE' => '2626182', 'INVESTMENT AMOUNT' => '1989270', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 1840270', 'TOTAL INSTALLMENT PAID' => '1840270', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '270', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	159 => array('S.NO.' => '160', 'ID' => '168', 'BRIK OWNER' => 'Abhishek Dayal - dayalabhishek@rediffmail.com', 'UNIT NUMBER' => 'Tower-3 Unit 103', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 570000', 'TOTAL INSTALLMENT PAID' => '570000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '46336', 'COINS' => '120', 'REFERRAL DISC' => '58440', 'COIN' => '', 'REFERRAL DISCOUNT' => '58440'),
	160 => array('S.NO.' => '161', 'ID' => '169', 'BRIK OWNER' => 'Mukesh Kumar Choudhary - xmmukesh@gmail.com', 'UNIT NUMBER' => 'Unit number - 7', 'PROJECT' => 'Golden Sands', 'SPV' => 'ARO 2 BHK SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA7827N', 'CIN NO.' => 'U74999UP2022PTC161905', 'BRIK VALUE' => '2626182', 'INVESTMENT AMOUNT' => '2190000', 'BOOKING AMOUNT PAID' => '190000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 2000000', 'TOTAL INSTALLMENT PAID' => '1800000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	161 => array('S.NO.' => '162', 'ID' => '170', 'BRIK OWNER' => 'Sanjay Koul - sanjay.koul@timken.com', 'UNIT NUMBER' => 'Resale Brik\'s 00', 'PROJECT' => 'Resale Brik\'s', 'SPV' => '00', 'SPV ACCOUNT' => '00', 'IFSC' => '00', 'PAN CARD NO.' => '00', 'CIN NO.' => '00', 'BRIK VALUE' => '0', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '700000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '247636', 'COINS' => '390', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	162 => array('S.NO.' => '163', 'ID' => '171', 'BRIK OWNER' => 'Abhishek Dayal - dayalabhishek@rediffmail.com', 'UNIT NUMBER' => 'B1', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '700000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '247636', 'COINS' => '120', 'REFERRAL DISC' => '58440', 'COIN' => '120', 'REFERRAL DISCOUNT' => '58440'),
	163 => array('S.NO.' => '164', 'ID' => '172', 'BRIK OWNER' => 'Puneet Dhawariya - puneet.educomp@gmail.com', 'UNIT NUMBER' => 'B1', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '197636', 'COINS' => '228', 'REFERRAL DISC' => '0', 'COIN' => '108', 'REFERRAL DISCOUNT' => '0'),
	164 => array('S.NO.' => '165', 'ID' => '173', 'BRIK OWNER' => 'Air Cmde Mohit Kumar Nayyar VM,VSM - mohitkumarnayyar@gmail.com', 'UNIT NUMBER' => 'B1', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '700000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '247636', 'COINS' => '330', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	165 => array('S.NO.' => '166', 'ID' => '174', 'BRIK OWNER' => 'Pushpaben Kisorsinh Gadhvi - pushpagadhvi04@gmail.com', 'UNIT NUMBER' => '', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '650000', 'DISCOUNT ON BRIK' => '104227', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	166 => array('S.NO.' => '167', 'ID' => '175', 'BRIK OWNER' => 'Kothapalli Rajiv Varma - rv.nani91@gmail.com', 'UNIT NUMBER' => 'B1', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '197636', 'COINS' => '240', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	167 => array('S.NO.' => '168', 'ID' => '176', 'BRIK OWNER' => 'Shobha . - samemofrnd@gmail.com', 'UNIT NUMBER' => 'Resale Brik\'s 00', 'PROJECT' => 'Resale Brik\'s', 'SPV' => '00', 'SPV ACCOUNT' => '00', 'IFSC' => '00', 'PAN CARD NO.' => '00', 'CIN NO.' => '00', 'BRIK VALUE' => '0', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 2 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '197636', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	168 => array('S.NO.' => '169', 'ID' => '177', 'BRIK OWNER' => 'Ranvir Bharadwaj - bharadwajranvir@gmail.com', 'UNIT NUMBER' => 'B1', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '197636', 'COINS' => '240', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	169 => array('S.NO.' => '170', 'ID' => '178', 'BRIK OWNER' => 'Tarannum Iqbal Siddiqui - aas1786.as@gmail.com', 'UNIT NUMBER' => 'B1', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '197636', 'COINS' => '360', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	170 => array('S.NO.' => '171', 'ID' => '179', 'BRIK OWNER' => 'Aviral Gahlot - aviralgahlot121@gmail.com', 'UNIT NUMBER' => 'B2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '197636', 'COINS' => '360', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	171 => array('S.NO.' => '172', 'ID' => '180', 'BRIK OWNER' => 'SHUBHANKAR KARMAKAR - lakshyaenterprises1930@gmail.com', 'UNIT NUMBER' => 'B3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '700000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '247636', 'COINS' => '450', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	172 => array('S.NO.' => '173', 'ID' => '181', 'BRIK OWNER' => 'Dr. Ankur Chikara - ankurchikara@gmail.com', 'UNIT NUMBER' => 'B2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '197636', 'COINS' => '360', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	173 => array('S.NO.' => '174', 'ID' => '182', 'BRIK OWNER' => 'Nabajeet Kalita - navafree2rhyme@gmail.com', 'UNIT NUMBER' => 'B3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 662790', 'TOTAL INSTALLMENT PAID' => '662790', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '197636', 'COINS' => '540', 'REFERRAL DISC' => '0', 'COIN' => '189', 'REFERRAL DISCOUNT' => '0'),
	174 => array('S.NO.' => '175', 'ID' => '183', 'BRIK OWNER' => 'Dr. Abhay Kumar Singh - abhay7075707@gmail.com', 'UNIT NUMBER' => 'B2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '700000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '247636', 'COINS' => '540', 'REFERRAL DISC' => '0', 'COIN' => '240', 'REFERRAL DISCOUNT' => '0'),
	175 => array('S.NO.' => '176', 'ID' => '184', 'BRIK OWNER' => 'Kush Kalra - kalrakush786@gmail.com', 'UNIT NUMBER' => 'Resale Brik\'s 00', 'PROJECT' => 'Resale Brik\'s', 'SPV' => '00', 'SPV ACCOUNT' => '00', 'IFSC' => '00', 'PAN CARD NO.' => '00', 'CIN NO.' => '00', 'BRIK VALUE' => '0', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '197636', 'COINS' => '450', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	176 => array('S.NO.' => '177', 'ID' => '185', 'BRIK OWNER' => 'Nagavenkata Ravi Kiran Juluru - ravikiranjuluru@gmail.com', 'UNIT NUMBER' => 'B2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '700000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '247636', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	177 => array('S.NO.' => '178', 'ID' => '186', 'BRIK OWNER' => 'Man Singh - singh.man20@gmail.com', 'UNIT NUMBER' => 'B2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '700000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '247636', 'COINS' => '116', 'REFERRAL DISC' => '0', 'COIN' => '116', 'REFERRAL DISCOUNT' => '0'),
	178 => array('S.NO.' => '179', 'ID' => '187', 'BRIK OWNER' => 'Ajay Kumar - ajayeklavya@yahoo.com', 'UNIT NUMBER' => 'Row-8/Block 2/A-101', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '520000', 'TOTAL INSTALLMENT PENDING' => '30000', 'DISCOUNT ON BRIK' => '50000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	179 => array('S.NO.' => '180', 'ID' => '188', 'BRIK OWNER' => 'Ratna Ravi Pangala - maheshaonline01@gmail.com', 'UNIT NUMBER' => 'Resale Brik\'s 00', 'PROJECT' => 'Resale Brik\'s', 'SPV' => '00', 'SPV ACCOUNT' => '00', 'IFSC' => '00', 'PAN CARD NO.' => '00', 'CIN NO.' => '00', 'BRIK VALUE' => '0', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '197636', 'COINS' => '240', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	180 => array('S.NO.' => '181', 'ID' => '189', 'BRIK OWNER' => 'Varsha N Kulkarni - abhishekakulkarni@bel.co.in', 'UNIT NUMBER' => 'B3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '197636', 'COINS' => '240', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	181 => array('S.NO.' => '182', 'ID' => '190', 'BRIK OWNER' => 'Prathap Kumar - drsprathapkumar@gmail.com', 'UNIT NUMBER' => 'Resale Brik\'s 00', 'PROJECT' => 'Resale Brik\'s', 'SPV' => '00', 'SPV ACCOUNT' => '00', 'IFSC' => '00', 'PAN CARD NO.' => '00', 'CIN NO.' => '00', 'BRIK VALUE' => '0', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '197636', 'COINS' => '240', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	182 => array('S.NO.' => '183', 'ID' => '191', 'BRIK OWNER' => 'ANUPRIYA GUPTA - akumar095@gmail.com', 'UNIT NUMBER' => 'B3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '899000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '800000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '147636', 'COINS' => '240', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	183 => array('S.NO.' => '184', 'ID' => '192', 'BRIK OWNER' => 'AMITABHA MITRA - amitabhamitra@hotmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-507', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 730000', 'TOTAL INSTALLMENT PAID' => '413875', 'TOTAL INSTALLMENT PENDING' => '316125', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	184 => array('S.NO.' => '185', 'ID' => '193', 'BRIK OWNER' => 'Rajat Dutt Sharma - er.rajatds@gmail.com', 'UNIT NUMBER' => 'Row-8/Block 2/A-101', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '50000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	185 => array('S.NO.' => '186', 'ID' => '194', 'BRIK OWNER' => 'Daya Sharma - dayasharma340@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 793500', 'TOTAL INSTALLMENT PAID' => '125000', 'TOTAL INSTALLMENT PENDING' => '668500', 'DISCOUNT ON BRIK' => '36090', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	186 => array('S.NO.' => '187', 'ID' => '195', 'BRIK OWNER' => 'Harsha Kumari - kumariharsha2018@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-504', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 730000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '230000', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	187 => array('S.NO.' => '188', 'ID' => '196', 'BRIK OWNER' => 'Ussv Mehar - umehar@yahoo.com', 'UNIT NUMBER' => '302', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '929000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '850000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	188 => array('S.NO.' => '189', 'ID' => '197', 'BRIK OWNER' => 'Mandeep Singh - mandeeppsit@gmail.com', 'UNIT NUMBER' => '302', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '850000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '300', 'REFERRAL DISC' => '0', 'COIN' => '0', 'REFERRAL DISCOUNT' => '0'),
	189 => array('S.NO.' => '190', 'ID' => '198', 'BRIK OWNER' => 'Abhinav Chetan Anand - abhinav.acap22@gmail.com', 'UNIT NUMBER' => 'Unit number - 7', 'PROJECT' => 'Golden Sands', 'SPV' => 'ARO 2 BHK SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA7827N', 'CIN NO.' => 'U74999UP2022PTC161905', 'BRIK VALUE' => '2626182', 'INVESTMENT AMOUNT' => '2090000', 'BOOKING AMOUNT PAID' => '190000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 1900000', 'TOTAL INSTALLMENT PAID' => '1700000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '207455', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	190 => array('S.NO.' => '191', 'ID' => '199', 'BRIK OWNER' => 'Anil Thakorbhai Naik - minal_comm@yahoo.com', 'UNIT NUMBER' => 'Tower-3 Unit 103', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '669590', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 590590', 'TOTAL INSTALLMENT PAID' => '590590', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	191 => array('S.NO.' => '192', 'ID' => '200', 'BRIK OWNER' => 'Divyateja Reddy Thunga - ursvasi@gmail.com', 'UNIT NUMBER' => '302', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '881180', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 782180', 'TOTAL INSTALLMENT PAID' => '782180', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '117820', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	192 => array('S.NO.' => '193', 'ID' => '201', 'BRIK OWNER' => 'Rohit Verma - rohitkverma72@gmail.com', 'UNIT NUMBER' => 'B2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '700000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '120', 'REFERRAL DISC' => '12930', 'COIN' => '120', 'REFERRAL DISCOUNT' => '12930'),
	193 => array('S.NO.' => '194', 'ID' => '202', 'BRIK OWNER' => 'Praveen Kumar Pandey - pandeypraveenkr73@gmail.com', 'UNIT NUMBER' => '302', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '929000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 830000', 'TOTAL INSTALLMENT PAID' => '830000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '70000', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	194 => array('S.NO.' => '195', 'ID' => '203', 'BRIK OWNER' => 'Paresh Vijayanand Jadhav - paresh_vjadhav@yahoo.com', 'UNIT NUMBER' => 'T10-104', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '979000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 880000', 'TOTAL INSTALLMENT PAID' => '880000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '70000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '78', 'REFERRAL DISCOUNT' => '0'),
	195 => array('S.NO.' => '196', 'ID' => '204', 'BRIK OWNER' => 'Nabajeet Kalita - navafree2rhyme@gmail.com', 'UNIT NUMBER' => 'T10-104', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '929000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 830000', 'TOTAL INSTALLMENT PAID' => '830000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '70000', 'COINS' => '540', 'REFERRAL DISC' => '0', 'COIN' => '0', 'REFERRAL DISCOUNT' => '0'),
	196 => array('S.NO.' => '197', 'ID' => '205', 'BRIK OWNER' => 'Ashiesh Arora Huf - ashiesh3006@rediffmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-504', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 730000', 'TOTAL INSTALLMENT PAID' => '630000', 'TOTAL INSTALLMENT PENDING' => '100000', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	197 => array('S.NO.' => '198', 'ID' => '206', 'BRIK OWNER' => 'Ashiesh Arora Huf - ashiesh3006@rediffmail.com', 'UNIT NUMBER' => 'B3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '869000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 770000', 'TOTAL INSTALLMENT PAID' => '770000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '177636', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	198 => array('S.NO.' => '199', 'ID' => '208', 'BRIK OWNER' => 'Mandeep Singh - mandeeppsit@gmail.com', 'UNIT NUMBER' => 'B3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '850000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '300', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	199 => array('S.NO.' => '200', 'ID' => '209', 'BRIK OWNER' => 'Pratibha Singh - pratibhasingh113@gmail.com', 'UNIT NUMBER' => '302', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '929000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '800000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	200 => array('S.NO.' => '201', 'ID' => '210', 'BRIK OWNER' => 'Alok Sinha - aloksinha.lko@gmail.com', 'UNIT NUMBER' => '302', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '929000', 'BOOKING AMOUNT PAID' => '110000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 819000', 'TOTAL INSTALLMENT PAID' => '819000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '82', 'REFERRAL DISC' => '0', 'COIN' => '82', 'REFERRAL DISCOUNT' => '0'),
	201 => array('S.NO.' => '202', 'ID' => '211', 'BRIK OWNER' => 'SOUBHAGYA KUMAR NAYAK - shaubhagya.nayak@gmail.com', 'UNIT NUMBER' => 'B3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '850000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '97636', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	202 => array('S.NO.' => '203', 'ID' => '212', 'BRIK OWNER' => 'SAMEEKSHA MAURYA - sameeksha.pkg@gmail.com', 'UNIT NUMBER' => 'B3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 730000', 'TOTAL INSTALLMENT PAID' => '730000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '217636', 'COINS' => '32', 'REFERRAL DISC' => '0', 'COIN' => '51', 'REFERRAL DISCOUNT' => '0'),
	203 => array('S.NO.' => '204', 'ID' => '213', 'BRIK OWNER' => 'Ramchandra Vasant Chikhalagi - ram.chikhalagi@gmail.com', 'UNIT NUMBER' => '302', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '929000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 830000', 'TOTAL INSTALLMENT PAID' => '830000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '70000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	204 => array('S.NO.' => '205', 'ID' => '214', 'BRIK OWNER' => 'Namita Priya - prasadkamit@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 16 Installments) Amount: 636066', 'TOTAL INSTALLMENT PAID' => '210000', 'TOTAL INSTALLMENT PENDING' => '426066', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	205 => array('S.NO.' => '206', 'ID' => '215', 'BRIK OWNER' => 'Yash Tayal - yashtayal@gmail.com', 'UNIT NUMBER' => '00', 'PROJECT' => 'Liquidate Brik\'s', 'SPV' => 'In-Process', 'SPV ACCOUNT' => '', 'IFSC' => '', 'PAN CARD NO.' => '', 'CIN NO.' => '', 'BRIK VALUE' => '', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 18 Installments) Amount: 570000', 'TOTAL INSTALLMENT PAID' => '541500', 'TOTAL INSTALLMENT PENDING' => '28500', 'DISCOUNT ON BRIK' => '50000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	206 => array('S.NO.' => '207', 'ID' => '216', 'BRIK OWNER' => 'Bhaskar Pratap Swain - bhaskarswain4@gmail.com', 'UNIT NUMBER' => 'Resale Brik\'s 00', 'PROJECT' => 'Resale Brik\'s', 'SPV' => '00', 'SPV ACCOUNT' => '00', 'IFSC' => '00', 'PAN CARD NO.' => '00', 'CIN NO.' => '00', 'BRIK VALUE' => '0', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	207 => array('S.NO.' => '208', 'ID' => '217', 'BRIK OWNER' => 'Bharat Vittal Naik - bharatvittalnaik@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-504', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '150000', 'DISCOUNT ON BRIK' => '86090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	208 => array('S.NO.' => '209', 'ID' => '218', 'BRIK OWNER' => 'Charu Joshi - cdrdpjoshi@gmail.com', 'UNIT NUMBER' => 'B3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '197636', 'COINS' => '420', 'REFERRAL DISC' => '0', 'COIN' => '390', 'REFERRAL DISCOUNT' => '0'),
	209 => array('S.NO.' => '210', 'ID' => '219', 'BRIK OWNER' => 'Archana Rawat - riddhimanbajari@gmail.com', 'UNIT NUMBER' => 'Resale Brik\'s 00', 'PROJECT' => 'Resale Brik\'s', 'SPV' => '00', 'SPV ACCOUNT' => '00', 'IFSC' => '00', 'PAN CARD NO.' => '00', 'CIN NO.' => '00', 'BRIK VALUE' => '0', 'INVESTMENT AMOUNT' => '99000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 830000', 'TOTAL INSTALLMENT PAID' => '830000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '70000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	210 => array('S.NO.' => '211', 'ID' => '220', 'BRIK OWNER' => 'Vijay Kumar - vkrirse2001@gmail.com', 'UNIT NUMBER' => 'B3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '850000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '97636', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	211 => array('S.NO.' => '212', 'ID' => '221', 'BRIK OWNER' => 'Penmatsa Janakiramaraju - worthyone2u@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-504', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 15 Installments) Amount: 759131.2', 'TOTAL INSTALLMENT PAID' => '490000', 'TOTAL INSTALLMENT PENDING' => '269131.2', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	212 => array('S.NO.' => '213', 'ID' => '222', 'BRIK OWNER' => 'Mohammed Abdul Azeem - aazeem7868@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 14 Installments) Amount: 796876', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '796876', 'DISCOUNT ON BRIK' => '86090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	213 => array('S.NO.' => '214', 'ID' => '223', 'BRIK OWNER' => 'Archana YM - archanayashwanth27@gmail.com', 'UNIT NUMBER' => '302', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '929000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 830000', 'TOTAL INSTALLMENT PAID' => '830000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '70000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	214 => array('S.NO.' => '215', 'ID' => '224', 'BRIK OWNER' => 'Anugrah Deodatta Gaikwad - anugrahgaikwad05@gmail.com', 'UNIT NUMBER' => 'Resale Brik\'s 00', 'PROJECT' => 'Resale Brik\'s', 'SPV' => '00', 'SPV ACCOUNT' => '00', 'IFSC' => '00', 'PAN CARD NO.' => '00', 'CIN NO.' => '00', 'BRIK VALUE' => '0', 'INVESTMENT AMOUNT' => '899000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '800000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '100000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	215 => array('S.NO.' => '216', 'ID' => '225', 'BRIK OWNER' => 'Ashwath Venkat Rao - ashwa82@gmail.com', 'UNIT NUMBER' => 'T10-104', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '929000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 830000', 'TOTAL INSTALLMENT PAID' => '830000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '70000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => 'resale', 'REFERRAL DISCOUNT' => '0'),
	216 => array('S.NO.' => '217', 'ID' => '226', 'BRIK OWNER' => 'Aman Deep - malikkcm@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-303', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 19 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '472000', 'TOTAL INSTALLMENT PENDING' => '228000', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	217 => array('S.NO.' => '218', 'ID' => '227', 'BRIK OWNER' => 'Mohit Sharma - mohitsharma2065@gmail.com', 'UNIT NUMBER' => 'Tower-3 Unit 103', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '650000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 571000', 'TOTAL INSTALLMENT PAID' => '435000', 'TOTAL INSTALLMENT PENDING' => '136000', 'DISCOUNT ON BRIK' => '85245', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	218 => array('S.NO.' => '219', 'ID' => '228', 'BRIK OWNER' => 'Anurag Sinha - anuragsinha2001@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '850000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '97636', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	219 => array('S.NO.' => '220', 'ID' => '229', 'BRIK OWNER' => 'Kush Kalra - kalrakush786@gmail.com', 'UNIT NUMBER' => 'T10-104', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '929000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 830000', 'TOTAL INSTALLMENT PAID' => '830000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '70000', 'COINS' => '450', 'REFERRAL DISC' => '0', 'COIN' => '210', 'REFERRAL DISCOUNT' => '0'),
	220 => array('S.NO.' => '221', 'ID' => '230', 'BRIK OWNER' => 'Rajendra Raikwar - raikwar.raj@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-504', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 22 Installments) Amount: 730000', 'TOTAL INSTALLMENT PAID' => '730000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	221 => array('S.NO.' => '222', 'ID' => '231', 'BRIK OWNER' => 'Deepak Lilani - deepulilani@gmail.com', 'UNIT NUMBER' => 'B2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '850000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 751000', 'TOTAL INSTALLMENT PAID' => '751000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	222 => array('S.NO.' => '223', 'ID' => '232', 'BRIK OWNER' => 'Sneha Anil Barve - barveani@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-504', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 26 Installments) Amount: 730000', 'TOTAL INSTALLMENT PAID' => '320000', 'TOTAL INSTALLMENT PENDING' => '410000', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	223 => array('S.NO.' => '224', 'ID' => '233', 'BRIK OWNER' => 'Sushma Singh - kuldeepest@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '929000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 830000', 'TOTAL INSTALLMENT PAID' => '830000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	224 => array('S.NO.' => '225', 'ID' => '234', 'BRIK OWNER' => 'Priyanka Kumari - priyaraj4184@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-303', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 19 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '280000', 'TOTAL INSTALLMENT PENDING' => '420000', 'DISCOUNT ON BRIK' => '86090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	225 => array('S.NO.' => '226', 'ID' => '235', 'BRIK OWNER' => 'Sumeet Kumar - sonu_njoy2004@yahoo.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-303', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 705355', 'TOTAL INSTALLMENT PAID' => '579650', 'TOTAL INSTALLMENT PENDING' => '125705', 'DISCOUNT ON BRIK' => '80960', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	226 => array('S.NO.' => '227', 'ID' => '236', 'BRIK OWNER' => 'Rishi Raj Gupta - razavenue@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '907180', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 808180', 'TOTAL INSTALLMENT PAID' => '808180', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '139456', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	227 => array('S.NO.' => '228', 'ID' => '237', 'BRIK OWNER' => 'Shalini Purushottam Modani - pmodani@gmail.com', 'UNIT NUMBER' => 'B2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '197636', 'COINS' => '105', 'REFERRAL DISC' => '0', 'COIN' => '15', 'REFERRAL DISCOUNT' => '0'),
	228 => array('S.NO.' => '229', 'ID' => '238', 'BRIK OWNER' => 'Suresh Jayagondar Yamahappa - sureshinbec@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-303', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 730000', 'TOTAL INSTALLMENT PAID' => '579425', 'TOTAL INSTALLMENT PENDING' => '150575', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	229 => array('S.NO.' => '230', 'ID' => '239', 'BRIK OWNER' => 'Akshay Jyoti Baruah - akshay.baruah@nrl.co.in', 'UNIT NUMBER' => 'T10-104', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '850000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '170000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	230 => array('S.NO.' => '231', 'ID' => '240', 'BRIK OWNER' => 'Ruchita Ravindra Palande - ravindrapalande53@gmail.com', 'UNIT NUMBER' => 'T 11 - 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '970000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 871000', 'TOTAL INSTALLMENT PAID' => '871000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '199000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	231 => array('S.NO.' => '232', 'ID' => '241', 'BRIK OWNER' => 'Chanaveeragouda Virupaxgouda Goudar - cvgoudar@gmail.com', 'UNIT NUMBER' => 'T10-104', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1169000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '850000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	232 => array('S.NO.' => '233', 'ID' => '244', 'BRIK OWNER' => 'Pratibha Choudhary - cievkrp@gmail.com', 'UNIT NUMBER' => 'T 11 - 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '900000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '120000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	233 => array('S.NO.' => '234', 'ID' => '245', 'BRIK OWNER' => 'Sunand Padmanabhan - sunand.wired@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-303', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 730000', 'TOTAL INSTALLMENT PAID' => '540000', 'TOTAL INSTALLMENT PENDING' => '190000', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	234 => array('S.NO.' => '235', 'ID' => '246', 'BRIK OWNER' => 'Sandeep Sharma - greatsandi123@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '899000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '800000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '147636', 'COINS' => '100', 'REFERRAL DISC' => '56700', 'COIN' => '84', 'REFERRAL DISCOUNT' => '56700'),
	235 => array('S.NO.' => '236', 'ID' => '247', 'BRIK OWNER' => 'Subir Das - subirdas472@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 1234915', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1234915', 'DISCOUNT ON BRIK' => '86090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	236 => array('S.NO.' => '237', 'ID' => '248', 'BRIK OWNER' => 'Yaan Business Management Solutions Llp (Yashmin Yevawala) - squib.ybms@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 661132', 'TOTAL INSTALLMENT PAID' => '190000', 'TOTAL INSTALLMENT PENDING' => '471132', 'DISCOUNT ON BRIK' => '97791', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	237 => array('S.NO.' => '238', 'ID' => '249', 'BRIK OWNER' => 'Raj Kumar Chaurasia - raj25iitm@gmail.com', 'UNIT NUMBER' => 'Tower-3 Unit 103', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 645600', 'TOTAL INSTALLMENT PAID' => '560000', 'TOTAL INSTALLMENT PENDING' => '85600', 'DISCOUNT ON BRIK' => '77791', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	238 => array('S.NO.' => '239', 'ID' => '250', 'BRIK OWNER' => 'Bipin Kumar Sahoo - bipin.4010@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-303', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 780000', 'TOTAL INSTALLMENT PAID' => '590000', 'TOTAL INSTALLMENT PENDING' => '190000', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	239 => array('S.NO.' => '240', 'ID' => '251', 'BRIK OWNER' => 'Neeru Kalra - neerukalra23@gmail.com', 'UNIT NUMBER' => 'Tower-3 Unit 103', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 616646', 'TOTAL INSTALLMENT PAID' => '490000', 'TOTAL INSTALLMENT PENDING' => '126646', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	240 => array('S.NO.' => '241', 'ID' => '252', 'BRIK OWNER' => 'VIKRAM NANDA - vikramnanda99@hotmail.com', 'UNIT NUMBER' => 'T10-104', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '850000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '170000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	241 => array('S.NO.' => '242', 'ID' => '253', 'BRIK OWNER' => 'Nitin Nagia - nitin_nagia@rediffmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	242 => array('S.NO.' => '243', 'ID' => '254', 'BRIK OWNER' => 'Era Arora - eraarora87@gmail.com', 'UNIT NUMBER' => 'T8-506', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	243 => array('S.NO.' => '244', 'ID' => '255', 'BRIK OWNER' => 'Nagarjuna Reddy Kamireddy - nagarjuna.k@icloud.com', 'UNIT NUMBER' => 'T 11 - 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '900000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '120000', 'COINS' => '50', 'REFERRAL DISC' => '0', 'COIN' => '50', 'REFERRAL DISCOUNT' => '0'),
	244 => array('S.NO.' => '245', 'ID' => '256', 'BRIK OWNER' => 'Akshat Chaturvedi - akshatc703@gmail.com', 'UNIT NUMBER' => 'T8-506', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	245 => array('S.NO.' => '246', 'ID' => '257', 'BRIK OWNER' => 'G Sravanthi - sravanthiamullu@gmail.com', 'UNIT NUMBER' => 'Resale Brik\'s 00', 'PROJECT' => 'Resale Brik\'s', 'SPV' => '00', 'SPV ACCOUNT' => '00', 'IFSC' => '00', 'PAN CARD NO.' => '00', 'CIN NO.' => '00', 'BRIK VALUE' => '0', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '850000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '170000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	246 => array('S.NO.' => '247', 'ID' => '258', 'BRIK OWNER' => 'Rashmi Verma - rasverma1989@gmail.com', 'UNIT NUMBER' => 'T8-506', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	247 => array('S.NO.' => '248', 'ID' => '259', 'BRIK OWNER' => 'Akhil Sachan - akhilrox.10@gmail.com', 'UNIT NUMBER' => '505', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	248 => array('S.NO.' => '249', 'ID' => '260', 'BRIK OWNER' => 'Sagar Sailesh Sodha - sagar.sodha94@gmail.com', 'UNIT NUMBER' => 'T8-506', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	249 => array('S.NO.' => '250', 'ID' => '261', 'BRIK OWNER' => 'Ashwini Ravi Dhumal - dhumalravi003@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-303', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 730000', 'TOTAL INSTALLMENT PAID' => '540000', 'TOTAL INSTALLMENT PENDING' => '190000', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	250 => array('S.NO.' => '251', 'ID' => '262', 'BRIK OWNER' => 'Dr. Khushboo Harsh Garg - khushboo.garg104@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-303', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '580000', 'TOTAL INSTALLMENT PENDING' => '170000', 'DISCOUNT ON BRIK' => '36090', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	251 => array('S.NO.' => '252', 'ID' => '263', 'BRIK OWNER' => 'Nayeem Afroz - naimafroz@yahoo.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-303', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 736242', 'TOTAL INSTALLMENT PAID' => '580000', 'TOTAL INSTALLMENT PENDING' => '156242', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	252 => array('S.NO.' => '253', 'ID' => '264', 'BRIK OWNER' => 'PRASAD PRAKASH KHANGAONKAR - prasadpkhangaonkar@gmail.com', 'UNIT NUMBER' => 'T 11 - 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '900000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '120000', 'COINS' => '80', 'REFERRAL DISC' => '0', 'COIN' => '80', 'REFERRAL DISCOUNT' => '0'),
	253 => array('S.NO.' => '254', 'ID' => '265', 'BRIK OWNER' => 'Hardikkumar Rameshchandra Naik (HUF) - reachme@haardiknayak.com', 'UNIT NUMBER' => 'T 11 - 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '900000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '120000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	254 => array('S.NO.' => '255', 'ID' => '266', 'BRIK OWNER' => 'Limaye Milind Bhalchandra - milindlimaye67@gmail.com', 'UNIT NUMBER' => 'T 11 - 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '900000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '120000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	255 => array('S.NO.' => '256', 'ID' => '267', 'BRIK OWNER' => 'Sangeeta Das - dassangeeta472@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '2090000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 2520683', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '2520683', 'DISCOUNT ON BRIK' => '536182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	256 => array('S.NO.' => '257', 'ID' => '268', 'BRIK OWNER' => 'Haripriya Bhatt Sarkar - haripriyabhatt12@gmail.com', 'UNIT NUMBER' => 'T 11 - 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '900000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '120000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	257 => array('S.NO.' => '258', 'ID' => '269', 'BRIK OWNER' => 'Shyam Sunder Kedia Huf - vedantkedia043@gmail.com', 'UNIT NUMBER' => 'T 11 - 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '900000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '120000', 'COINS' => '81', 'REFERRAL DISC' => '0', 'COIN' => '81', 'REFERRAL DISCOUNT' => '0'),
	258 => array('S.NO.' => '259', 'ID' => '270', 'BRIK OWNER' => 'Praneet kumar - pkumar283@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-504', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 730000', 'TOTAL INSTALLMENT PAID' => '450000', 'TOTAL INSTALLMENT PENDING' => '280000', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	259 => array('S.NO.' => '260', 'ID' => '271', 'BRIK OWNER' => 'Priyanka Bhatia - priyankabhatia079@gmail.com', 'UNIT NUMBER' => 'T8-506', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '569000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 470000', 'TOTAL INSTALLMENT PAID' => '470000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '73000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	260 => array('S.NO.' => '261', 'ID' => '272', 'BRIK OWNER' => 'Akhilesh Mahesh Shivhare - am_shivhare@yahoo.co.in', 'UNIT NUMBER' => 'T8-506', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '569000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 470000', 'TOTAL INSTALLMENT PAID' => '470000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '73000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	261 => array('S.NO.' => '262', 'ID' => '273', 'BRIK OWNER' => 'Debkumar Bhattacharjee - debbhattacharjee2004@yahoo.co.in', 'UNIT NUMBER' => 'Resale Brik\'s 00', 'PROJECT' => 'Resale Brik\'s', 'SPV' => '00', 'SPV ACCOUNT' => '00', 'IFSC' => '00', 'PAN CARD NO.' => '00', 'CIN NO.' => '00', 'BRIK VALUE' => '0', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	262 => array('S.NO.' => '263', 'ID' => '274', 'BRIK OWNER' => 'Prasanna K G - prasanna@kakunje.com', 'UNIT NUMBER' => 'Row-8/B-308', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 750808', 'TOTAL INSTALLMENT PAID' => '590000', 'TOTAL INSTALLMENT PENDING' => '160808', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	263 => array('S.NO.' => '264', 'ID' => '275', 'BRIK OWNER' => 'Shakuntala . - vashishthadivakar@gmail.com', 'UNIT NUMBER' => 'T10-104', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '900000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '120000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	264 => array('S.NO.' => '265', 'ID' => '276', 'BRIK OWNER' => 'ROBIN AGARWAL - robin.agarwal87@gmail.com', 'UNIT NUMBER' => 'Resale Brik\'s 00', 'PROJECT' => 'Resale Brik\'s', 'SPV' => '00', 'SPV ACCOUNT' => '00', 'IFSC' => '00', 'PAN CARD NO.' => '00', 'CIN NO.' => '00', 'BRIK VALUE' => '0', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	265 => array('S.NO.' => '266', 'ID' => '277', 'BRIK OWNER' => 'RENU WADHWA - navdeep.wadhwa@gmail.com', 'UNIT NUMBER' => 'Tower-3 Unit 103', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '77791', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	266 => array('S.NO.' => '267', 'ID' => '278', 'BRIK OWNER' => 'SANJAYA SENAPATY - ss.always2015@gmail.com', 'UNIT NUMBER' => 'Resale Brik\'s 00', 'PROJECT' => 'Resale Brik\'s', 'SPV' => '00', 'SPV ACCOUNT' => '00', 'IFSC' => '00', 'PAN CARD NO.' => '00', 'CIN NO.' => '00', 'BRIK VALUE' => '0', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	267 => array('S.NO.' => '268', 'ID' => '279', 'BRIK OWNER' => 'Hemang Arvindkumar Sanghvi - sanghvihemang@yahoo.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-303', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 730000', 'TOTAL INSTALLMENT PAID' => '540000', 'TOTAL INSTALLMENT PENDING' => '190000', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	268 => array('S.NO.' => '269', 'ID' => '280', 'BRIK OWNER' => 'Mamta sharma - mamtasharma1010@gmail.com', 'UNIT NUMBER' => 'Row-8/B-308', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 739469', 'TOTAL INSTALLMENT PAID' => '583863', 'TOTAL INSTALLMENT PENDING' => '155606', 'DISCOUNT ON BRIK' => '62227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	269 => array('S.NO.' => '270', 'ID' => '281', 'BRIK OWNER' => 'Saurabh Kumar Patel Huf - dr.patelsaurabh@gmail.com', 'UNIT NUMBER' => '505', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '569000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 470000', 'TOTAL INSTALLMENT PAID' => '470000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '73000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	270 => array('S.NO.' => '271', 'ID' => '282', 'BRIK OWNER' => 'Arya Bhushan Pandey - aryabpandey@gmail.com', 'UNIT NUMBER' => 'Tower-3 Unit 103', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '570000', 'TOTAL INSTALLMENT PENDING' => '30000', 'DISCOUNT ON BRIK' => '77791', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	271 => array('S.NO.' => '272', 'ID' => '283', 'BRIK OWNER' => 'ANUP MENON - anupmenon71@gmail.com', 'UNIT NUMBER' => 'T 11 - 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '900000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '120000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	272 => array('S.NO.' => '273', 'ID' => '284', 'BRIK OWNER' => 'Mina Baruah Kalita - rajiblochankalita@gmail.com', 'UNIT NUMBER' => 'T 11 - 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '900000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '120000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	273 => array('S.NO.' => '274', 'ID' => '285', 'BRIK OWNER' => 'Raj Kumar Chaurasia - raj25iitm@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040006', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	274 => array('S.NO.' => '275', 'ID' => '286', 'BRIK OWNER' => 'Abhishek Dayal - dayalabhishek@rediffmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040006', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 270030', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '90030', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '120', 'REFERRAL DISC' => '58440', 'COIN' => '', 'REFERRAL DISCOUNT' => '58440'),
	275 => array('S.NO.' => '276', 'ID' => '287', 'BRIK OWNER' => 'Dr. Jeevan Vutchula - drjeevan447@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040008', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '270', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	276 => array('S.NO.' => '277', 'ID' => '288', 'BRIK OWNER' => 'Shilpi Agarwal - shilagar@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040006', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '54', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	277 => array('S.NO.' => '278', 'ID' => '289', 'BRIK OWNER' => 'Veena kumari - vk8864272@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040006', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 306120', 'TOTAL INSTALLMENT PAID' => '186120', 'TOTAL INSTALLMENT PENDING' => '126120', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	278 => array('S.NO.' => '279', 'ID' => '290', 'BRIK OWNER' => 'Dr. Abhay Kumar Singh - abhay7075707@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040006', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 303120', 'TOTAL INSTALLMENT PAID' => '183120', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '540', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	279 => array('S.NO.' => '280', 'ID' => '291', 'BRIK OWNER' => 'Suvarchala Penmatsa - penmatsasuvarchala@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040006', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '150000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	280 => array('S.NO.' => '281', 'ID' => '292', 'BRIK OWNER' => 'ANUPRIYA GUPTA - akumar095@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040006', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '240', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	281 => array('S.NO.' => '282', 'ID' => '293', 'BRIK OWNER' => 'Dr. Ankur Chikara - ankurchikara@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040007', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '360', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	282 => array('S.NO.' => '283', 'ID' => '294', 'BRIK OWNER' => 'Reena Mehta - maneesh.mehta@hotmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040007', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '369000', 'BOOKING AMOUNT PAID' => '69000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '32090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	283 => array('S.NO.' => '284', 'ID' => '295', 'BRIK OWNER' => 'Shanti Raikwar - r_raikwar@rediffmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040007', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 42 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '192168', 'TOTAL INSTALLMENT PENDING' => '107832', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	284 => array('S.NO.' => '285', 'ID' => '296', 'BRIK OWNER' => 'Dr. Khushboo Harsh Garg - khushboo.garg104@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '969000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 820000', 'TOTAL INSTALLMENT PAID' => '820000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '77636', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	285 => array('S.NO.' => '286', 'ID' => '297', 'BRIK OWNER' => 'Anirudh Choudhary - ani0020.ac@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040007', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	286 => array('S.NO.' => '287', 'ID' => '298', 'BRIK OWNER' => 'Namita Priya - prasadkamit@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 322063', 'TOTAL INSTALLMENT PAID' => '60000', 'TOTAL INSTALLMENT PENDING' => '262063', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	287 => array('S.NO.' => '288', 'ID' => '299', 'BRIK OWNER' => 'Ussv Mehar - umehar@yahoo.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040007', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	288 => array('S.NO.' => '289', 'ID' => '300', 'BRIK OWNER' => 'Dheeraj Singh - dheeraj_20786@yahoo.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040007', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	289 => array('S.NO.' => '290', 'ID' => '301', 'BRIK OWNER' => 'Nitesh Rajkumar Pathak - nitesh.rap@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 330900', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '330900', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	290 => array('S.NO.' => '291', 'ID' => '302', 'BRIK OWNER' => 'Puneet Dhawariya - puneet.educomp@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040007', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '228', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	291 => array('S.NO.' => '292', 'ID' => '303', 'BRIK OWNER' => 'Sreehari Varma kothapalli - varma4666@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040010', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	292 => array('S.NO.' => '293', 'ID' => '304', 'BRIK OWNER' => 'Anurag Sinha - anuragsinha2001@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040008', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	293 => array('S.NO.' => '294', 'ID' => '305', 'BRIK OWNER' => 'Rohit Agarwal - rohitagarwal3333@yahoo.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040008', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	294 => array('S.NO.' => '295', 'ID' => '306', 'BRIK OWNER' => 'Soni Tyagi - mrssonityagi@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040008', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	295 => array('S.NO.' => '296', 'ID' => '307', 'BRIK OWNER' => 'Riddhiman Dutta - we2gether.riddhi@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040008', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '90000', 'TOTAL INSTALLMENT PENDING' => '210000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	296 => array('S.NO.' => '297', 'ID' => '308', 'BRIK OWNER' => 'Kishorsinh Fulsinh Gadhvi - kishor.gadhvi2206@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Vanya Awas', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '150000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	297 => array('S.NO.' => '298', 'ID' => '309', 'BRIK OWNER' => 'Haripriya Bhatt Sarkar - haripriyabhatt12@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040008', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '100000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	298 => array('S.NO.' => '299', 'ID' => '310', 'BRIK OWNER' => 'Chitrada Ramakrishna - ramakrishnabeach@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040008', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '369000', 'BOOKING AMOUNT PAID' => '69000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '32090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	299 => array('S.NO.' => '300', 'ID' => '311', 'BRIK OWNER' => 'Penmatsa Satyanarayana Raju - psnraju2348@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040008', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '369000', 'BOOKING AMOUNT PAID' => '69000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '120000', 'TOTAL INSTALLMENT PENDING' => '180000', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	300 => array('S.NO.' => '301', 'ID' => '312', 'BRIK OWNER' => 'SANJAYA SENAPATY - ss.always2015@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040008', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	301 => array('S.NO.' => '302', 'ID' => '313', 'BRIK OWNER' => 'Sarita Pandey - saritajan08@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040010', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	302 => array('S.NO.' => '303', 'ID' => '314', 'BRIK OWNER' => 'Krishna Mohan Prasad Kanoj - kanoj.krishna@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040009', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	303 => array('S.NO.' => '304', 'ID' => '315', 'BRIK OWNER' => 'Tonika Jain - roshandtn@yahoo.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040009', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 303000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '123000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	304 => array('S.NO.' => '305', 'ID' => '316', 'BRIK OWNER' => 'Sushma Singh - kuldeepest@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040009', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '339000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 290000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '110000', 'DISCOUNT ON BRIK' => '', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	305 => array('S.NO.' => '306', 'ID' => '317', 'BRIK OWNER' => 'Neha Srivastava - srivastava6.neha@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040009', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '165000', 'TOTAL INSTALLMENT PENDING' => '135000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	306 => array('S.NO.' => '307', 'ID' => '318', 'BRIK OWNER' => 'Gaurav Gupta - ya1gaurav@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040009', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	307 => array('S.NO.' => '308', 'ID' => '319', 'BRIK OWNER' => 'Annapurna Dey - deysusovan93@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040009', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '165000', 'TOTAL INSTALLMENT PENDING' => '135000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	308 => array('S.NO.' => '309', 'ID' => '320', 'BRIK OWNER' => 'Poonam Nayyar - poonamnayyar61@yahoo.in', 'UNIT NUMBER' => 'Tower Tulip - VA 040009', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	309 => array('S.NO.' => '310', 'ID' => '321', 'BRIK OWNER' => 'Priyanka Panigrahi - sdh396@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040009', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '359000', 'BOOKING AMOUNT PAID' => '59000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 315606', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '315606', 'DISCOUNT ON BRIK' => '42090', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	310 => array('S.NO.' => '311', 'ID' => '322', 'BRIK OWNER' => 'Subir Das - subirdas472@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 359260', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '359260', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	311 => array('S.NO.' => '312', 'ID' => '323', 'BRIK OWNER' => 'Maitri Sarkar - sshkd19@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040009', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	312 => array('S.NO.' => '313', 'ID' => '324', 'BRIK OWNER' => 'Swapna Prasad Hande - swapnahande2012@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040009', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	313 => array('S.NO.' => '314', 'ID' => '325', 'BRIK OWNER' => 'Renu Gupta - renugun78@gmail.com', 'UNIT NUMBER' => 'T10-104', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '900000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '120000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	314 => array('S.NO.' => '315', 'ID' => '326', 'BRIK OWNER' => 'Ravi Bhimsen Dhumal - ashwinipranshu@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040007', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	315 => array('S.NO.' => '316', 'ID' => '327', 'BRIK OWNER' => 'Renu Gupta - renugun78@gmail.com', 'UNIT NUMBER' => 'T7-206', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SE2BR SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6092B', 'CIN NO.' => 'U70109UP2022PTC157704', 'BRIK VALUE' => '1019909', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 805202', 'TOTAL INSTALLMENT PAID' => '760000', 'TOTAL INSTALLMENT PENDING' => '45202', 'DISCOUNT ON BRIK' => '70909', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	316 => array('S.NO.' => '317', 'ID' => '328', 'BRIK OWNER' => 'Prannay Chhibber - prannaychhibber@gmail.com', 'UNIT NUMBER' => 'Tower-3 Unit 103', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 532166', 'TOTAL INSTALLMENT PAID' => '323560', 'TOTAL INSTALLMENT PENDING' => '208606', 'DISCOUNT ON BRIK' => '97791', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	317 => array('S.NO.' => '318', 'ID' => '329', 'BRIK OWNER' => 'Madhavi T S - arjunnama@gmail.com', 'UNIT NUMBER' => 'Row-8/B-308', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 730000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '180000', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	318 => array('S.NO.' => '319', 'ID' => '330', 'BRIK OWNER' => 'Jyot Kindra - jyotkindra@gmail.com', 'UNIT NUMBER' => 'Resale Brik\'s 00', 'PROJECT' => 'Resale Brik\'s', 'SPV' => '00', 'SPV ACCOUNT' => '00', 'IFSC' => '00', 'PAN CARD NO.' => '00', 'CIN NO.' => '00', 'BRIK VALUE' => '0', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 497588', 'TOTAL INSTALLMENT PAID' => '497588', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	319 => array('S.NO.' => '320', 'ID' => '331', 'BRIK OWNER' => 'Prasad Jaywant Hande - prasad1881@gmail.com', 'UNIT NUMBER' => '505', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	320 => array('S.NO.' => '321', 'ID' => '332', 'BRIK OWNER' => 'Gautam Sumanbhai Desai - ananddecor@gmail.com', 'UNIT NUMBER' => 'Row-8/B-308', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 748727', 'TOTAL INSTALLMENT PAID' => '370000', 'TOTAL INSTALLMENT PENDING' => '378727', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	321 => array('S.NO.' => '322', 'ID' => '333', 'BRIK OWNER' => 'Vipasha Hardik Naik - vipashanayak@yahoo.in', 'UNIT NUMBER' => 'Row-8/B-308', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 730000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '180000', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	322 => array('S.NO.' => '323', 'ID' => '334', 'BRIK OWNER' => 'Foram Sandeep Desai - skdesai1976@gmail.com', 'UNIT NUMBER' => 'Row-8/B-308', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 730000', 'TOTAL INSTALLMENT PAID' => '490000', 'TOTAL INSTALLMENT PENDING' => '240000', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	323 => array('S.NO.' => '324', 'ID' => '335', 'BRIK OWNER' => 'Archana Dabhade - ramdabhade@gmail.com', 'UNIT NUMBER' => '705', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	324 => array('S.NO.' => '325', 'ID' => '336', 'BRIK OWNER' => 'Nancy Yadav - alankarrocks@gmail.com', 'UNIT NUMBER' => 'Tower-3 Unit 103', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 595606', 'TOTAL INSTALLMENT PAID' => '538000', 'TOTAL INSTALLMENT PENDING' => '57606', 'DISCOUNT ON BRIK' => '97791', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	325 => array('S.NO.' => '326', 'ID' => '337', 'BRIK OWNER' => 'Anju Bala - pankajraju1967@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040010', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 288500', 'TOTAL INSTALLMENT PAID' => '168500', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	326 => array('S.NO.' => '327', 'ID' => '338', 'BRIK OWNER' => 'Nirmala Chitlange - mmchitlange@gmail.com', 'UNIT NUMBER' => '505', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '180', 'REFERRAL DISCOUNT' => '0'),
	327 => array('S.NO.' => '328', 'ID' => '339', 'BRIK OWNER' => 'Suma D S - suma.ds@hotmail.com', 'UNIT NUMBER' => '505', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '569000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 470000', 'TOTAL INSTALLMENT PAID' => '470000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '73000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	328 => array('S.NO.' => '329', 'ID' => '340', 'BRIK OWNER' => 'Harinder Bhasin - harinderbhasin@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040010', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	329 => array('S.NO.' => '330', 'ID' => '341', 'BRIK OWNER' => 'Deepak Lilani - deepulilani@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040005', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 303094', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '123094', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	330 => array('S.NO.' => '331', 'ID' => '342', 'BRIK OWNER' => 'Chalamala Revanth - chalamalarevanth@gmail.com', 'UNIT NUMBER' => '505', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '50', 'REFERRAL DISCOUNT' => '0'),
	331 => array('S.NO.' => '332', 'ID' => '343', 'BRIK OWNER' => 'SURABHI GAMBHIR - surabhi.gambhir@gmail.com', 'UNIT NUMBER' => 'Unit number - 7', 'PROJECT' => 'Golden Sands', 'SPV' => 'ARO 2 BHK SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA7827N', 'CIN NO.' => 'U74999UP2022PTC161905', 'BRIK VALUE' => '2626182', 'INVESTMENT AMOUNT' => '2190000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 1900000', 'TOTAL INSTALLMENT PAID' => '1900000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '436182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	332 => array('S.NO.' => '333', 'ID' => '344', 'BRIK OWNER' => 'Archana Dabhade - ramdabhade@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040010', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	333 => array('S.NO.' => '334', 'ID' => '345', 'BRIK OWNER' => 'Ashutosh Batra - matrixcapitalllp@gmail.com', 'UNIT NUMBER' => 'Row-8/B-308', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 764333', 'TOTAL INSTALLMENT PAID' => '220000', 'TOTAL INSTALLMENT PENDING' => '544333', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	334 => array('S.NO.' => '335', 'ID' => '346', 'BRIK OWNER' => 'Taruna Pahuja - ravi.pahuja@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '500000', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	335 => array('S.NO.' => '336', 'ID' => '347', 'BRIK OWNER' => 'Renu Gupta - renugun78@gmail.com', 'UNIT NUMBER' => 'W 10', 'PROJECT' => 'Vanya Awas', 'SPV' => 'ALPINE ESCAPE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAZCA0891K', 'CIN NO.' => 'U68200UP2023PTC186009', 'BRIK VALUE' => '953455', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '580000', 'TOTAL INSTALLMENT PENDING' => '170000', 'DISCOUNT ON BRIK' => '104455', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	336 => array('S.NO.' => '337', 'ID' => '348', 'BRIK OWNER' => 'Purushottam Modani - purumodani7@gmail.com', 'UNIT NUMBER' => 'W 10', 'PROJECT' => 'Vanya Awas', 'SPV' => 'ALPINE ESCAPE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAZCA0891K', 'CIN NO.' => 'U68200UP2023PTC186009', 'BRIK VALUE' => '953455', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '350000', 'DISCOUNT ON BRIK' => '104455', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	337 => array('S.NO.' => '338', 'ID' => '349', 'BRIK OWNER' => 'SURABHI GAMBHIR - surabhi.gambhir@gmail.com', 'UNIT NUMBER' => 'W 10', 'PROJECT' => 'Vanya Awas', 'SPV' => 'ALPINE ESCAPE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAZCA0891K', 'CIN NO.' => 'U68200UP2023PTC186009', 'BRIK VALUE' => '953455', 'INVESTMENT AMOUNT' => '899000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '580000', 'TOTAL INSTALLMENT PENDING' => '220000', 'DISCOUNT ON BRIK' => '54455', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	338 => array('S.NO.' => '339', 'ID' => '350', 'BRIK OWNER' => 'Beela Subash Chandra Bose - subash_bose1@rediffmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '850000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '199546', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	339 => array('S.NO.' => '340', 'ID' => '351', 'BRIK OWNER' => 'Vipasha Hardik Naik - vipashanayak@yahoo.in', 'UNIT NUMBER' => 'W 10', 'PROJECT' => 'Vanya Awas', 'SPV' => 'ALPINE ESCAPE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAZCA0891K', 'CIN NO.' => 'U68200UP2023PTC186009', 'BRIK VALUE' => '953455', 'INVESTMENT AMOUNT' => '899000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '580000', 'TOTAL INSTALLMENT PENDING' => '220000', 'DISCOUNT ON BRIK' => '54455', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	340 => array('S.NO.' => '341', 'ID' => '352', 'BRIK OWNER' => 'Usha Singh - ushasingh1587@outlook.com', 'UNIT NUMBER' => 'Unit number - 7', 'PROJECT' => 'Golden Sands', 'SPV' => 'ARO 2 BHK SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA7827N', 'CIN NO.' => 'U74999UP2022PTC161905', 'BRIK VALUE' => '2626182', 'INVESTMENT AMOUNT' => '2190000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 1817530', 'TOTAL INSTALLMENT PAID' => '1600000', 'TOTAL INSTALLMENT PENDING' => '217530', 'DISCOUNT ON BRIK' => '436182', 'COINS' => '0', 'REFERRAL DISC' => '82470', 'COIN' => '', 'REFERRAL DISCOUNT' => '82470'),
	341 => array('S.NO.' => '342', 'ID' => '353', 'BRIK OWNER' => 'Prasad Y Bansod - rabbu7288@gmail.com', 'UNIT NUMBER' => '505', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	342 => array('S.NO.' => '343', 'ID' => '354', 'BRIK OWNER' => 'Kush Kalra - kalrakush786@gmail.com', 'UNIT NUMBER' => 'W 10', 'PROJECT' => 'Vanya Awas', 'SPV' => 'ALPINE ESCAPE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAZCA0891K', 'CIN NO.' => 'U68200UP2023PTC186009', 'BRIK VALUE' => '953455', 'INVESTMENT AMOUNT' => '839000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '350000', 'DISCOUNT ON BRIK' => '114455', 'COINS' => '450', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	343 => array('S.NO.' => '344', 'ID' => '355', 'BRIK OWNER' => 'JITENDER KUAMR - jitendrakmr695@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 312485', 'TOTAL INSTALLMENT PAID' => '60000', 'TOTAL INSTALLMENT PENDING' => '252485', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	344 => array('S.NO.' => '345', 'ID' => '360', 'BRIK OWNER' => 'Kothapalli Manjula - rajivvarma@dhanvihcproducts.com', 'UNIT NUMBER' => 'W 10', 'PROJECT' => 'Vanya Awas', 'SPV' => 'ALPINE ESCAPE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAZCA0891K', 'CIN NO.' => 'U68200UP2023PTC186009', 'BRIK VALUE' => '953455', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 15 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '450000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '104455', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	345 => array('S.NO.' => '346', 'ID' => '362', 'BRIK OWNER' => 'Naveen Jones - iamnaveenjones@gmail.com', 'UNIT NUMBER' => '505', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	346 => array('S.NO.' => '347', 'ID' => '363', 'BRIK OWNER' => 'Sangram Shivaji Sawant - sangram_bvg@rediffmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040010', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '369000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 301444', 'TOTAL INSTALLMENT PAID' => '30000', 'TOTAL INSTALLMENT PENDING' => '271444', 'DISCOUNT ON BRIK' => '32090', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	347 => array('S.NO.' => '348', 'ID' => '364', 'BRIK OWNER' => 'Suman Maity - designersumanmaity@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '569000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 524000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '524000', 'DISCOUNT ON BRIK' => '73000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	348 => array('S.NO.' => '349', 'ID' => '365', 'BRIK OWNER' => 'Nirbhay Chavre - nirbhaychavre@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040010', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	349 => array('S.NO.' => '350', 'ID' => '366', 'BRIK OWNER' => 'Varsha N Kulkarni - abhishekakulkarni@bel.co.in', 'UNIT NUMBER' => 'Tower Tulip - VA 040010', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 273121', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '123121', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '240', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	350 => array('S.NO.' => '351', 'ID' => '367', 'BRIK OWNER' => 'Abhishek Dayal - dayalabhishek@rediffmail.com', 'UNIT NUMBER' => 'A1', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'SnowPeak Suites Pvt Ltd - A1', 'SPV ACCOUNT' => 'SNOWPEAK SUITES PRIVATE LIMITED', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABLCS9101R', 'CIN NO.' => 'U68100UP2023PTC190891', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1649000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1500000', 'TOTAL INSTALLMENT PAID' => '1400000', 'TOTAL INSTALLMENT PENDING' => '100000', 'DISCOUNT ON BRIK' => '325818', 'COINS' => '120', 'REFERRAL DISC' => '58440', 'COIN' => '', 'REFERRAL DISCOUNT' => '58440'),
	351 => array('S.NO.' => '352', 'ID' => '368', 'BRIK OWNER' => 'Binidra Banerjee - drbinidrapiku2013@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040010', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	352 => array('S.NO.' => '353', 'ID' => '369', 'BRIK OWNER' => 'Kothapalli Manjula - rajivvarma@dhanvihcproducts.com', 'UNIT NUMBER' => 'A1', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'SnowPeak Suites Pvt Ltd - A1', 'SPV ACCOUNT' => 'SNOWPEAK SUITES PRIVATE LIMITED', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABLCS9101R', 'CIN NO.' => 'U68100UP2023PTC190891', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1649000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 1500000', 'TOTAL INSTALLMENT PAID' => '1350000', 'TOTAL INSTALLMENT PENDING' => '150000', 'DISCOUNT ON BRIK' => '325818', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	353 => array('S.NO.' => '354', 'ID' => '370', 'BRIK OWNER' => 'Praneet kumar - pkumar283@gmail.com', 'UNIT NUMBER' => 'A1', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'SnowPeak Suites Pvt Ltd - A1', 'SPV ACCOUNT' => 'SNOWPEAK SUITES PRIVATE LIMITED', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABLCS9101R', 'CIN NO.' => 'U68100UP2023PTC190891', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1600000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 1451000', 'TOTAL INSTALLMENT PAID' => '880000', 'TOTAL INSTALLMENT PENDING' => '571000', 'DISCOUNT ON BRIK' => '374818', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	354 => array('S.NO.' => '355', 'ID' => '371', 'BRIK OWNER' => 'Hardikkumar Rameshchandra Naik (HUF) - reachme@haardiknayak.com', 'UNIT NUMBER' => 'A1', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'SnowPeak Suites Pvt Ltd - A1', 'SPV ACCOUNT' => 'SNOWPEAK SUITES PRIVATE LIMITED', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABLCS9101R', 'CIN NO.' => 'U68100UP2023PTC190891', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1599000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1450000', 'TOTAL INSTALLMENT PAID' => '1450000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '375818', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	355 => array('S.NO.' => '356', 'ID' => '372', 'BRIK OWNER' => 'ANUP MENON - anupmenon71@gmail.com', 'UNIT NUMBER' => 'A1', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'SnowPeak Suites Pvt Ltd - A1', 'SPV ACCOUNT' => 'SNOWPEAK SUITES PRIVATE LIMITED', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABLCS9101R', 'CIN NO.' => 'U68100UP2023PTC190891', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1649000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1500000', 'TOTAL INSTALLMENT PAID' => '1400000', 'TOTAL INSTALLMENT PENDING' => '100000', 'DISCOUNT ON BRIK' => '325818', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	356 => array('S.NO.' => '357', 'ID' => '373', 'BRIK OWNER' => 'Niharika Sahoo - analytiqe@gmail.com', 'UNIT NUMBER' => '706', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '36', 'REFERRAL DISCOUNT' => '0'),
	357 => array('S.NO.' => '358', 'ID' => '374', 'BRIK OWNER' => 'Mukul Jain - mukul.jain@live.com', 'UNIT NUMBER' => 'A1', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'SnowPeak Suites Pvt Ltd - A1', 'SPV ACCOUNT' => 'SNOWPEAK SUITES PRIVATE LIMITED', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABLCS9101R', 'CIN NO.' => 'U68100UP2023PTC190891', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1699000', 'BOOKING AMOUNT PAID' => '190000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 1555818', 'TOTAL INSTALLMENT PAID' => '1150000', 'TOTAL INSTALLMENT PENDING' => '405818', 'DISCOUNT ON BRIK' => '275818', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	358 => array('S.NO.' => '359', 'ID' => '375', 'BRIK OWNER' => 'Harinder Bhasin - harinderbhasin@gmail.com', 'UNIT NUMBER' => 'A1', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'SnowPeak Suites Pvt Ltd - A1', 'SPV ACCOUNT' => 'SNOWPEAK SUITES PRIVATE LIMITED', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABLCS9101R', 'CIN NO.' => 'U68100UP2023PTC190891', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1599000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1450000', 'TOTAL INSTALLMENT PAID' => '1400000', 'TOTAL INSTALLMENT PENDING' => '50000', 'DISCOUNT ON BRIK' => '375818', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	359 => array('S.NO.' => '360', 'ID' => '376', 'BRIK OWNER' => 'SURABHI GAMBHIR - surabhi.gambhir@gmail.com', 'UNIT NUMBER' => 'A1', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'SnowPeak Suites Pvt Ltd - A1', 'SPV ACCOUNT' => 'SNOWPEAK SUITES PRIVATE LIMITED', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABLCS9101R', 'CIN NO.' => 'U68100UP2023PTC190891', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1649000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 1510200', 'TOTAL INSTALLMENT PAID' => '1200000', 'TOTAL INSTALLMENT PENDING' => '310200', 'DISCOUNT ON BRIK' => '325818', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	360 => array('S.NO.' => '361', 'ID' => '377', 'BRIK OWNER' => 'Priyanka Bhaskar - priyanka.bhaskar@gmail.com', 'UNIT NUMBER' => 'W 10', 'PROJECT' => 'Vanya Awas', 'SPV' => 'ALPINE ESCAPE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAZCA0891K', 'CIN NO.' => 'U68200UP2023PTC186009', 'BRIK VALUE' => '953455', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '104455', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	361 => array('S.NO.' => '362', 'ID' => '378', 'BRIK OWNER' => 'Rahul Rawat - rahul.rawat11@gmail.com', 'UNIT NUMBER' => '505', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	362 => array('S.NO.' => '363', 'ID' => '379', 'BRIK OWNER' => 'Shilpy Gupta - apocalypse0007@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 846370', 'TOTAL INSTALLMENT PAID' => '846370', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '199546', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	363 => array('S.NO.' => '364', 'ID' => '380', 'BRIK OWNER' => 'Hardeep Malik - hardeepmalik333@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040007', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 306242', 'TOTAL INSTALLMENT PAID' => '90000', 'TOTAL INSTALLMENT PENDING' => '216242', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	364 => array('S.NO.' => '365', 'ID' => '381', 'BRIK OWNER' => 'ARCHIT RATHORE - architrathore@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 1 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '850000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '47636', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	365 => array('S.NO.' => '366', 'ID' => '382', 'BRIK OWNER' => 'Himanshu Yadav - himanshuy0910@gmail.com', 'UNIT NUMBER' => 'Tower-3 Unit 103', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '50000', 'DISCOUNT ON BRIK' => '77791', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	366 => array('S.NO.' => '367', 'ID' => '383', 'BRIK OWNER' => 'Purushottam Modani - purumodani7@gmail.com', 'UNIT NUMBER' => 'A1', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'SnowPeak Suites Pvt Ltd - A1', 'SPV ACCOUNT' => 'SNOWPEAK SUITES PRIVATE LIMITED', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABLCS9101R', 'CIN NO.' => 'U68100UP2023PTC190891', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1549000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 1400000', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '1100000', 'DISCOUNT ON BRIK' => '425818', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	367 => array('S.NO.' => '368', 'ID' => '384', 'BRIK OWNER' => 'Aaron Prashanth Raj J - aaron.raj41@yahoo.com', 'UNIT NUMBER' => 'T11- 202', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '900000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '120000', 'COINS' => '86', 'REFERRAL DISC' => '0', 'COIN' => '86', 'REFERRAL DISCOUNT' => '0'),
	368 => array('S.NO.' => '369', 'ID' => '385', 'BRIK OWNER' => 'Karan Sen - karansen@gmail.com', 'UNIT NUMBER' => 'T11- 202', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '900000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '120000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	369 => array('S.NO.' => '370', 'ID' => '386', 'BRIK OWNER' => 'Khan Tabish Afzaal Iqbalullah Khan - tabishkhan7@gmail.com', 'UNIT NUMBER' => 'Row-8/B-308', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '510000', 'TOTAL INSTALLMENT PENDING' => '190000', 'DISCOUNT ON BRIK' => '36090', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	370 => array('S.NO.' => '371', 'ID' => '387', 'BRIK OWNER' => 'Hardeep Malik - hardeepmalik333@gmail.com', 'UNIT NUMBER' => 'Tower 8 Block B306', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 753929', 'TOTAL INSTALLMENT PAID' => '430000', 'TOTAL INSTALLMENT PENDING' => '323929', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	371 => array('S.NO.' => '372', 'ID' => '388', 'BRIK OWNER' => 'Ashutosh Batra - matrixcapitalllp@gmail.com', 'UNIT NUMBER' => 'W 10', 'PROJECT' => 'Vanya Awas', 'SPV' => 'ALPINE ESCAPE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAZCA0891K', 'CIN NO.' => 'U68200UP2023PTC186009', 'BRIK VALUE' => '953455', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 16 Installments) Amount: 770808', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '670808', 'DISCOUNT ON BRIK' => '104455', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	372 => array('S.NO.' => '373', 'ID' => '389', 'BRIK OWNER' => 'Arpita Banerjee - 12arpitamukherjee@gmail.com', 'UNIT NUMBER' => '706', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	373 => array('S.NO.' => '374', 'ID' => '390', 'BRIK OWNER' => 'Ajay Kumar Pandey - ajaoy.itbhu23@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040011', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 303000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '123000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	374 => array('S.NO.' => '375', 'ID' => '391', 'BRIK OWNER' => 'Saurabh Kumar Patel Huf - dr.patelsaurabh@gmail.com', 'UNIT NUMBER' => 'A1', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'SnowPeak Suites Pvt Ltd - A1', 'SPV ACCOUNT' => 'SNOWPEAK SUITES PRIVATE LIMITED', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABLCS9101R', 'CIN NO.' => 'U68100UP2023PTC190891', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1599000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 1450000', 'TOTAL INSTALLMENT PAID' => '800000', 'TOTAL INSTALLMENT PENDING' => '650000', 'DISCOUNT ON BRIK' => '375818', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	375 => array('S.NO.' => '376', 'ID' => '392', 'BRIK OWNER' => 'Rohan Chauhan - ravitubms2479@yahoo.com', 'UNIT NUMBER' => 'T11- 202', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '900000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '120000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	376 => array('S.NO.' => '377', 'ID' => '393', 'BRIK OWNER' => 'Tonika Jain - roshandtn@yahoo.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Mountain Heritage Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AARCM3870G', 'CIN NO.' => 'U68100UP2023PTC190853', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1649000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 1583232', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '1283232', 'DISCOUNT ON BRIK' => '325818', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	377 => array('S.NO.' => '378', 'ID' => '394', 'BRIK OWNER' => 'Manish Jadiya - manish.jadiya27@gmail.com', 'UNIT NUMBER' => '706', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 530000', 'TOTAL INSTALLMENT PAID' => '530000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '13000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	378 => array('S.NO.' => '379', 'ID' => '395', 'BRIK OWNER' => 'NIKHIL ANIL DHAYARIKAR - nikhil.dhayarikar@gmail.com', 'UNIT NUMBER' => '706', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '43000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	379 => array('S.NO.' => '380', 'ID' => '401', 'BRIK OWNER' => 'Binin Kallumkal Sukumaran - bininishere@gmail.com', 'UNIT NUMBER' => '706', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '619000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 520000', 'TOTAL INSTALLMENT PAID' => '520000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '23000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	380 => array('S.NO.' => '381', 'ID' => '402', 'BRIK OWNER' => 'Vikram Singh Tomar - vikramsingh.tomar.vst@gmail.com', 'UNIT NUMBER' => 'W 10', 'PROJECT' => 'Vanya Awas', 'SPV' => 'ALPINE ESCAPE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAZCA0891K', 'CIN NO.' => 'U68200UP2023PTC186009', 'BRIK VALUE' => '953455', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '104455', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	381 => array('S.NO.' => '382', 'ID' => '403', 'BRIK OWNER' => 'Mohd. Shahid Siddiqui - sh_mannat@rediffmail.com', 'UNIT NUMBER' => '706', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 530000', 'TOTAL INSTALLMENT PAID' => '530000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '30000', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '0', 'REFERRAL DISCOUNT' => '0'),
	382 => array('S.NO.' => '383', 'ID' => '404', 'BRIK OWNER' => 'Ashutosh Batra - matrixcapitalllp@gmail.com', 'UNIT NUMBER' => '706', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '579000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 514333', 'TOTAL INSTALLMENT PAID' => '480000', 'TOTAL INSTALLMENT PENDING' => '34333', 'DISCOUNT ON BRIK' => '80000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	383 => array('S.NO.' => '384', 'ID' => '405', 'BRIK OWNER' => 'Renu Gupta - renugun78@gmail.com', 'UNIT NUMBER' => 'A1', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'SnowPeak Suites Pvt Ltd - A1', 'SPV ACCOUNT' => 'SNOWPEAK SUITES PRIVATE LIMITED', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABLCS9101R', 'CIN NO.' => 'U68100UP2023PTC190891', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1549000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 1470000', 'TOTAL INSTALLMENT PAID' => '1100000', 'TOTAL INSTALLMENT PENDING' => '370000', 'DISCOUNT ON BRIK' => '425818', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	384 => array('S.NO.' => '385', 'ID' => '406', 'BRIK OWNER' => 'Rajkumar R - drrajkumar0208@gmail.com', 'UNIT NUMBER' => '302', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '900000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '120000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	385 => array('S.NO.' => '386', 'ID' => '407', 'BRIK OWNER' => 'Nirmala Chitlange - mmchitlange@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '969999', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 820999', 'TOTAL INSTALLMENT PAID' => '820999', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '228547', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '180', 'REFERRAL DISCOUNT' => '0'),
	386 => array('S.NO.' => '387', 'ID' => '408', 'BRIK OWNER' => 'Padarthi Vinod Kumar - pvkvinod@gmail.com', 'UNIT NUMBER' => '706', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '60000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	387 => array('S.NO.' => '388', 'ID' => '410', 'BRIK OWNER' => 'Madhu Bala - nitish.gulati22@gmail.com', 'UNIT NUMBER' => 'T11- 202', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1069000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 920000', 'TOTAL INSTALLMENT PAID' => '920000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '100000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	388 => array('S.NO.' => '389', 'ID' => '411', 'BRIK OWNER' => 'Meharwade Sneha Sandeep - sandeep.meharwade123@gmail.com', 'UNIT NUMBER' => '706', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 530000', 'TOTAL INSTALLMENT PAID' => '530000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '30000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	389 => array('S.NO.' => '390', 'ID' => '412', 'BRIK OWNER' => 'Amit Choudhury - amitchoudhury2201@gmail.com', 'UNIT NUMBER' => 'W 10', 'PROJECT' => 'Vanya Awas', 'SPV' => 'ALPINE ESCAPE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAZCA0891K', 'CIN NO.' => 'U68200UP2023PTC186009', 'BRIK VALUE' => '953455', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '470000', 'TOTAL INSTALLMENT PENDING' => '280000', 'DISCOUNT ON BRIK' => '104455', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	390 => array('S.NO.' => '391', 'ID' => '413', 'BRIK OWNER' => 'Mohd. Shahid Siddiqui - sh_mannat@rediffmail.com', 'UNIT NUMBER' => 'B3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '969999', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 820999', 'TOTAL INSTALLMENT PAID' => '820999', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '228547', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '174', 'REFERRAL DISCOUNT' => '0'),
	391 => array('S.NO.' => '392', 'ID' => '414', 'BRIK OWNER' => 'Shwetha Mruthyunjaya - Mshwetha2020@gmail.com', 'UNIT NUMBER' => 'Row-8/B-308', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 748727', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '448727', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	392 => array('S.NO.' => '393', 'ID' => '415', 'BRIK OWNER' => 'Anurag Bholanath Dwivedi - anurag.dwivedi@outlook.com', 'UNIT NUMBER' => 'Row-8/B-308', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 730000', 'TOTAL INSTALLMENT PAID' => '610000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	393 => array('S.NO.' => '394', 'ID' => '416', 'BRIK OWNER' => 'Garv Arora - geeturahul@rediffmail.com', 'UNIT NUMBER' => 'Row-8/B-308', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 730000', 'TOTAL INSTALLMENT PAID' => '490000', 'TOTAL INSTALLMENT PENDING' => '240000', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	394 => array('S.NO.' => '395', 'ID' => '417', 'BRIK OWNER' => 'Motamarry Akhil Kumar - akhil184544@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040011', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '401090', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 302090', 'TOTAL INSTALLMENT PAID' => '210000', 'TOTAL INSTALLMENT PENDING' => '92090', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	395 => array('S.NO.' => '396', 'ID' => '419', 'BRIK OWNER' => 'Shashank Tiwari - Shashanktiwari111@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040011', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '401090', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 302090', 'TOTAL INSTALLMENT PAID' => '210000', 'TOTAL INSTALLMENT PENDING' => '92090', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	396 => array('S.NO.' => '397', 'ID' => '420', 'BRIK OWNER' => 'Geeta Manhas Arora - rahularora281113@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '1017530', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 868530', 'TOTAL INSTALLMENT PAID' => '868530', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '181016', 'COINS' => '117', 'REFERRAL DISC' => '0', 'COIN' => '117', 'REFERRAL DISCOUNT' => '0'),
	397 => array('S.NO.' => '398', 'ID' => '421', 'BRIK OWNER' => 'Saroj Singh - iitraja@gmail.com', 'UNIT NUMBER' => '505', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	398 => array('S.NO.' => '399', 'ID' => '422', 'BRIK OWNER' => 'Deepak Kumar R - digitalpachu@gmail.com', 'UNIT NUMBER' => '705', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '60000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => 'Re-sale', 'REFERRAL DISCOUNT' => '0'),
	399 => array('S.NO.' => '400', 'ID' => '423', 'BRIK OWNER' => 'Rajendra Agrawal - grajca1@gmail.com', 'UNIT NUMBER' => '705', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 530000', 'TOTAL INSTALLMENT PAID' => '530000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	400 => array('S.NO.' => '401', 'ID' => '424', 'BRIK OWNER' => 'Ponnien Selvi Ramesh - thedarklord160694@gmail.com', 'UNIT NUMBER' => 'T11- 202', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1099000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 950000', 'TOTAL INSTALLMENT PAID' => '950000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '210', 'REFERRAL DISC' => '0', 'COIN' => '0', 'REFERRAL DISCOUNT' => '0'),
	401 => array('S.NO.' => '402', 'ID' => '425', 'BRIK OWNER' => 'M/S Soonicorn Accelerator LLP - praveshgoel@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 2 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '850000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '199546', 'COINS' => '57', 'REFERRAL DISC' => '33870', 'COIN' => '57', 'REFERRAL DISCOUNT' => '33870'),
	402 => array('S.NO.' => '403', 'ID' => '426', 'BRIK OWNER' => 'Kandukuri Prasanna Kumari - gopalakandukuri@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-504', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 730000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '180000', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	403 => array('S.NO.' => '404', 'ID' => '427', 'BRIK OWNER' => 'Ruchi Verma - csruchiverma@gmail.com', 'UNIT NUMBER' => 'T10-104', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1099000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 950000', 'TOTAL INSTALLMENT PAID' => '950000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '70000', 'COINS' => '15', 'REFERRAL DISC' => '0', 'COIN' => '15', 'REFERRAL DISCOUNT' => '0'),
	404 => array('S.NO.' => '405', 'ID' => '428', 'BRIK OWNER' => 'Sonia Dangi - kuldeepdangi@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-504', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 680000', 'TOTAL INSTALLMENT PAID' => '430000', 'TOTAL INSTALLMENT PENDING' => '250000', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	405 => array('S.NO.' => '406', 'ID' => '429', 'BRIK OWNER' => 'Dharam Bandhu - dharam.sharma09@gmail.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Mountain Heritage Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AARCM3870G', 'CIN NO.' => 'U68100UP2023PTC190853', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1690000', 'BOOKING AMOUNT PAID' => '190000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1500000', 'TOTAL INSTALLMENT PAID' => '1400000', 'TOTAL INSTALLMENT PENDING' => '100000', 'DISCOUNT ON BRIK' => '284818', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	406 => array('S.NO.' => '407', 'ID' => '430', 'BRIK OWNER' => 'Muralidharan R - murali83073@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-504', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 716646', 'TOTAL INSTALLMENT PAID' => '340000', 'TOTAL INSTALLMENT PENDING' => '376646', 'DISCOUNT ON BRIK' => '36090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	407 => array('S.NO.' => '408', 'ID' => '431', 'BRIK OWNER' => 'Ponnien Selvi Ramesh - thedarklord160694@gmail.com', 'UNIT NUMBER' => 'Tower 8 Block B306', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 680000', 'TOTAL INSTALLMENT PAID' => '680000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '210', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	408 => array('S.NO.' => '409', 'ID' => '432', 'BRIK OWNER' => 'Bhalchandra Anant Vajaratkar - bhal.diamond@gmail.com', 'UNIT NUMBER' => 'T11- 202', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1099000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 950000', 'TOTAL INSTALLMENT PAID' => '950000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '70000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	409 => array('S.NO.' => '410', 'ID' => '433', 'BRIK OWNER' => 'Jiya Neeraj Bathija - jineevi2012@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-504', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '630000', 'TOTAL INSTALLMENT PENDING' => '70000', 'DISCOUNT ON BRIK' => '36090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	410 => array('S.NO.' => '411', 'ID' => '434', 'BRIK OWNER' => 'Priyanka . - pramodkhere@gmail.com', 'UNIT NUMBER' => '705', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 530000', 'TOTAL INSTALLMENT PAID' => '530000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '30000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	411 => array('S.NO.' => '412', 'ID' => '435', 'BRIK OWNER' => 'Beela Subash Chandra Bose - subash_bose1@rediffmail.com', 'UNIT NUMBER' => 'T1-012', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '636020', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 537020', 'TOTAL INSTALLMENT PAID' => '450000', 'TOTAL INSTALLMENT PENDING' => '87020', 'DISCOUNT ON BRIK' => '58617', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	412 => array('S.NO.' => '413', 'ID' => '436', 'BRIK OWNER' => 'Abhishek Dayal - dayalabhishek@rediffmail.com', 'UNIT NUMBER' => 'T1-012', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '420000', 'TOTAL INSTALLMENT PENDING' => '130000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '120', 'REFERRAL DISC' => '58440', 'COIN' => '', 'REFERRAL DISCOUNT' => '58440'),
	413 => array('S.NO.' => '414', 'ID' => '437', 'BRIK OWNER' => 'Niharika Sahoo - analytiqe@gmail.com', 'UNIT NUMBER' => 'T1-012', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 578091', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '428091', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	414 => array('S.NO.' => '415', 'ID' => '438', 'BRIK OWNER' => 'Deeksha Nagia - deekshanagia@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '230000', 'TOTAL INSTALLMENT PENDING' => '320000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	415 => array('S.NO.' => '416', 'ID' => '439', 'BRIK OWNER' => 'SANJAYA SENAPATY - ss.always2015@gmail.com', 'UNIT NUMBER' => 'T1-012', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '420000', 'TOTAL INSTALLMENT PENDING' => '130000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	416 => array('S.NO.' => '417', 'ID' => '440', 'BRIK OWNER' => 'Barsharani Nayak - nayak.barsha.nayak@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 581000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '581000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	417 => array('S.NO.' => '418', 'ID' => '441', 'BRIK OWNER' => 'Shalini Purushottam Modani - pmodani@gmail.com', 'UNIT NUMBER' => 'T1-013', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '350000', 'DISCOUNT ON BRIK' => '95637', 'COINS' => '105', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	418 => array('S.NO.' => '419', 'ID' => '442', 'BRIK OWNER' => 'Anju Bala - pankajraju1967@gmail.com', 'UNIT NUMBER' => 'T1-711', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '360000', 'TOTAL INSTALLMENT PENDING' => '140000', 'DISCOUNT ON BRIK' => '95637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	419 => array('S.NO.' => '420', 'ID' => '443', 'BRIK OWNER' => 'Padarthi Vinod Kumar - pvkvinod@gmail.com', 'UNIT NUMBER' => 'T1-711', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '599000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 500000', 'TOTAL INSTALLMENT PAID' => '260000', 'TOTAL INSTALLMENT PENDING' => '240000', 'DISCOUNT ON BRIK' => '95637', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	420 => array('S.NO.' => '421', 'ID' => '444', 'BRIK OWNER' => 'Raj Kumar Chaurasia - raj25iitm@gmail.com', 'UNIT NUMBER' => 'T1-012', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '390000', 'TOTAL INSTALLMENT PENDING' => '160000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	421 => array('S.NO.' => '422', 'ID' => '445', 'BRIK OWNER' => 'Harinder Bhasin - harinderbhasin@gmail.com', 'UNIT NUMBER' => 'T1-013', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 511130', 'TOTAL INSTALLMENT PAID' => '371130', 'TOTAL INSTALLMENT PENDING' => '140000', 'DISCOUNT ON BRIK' => '65637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	422 => array('S.NO.' => '423', 'ID' => '446', 'BRIK OWNER' => 'Prasad Y Bansod - rabbu7288@gmail.com', 'UNIT NUMBER' => 'T1-012', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 558323', 'TOTAL INSTALLMENT PAID' => '230000', 'TOTAL INSTALLMENT PENDING' => '328323', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	423 => array('S.NO.' => '424', 'ID' => '447', 'BRIK OWNER' => 'Usha Singh - ushasingh1587@outlook.com', 'UNIT NUMBER' => 'T1-013', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '250000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '82470', 'COIN' => '', 'REFERRAL DISCOUNT' => '82470'),
	424 => array('S.NO.' => '425', 'ID' => '448', 'BRIK OWNER' => 'Harsimran Bhasin - hary1995@gmail.com', 'UNIT NUMBER' => 'T1-013', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 530000', 'TOTAL INSTALLMENT PAID' => '390000', 'TOTAL INSTALLMENT PENDING' => '140000', 'DISCOUNT ON BRIK' => '65637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	425 => array('S.NO.' => '426', 'ID' => '449', 'BRIK OWNER' => 'Rajashree Patra - niharkantapatra640@gmail.com', 'UNIT NUMBER' => 'T1-012', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '390000', 'TOTAL INSTALLMENT PENDING' => '160000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	426 => array('S.NO.' => '427', 'ID' => '450', 'BRIK OWNER' => 'Dr. Abhay Kumar Singh - abhay7075707@gmail.com', 'UNIT NUMBER' => 'T1-611', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '390000', 'TOTAL INSTALLMENT PENDING' => '160000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '540', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	427 => array('S.NO.' => '428', 'ID' => '451', 'BRIK OWNER' => 'Krishna Malini Patra - tusar_cost@rediffmail.com', 'UNIT NUMBER' => 'T1-013', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 554162', 'TOTAL INSTALLMENT PAID' => '350000', 'TOTAL INSTALLMENT PENDING' => '204162', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	428 => array('S.NO.' => '429', 'ID' => '452', 'BRIK OWNER' => 'Sunita Singh - sunilmohanty007@gmail.com', 'UNIT NUMBER' => 'T1-013', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '390000', 'TOTAL INSTALLMENT PENDING' => '160000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	429 => array('S.NO.' => '430', 'ID' => '453', 'BRIK OWNER' => 'Braja Gopal Sahoo - braja_g@rediffmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 582252', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '582252', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	430 => array('S.NO.' => '431', 'ID' => '454', 'BRIK OWNER' => 'Godavari . - godavari.dwivedi@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 569000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '569000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '420', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	431 => array('S.NO.' => '432', 'ID' => '455', 'BRIK OWNER' => 'Harshit Choudhary - harshitchoudhary@gmail.com', 'UNIT NUMBER' => 'T1-711', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '390000', 'TOTAL INSTALLMENT PENDING' => '160000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	432 => array('S.NO.' => '433', 'ID' => '456', 'BRIK OWNER' => 'Sonal Agrawal - sonal.com@hotmail.com', 'UNIT NUMBER' => 'T1-711', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 530000', 'TOTAL INSTALLMENT PAID' => '390000', 'TOTAL INSTALLMENT PENDING' => '180000', 'DISCOUNT ON BRIK' => '65637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	433 => array('S.NO.' => '434', 'ID' => '457', 'BRIK OWNER' => 'Priyanka Panigrahi - sdh396@gmail.com', 'UNIT NUMBER' => 'T1-013', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 562485', 'TOTAL INSTALLMENT PAID' => '310000', 'TOTAL INSTALLMENT PENDING' => '252485', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	434 => array('S.NO.' => '435', 'ID' => '458', 'BRIK OWNER' => 'Amit Chandra Gupta - amit.ch.gupta@gmail.com', 'UNIT NUMBER' => '705', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '636000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 537000', 'TOTAL INSTALLMENT PAID' => '537000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '63454', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	435 => array('S.NO.' => '436', 'ID' => '459', 'BRIK OWNER' => 'Krithika Balaji - krithisankar@gmail.com', 'UNIT NUMBER' => 'Tower 8 Block B306', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '640000', 'TOTAL INSTALLMENT PENDING' => '60000', 'DISCOUNT ON BRIK' => '115909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	436 => array('S.NO.' => '437', 'ID' => '460', 'BRIK OWNER' => 'Nikhita Kabadi - nikhitakabadi77@gmail.com', 'UNIT NUMBER' => 'T1-711', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 530000', 'TOTAL INSTALLMENT PAID' => '390000', 'TOTAL INSTALLMENT PENDING' => '140000', 'DISCOUNT ON BRIK' => '65637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	437 => array('S.NO.' => '438', 'ID' => '461', 'BRIK OWNER' => 'Bhawna . - anil.srms@gmail.com', 'UNIT NUMBER' => '705', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '50454', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	438 => array('S.NO.' => '439', 'ID' => '462', 'BRIK OWNER' => 'Naresh Dhoundiyal - naresh.amritachander@gmail.com', 'UNIT NUMBER' => 'T11- 202', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1099000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 950000', 'TOTAL INSTALLMENT PAID' => '950000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '177272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	439 => array('S.NO.' => '440', 'ID' => '463', 'BRIK OWNER' => 'Ashutosh Batra - matrixcapitalllp@gmail.com', 'UNIT NUMBER' => 'T1-711', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 545606', 'TOTAL INSTALLMENT PAID' => '210000', 'TOTAL INSTALLMENT PENDING' => '335606', 'DISCOUNT ON BRIK' => '65637', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	440 => array('S.NO.' => '441', 'ID' => '464', 'BRIK OWNER' => 'Mamta sharma - mamtasharma1010@gmail.com', 'UNIT NUMBER' => 'T1-013', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '255000', 'TOTAL INSTALLMENT PENDING' => '295000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	441 => array('S.NO.' => '442', 'ID' => '465', 'BRIK OWNER' => 'ECLAT DESIGNS & INFRASTRUCTURE PRIVATE LIMITED - kiruba.yoga@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040008', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '401090', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 305211', 'TOTAL INSTALLMENT PAID' => '120000', 'TOTAL INSTALLMENT PENDING' => '185211', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	442 => array('S.NO.' => '443', 'ID' => '466', 'BRIK OWNER' => 'Laurence Soares - soareslaurence@yahoo.com', 'UNIT NUMBER' => '705', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '50454', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	443 => array('S.NO.' => '444', 'ID' => '467', 'BRIK OWNER' => 'Swatilekha Das - tituctc@gmail.com', 'UNIT NUMBER' => 'T1-711', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '390000', 'TOTAL INSTALLMENT PENDING' => '160000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	444 => array('S.NO.' => '445', 'ID' => '468', 'BRIK OWNER' => 'Majji Apoorva - srikanth.sarika@gmail.com', 'UNIT NUMBER' => 'Row-8/B-304', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 810404', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '610404', 'DISCOUNT ON BRIK' => '57000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	445 => array('S.NO.' => '446', 'ID' => '469', 'BRIK OWNER' => 'Sagar Sailesh Sodha - sagar.sodha94@gmail.com', 'UNIT NUMBER' => 'T1-012', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '310000', 'TOTAL INSTALLMENT PENDING' => '240000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	446 => array('S.NO.' => '447', 'ID' => '470', 'BRIK OWNER' => 'Alok Satapathy - s_alok2@rediffmail.com', 'UNIT NUMBER' => 'T1-711', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '390000', 'TOTAL INSTALLMENT PENDING' => '160000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	447 => array('S.NO.' => '448', 'ID' => '471', 'BRIK OWNER' => 'Dr. Khushboo Harsh Garg - khushboo.garg104@gmail.com', 'UNIT NUMBER' => 'T1-710', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 530000', 'TOTAL INSTALLMENT PAID' => '390000', 'TOTAL INSTALLMENT PENDING' => '140000', 'DISCOUNT ON BRIK' => '65637', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	448 => array('S.NO.' => '449', 'ID' => '472', 'BRIK OWNER' => 'SAMPATHVRIDDI LLP - sampathvriddillp@gmail.com', 'UNIT NUMBER' => 'T1-711', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 530000', 'TOTAL INSTALLMENT PAID' => '350000', 'TOTAL INSTALLMENT PENDING' => '180000', 'DISCOUNT ON BRIK' => '65637', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	449 => array('S.NO.' => '450', 'ID' => '473', 'BRIK OWNER' => 'Sachin Kumar Shukla - sachinshukla3800@gmail.com', 'UNIT NUMBER' => 'T1-711', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 558091', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '408091', 'DISCOUNT ON BRIK' => '65637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	450 => array('S.NO.' => '451', 'ID' => '474', 'BRIK OWNER' => 'Saket Prakash - saket_prakash@yahoo.com', 'UNIT NUMBER' => 'Tower 8 Block B306', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 683989', 'TOTAL INSTALLMENT PAID' => '583989', 'TOTAL INSTALLMENT PENDING' => '100000', 'DISCOUNT ON BRIK' => '36090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	451 => array('S.NO.' => '452', 'ID' => '475', 'BRIK OWNER' => 'Ruchi Verma - csruchiverma@gmail.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Mountain Heritage Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AARCM3870G', 'CIN NO.' => 'U68100UP2023PTC190853', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1790000', 'BOOKING AMOUNT PAID' => '190000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 1560000', 'TOTAL INSTALLMENT PAID' => '1560000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '184818', 'COINS' => '15', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	452 => array('S.NO.' => '453', 'ID' => '476', 'BRIK OWNER' => 'Debendra Kumar Sahu - dr_dksahu2006@yahoo.co.in', 'UNIT NUMBER' => 'T1-710', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '380000', 'TOTAL INSTALLMENT PENDING' => '170000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	453 => array('S.NO.' => '454', 'ID' => '477', 'BRIK OWNER' => 'Babita . - tapishbaliyan@gmail.com', 'UNIT NUMBER' => '706', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 2 Installments) Amount: 530000', 'TOTAL INSTALLMENT PAID' => '530000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '70454', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	454 => array('S.NO.' => '455', 'ID' => '478', 'BRIK OWNER' => 'Naresh Dhoundiyal - naresh.amritachander@gmail.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Mountain Heritage Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AARCM3870G', 'CIN NO.' => 'U68100UP2023PTC190853', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1749000', 'BOOKING AMOUNT PAID' => '190000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 1589600', 'TOTAL INSTALLMENT PAID' => '1400000', 'TOTAL INSTALLMENT PENDING' => '189600', 'DISCOUNT ON BRIK' => '225818', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	455 => array('S.NO.' => '456', 'ID' => '479', 'BRIK OWNER' => 'Kabita Das - swadhinpradhanpaypal@gmail.com', 'UNIT NUMBER' => '705', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '50454', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	456 => array('S.NO.' => '457', 'ID' => '480', 'BRIK OWNER' => 'Veeravalli Dhruva Kiran - dhruvakiran23@gmail.com', 'UNIT NUMBER' => '705', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '50454', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	457 => array('S.NO.' => '458', 'ID' => '481', 'BRIK OWNER' => 'Anita Mahapatra - anitamahapatra810@gmail.com', 'UNIT NUMBER' => 'T1-1210', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '380000', 'TOTAL INSTALLMENT PENDING' => '170000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	458 => array('S.NO.' => '459', 'ID' => '482', 'BRIK OWNER' => 'Kush Kalra - kalrakush786@gmail.com', 'UNIT NUMBER' => 'T1-710', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 534000', 'TOTAL INSTALLMENT PAID' => '370000', 'TOTAL INSTALLMENT PENDING' => '164000', 'DISCOUNT ON BRIK' => '65637', 'COINS' => '450', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	459 => array('S.NO.' => '460', 'ID' => '483', 'BRIK OWNER' => 'Dharmi Chand Jain - jaindc1@yahoo.com', 'UNIT NUMBER' => 'Tower 8 Block B306', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 720000', 'TOTAL INSTALLMENT PAID' => '560000', 'TOTAL INSTALLMENT PENDING' => '160000', 'DISCOUNT ON BRIK' => '115909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	460 => array('S.NO.' => '461', 'ID' => '484', 'BRIK OWNER' => 'Amit Kumar Tiwari - meet2amit2002@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 14 Installments) Amount: 794829.63', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '794829.63', 'DISCOUNT ON BRIK' => '56090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	461 => array('S.NO.' => '462', 'ID' => '485', 'BRIK OWNER' => 'Kailash Gunwantrao Bhumbar HUF - kailashbhumbarhuf@gmail.com', 'UNIT NUMBER' => 'T1-1210', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 558000', 'TOTAL INSTALLMENT PAID' => '350000', 'TOTAL INSTALLMENT PENDING' => '208000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	462 => array('S.NO.' => '463', 'ID' => '486', 'BRIK OWNER' => 'Jatin Sirohi - jatindbt17@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040011', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '401090', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 302090', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '152090', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	463 => array('S.NO.' => '464', 'ID' => '487', 'BRIK OWNER' => 'Deepali Parikh - Parikh.deepali@gmail.com', 'UNIT NUMBER' => 'T1-1210', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 530000', 'TOTAL INSTALLMENT PAID' => '390000', 'TOTAL INSTALLMENT PENDING' => '140000', 'DISCOUNT ON BRIK' => '65637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	464 => array('S.NO.' => '465', 'ID' => '488', 'BRIK OWNER' => 'Suraj Shukla - surajshukla335@gmail.com', 'UNIT NUMBER' => '705', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '50454', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	465 => array('S.NO.' => '466', 'ID' => '489', 'BRIK OWNER' => 'Asmita P Naik - asmita.naik@gmail.com', 'UNIT NUMBER' => 'Unit number - 7', 'PROJECT' => 'Golden Sands', 'SPV' => 'ARO 2 BHK SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA7827N', 'CIN NO.' => 'U74999UP2022PTC161905', 'BRIK VALUE' => '2626182', 'INVESTMENT AMOUNT' => '2290000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 2000000', 'TOTAL INSTALLMENT PAID' => '2000000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '336182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	466 => array('S.NO.' => '467', 'ID' => '490', 'BRIK OWNER' => 'Ramalakshmi Ravichandran - psravichandran67@yahoo.com', 'UNIT NUMBER' => 'T11- 202', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1169000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 1020000', 'TOTAL INSTALLMENT PAID' => '1020000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '107272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	467 => array('S.NO.' => '468', 'ID' => '491', 'BRIK OWNER' => 'Jatin Sirohi - jatindbt17@gmail.com', 'UNIT NUMBER' => 'T1-1210', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '350000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	468 => array('S.NO.' => '469', 'ID' => '492', 'BRIK OWNER' => 'Gopal Agrawal - Gopal@souryamedical.com', 'UNIT NUMBER' => 'Resale Brik\'s 00', 'PROJECT' => 'Resale Brik\'s', 'SPV' => '00', 'SPV ACCOUNT' => '00', 'IFSC' => '00', 'PAN CARD NO.' => '00', 'CIN NO.' => '00', 'BRIK VALUE' => '0', 'INVESTMENT AMOUNT' => '1', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '50454', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	469 => array('S.NO.' => '470', 'ID' => '493', 'BRIK OWNER' => 'Ankit khemka - khemkankit@gmail.com', 'UNIT NUMBER' => 'T1-1210', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '350000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	470 => array('S.NO.' => '471', 'ID' => '494', 'BRIK OWNER' => 'Sraddha Suman Patro - amaresh.sahu2013@gmail.com', 'UNIT NUMBER' => 'T1-1210', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 578091', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '578091', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	471 => array('S.NO.' => '472', 'ID' => '495', 'BRIK OWNER' => 'Pooja Pushp - Amit.pushp@gmail.com', 'UNIT NUMBER' => 'Tower 8 Block B306', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '849000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 730172', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '730172', 'DISCOUNT ON BRIK' => '115909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	472 => array('S.NO.' => '473', 'ID' => '496', 'BRIK OWNER' => 'Nandini Parida - Casatyaparida@gmail.com', 'UNIT NUMBER' => 'T1-1210', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '650000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 537342', 'TOTAL INSTALLMENT PAID' => '310000', 'TOTAL INSTALLMENT PENDING' => '227342', 'DISCOUNT ON BRIK' => '25637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	473 => array('S.NO.' => '474', 'ID' => '497', 'BRIK OWNER' => 'Pranav Narendra Shethji - dshethji1974@gmail.com', 'UNIT NUMBER' => 'Tower 8 Block B306', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '925000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 776000', 'TOTAL INSTALLMENT PAID' => '630000', 'TOTAL INSTALLMENT PENDING' => '146000', 'DISCOUNT ON BRIK' => '39909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	474 => array('S.NO.' => '475', 'ID' => '498', 'BRIK OWNER' => 'Kanad Banik - kanadbanik7@gmail.com', 'UNIT NUMBER' => 'T5/704', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '50454', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	475 => array('S.NO.' => '476', 'ID' => '499', 'BRIK OWNER' => 'Hoysala M G - hoysala.mg@gmail.com', 'UNIT NUMBER' => 'T5/704', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '50454', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	476 => array('S.NO.' => '477', 'ID' => '500', 'BRIK OWNER' => 'Sunita Kumari - sukhdev11@gmail.com', 'UNIT NUMBER' => 'T5/704', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '50454', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	477 => array('S.NO.' => '478', 'ID' => '501', 'BRIK OWNER' => 'Tarun Roy - tarun.roy@thefootballlink.com', 'UNIT NUMBER' => 'T1-1210', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '350000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	478 => array('S.NO.' => '479', 'ID' => '502', 'BRIK OWNER' => 'Pira Mohan Das - daspiru2011@gmail.com', 'UNIT NUMBER' => 'T1-1210', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '350000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	479 => array('S.NO.' => '480', 'ID' => '503', 'BRIK OWNER' => 'Polavarapu Ammani - raghu.polavarapu@gmail.com', 'UNIT NUMBER' => 'T 11 - 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1099000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 950000', 'TOTAL INSTALLMENT PAID' => '950000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '177272', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '0', 'REFERRAL DISCOUNT' => '0'),
	480 => array('S.NO.' => '481', 'ID' => '504', 'BRIK OWNER' => 'Polavarapu Ammani - raghu.polavarapu@gmail.com', 'UNIT NUMBER' => 'B1', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '1099000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 950000', 'TOTAL INSTALLMENT PAID' => '950000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '99546', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '210', 'REFERRAL DISCOUNT' => '0'),
	481 => array('S.NO.' => '482', 'ID' => '505', 'BRIK OWNER' => 'Lal Mohan Mohapatra - lalmohan.lalu@gmail.com', 'UNIT NUMBER' => 'T5/704', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 570808', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '20808', 'DISCOUNT ON BRIK' => '50454', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	482 => array('S.NO.' => '483', 'ID' => '506', 'BRIK OWNER' => 'Lal Mohan Mohapatra - lalmohan.lalu@gmail.com', 'UNIT NUMBER' => 'T1-710', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 530000', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '130000', 'DISCOUNT ON BRIK' => '65637', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	483 => array('S.NO.' => '484', 'ID' => '507', 'BRIK OWNER' => 'Subhankar Mahapatra HUF - subhankarmahapatra100@gmail.com', 'UNIT NUMBER' => 'T1-1210', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 530000', 'TOTAL INSTALLMENT PAID' => '290000', 'TOTAL INSTALLMENT PENDING' => '240000', 'DISCOUNT ON BRIK' => '65637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	484 => array('S.NO.' => '485', 'ID' => '508', 'BRIK OWNER' => 'Avinash Bhagat - aviinashsbhagat@gmail.com', 'UNIT NUMBER' => 'B1', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 1 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '850000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '199546', 'COINS' => '99', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	485 => array('S.NO.' => '486', 'ID' => '509', 'BRIK OWNER' => 'Prannay Chhibber - prannaychhibber@gmail.com', 'UNIT NUMBER' => 'T1-710', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '619000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 520000', 'TOTAL INSTALLMENT PAID' => '100000', 'TOTAL INSTALLMENT PENDING' => '420000', 'DISCOUNT ON BRIK' => '75637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	486 => array('S.NO.' => '487', 'ID' => '510', 'BRIK OWNER' => 'Sibasish Sahoo - sibasish0609@gmail.com', 'UNIT NUMBER' => 'T1-710', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '350000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	487 => array('S.NO.' => '488', 'ID' => '511', 'BRIK OWNER' => 'Arvind Srivastava - arvindsri69@gmail.com', 'UNIT NUMBER' => 'B1', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '1099000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 950000', 'TOTAL INSTALLMENT PAID' => '950000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '99546', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	488 => array('S.NO.' => '489', 'ID' => '512', 'BRIK OWNER' => 'Nisha Bhagat - nishabhagat1975@gmail.com', 'UNIT NUMBER' => 'T11- 202', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1029000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 1 Installments) Amount: 880000', 'TOTAL INSTALLMENT PAID' => '880000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '247272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	489 => array('S.NO.' => '490', 'ID' => '513', 'BRIK OWNER' => 'Nitya Dipankar - nitya.dipankar@gmail.com', 'UNIT NUMBER' => 'T1-710', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 511060', 'TOTAL INSTALLMENT PAID' => '231060', 'TOTAL INSTALLMENT PENDING' => '280000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	490 => array('S.NO.' => '491', 'ID' => '514', 'BRIK OWNER' => 'Greta Ivan Lopes - gretalopes14@gmail.com', 'UNIT NUMBER' => 'T5/704', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '50000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	491 => array('S.NO.' => '492', 'ID' => '515', 'BRIK OWNER' => 'Partha Sarathi Panda - p.partha04@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 573000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '573000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	492 => array('S.NO.' => '493', 'ID' => '516', 'BRIK OWNER' => 'Suresh Kumar - sureshkumarsingh2907@gmail.com', 'UNIT NUMBER' => 'Tower 8 Block B306', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '879000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 730000', 'TOTAL INSTALLMENT PAID' => '610000', 'TOTAL INSTALLMENT PENDING' => '120000', 'DISCOUNT ON BRIK' => '85909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	493 => array('S.NO.' => '494', 'ID' => '517', 'BRIK OWNER' => 'Rishav Kumar Sahu - sahu.rishav@gmail.com', 'UNIT NUMBER' => '302', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 950000', 'TOTAL INSTALLMENT PAID' => '950000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '120000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	494 => array('S.NO.' => '495', 'ID' => '518', 'BRIK OWNER' => 'Prateekshya Misra - babutunu.misra@gmail.com', 'UNIT NUMBER' => 'T1-1210', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 573929', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '423929', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	495 => array('S.NO.' => '496', 'ID' => '519', 'BRIK OWNER' => 'Swagatika Sahoo - trideepsahu@gmail.com', 'UNIT NUMBER' => 'T1-710', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 560000', 'TOTAL INSTALLMENT PAID' => '310000', 'TOTAL INSTALLMENT PENDING' => '250000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	496 => array('S.NO.' => '497', 'ID' => '520', 'BRIK OWNER' => 'SASTIK INFRATECH PRIVATE LIMITED - sastikinfratech@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040011', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '401090', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 302090', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '152090', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	497 => array('S.NO.' => '498', 'ID' => '521', 'BRIK OWNER' => 'Monodip Dhar - monodipdhar@gmail.com', 'UNIT NUMBER' => 'W 10', 'PROJECT' => 'Vanya Awas', 'SPV' => 'ALPINE ESCAPE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAZCA0891K', 'CIN NO.' => 'U68200UP2023PTC186009', 'BRIK VALUE' => '953455', 'INVESTMENT AMOUNT' => '899000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 708060', 'TOTAL INSTALLMENT PAID' => '258060', 'TOTAL INSTALLMENT PENDING' => '450000', 'DISCOUNT ON BRIK' => '54455', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	498 => array('S.NO.' => '499', 'ID' => '522', 'BRIK OWNER' => 'Biswajit Rana - biswa.rana86@gmail.com', 'UNIT NUMBER' => 'T1-1211', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 530000', 'TOTAL INSTALLMENT PAID' => '270000', 'TOTAL INSTALLMENT PENDING' => '260000', 'DISCOUNT ON BRIK' => '65637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	499 => array('S.NO.' => '500', 'ID' => '523', 'BRIK OWNER' => 'Venkatesh Dani - venkatesh.dani@yahoo.in', 'UNIT NUMBER' => 'Tower-8-0304 3rd Floor', 'PROJECT' => 'Rio De Goa', 'SPV' => 'BRIKITT RIO PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AABCZ6471G', 'CIN NO.' => 'U93090UP2020PTC138840', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '900000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '120000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	500 => array('S.NO.' => '501', 'ID' => '524', 'BRIK OWNER' => 'Mathan Kumar N - mathanmail@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-506', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '899000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '580000', 'TOTAL INSTALLMENT PENDING' => '170000', 'DISCOUNT ON BRIK' => '64909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	501 => array('S.NO.' => '502', 'ID' => '525', 'BRIK OWNER' => 'Jitendra Dilip Meghrajani - jitendra.meghrajani@gmail.com', 'UNIT NUMBER' => 'T7-206', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SE2BR SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6092B', 'CIN NO.' => 'U70109UP2022PTC157704', 'BRIK VALUE' => '1019909', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '710000', 'TOTAL INSTALLMENT PENDING' => '90000', 'DISCOUNT ON BRIK' => '70909', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	502 => array('S.NO.' => '503', 'ID' => '526', 'BRIK OWNER' => 'Anil Anupam Mohanty - anil.a.mohanty@gmail.com', 'UNIT NUMBER' => 'T1-710', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '310000', 'TOTAL INSTALLMENT PENDING' => '240000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	503 => array('S.NO.' => '504', 'ID' => '527', 'BRIK OWNER' => 'SANGHAMITRA MALLA - meeta1983.malla@gmail.com', 'UNIT NUMBER' => 'T1-710', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 530000', 'TOTAL INSTALLMENT PAID' => '270000', 'TOTAL INSTALLMENT PENDING' => '260000', 'DISCOUNT ON BRIK' => '65637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	504 => array('S.NO.' => '505', 'ID' => '528', 'BRIK OWNER' => 'Anjali Kumari - amitanjali1211@gmail.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Mountain Heritage Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AARCM3870G', 'CIN NO.' => 'U68100UP2023PTC190853', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1890000', 'BOOKING AMOUNT PAID' => '190000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 1731212', 'TOTAL INSTALLMENT PAID' => '1500000', 'TOTAL INSTALLMENT PENDING' => '231212', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	505 => array('S.NO.' => '506', 'ID' => '529', 'BRIK OWNER' => 'Ajit Sahu - abhijitsahu068@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 573000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '573000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	506 => array('S.NO.' => '507', 'ID' => '530', 'BRIK OWNER' => 'Tanvii Sahu - tanvitanaya08@gmail.com', 'UNIT NUMBER' => 'T1-1211', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '350000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	507 => array('S.NO.' => '508', 'ID' => '531', 'BRIK OWNER' => 'Jasmine Nayak - nayakjasmine09@gmail.com', 'UNIT NUMBER' => 'T1-1211', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 530000', 'TOTAL INSTALLMENT PAID' => '350000', 'TOTAL INSTALLMENT PENDING' => '180000', 'DISCOUNT ON BRIK' => '65637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	508 => array('S.NO.' => '509', 'ID' => '532', 'BRIK OWNER' => 'Chinmai Panda - sabyatmishra@gmail.com', 'UNIT NUMBER' => 'T1-1211', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '360000', 'TOTAL INSTALLMENT PENDING' => '190000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	509 => array('S.NO.' => '510', 'ID' => '533', 'BRIK OWNER' => 'Sibasis Panda - Sibasis.dba@gmail.com', 'UNIT NUMBER' => 'T1-1211', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 530000', 'TOTAL INSTALLMENT PAID' => '350000', 'TOTAL INSTALLMENT PENDING' => '180000', 'DISCOUNT ON BRIK' => '65637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	510 => array('S.NO.' => '511', 'ID' => '534', 'BRIK OWNER' => 'Monika Kumari - meamitsbi@gmail.com', 'UNIT NUMBER' => '706', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '50454', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	511 => array('S.NO.' => '512', 'ID' => '535', 'BRIK OWNER' => 'RADHARANI MISHRA - stanmay19@yahoo.com', 'UNIT NUMBER' => 'T1-1211', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '639000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 504692', 'TOTAL INSTALLMENT PAID' => '300530', 'TOTAL INSTALLMENT PENDING' => '204162', 'DISCOUNT ON BRIK' => '55637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	512 => array('S.NO.' => '513', 'ID' => '536', 'BRIK OWNER' => 'Siddhartha Prasad mishra - siddharth.luna@gmail.com', 'UNIT NUMBER' => 'T1-1211', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 14 Installments) Amount: 568727', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '368727', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	513 => array('S.NO.' => '514', 'ID' => '537', 'BRIK OWNER' => 'Amrita Ghosh Dastidar - duttaamrita05@gmail.com', 'UNIT NUMBER' => 'T1-1211', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '150000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	514 => array('S.NO.' => '515', 'ID' => '538', 'BRIK OWNER' => 'ECLAT DESIGNS & INFRASTRUCTURE PRIVATE LIMITED - kiruba.yoga@gmail.com', 'UNIT NUMBER' => 'T1-1211', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '1', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 558323', 'TOTAL INSTALLMENT PAID' => '310000', 'TOTAL INSTALLMENT PENDING' => '248323', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	515 => array('S.NO.' => '516', 'ID' => '539', 'BRIK OWNER' => 'Arvind Agrawal - arvindagra2000@gmail.com', 'UNIT NUMBER' => 'T5/704', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '50454', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	516 => array('S.NO.' => '517', 'ID' => '540', 'BRIK OWNER' => 'Umasankar Samantaray - umasankar23071410@gmail.com', 'UNIT NUMBER' => 'T1-1211', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '350000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	517 => array('S.NO.' => '518', 'ID' => '541', 'BRIK OWNER' => 'Banishree Patra - sparida04@yahoo.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040011', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '383270', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 284270', 'TOTAL INSTALLMENT PAID' => '120000', 'TOTAL INSTALLMENT PENDING' => '164270', 'DISCOUNT ON BRIK' => '17820', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	518 => array('S.NO.' => '519', 'ID' => '542', 'BRIK OWNER' => 'Nandini Parida - Casatyaparida@gmail.com', 'UNIT NUMBER' => 'Galaxy 2701 - 101', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 563392', 'TOTAL INSTALLMENT PAID' => '410000', 'TOTAL INSTALLMENT PENDING' => '153392', 'DISCOUNT ON BRIK' => '204227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	519 => array('S.NO.' => '520', 'ID' => '543', 'BRIK OWNER' => 'Nihar Kanta Patra - rajashreepatra4769@gmail.com', 'UNIT NUMBER' => 'Galaxy 2701 - 101', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 553641', 'TOTAL INSTALLMENT PAID' => '375000', 'TOTAL INSTALLMENT PENDING' => '178641', 'DISCOUNT ON BRIK' => '204227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	520 => array('S.NO.' => '521', 'ID' => '544', 'BRIK OWNER' => 'Rangaraju Aravind - Aravindrangaraju2581@gmail.com', 'UNIT NUMBER' => 'T5-806', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 586414', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '586414', 'DISCOUNT ON BRIK' => '89727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => 'RESALE', 'REFERRAL DISCOUNT' => '0'),
	521 => array('S.NO.' => '522', 'ID' => '545', 'BRIK OWNER' => 'Sandeep Mehta - sandeepmehta67@gmail.com', 'UNIT NUMBER' => 'Galaxy 2701 - 101', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '470000', 'TOTAL INSTALLMENT PENDING' => '180000', 'DISCOUNT ON BRIK' => '104227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	522 => array('S.NO.' => '523', 'ID' => '546', 'BRIK OWNER' => 'Sonal Agrawal - sonal.com@hotmail.com', 'UNIT NUMBER' => 'Galaxy 2701 - 101', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 569612', 'TOTAL INSTALLMENT PAID' => '485000', 'TOTAL INSTALLMENT PENDING' => '84612', 'DISCOUNT ON BRIK' => '204227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	523 => array('S.NO.' => '524', 'ID' => '547', 'BRIK OWNER' => 'Air Cmde Mohit Kumar Nayyar VM,VSM - mohitkumarnayyar@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Holiday Horizons Pvt Ltd', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4366E', 'CIN NO.' => 'U68100UP2024PTC205856', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1990000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 1700000', 'TOTAL INSTALLMENT PAID' => '1000000', 'TOTAL INSTALLMENT PENDING' => '700000', 'DISCOUNT ON BRIK' => '398454', 'COINS' => '330', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	524 => array('S.NO.' => '525', 'ID' => '548', 'BRIK OWNER' => 'Ramalakshmi Ravichandran - psravichandran67@yahoo.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Mountain Heritage Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AARCM3870G', 'CIN NO.' => 'U68100UP2023PTC190853', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1883788', 'BOOKING AMOUNT PAID' => '190000', 'INSTALLMENTS' => '(Total 16 Installments) Amount: 1714596', 'TOTAL INSTALLMENT PAID' => '1400000', 'TOTAL INSTALLMENT PENDING' => '314596', 'DISCOUNT ON BRIK' => '604666', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	525 => array('S.NO.' => '526', 'ID' => '549', 'BRIK OWNER' => 'Sumalatha R Bhoopalam - Raghubhoopalam1983@gmail.com', 'UNIT NUMBER' => 'Row-8/Block 5/ B-201', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '899000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 759364', 'TOTAL INSTALLMENT PAID' => '340000', 'TOTAL INSTALLMENT PENDING' => '419364', 'DISCOUNT ON BRIK' => '107000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	526 => array('S.NO.' => '527', 'ID' => '550', 'BRIK OWNER' => 'Itishree Mishra - me.itishree.mishra@gmail.com', 'UNIT NUMBER' => 'T1-1205', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 452650', 'TOTAL INSTALLMENT PAID' => '142650', 'TOTAL INSTALLMENT PENDING' => '310000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	527 => array('S.NO.' => '528', 'ID' => '551', 'BRIK OWNER' => 'Manav Lalotra - manav.lalotra821@gmail.com', 'UNIT NUMBER' => 'T11- 202', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1130000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 981000', 'TOTAL INSTALLMENT PAID' => '981000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '146272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '78', 'REFERRAL DISCOUNT' => '0'),
	528 => array('S.NO.' => '529', 'ID' => '552', 'BRIK OWNER' => 'Debasish Panda HUF - debasishpandamax@gmail.com', 'UNIT NUMBER' => 'T1-1205', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 458890', 'TOTAL INSTALLMENT PAID' => '218890', 'TOTAL INSTALLMENT PENDING' => '240000', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	529 => array('S.NO.' => '530', 'ID' => '553', 'BRIK OWNER' => 'Anjali Sahu - bhagabatsahu@gmail.com', 'UNIT NUMBER' => 'T1-1205', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 558160', 'TOTAL INSTALLMENT PAID' => '350000', 'TOTAL INSTALLMENT PENDING' => '208160', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	530 => array('S.NO.' => '531', 'ID' => '554', 'BRIK OWNER' => 'Anurag Bholanath Dwivedi - anurag.dwivedi@outlook.com', 'UNIT NUMBER' => 'Galaxy 2701 - 101', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '435000', 'TOTAL INSTALLMENT PENDING' => '115000', 'DISCOUNT ON BRIK' => '204227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	531 => array('S.NO.' => '532', 'ID' => '555', 'BRIK OWNER' => 'Gokulananda Sahu - gokulsahu94@gmail.com', 'UNIT NUMBER' => 'Galaxy 2701 - 101', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '420000', 'TOTAL INSTALLMENT PENDING' => '180000', 'DISCOUNT ON BRIK' => '154227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	532 => array('S.NO.' => '533', 'ID' => '556', 'BRIK OWNER' => 'Tulajansa S Dani - danituljan1977@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-507', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 814000', 'TOTAL INSTALLMENT PAID' => '700000', 'TOTAL INSTALLMENT PENDING' => '114000', 'DISCOUNT ON BRIK' => '57000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	533 => array('S.NO.' => '534', 'ID' => '557', 'BRIK OWNER' => 'Kirandevi Ajay Kumar Gupta - kirandeviajaygupta@gmail.com', 'UNIT NUMBER' => 'T8-506', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	534 => array('S.NO.' => '535', 'ID' => '558', 'BRIK OWNER' => 'Sahana K S - raghuabhineeth2@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-303', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '57000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	535 => array('S.NO.' => '536', 'ID' => '559', 'BRIK OWNER' => 'Dambarudhar Meher - rawcotton2013@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040011', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '401090', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 302090', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '152090', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	536 => array('S.NO.' => '537', 'ID' => '560', 'BRIK OWNER' => 'Shashank Tiwari - Shashanktiwari111@gmail.com', 'UNIT NUMBER' => 'Galaxy 2701 - 101', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '370000', 'TOTAL INSTALLMENT PENDING' => '180000', 'DISCOUNT ON BRIK' => '204227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	537 => array('S.NO.' => '538', 'ID' => '561', 'BRIK OWNER' => 'Deepali Vohra - vohradeepali@yahoo.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-505', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '450000', 'TOTAL INSTALLMENT PENDING' => '350000', 'DISCOUNT ON BRIK' => '57000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	538 => array('S.NO.' => '539', 'ID' => '562', 'BRIK OWNER' => 'Anilaben Goswami - amit.rg80@gmail.com', 'UNIT NUMBER' => 'Galaxy 2704 - 102', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 665300', 'TOTAL INSTALLMENT PAID' => '430000', 'TOTAL INSTALLMENT PENDING' => '235300', 'DISCOUNT ON BRIK' => '104227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	539 => array('S.NO.' => '540', 'ID' => '563', 'BRIK OWNER' => 'Sujit Kumar Pattanaik - jitusujit@gmail.com', 'UNIT NUMBER' => 'T1-1205', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '550000', 'DISCOUNT ON BRIK' => '66182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	540 => array('S.NO.' => '541', 'ID' => '564', 'BRIK OWNER' => 'VIKRAM NANDA - vikramnanda99@hotmail.com', 'UNIT NUMBER' => 'Galaxy 2701 - 101', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 560000', 'TOTAL INSTALLMENT PAID' => '350000', 'TOTAL INSTALLMENT PENDING' => '210000', 'DISCOUNT ON BRIK' => '204227', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	541 => array('S.NO.' => '542', 'ID' => '565', 'BRIK OWNER' => 'Limaye Milind Bhalchandra - milindlimaye67@gmail.com', 'UNIT NUMBER' => 'Galaxy 2702 - 201', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 585374', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '385374', 'DISCOUNT ON BRIK' => '204227', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	542 => array('S.NO.' => '543', 'ID' => '566', 'BRIK OWNER' => 'Karan Kumar - karan.ukenterprises@gmail.com', 'UNIT NUMBER' => 'Tower 8 Block B306', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '929000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 780000', 'TOTAL INSTALLMENT PAID' => '360000', 'TOTAL INSTALLMENT PENDING' => '420000', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	543 => array('S.NO.' => '544', 'ID' => '567', 'BRIK OWNER' => 'Sanjana . - sanjana.bangia07@gmail.com', 'UNIT NUMBER' => 'Galaxy 2702 - 201', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '470000', 'TOTAL INSTALLMENT PENDING' => '180000', 'DISCOUNT ON BRIK' => '104227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	544 => array('S.NO.' => '545', 'ID' => '568', 'BRIK OWNER' => 'Madhu Bala - nitish.gulati22@gmail.com', 'UNIT NUMBER' => 'Tower 8 Block B306', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '899000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 750000', 'TOTAL INSTALLMENT PAID' => '620000', 'TOTAL INSTALLMENT PENDING' => '130000', 'DISCOUNT ON BRIK' => '107000', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	545 => array('S.NO.' => '546', 'ID' => '569', 'BRIK OWNER' => 'Zenia George Dabreo - dabreozenia02@gmail.com', 'UNIT NUMBER' => 'Galaxy 2704 - 102', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 576010', 'TOTAL INSTALLMENT PAID' => '100000', 'TOTAL INSTALLMENT PENDING' => '476010', 'DISCOUNT ON BRIK' => '204227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	546 => array('S.NO.' => '547', 'ID' => '570', 'BRIK OWNER' => 'Chinmoy Kumar Muduli - chinmoy.muduli@gmail.com', 'UNIT NUMBER' => 'T1-1205', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '669000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 14 Installments) Amount: 609229', 'TOTAL INSTALLMENT PAID' => '270000', 'TOTAL INSTALLMENT PENDING' => '339229', 'DISCOUNT ON BRIK' => '66182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	547 => array('S.NO.' => '548', 'ID' => '571', 'BRIK OWNER' => 'Mirdul Kumar Gupta - mridul.gupta@rediffmail.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Mountain Heritage Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AARCM3870G', 'CIN NO.' => 'U68100UP2023PTC190853', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1890000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 1631212', 'TOTAL INSTALLMENT PAID' => '700000', 'TOTAL INSTALLMENT PENDING' => '931212', 'DISCOUNT ON BRIK' => '598454', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	548 => array('S.NO.' => '549', 'ID' => '572', 'BRIK OWNER' => 'Sabita Sethi - pramodkumar.swagat@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 631437', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '631437', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	549 => array('S.NO.' => '550', 'ID' => '573', 'BRIK OWNER' => 'Pankaj Atri - pankajatri83@gmail.com', 'UNIT NUMBER' => 'B2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '1099000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 950000', 'TOTAL INSTALLMENT PAID' => '950000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '99546', 'COINS' => '100', 'REFERRAL DISC' => '0', 'COIN' => '187', 'REFERRAL DISCOUNT' => '0'),
	550 => array('S.NO.' => '551', 'ID' => '574', 'BRIK OWNER' => 'Saurabh Kumar Sahu - saurabh281093@gmail.com', 'UNIT NUMBER' => 'T1-1205', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '669000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 580404', 'TOTAL INSTALLMENT PAID' => '210000', 'TOTAL INSTALLMENT PENDING' => '370404', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	551 => array('S.NO.' => '552', 'ID' => '575', 'BRIK OWNER' => 'Narayan Prasad Das - npdas1971@gmail.com', 'UNIT NUMBER' => 'T1-1205', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '240000', 'TOTAL INSTALLMENT PENDING' => '310000', 'DISCOUNT ON BRIK' => '66182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	552 => array('S.NO.' => '553', 'ID' => '576', 'BRIK OWNER' => 'Sradhanjali Pattanayak - shradhanjali103@gmail.com', 'UNIT NUMBER' => 'T2-618', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '669000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 570000', 'TOTAL INSTALLMENT PAID' => '270000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '46182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	553 => array('S.NO.' => '554', 'ID' => '577', 'BRIK OWNER' => 'Joseph Panakkal Lazar - Josephpanakal@yahoo.com', 'UNIT NUMBER' => 'T5/704', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '50454', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	554 => array('S.NO.' => '555', 'ID' => '578', 'BRIK OWNER' => 'Sunil Kumar Mittal - sunilMittal1@yahoo.in', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1890000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 1641616', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1641616', 'DISCOUNT ON BRIK' => '598454', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	555 => array('S.NO.' => '556', 'ID' => '579', 'BRIK OWNER' => 'Mathan Kumar N - mathanmail@gmail.com', 'UNIT NUMBER' => 'Galaxy 2701 - 101', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '250000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '204227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	556 => array('S.NO.' => '557', 'ID' => '580', 'BRIK OWNER' => 'Purushottam Modani - purumodani7@gmail.com', 'UNIT NUMBER' => 'Row Villa No. 2', 'PROJECT' => 'MVR Casa Villa', 'SPV' => 'LUXE CA VILLA 3BHK PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAECL9764D', 'CIN NO.' => 'U70109UP2022PTC161805', 'BRIK VALUE' => '3243636', 'INVESTMENT AMOUNT' => '2690000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 2400000', 'TOTAL INSTALLMENT PAID' => '1600000', 'TOTAL INSTALLMENT PENDING' => '800000', 'DISCOUNT ON BRIK' => '553636', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '0', 'REFERRAL DISCOUNT' => '0'),
	557 => array('S.NO.' => '558', 'ID' => '581', 'BRIK OWNER' => 'Vishal Kumar - vishalsah1986@gmail.com', 'UNIT NUMBER' => 'T8/Block B302', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '929000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 790000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '290000', 'DISCOUNT ON BRIK' => '77000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	558 => array('S.NO.' => '559', 'ID' => '582', 'BRIK OWNER' => 'Vinit Vikas - vinitvikas@gmail.com', 'UNIT NUMBER' => 'Galaxy 2702 - 201', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 610000', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '310000', 'DISCOUNT ON BRIK' => '154227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	559 => array('S.NO.' => '560', 'ID' => '583', 'BRIK OWNER' => 'Ankur Bhargava - ankur.jupiter@gmail.com', 'UNIT NUMBER' => 'T3-201', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '430000', 'TOTAL INSTALLMENT PENDING' => '170000', 'DISCOUNT ON BRIK' => '77791', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	560 => array('S.NO.' => '561', 'ID' => '584', 'BRIK OWNER' => 'Manas Kumar Mohanty - manas.by@gmail.com', 'UNIT NUMBER' => 'T2-618', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '240000', 'TOTAL INSTALLMENT PENDING' => '310000', 'DISCOUNT ON BRIK' => '66182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	561 => array('S.NO.' => '562', 'ID' => '585', 'BRIK OWNER' => 'Vandana Nath - asishkumar31@gmail.com', 'UNIT NUMBER' => 'T1-012', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '360000', 'TOTAL INSTALLMENT PENDING' => '240000', 'DISCOUNT ON BRIK' => '16182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	562 => array('S.NO.' => '563', 'ID' => '586', 'BRIK OWNER' => 'Shevetambri Udehan - u.sheveta@gmail.com', 'UNIT NUMBER' => 'T8/Block B302', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '520000', 'TOTAL INSTALLMENT PENDING' => '280000', 'DISCOUNT ON BRIK' => '57000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	563 => array('S.NO.' => '564', 'ID' => '587', 'BRIK OWNER' => 'Gokulananda Sahu - gokulsahu94@gmail.com', 'UNIT NUMBER' => 'T8/Block B302', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '869000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 770000', 'TOTAL INSTALLMENT PAID' => '580000', 'TOTAL INSTALLMENT PENDING' => '190000', 'DISCOUNT ON BRIK' => '137000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	564 => array('S.NO.' => '565', 'ID' => '588', 'BRIK OWNER' => 'Preeti Gupta - preetig1902@gmail.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Mountain Heritage Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AARCM3870G', 'CIN NO.' => 'U68100UP2023PTC190853', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1890000', 'BOOKING AMOUNT PAID' => '190000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 1741616', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1741616', 'DISCOUNT ON BRIK' => '598454', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	565 => array('S.NO.' => '566', 'ID' => '589', 'BRIK OWNER' => 'Ramendra Narayan Singh - rnsrashmi@rediffmail.com', 'UNIT NUMBER' => 'T2-618', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 610404', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '410404', 'DISCOUNT ON BRIK' => '16182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	566 => array('S.NO.' => '567', 'ID' => '590', 'BRIK OWNER' => 'Saria Rahman - saria.rahman@gmail.com', 'UNIT NUMBER' => 'Galaxy 2703 - 301', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '400000', 'DISCOUNT ON BRIK' => '154227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	567 => array('S.NO.' => '568', 'ID' => '591', 'BRIK OWNER' => 'Jagvir Singh - Jagveer_agha@yahoo.com', 'UNIT NUMBER' => 'Galaxy 2704 - 102', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '154227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	568 => array('S.NO.' => '569', 'ID' => '592', 'BRIK OWNER' => 'Ponnien Selvi Ramesh - thedarklord160694@gmail.com', 'UNIT NUMBER' => 'B2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '1099000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 950000', 'TOTAL INSTALLMENT PAID' => '950000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '99546', 'COINS' => '210', 'REFERRAL DISC' => '0', 'COIN' => '210', 'REFERRAL DISCOUNT' => '0'),
	569 => array('S.NO.' => '570', 'ID' => '593', 'BRIK OWNER' => 'Banishree Pattanaik - sparija2008@gmail.com', 'UNIT NUMBER' => 'T2-618', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 14 Installments) Amount: 560000', 'TOTAL INSTALLMENT PAID' => '360000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '66182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	570 => array('S.NO.' => '571', 'ID' => '594', 'BRIK OWNER' => 'Rameswar Sahoo - todaysram@gmail.com', 'UNIT NUMBER' => 'T5/704', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 626818', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '626818', 'DISCOUNT ON BRIK' => '59727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => 'cancel', 'REFERRAL DISCOUNT' => '0'),
	571 => array('S.NO.' => '572', 'ID' => '595', 'BRIK OWNER' => 'Sugandha Kumari - pawanksinh@gmail.com', 'UNIT NUMBER' => 'T2-618', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 565606', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '415606', 'DISCOUNT ON BRIK' => '66182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	572 => array('S.NO.' => '573', 'ID' => '596', 'BRIK OWNER' => 'Manas Ranjan Behera - Lmanas20@gmail.com', 'UNIT NUMBER' => 'T2-618', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 14 Installments) Amount: 556763', 'TOTAL INSTALLMENT PAID' => '215000', 'TOTAL INSTALLMENT PENDING' => '341763', 'DISCOUNT ON BRIK' => '66182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	573 => array('S.NO.' => '574', 'ID' => '597', 'BRIK OWNER' => 'Vijay Jhanjee - jhanjivijay@yahoo.com', 'UNIT NUMBER' => 'T10-104', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1149000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 1000000', 'TOTAL INSTALLMENT PAID' => '1000000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '127272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	574 => array('S.NO.' => '575', 'ID' => '598', 'BRIK OWNER' => 'Md Sarfaraz Ahmad - sarfarazahmaddhn@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040011', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 303121', 'TOTAL INSTALLMENT PAID' => '90000', 'TOTAL INSTALLMENT PENDING' => '213121', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	575 => array('S.NO.' => '576', 'ID' => '599', 'BRIK OWNER' => 'Kirtikumar Bhikhabhai Bheda - bhedakirti@gmail.com', 'UNIT NUMBER' => 'Galaxy 2702 - 201', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '580000', 'DISCOUNT ON BRIK' => '174227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	576 => array('S.NO.' => '577', 'ID' => '600', 'BRIK OWNER' => 'Dolly Gupta - riteshgupta705@gmail.com', 'UNIT NUMBER' => 'T1-1205', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '240000', 'TOTAL INSTALLMENT PENDING' => '340000', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	577 => array('S.NO.' => '578', 'ID' => '601', 'BRIK OWNER' => 'Diksha Gupta - naveen0404@yahoo.com', 'UNIT NUMBER' => 'Galaxy 2702 - 201', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 631212', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '481212', 'DISCOUNT ON BRIK' => '154227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	578 => array('S.NO.' => '579', 'ID' => '602', 'BRIK OWNER' => 'Santoshi Kumari Pathi - nigam893@gmail.com', 'UNIT NUMBER' => 'T2-618', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 559630', 'TOTAL INSTALLMENT PAID' => '219630', 'TOTAL INSTALLMENT PENDING' => '340000', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	579 => array('S.NO.' => '580', 'ID' => '603', 'BRIK OWNER' => 'Kanupriya Bansal - advrahatbansal@gmail.com', 'UNIT NUMBER' => 'Galaxy 2702 - 201', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 536190', 'TOTAL INSTALLMENT PAID' => '236190', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '154227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	580 => array('S.NO.' => '581', 'ID' => '605', 'BRIK OWNER' => 'Abhinav Chopra - abhinav.chopra90@gmail.com', 'UNIT NUMBER' => 'Galaxy 2702 - 201', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '154227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	581 => array('S.NO.' => '582', 'ID' => '606', 'BRIK OWNER' => 'Sandeep Joshi - sanjoshi.arju@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040003', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 302090', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '302090', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	582 => array('S.NO.' => '583', 'ID' => '607', 'BRIK OWNER' => 'Nitesh Kumar Agarwal - niteshjindal1985@gmail.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Mountain Heritage Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AARCM3870G', 'CIN NO.' => 'U68100UP2023PTC190853', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1899000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 1645414', 'TOTAL INSTALLMENT PAID' => '700000', 'TOTAL INSTALLMENT PENDING' => '945414', 'DISCOUNT ON BRIK' => '589454', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	583 => array('S.NO.' => '584', 'ID' => '608', 'BRIK OWNER' => 'Pratyancha Singh - Prat_singh2412@yahoo.com', 'UNIT NUMBER' => 'T8-506', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	584 => array('S.NO.' => '585', 'ID' => '609', 'BRIK OWNER' => 'Suryakant Dhotre HUF - vastumahaveda@gmail.com', 'UNIT NUMBER' => 'Row Villa No. 2', 'PROJECT' => 'MVR Casa Villa', 'SPV' => 'LUXE CA VILLA 3BHK PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAECL9764D', 'CIN NO.' => 'U70109UP2022PTC161805', 'BRIK VALUE' => '3243636', 'INVESTMENT AMOUNT' => '2990000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 2700000', 'TOTAL INSTALLMENT PAID' => '2700000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '253636', 'COINS' => '270', 'REFERRAL DISC' => '20970', 'COIN' => '270', 'REFERRAL DISCOUNT' => '20970'),
	585 => array('S.NO.' => '586', 'ID' => '610', 'BRIK OWNER' => 'Kavita Chhabria - kapil4chhabria@gmail.com', 'UNIT NUMBER' => 'T8-506', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '719000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 620000', 'TOTAL INSTALLMENT PAID' => '620000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '19727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	586 => array('S.NO.' => '587', 'ID' => '611', 'BRIK OWNER' => 'Kavita Chhabria - kapil4chhabria@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '1149000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 1040000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1040000', 'DISCOUNT ON BRIK' => '49546', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	587 => array('S.NO.' => '588', 'ID' => '612', 'BRIK OWNER' => 'Prasad Jaywant Hande - prasad1881@gmail.com', 'UNIT NUMBER' => 'T1-711', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 565000', 'TOTAL INSTALLMENT PAID' => '350000', 'TOTAL INSTALLMENT PENDING' => '215000', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	588 => array('S.NO.' => '589', 'ID' => '613', 'BRIK OWNER' => 'Ambily John - ambili2345@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040011', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '79000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '120000', 'TOTAL INSTALLMENT PENDING' => '180000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	589 => array('S.NO.' => '590', 'ID' => '614', 'BRIK OWNER' => 'Amit Kumar Suman - amit_suman@yahoo.com', 'UNIT NUMBER' => 'T7- 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	590 => array('S.NO.' => '591', 'ID' => '615', 'BRIK OWNER' => 'Munna Kumar - munnanavy6@gmail.com', 'UNIT NUMBER' => 'Galaxy 2703 - 301', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '154227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	591 => array('S.NO.' => '592', 'ID' => '616', 'BRIK OWNER' => 'Vibha . - collegevibhacodoc@gmail.com', 'UNIT NUMBER' => 'Galaxy 2701 - 101', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '250000', 'TOTAL INSTALLMENT PENDING' => '400000', 'DISCOUNT ON BRIK' => '104227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	592 => array('S.NO.' => '593', 'ID' => '617', 'BRIK OWNER' => 'Hritik Suman - hritiksuman@gmail.com', 'UNIT NUMBER' => 'Galaxy 2703 - 301', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '660180', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 561180', 'TOTAL INSTALLMENT PAID' => '390000', 'TOTAL INSTALLMENT PENDING' => '171180', 'DISCOUNT ON BRIK' => '193047', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	593 => array('S.NO.' => '594', 'ID' => '618', 'BRIK OWNER' => 'Lakshmi V Bhandarkar - bhandarkar7@gmail.com', 'UNIT NUMBER' => 'T5/704', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	594 => array('S.NO.' => '595', 'ID' => '619', 'BRIK OWNER' => 'Madhukar . - er.madhukar@gmail.com', 'UNIT NUMBER' => 'Galaxy 2703 - 301', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '154227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	595 => array('S.NO.' => '596', 'ID' => '620', 'BRIK OWNER' => 'Nancy Suman - sumannancy9@gmail.com', 'UNIT NUMBER' => 'Galaxy 2703 - 301', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '660180', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 561180', 'TOTAL INSTALLMENT PAID' => '390000', 'TOTAL INSTALLMENT PENDING' => '171180', 'DISCOUNT ON BRIK' => '193047', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	596 => array('S.NO.' => '597', 'ID' => '621', 'BRIK OWNER' => 'Amit Gupta - pktg19@gmail.com', 'UNIT NUMBER' => 'Galaxy 2705 - 202', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '330000', 'TOTAL INSTALLMENT PENDING' => '270000', 'DISCOUNT ON BRIK' => '154227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	597 => array('S.NO.' => '598', 'ID' => '622', 'BRIK OWNER' => 'Amit Kumar Tiwari - meet2amit2002@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040011', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '349000', 'BOOKING AMOUNT PAID' => '49000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 306242', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '306242', 'DISCOUNT ON BRIK' => '52090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	598 => array('S.NO.' => '599', 'ID' => '623', 'BRIK OWNER' => 'Jishu Rashmi - rnsrashmi5@gmail.com', 'UNIT NUMBER' => 'Galaxy 2703 - 301', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 560000', 'TOTAL INSTALLMENT PAID' => '100000', 'TOTAL INSTALLMENT PENDING' => '460000', 'DISCOUNT ON BRIK' => '204227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	599 => array('S.NO.' => '600', 'ID' => '624', 'BRIK OWNER' => 'Sunita Patro - sunitaenagic1986@gmail.com', 'UNIT NUMBER' => 'T2-618', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 498520', 'TOTAL INSTALLMENT PAID' => '199260', 'TOTAL INSTALLMENT PENDING' => '299260', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	600 => array('S.NO.' => '601', 'ID' => '625', 'BRIK OWNER' => 'Ankur Bhargava - ankur.jupiter@gmail.com', 'UNIT NUMBER' => 'T8/Block B302', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '925000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 741530', 'TOTAL INSTALLMENT PAID' => '465530', 'TOTAL INSTALLMENT PENDING' => '276000', 'DISCOUNT ON BRIK' => '81000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	601 => array('S.NO.' => '602', 'ID' => '626', 'BRIK OWNER' => 'Rahul Sharma - Editortti@gmail.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Mountain Heritage Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AARCM3870G', 'CIN NO.' => 'U68100UP2023PTC190853', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1800000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 1500000', 'TOTAL INSTALLMENT PAID' => '1300000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '698454', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	602 => array('S.NO.' => '603', 'ID' => '627', 'BRIK OWNER' => 'Rakesh Sirohi - sirohionline@rediffmail.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '1119000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 970000', 'TOTAL INSTALLMENT PAID' => '970000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '79546', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	603 => array('S.NO.' => '604', 'ID' => '628', 'BRIK OWNER' => 'Prabhat Ranjan - iitkgpprabhat@gmail.com', 'UNIT NUMBER' => 'T7- 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '89727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	604 => array('S.NO.' => '605', 'ID' => '629', 'BRIK OWNER' => 'Nitesh Kumar Agarwal - niteshjindal1985@gmail.com', 'UNIT NUMBER' => 'T1-611', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '629000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 530000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '380000', 'DISCOUNT ON BRIK' => '86182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	605 => array('S.NO.' => '606', 'ID' => '630', 'BRIK OWNER' => 'Shanthala J - jpradeep15@gmail.com', 'UNIT NUMBER' => 'Row-6/Block4/A-402', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '390000', 'TOTAL INSTALLMENT PENDING' => '210000', 'DISCOUNT ON BRIK' => '50000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	606 => array('S.NO.' => '607', 'ID' => '631', 'BRIK OWNER' => 'Sucheta Das - rajesh.cesu@gmail.com', 'UNIT NUMBER' => 'T1-611', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '240000', 'TOTAL INSTALLMENT PENDING' => '340000', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	607 => array('S.NO.' => '608', 'ID' => '632', 'BRIK OWNER' => 'Neeraj Kumar - niraj.ninja33@gmail.com', 'UNIT NUMBER' => 'T8/Block B302', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '57000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	608 => array('S.NO.' => '609', 'ID' => '633', 'BRIK OWNER' => 'Purushottam Kaushik - kaushik901@gmail.com', 'UNIT NUMBER' => 'T2-618', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '360000', 'TOTAL INSTALLMENT PENDING' => '240000', 'DISCOUNT ON BRIK' => '16182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	609 => array('S.NO.' => '610', 'ID' => '634', 'BRIK OWNER' => 'Satyendra Kumar - satyendrakumar010369@gmail.com', 'UNIT NUMBER' => 'T2-618', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '360000', 'TOTAL INSTALLMENT PENDING' => '240000', 'DISCOUNT ON BRIK' => '16182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	610 => array('S.NO.' => '611', 'ID' => '635', 'BRIK OWNER' => 'Rabindra Kumar Mahapatra - rkmahapatra777@gmail.com', 'UNIT NUMBER' => 'T1-1205', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 566646', 'TOTAL INSTALLMENT PAID' => '160000', 'TOTAL INSTALLMENT PENDING' => '406646', 'DISCOUNT ON BRIK' => '66182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	611 => array('S.NO.' => '612', 'ID' => '636', 'BRIK OWNER' => 'Mamta Barla - mamtabarla2074@gmail.com', 'UNIT NUMBER' => 'T7- 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	612 => array('S.NO.' => '613', 'ID' => '637', 'BRIK OWNER' => 'Anita Mahapatra - anitamahapatra810@gmail.com', 'UNIT NUMBER' => 'T7- 807', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '669000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 570000', 'TOTAL INSTALLMENT PAID' => '570000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '45637', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '45', 'REFERRAL DISCOUNT' => '0'),
	613 => array('S.NO.' => '614', 'ID' => '638', 'BRIK OWNER' => 'Tenzin Rabyang - Terab6709@gmail.com', 'UNIT NUMBER' => 'T7- 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	614 => array('S.NO.' => '615', 'ID' => '639', 'BRIK OWNER' => 'Vivek Verma - vivekiitroorkee@gmail.com', 'UNIT NUMBER' => 'Galaxy 2702 - 201', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '725243', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 626243', 'TOTAL INSTALLMENT PAID' => '360000', 'TOTAL INSTALLMENT PENDING' => '266243', 'DISCOUNT ON BRIK' => '127984', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	615 => array('S.NO.' => '616', 'ID' => '640', 'BRIK OWNER' => 'Ayush Vikram Surana - ayush.surana24@rediffmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040007', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 280000', 'TOTAL INSTALLMENT PAID' => '120000', 'TOTAL INSTALLMENT PENDING' => '160000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	616 => array('S.NO.' => '617', 'ID' => '641', 'BRIK OWNER' => 'Swati Swarupa Das - swatiswarupa96@gmail.com', 'UNIT NUMBER' => 'T1-1205', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '310000', 'TOTAL INSTALLMENT PENDING' => '270000', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	617 => array('S.NO.' => '618', 'ID' => '642', 'BRIK OWNER' => 'Chandra Sekhar Lenka - cslenka@gmail.com', 'UNIT NUMBER' => 'T2-618', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 17 Installments) Amount: 564364', 'TOTAL INSTALLMENT PAID' => '280000', 'TOTAL INSTALLMENT PENDING' => '284364', 'DISCOUNT ON BRIK' => '66182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	618 => array('S.NO.' => '619', 'ID' => '643', 'BRIK OWNER' => 'Rupali Vikram Pingale - rupalipeer@gmail.com', 'UNIT NUMBER' => 'Row - 8/Block 5/B-506', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '57000', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	619 => array('S.NO.' => '620', 'ID' => '644', 'BRIK OWNER' => 'Naresh Babu Dhananjayan - halder.nibedita@gmail.com', 'UNIT NUMBER' => 'Galaxy 2703 - 301', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '725243', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 626243', 'TOTAL INSTALLMENT PAID' => '330000', 'TOTAL INSTALLMENT PENDING' => '296243', 'DISCOUNT ON BRIK' => '127984', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	620 => array('S.NO.' => '621', 'ID' => '645', 'BRIK OWNER' => 'Bibhu Samal - samalbp55@gmail.com', 'UNIT NUMBER' => 'T1-710', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '360000', 'TOTAL INSTALLMENT PENDING' => '240000', 'DISCOUNT ON BRIK' => '16182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	621 => array('S.NO.' => '622', 'ID' => '646', 'BRIK OWNER' => 'Sagar Banga - sagarbanga3321@gmail.com', 'UNIT NUMBER' => 'Galaxy 2703 - 301', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '725243', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 626243', 'TOTAL INSTALLMENT PAID' => '430000', 'TOTAL INSTALLMENT PENDING' => '196243', 'DISCOUNT ON BRIK' => '127984', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	622 => array('S.NO.' => '623', 'ID' => '647', 'BRIK OWNER' => 'Ramesh Chandra Swain - rameshswn2@gmail.com', 'UNIT NUMBER' => 'T1-1211', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '360000', 'TOTAL INSTALLMENT PENDING' => '220000', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	623 => array('S.NO.' => '624', 'ID' => '648', 'BRIK OWNER' => 'Shubhi Bhalla - nikhilbhalla89@gmail.com', 'UNIT NUMBER' => 'Galaxy 2701 - 101', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '725243', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 626243', 'TOTAL INSTALLMENT PAID' => '430000', 'TOTAL INSTALLMENT PENDING' => '196243', 'DISCOUNT ON BRIK' => '127984', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	624 => array('S.NO.' => '625', 'ID' => '649', 'BRIK OWNER' => 'Chandra Obula Reddy Vundela - obulareddy.110383@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040008', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '401090', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 302090', 'TOTAL INSTALLMENT PAID' => '120000', 'TOTAL INSTALLMENT PENDING' => '182090', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	625 => array('S.NO.' => '626', 'ID' => '650', 'BRIK OWNER' => 'Ashmit Agarwal - agarwalashmit87@gmail.com', 'UNIT NUMBER' => 'Galaxy 2705 - 202', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '154227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	626 => array('S.NO.' => '627', 'ID' => '651', 'BRIK OWNER' => 'Prannay Chhibber - prannaychhibber@gmail.com', 'UNIT NUMBER' => 'Galaxy 2704 - 102', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '160000', 'TOTAL INSTALLMENT PENDING' => '390000', 'DISCOUNT ON BRIK' => '204227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	627 => array('S.NO.' => '628', 'ID' => '652', 'BRIK OWNER' => 'Shakeeb Ayaz - ayazshakeeb@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040010', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '401090', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 302090', 'TOTAL INSTALLMENT PAID' => '120000', 'TOTAL INSTALLMENT PENDING' => '182090', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	628 => array('S.NO.' => '629', 'ID' => '653', 'BRIK OWNER' => 'Pramod Sharma - pramod.anu0006@gmail.com', 'UNIT NUMBER' => 'Galaxy 2705 - 202', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '154227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	629 => array('S.NO.' => '630', 'ID' => '654', 'BRIK OWNER' => 'Sanjay Koul - sanjay.koul@timken.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Holiday Horizons Pvt Ltd', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4366E', 'CIN NO.' => 'U68100UP2024PTC205856', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1990000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1700000', 'TOTAL INSTALLMENT PAID' => '1500000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '498454', 'COINS' => '390', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	630 => array('S.NO.' => '631', 'ID' => '655', 'BRIK OWNER' => 'Arvind Yadav - aastha.atp07@gmail.com', 'UNIT NUMBER' => 'Galaxy 2705 - 202', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '154227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	631 => array('S.NO.' => '632', 'ID' => '656', 'BRIK OWNER' => 'Prosit Mukherjee - lifestyleimprover2008@gmail.com', 'UNIT NUMBER' => 'T1-012', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 559630', 'TOTAL INSTALLMENT PAID' => '259630', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	632 => array('S.NO.' => '633', 'ID' => '657', 'BRIK OWNER' => 'Haripriya Y - pvelury@gmail.com', 'UNIT NUMBER' => 'T8/Block B302', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '57000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	633 => array('S.NO.' => '634', 'ID' => '658', 'BRIK OWNER' => 'Kanta Kumari - deepanshu.raj@gmail.com', 'UNIT NUMBER' => 'Galaxy 2702 - 201', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '725243', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 626243', 'TOTAL INSTALLMENT PAID' => '310000', 'TOTAL INSTALLMENT PENDING' => '316243', 'DISCOUNT ON BRIK' => '127984', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	634 => array('S.NO.' => '635', 'ID' => '659', 'BRIK OWNER' => 'ORYX Security Force Private Limited - indiaoryx@gmail.com', 'UNIT NUMBER' => 'T1-013', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '580000', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	635 => array('S.NO.' => '636', 'ID' => '660', 'BRIK OWNER' => 'Shampa Dhar - bonvoyageholidayz@gmail.com', 'UNIT NUMBER' => 'T8-506', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 1 Installments) Amount: 579030', 'TOTAL INSTALLMENT PAID' => '579030', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	636 => array('S.NO.' => '637', 'ID' => '661', 'BRIK OWNER' => 'Rina Bardhan - pushpendubardhan@gmail.com', 'UNIT NUMBER' => 'T7- 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	637 => array('S.NO.' => '638', 'ID' => '662', 'BRIK OWNER' => 'Ananya Sen - sumitsen1972@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040009', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '401090', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 290420', 'TOTAL INSTALLMENT PAID' => '108330', 'TOTAL INSTALLMENT PENDING' => '182090', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	638 => array('S.NO.' => '639', 'ID' => '663', 'BRIK OWNER' => 'Shashin S - Shashin.d@gmail.com', 'UNIT NUMBER' => 'T7- 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '580000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '59727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	639 => array('S.NO.' => '640', 'ID' => '664', 'BRIK OWNER' => 'Khushi Goswami - khushitata2@gmail.com', 'UNIT NUMBER' => 'T7- 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	640 => array('S.NO.' => '641', 'ID' => '665', 'BRIK OWNER' => 'Hemant Kumar Agarwal - aasthatravels4@gmail.com', 'UNIT NUMBER' => 'Galaxy 2705 - 202', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '350000', 'TOTAL INSTALLMENT PENDING' => '250000', 'DISCOUNT ON BRIK' => '154227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	641 => array('S.NO.' => '642', 'ID' => '666', 'BRIK OWNER' => 'Prosit Mukherjee - lifestyleimprover2008@gmail.com', 'UNIT NUMBER' => 'Galaxy 2702 - 201', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 559630', 'TOTAL INSTALLMENT PAID' => '339630', 'TOTAL INSTALLMENT PENDING' => '220000', 'DISCOUNT ON BRIK' => '174227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	642 => array('S.NO.' => '643', 'ID' => '667', 'BRIK OWNER' => 'Rajashri Prasad Kakodkar & Prasad Ratnakant Kakodkar - prasad_kak@rediffmail.com', 'UNIT NUMBER' => 'T8/Block B302', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '929000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 780000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '280000', 'DISCOUNT ON BRIK' => '77000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	643 => array('S.NO.' => '644', 'ID' => '668', 'BRIK OWNER' => 'Santosh Kumar Singh HUF - hufsantoshkumarsingh@gmail.com', 'UNIT NUMBER' => 'Galaxy 2703 - 301', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '320000', 'TOTAL INSTALLMENT PENDING' => '330000', 'DISCOUNT ON BRIK' => '104227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	644 => array('S.NO.' => '645', 'ID' => '669', 'BRIK OWNER' => 'Arup Mishra - arupmishra2009@gmail.com', 'UNIT NUMBER' => 'T7- 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	645 => array('S.NO.' => '646', 'ID' => '670', 'BRIK OWNER' => 'Rahasyamayee Giri - laxyaenagic@gmail.com', 'UNIT NUMBER' => 'T1-013', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 604970', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '604970', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	646 => array('S.NO.' => '647', 'ID' => '671', 'BRIK OWNER' => 'Shital Prasad Dash - shitaldash1989@gmail.com', 'UNIT NUMBER' => 'T8/Block B302', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '57000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	647 => array('S.NO.' => '648', 'ID' => '672', 'BRIK OWNER' => 'Sushree Sangita Rout - bapujeepradhan@gmail.com', 'UNIT NUMBER' => 'T1-611', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '580000', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	648 => array('S.NO.' => '649', 'ID' => '673', 'BRIK OWNER' => 'Priya Gulati - pavibatra@gmail.com', 'UNIT NUMBER' => 'T5-806', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '580000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '59727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	649 => array('S.NO.' => '650', 'ID' => '674', 'BRIK OWNER' => 'Sanjay Saha - sanjaysaha29423@gmail.com', 'UNIT NUMBER' => 'T1-611', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '400000', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	650 => array('S.NO.' => '651', 'ID' => '675', 'BRIK OWNER' => 'Samit Kumar Mukherjee - skmukherjee.chemical@gmail.com', 'UNIT NUMBER' => 'T1-611', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '240000', 'TOTAL INSTALLMENT PENDING' => '340000', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	651 => array('S.NO.' => '652', 'ID' => '676', 'BRIK OWNER' => 'Jeetendra Khanna - jeetukhanna1975@gmail.com', 'UNIT NUMBER' => 'T4-304', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SE2BR SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6092B', 'CIN NO.' => 'U70109UP2022PTC157704', 'BRIK VALUE' => '1019909', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '480000', 'TOTAL INSTALLMENT PENDING' => '320000', 'DISCOUNT ON BRIK' => '70909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	652 => array('S.NO.' => '653', 'ID' => '677', 'BRIK OWNER' => 'Sushree Sangita Rout - bapujeepradhan@gmail.com', 'UNIT NUMBER' => 'T5-806', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '580000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '59727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	653 => array('S.NO.' => '654', 'ID' => '678', 'BRIK OWNER' => 'Ishita Dubey - ish.23.ld@gmail.com', 'UNIT NUMBER' => 'T3-201', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '440000', 'TOTAL INSTALLMENT PENDING' => '160000', 'DISCOUNT ON BRIK' => '77791', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	654 => array('S.NO.' => '655', 'ID' => '679', 'BRIK OWNER' => 'Rupali Vikram Pingale - rupalipeer@gmail.com', 'UNIT NUMBER' => 'T5/704', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 1 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '550000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	655 => array('S.NO.' => '656', 'ID' => '680', 'BRIK OWNER' => 'Rajashree Patra - niharkantapatra640@gmail.com', 'UNIT NUMBER' => 'T5-806', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '380000', 'DISCOUNT ON BRIK' => '59727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	656 => array('S.NO.' => '657', 'ID' => '681', 'BRIK OWNER' => 'Siddhartha Shankar Puhan - sspuhan@gmail.com', 'UNIT NUMBER' => 'T1-611', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '260000', 'TOTAL INSTALLMENT PENDING' => '290000', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	657 => array('S.NO.' => '658', 'ID' => '682', 'BRIK OWNER' => 'Yogesh Verma - 1775rv@gmail.com', 'UNIT NUMBER' => 'T7- 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '580000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '59727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	658 => array('S.NO.' => '659', 'ID' => '683', 'BRIK OWNER' => 'Jyotsnarani Sahu - erpurandarsahu@gmail.com', 'UNIT NUMBER' => 'T1-611', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 588323', 'TOTAL INSTALLMENT PAID' => '240000', 'TOTAL INSTALLMENT PENDING' => '348323', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	659 => array('S.NO.' => '660', 'ID' => '684', 'BRIK OWNER' => 'Swadhinata Sahoo - swadhinata04@gmail.com', 'UNIT NUMBER' => 'T11- 202', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1149000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 1 Installments) Amount: 1000000', 'TOTAL INSTALLMENT PAID' => '1000000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '127272', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '90', 'REFERRAL DISCOUNT' => '0'),
	660 => array('S.NO.' => '661', 'ID' => '685', 'BRIK OWNER' => 'Akriti Khanna - ravimohankhanna@rediffmail.com', 'UNIT NUMBER' => 'Galaxy 2705 - 202', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '721000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 622000', 'TOTAL INSTALLMENT PAID' => '390000', 'TOTAL INSTALLMENT PENDING' => '232000', 'DISCOUNT ON BRIK' => '132227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	661 => array('S.NO.' => '662', 'ID' => '686', 'BRIK OWNER' => 'Shruti Jain - Deepak_Kapi@yahoo.com', 'UNIT NUMBER' => 'Row-8/Block 2/A-101', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '639000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 540000', 'TOTAL INSTALLMENT PAID' => '330000', 'TOTAL INSTALLMENT PENDING' => '210000', 'DISCOUNT ON BRIK' => '60000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	662 => array('S.NO.' => '663', 'ID' => '687', 'BRIK OWNER' => 'Sampa Das Koley - sabyakoley@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 662424', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '662424', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	663 => array('S.NO.' => '664', 'ID' => '688', 'BRIK OWNER' => 'Sunita Das - himanshushekhardas@gmail.com', 'UNIT NUMBER' => 'T7- 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	664 => array('S.NO.' => '665', 'ID' => '689', 'BRIK OWNER' => 'Arunima Nanda - ganguly.arunima@gmail.com', 'UNIT NUMBER' => 'T8/Block B302', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '400000', 'DISCOUNT ON BRIK' => '57000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	665 => array('S.NO.' => '666', 'ID' => '690', 'BRIK OWNER' => 'Vikas Shukla - v1kas@outlook.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040005', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '401090', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 302090', 'TOTAL INSTALLMENT PAID' => '120000', 'TOTAL INSTALLMENT PENDING' => '182090', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	666 => array('S.NO.' => '667', 'ID' => '691', 'BRIK OWNER' => 'Shailendra Kumar Mishra - Shailendraiiftr@gmail.com', 'UNIT NUMBER' => 'Row-8/B-304', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 854101', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '254101', 'DISCOUNT ON BRIK' => '57000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	667 => array('S.NO.' => '668', 'ID' => '692', 'BRIK OWNER' => 'Priyanka Soni - p.soni.itbhu@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Holiday Horizons Pvt Ltd', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4366E', 'CIN NO.' => 'U68100UP2024PTC205856', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '2000000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 1710000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1710000', 'DISCOUNT ON BRIK' => '488454', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	668 => array('S.NO.' => '669', 'ID' => '693', 'BRIK OWNER' => 'Nishu Priya - nishupriya1385@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Holiday Horizons Pvt Ltd', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4366E', 'CIN NO.' => 'U68100UP2024PTC205856', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '2000000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 1710000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1710000', 'DISCOUNT ON BRIK' => '488454', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	669 => array('S.NO.' => '670', 'ID' => '694', 'BRIK OWNER' => 'Shreeya Padebettu - whenkeys@yahoo.com', 'UNIT NUMBER' => 'T5-806', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '580000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '59727', 'COINS' => '39', 'REFERRAL DISC' => '0', 'COIN' => '39', 'REFERRAL DISCOUNT' => '0'),
	670 => array('S.NO.' => '671', 'ID' => '695', 'BRIK OWNER' => 'Neha Kumari - Nehamasiwal2112@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Holiday Horizons Pvt Ltd', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4366E', 'CIN NO.' => 'U68100UP2024PTC205856', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1990000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 1700000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1700000', 'DISCOUNT ON BRIK' => '498454', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	671 => array('S.NO.' => '672', 'ID' => '696', 'BRIK OWNER' => 'Akhilesh Rajput - rajputakhilesh1997@gmail.com', 'UNIT NUMBER' => 'T3-102', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '440000', 'TOTAL INSTALLMENT PENDING' => '160000', 'DISCOUNT ON BRIK' => '77791', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	672 => array('S.NO.' => '673', 'ID' => '697', 'BRIK OWNER' => 'Amaresh Kumar Nayak - amaresh_41@yahoo.com', 'UNIT NUMBER' => 'T1-611', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '220000', 'TOTAL INSTALLMENT PENDING' => '330000', 'DISCOUNT ON BRIK' => '66182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	673 => array('S.NO.' => '674', 'ID' => '698', 'BRIK OWNER' => 'Rajeev Gupta - Rajeev6070@gmail.com', 'UNIT NUMBER' => 'Galaxy 2705 - 202', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '420000', 'TOTAL INSTALLMENT PENDING' => '180000', 'DISCOUNT ON BRIK' => '154227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	674 => array('S.NO.' => '675', 'ID' => '699', 'BRIK OWNER' => 'Susmita Deb Das - susmitadebdas12@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040007', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '399000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '120000', 'TOTAL INSTALLMENT PENDING' => '180000', 'DISCOUNT ON BRIK' => '2090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	675 => array('S.NO.' => '676', 'ID' => '700', 'BRIK OWNER' => 'Kumar J - jkumara1977@gmail.com', 'UNIT NUMBER' => 'T5-806', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '689000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 581000', 'TOTAL INSTALLMENT PAID' => '581000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '49727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	676 => array('S.NO.' => '677', 'ID' => '701', 'BRIK OWNER' => 'Raval Varshaben - shrey.iso@gmail.com', 'UNIT NUMBER' => 'Galaxy 2704 - 102', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '410000', 'TOTAL INSTALLMENT PENDING' => '240000', 'DISCOUNT ON BRIK' => '104227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	677 => array('S.NO.' => '678', 'ID' => '702', 'BRIK OWNER' => 'Sasmita Mallick - rrmallicknhpc@yahoo.com', 'UNIT NUMBER' => 'T1-611', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '520000', 'TOTAL INSTALLMENT PENDING' => '80000', 'DISCOUNT ON BRIK' => '16182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	678 => array('S.NO.' => '679', 'ID' => '703', 'BRIK OWNER' => 'Debashrita Pani - satabhisa31@gmail.com', 'UNIT NUMBER' => 'T1-611', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '240000', 'TOTAL INSTALLMENT PENDING' => '340000', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	679 => array('S.NO.' => '680', 'ID' => '704', 'BRIK OWNER' => 'Kush Kalra - kalrakush786@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Holiday Horizons Pvt Ltd', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4366E', 'CIN NO.' => 'U68100UP2024PTC205856', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1990000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1700000', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '1400000', 'DISCOUNT ON BRIK' => '498454', 'COINS' => '450', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	680 => array('S.NO.' => '681', 'ID' => '705', 'BRIK OWNER' => 'Niranjan N G - niranjanjoshi456@gmail.com', 'UNIT NUMBER' => 'T5-806', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 640343', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '640343', 'DISCOUNT ON BRIK' => '59727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '0', 'REFERRAL DISCOUNT' => '0'),
	681 => array('S.NO.' => '682', 'ID' => '706', 'BRIK OWNER' => 'Gunjan Goyal - gunjanbansalcs@gmail.com', 'UNIT NUMBER' => 'Galaxy 2705 - 202', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '154227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	682 => array('S.NO.' => '683', 'ID' => '707', 'BRIK OWNER' => 'Amandeep Kaur - jagpalak@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Holiday Horizons Pvt Ltd', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4366E', 'CIN NO.' => 'U68100UP2024PTC205856', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '1850000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 1 Installments) Amount: 1560000', 'TOTAL INSTALLMENT PAID' => '1560000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '638454', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	683 => array('S.NO.' => '684', 'ID' => '708', 'BRIK OWNER' => 'Kandra Kishore - kandra723@gmail.com', 'UNIT NUMBER' => 'Row-8/B-304', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '57000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	684 => array('S.NO.' => '685', 'ID' => '709', 'BRIK OWNER' => 'Amandeep Kaur - jagpalak@gmail.com', 'UNIT NUMBER' => 'T3- 503', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1149000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 1000000', 'TOTAL INSTALLMENT PAID' => '1000000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '127272', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '67', 'REFERRAL DISCOUNT' => '0'),
	685 => array('S.NO.' => '686', 'ID' => '710', 'BRIK OWNER' => 'Rajeev Gupta - Rajeev6070@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040005', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 280000', 'TOTAL INSTALLMENT PAID' => '105000', 'TOTAL INSTALLMENT PENDING' => '175000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	686 => array('S.NO.' => '687', 'ID' => '711', 'BRIK OWNER' => 'DIPANWITA SARKAR DHAR - amlansarkar70@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040005', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '389000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 290000', 'TOTAL INSTALLMENT PAID' => '115000', 'TOTAL INSTALLMENT PENDING' => '175000', 'DISCOUNT ON BRIK' => '12090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	687 => array('S.NO.' => '688', 'ID' => '712', 'BRIK OWNER' => 'Pritesh Verma - Pritesh7002@gmail.com', 'UNIT NUMBER' => 'T8/Block B302', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '400000', 'DISCOUNT ON BRIK' => '57000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	688 => array('S.NO.' => '689', 'ID' => '713', 'BRIK OWNER' => 'Milli Meeta Sahu - surya.sahu0@gmail.com', 'UNIT NUMBER' => 'T1-111', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '669000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 570000', 'TOTAL INSTALLMENT PAID' => '250000', 'TOTAL INSTALLMENT PENDING' => '320000', 'DISCOUNT ON BRIK' => '46182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	689 => array('S.NO.' => '690', 'ID' => '714', 'BRIK OWNER' => 'Goldi . - goldiaa14@gmail.com', 'UNIT NUMBER' => 'Galaxy 2704 - 102', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '410000', 'TOTAL INSTALLMENT PENDING' => '240000', 'DISCOUNT ON BRIK' => '104227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	690 => array('S.NO.' => '691', 'ID' => '715', 'BRIK OWNER' => 'Seema Sharma - mjudr720@gmail.com', 'UNIT NUMBER' => 'Galaxy 2704 - 102', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '410000', 'TOTAL INSTALLMENT PENDING' => '240000', 'DISCOUNT ON BRIK' => '104227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	691 => array('S.NO.' => '692', 'ID' => '716', 'BRIK OWNER' => 'Kevin Michael - kevin.michael1987@gmail.com', 'UNIT NUMBER' => 'T8/Block B302', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '57000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	692 => array('S.NO.' => '693', 'ID' => '717', 'BRIK OWNER' => 'Indu Kumari - ashutoshksingh@yahoo.co.in', 'UNIT NUMBER' => 'T5-806', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	693 => array('S.NO.' => '694', 'ID' => '718', 'BRIK OWNER' => 'T Surendran Menon - sunil0505@gmail.com', 'UNIT NUMBER' => 'T5-806', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	694 => array('S.NO.' => '695', 'ID' => '719', 'BRIK OWNER' => 'Vishal Sharma - Vishal_shm@yahoo.com', 'UNIT NUMBER' => 'Tower-3 Unit 103', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '440000', 'TOTAL INSTALLMENT PENDING' => '160000', 'DISCOUNT ON BRIK' => '77791', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	695 => array('S.NO.' => '696', 'ID' => '720', 'BRIK OWNER' => 'Arpita Mitra - sujay.india@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040004', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 280000', 'TOTAL INSTALLMENT PAID' => '105000', 'TOTAL INSTALLMENT PENDING' => '175000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	696 => array('S.NO.' => '697', 'ID' => '721', 'BRIK OWNER' => 'Vinit Vikas - vinitvikas@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040005', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 280000', 'TOTAL INSTALLMENT PAID' => '70000', 'TOTAL INSTALLMENT PENDING' => '210000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	697 => array('S.NO.' => '698', 'ID' => '722', 'BRIK OWNER' => 'Jyoti Ranjan Dash - jyotidash30@yahoo.co.in', 'UNIT NUMBER' => 'T1-111', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 579030', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '579030', 'DISCOUNT ON BRIK' => '16182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	698 => array('S.NO.' => '699', 'ID' => '723', 'BRIK OWNER' => 'Aruvi Jayadev - aruvijayadev91@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040004', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '389000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 15 Installments) Amount: 290000', 'TOTAL INSTALLMENT PAID' => '100000', 'TOTAL INSTALLMENT PENDING' => '190000', 'DISCOUNT ON BRIK' => '12090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	699 => array('S.NO.' => '700', 'ID' => '724', 'BRIK OWNER' => 'Rishabh Mishra - rishabhbabina@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040003', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '389000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 290000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '290000', 'DISCOUNT ON BRIK' => '12090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	700 => array('S.NO.' => '701', 'ID' => '725', 'BRIK OWNER' => 'Akhilesh Rajput - rajputakhilesh1997@gmail.com', 'UNIT NUMBER' => 'Galaxy 2704 - 102', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '726530', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 627530', 'TOTAL INSTALLMENT PAID' => '380000', 'TOTAL INSTALLMENT PENDING' => '247530', 'DISCOUNT ON BRIK' => '126697', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	701 => array('S.NO.' => '702', 'ID' => '726', 'BRIK OWNER' => 'Prosit Mukherjee - lifestyleimprover2008@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040004', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '375000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 276000', 'TOTAL INSTALLMENT PAID' => '105000', 'TOTAL INSTALLMENT PENDING' => '171000', 'DISCOUNT ON BRIK' => '26090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	702 => array('S.NO.' => '703', 'ID' => '727', 'BRIK OWNER' => 'Daljit Singh - singh.daljit85@gmail.com', 'UNIT NUMBER' => 'Galaxy 2704 - 102', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '290000', 'TOTAL INSTALLMENT PENDING' => '360000', 'DISCOUNT ON BRIK' => '104227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	703 => array('S.NO.' => '704', 'ID' => '728', 'BRIK OWNER' => 'Shubhendu Kumar - shubhendukumar1@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040005', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '389000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 290000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '290000', 'DISCOUNT ON BRIK' => '12090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	704 => array('S.NO.' => '705', 'ID' => '729', 'BRIK OWNER' => 'Aruvi Jayadev - aruvijayadev91@gmail.com', 'UNIT NUMBER' => 'Galaxy 2705 - 202', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 15 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '240000', 'TOTAL INSTALLMENT PENDING' => '360000', 'DISCOUNT ON BRIK' => '154227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	705 => array('S.NO.' => '706', 'ID' => '730', 'BRIK OWNER' => 'Vidya Kadavath - jayan.machingal@gmail.com', 'UNIT NUMBER' => 'Row-8/B-304', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '400000', 'DISCOUNT ON BRIK' => '57000', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	706 => array('S.NO.' => '707', 'ID' => '731', 'BRIK OWNER' => 'Santosh Goswami - santosh9goswami@gmail.com', 'UNIT NUMBER' => 'Row-8/Block 2/A-101', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 528130', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '228130', 'DISCOUNT ON BRIK' => '50000', 'COINS' => '0', 'REFERRAL DISC' => '21870', 'COIN' => '', 'REFERRAL DISCOUNT' => '21870'),
	707 => array('S.NO.' => '708', 'ID' => '732', 'BRIK OWNER' => 'Shikhar Kumar - drkumar4u@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040004', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '389000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 290000', 'TOTAL INSTALLMENT PAID' => '115000', 'TOTAL INSTALLMENT PENDING' => '175000', 'DISCOUNT ON BRIK' => '12090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	708 => array('S.NO.' => '709', 'ID' => '733', 'BRIK OWNER' => 'Dr.Devender Kumar Sharma - drdev.vashist@gmail.com', 'UNIT NUMBER' => 'Galaxy 2705 - 202', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '380000', 'TOTAL INSTALLMENT PENDING' => '220000', 'DISCOUNT ON BRIK' => '154227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	709 => array('S.NO.' => '710', 'ID' => '734', 'BRIK OWNER' => 'Khushboo Gupta - guptaankur2007@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Holiday Horizons Pvt Ltd', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4366E', 'CIN NO.' => 'U68100UP2024PTC205856', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '2000000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 1710000', 'TOTAL INSTALLMENT PAID' => '1100000', 'TOTAL INSTALLMENT PENDING' => '610000', 'DISCOUNT ON BRIK' => '488454', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	710 => array('S.NO.' => '711', 'ID' => '735', 'BRIK OWNER' => 'Rachna A Shah - rachanashahrapheal10@gmail.com', 'UNIT NUMBER' => 'Row-8/B-304', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '500000', 'DISCOUNT ON BRIK' => '57000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	711 => array('S.NO.' => '712', 'ID' => '736', 'BRIK OWNER' => 'Vidya Kadavath - jayan.machingal@gmail.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '1114530', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 965530', 'TOTAL INSTALLMENT PAID' => '965530', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '84470', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '108', 'REFERRAL DISCOUNT' => '0'),
	712 => array('S.NO.' => '713', 'ID' => '737', 'BRIK OWNER' => 'Vaishnavi Suresh - suresh60309kumar@gmail.com', 'UNIT NUMBER' => 'T8-506', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	713 => array('S.NO.' => '714', 'ID' => '738', 'BRIK OWNER' => 'Rakesh Semalty - rakeshsemalty@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Holiday Horizons Pvt Ltd', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4366E', 'CIN NO.' => 'U68100UP2024PTC205856', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '2025000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 1735000', 'TOTAL INSTALLMENT PAID' => '750000', 'TOTAL INSTALLMENT PENDING' => '985000', 'DISCOUNT ON BRIK' => '463454', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	714 => array('S.NO.' => '715', 'ID' => '739', 'BRIK OWNER' => 'Ruhi Garg - gargmudit86@gmail.com', 'UNIT NUMBER' => 'Galaxy 2705 - 202', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '729000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 630000', 'TOTAL INSTALLMENT PAID' => '330000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '124227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	715 => array('S.NO.' => '716', 'ID' => '740', 'BRIK OWNER' => 'Debabrata Chanda - dchanda@live.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040004', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '389000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 301965', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '301965', 'DISCOUNT ON BRIK' => '12090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	716 => array('S.NO.' => '717', 'ID' => '741', 'BRIK OWNER' => 'Puneet Sharma - Puneet.s0908@gmail.com', 'UNIT NUMBER' => 'T3-201', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '440000', 'TOTAL INSTALLMENT PENDING' => '160000', 'DISCOUNT ON BRIK' => '77791', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	717 => array('S.NO.' => '718', 'ID' => '742', 'BRIK OWNER' => 'Pratik Kumar Parida - pkp12397@rediffmail.com', 'UNIT NUMBER' => 'T1-111', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '250000', 'TOTAL INSTALLMENT PENDING' => '330000', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	718 => array('S.NO.' => '719', 'ID' => '743', 'BRIK OWNER' => 'Jahnavi Verma - cavipinverma@gmail.com', 'UNIT NUMBER' => 'T1-013', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '260000', 'TOTAL INSTALLMENT PENDING' => '290000', 'DISCOUNT ON BRIK' => '66182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	719 => array('S.NO.' => '720', 'ID' => '744', 'BRIK OWNER' => 'Sammarth . - santoshkumardarjee@gmail.com', 'UNIT NUMBER' => 'T1-111', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '240000', 'TOTAL INSTALLMENT PENDING' => '340000', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	720 => array('S.NO.' => '721', 'ID' => '745', 'BRIK OWNER' => 'Mohit Duggal - Duggal.nivea@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040004', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '389000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 290000', 'TOTAL INSTALLMENT PAID' => '115000', 'TOTAL INSTALLMENT PENDING' => '175000', 'DISCOUNT ON BRIK' => '12090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	721 => array('S.NO.' => '722', 'ID' => '746', 'BRIK OWNER' => 'Sapna Garg - rinkugarg1979@gmail.com', 'UNIT NUMBER' => 'Galaxy 2704 - 102', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '729000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 599530', 'TOTAL INSTALLMENT PAID' => '257530', 'TOTAL INSTALLMENT PENDING' => '342000', 'DISCOUNT ON BRIK' => '132227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	722 => array('S.NO.' => '723', 'ID' => '747', 'BRIK OWNER' => 'Lata Ravindra Mathur - Lata.m911@gmail.com', 'UNIT NUMBER' => 'T3- 503', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1149000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 1000000', 'TOTAL INSTALLMENT PAID' => '1000000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '127272', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '67', 'REFERRAL DISCOUNT' => '0'),
	723 => array('S.NO.' => '724', 'ID' => '748', 'BRIK OWNER' => 'Ritdhwaj Singh Chandel - ritdhwaj@gmail.com', 'UNIT NUMBER' => 'T5/704', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	724 => array('S.NO.' => '725', 'ID' => '749', 'BRIK OWNER' => 'Shri Yati Ideas LLP - yatishri.wealth@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Holiday Horizons Pvt Ltd', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4366E', 'CIN NO.' => 'U68100UP2024PTC205856', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '2050000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 1760000', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '1360000', 'DISCOUNT ON BRIK' => '438454', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	725 => array('S.NO.' => '726', 'ID' => '750', 'BRIK OWNER' => 'Amrish Kumar Sharma - amrishsharma1977@gmail.com', 'UNIT NUMBER' => 'T5-806', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '54', 'REFERRAL DISC' => '0', 'COIN' => '54', 'REFERRAL DISCOUNT' => '0'),
	726 => array('S.NO.' => '727', 'ID' => '751', 'BRIK OWNER' => 'Sanjay Baishya - sanjaybaishya07@gmail.com', 'UNIT NUMBER' => 'T3- 503', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1179000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 1030000', 'TOTAL INSTALLMENT PAID' => '1030000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '97272', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '67', 'REFERRAL DISCOUNT' => '0'),
	727 => array('S.NO.' => '728', 'ID' => '752', 'BRIK OWNER' => 'Dr. Khushboo Harsh Garg - khushboo.garg104@gmail.com', 'UNIT NUMBER' => 'A3', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Holiday Horizons Pvt Ltd', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4366E', 'CIN NO.' => 'U68100UP2024PTC205856', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '2000000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 1657800', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '1457800', 'DISCOUNT ON BRIK' => '488454', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	728 => array('S.NO.' => '729', 'ID' => '753', 'BRIK OWNER' => 'Meena Gupta - ervaibhav.gupta017@gmail.com', 'UNIT NUMBER' => 'T5-806', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '675000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 2 Installments) Amount: 576000', 'TOTAL INSTALLMENT PAID' => '576000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '63727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	729 => array('S.NO.' => '730', 'ID' => '754', 'BRIK OWNER' => 'Shashi S Vidyarthi - shashisvidyarthi@gmail.com', 'UNIT NUMBER' => 'T3- 503', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1149000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 1000000', 'TOTAL INSTALLMENT PAID' => '1000000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '127272', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '67', 'REFERRAL DISCOUNT' => '0'),
	730 => array('S.NO.' => '731', 'ID' => '755', 'BRIK OWNER' => 'Shelendra Pal Singh - yogaguru.shailendra@gmail.com', 'UNIT NUMBER' => 'T3- 503', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1149000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 1000000', 'TOTAL INSTALLMENT PAID' => '1000000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '127272', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '67', 'REFERRAL DISCOUNT' => '0'),
	731 => array('S.NO.' => '732', 'ID' => '756', 'BRIK OWNER' => 'Gauri Sumit Toke - tokegauri@gmail.com', 'UNIT NUMBER' => '505', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 634333', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '634333', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '0', 'REFERRAL DISCOUNT' => '0'),
	732 => array('S.NO.' => '733', 'ID' => '757', 'BRIK OWNER' => 'Pinki Chatterjee - chatterjee1984@gmail.com', 'UNIT NUMBER' => 'T1-111', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 559030', 'TOTAL INSTALLMENT PAID' => '249030', 'TOTAL INSTALLMENT PENDING' => '310000', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	733 => array('S.NO.' => '734', 'ID' => '758', 'BRIK OWNER' => 'Kaushik Palit - kaushikpalit21@gmail.com', 'UNIT NUMBER' => 'T1-111', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '16182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	734 => array('S.NO.' => '735', 'ID' => '759', 'BRIK OWNER' => 'Kalpana Palit - prabhat.palit@gmail.com', 'UNIT NUMBER' => 'T3- 503', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1163030', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 1014030', 'TOTAL INSTALLMENT PAID' => '1014030', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '113242', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '67', 'REFERRAL DISCOUNT' => '0'),
	735 => array('S.NO.' => '736', 'ID' => '760', 'BRIK OWNER' => 'Sameer Sud HUF - sameersud@yahoo.com', 'UNIT NUMBER' => 'T3- 503', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1149000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 1000000', 'TOTAL INSTALLMENT PAID' => '800000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '127272', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '67', 'REFERRAL DISCOUNT' => '0'),
	736 => array('S.NO.' => '737', 'ID' => '761', 'BRIK OWNER' => 'Vijay Sudeepthi Padma - tosudeepthi@gmail.com', 'UNIT NUMBER' => 'Row-8/B-304', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '57000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	737 => array('S.NO.' => '738', 'ID' => '762', 'BRIK OWNER' => 'Sucharita Bakshi - Rabinarayan_dash@yahoo.co.in', 'UNIT NUMBER' => 'T1-111', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 559630', 'TOTAL INSTALLMENT PAID' => '159630', 'TOTAL INSTALLMENT PENDING' => '400000', 'DISCOUNT ON BRIK' => '36182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	738 => array('S.NO.' => '739', 'ID' => '763', 'BRIK OWNER' => 'Anoop Vyas - anoopvyas476@gmail.com', 'UNIT NUMBER' => 'T3- 503', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1199000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 1014030', 'TOTAL INSTALLMENT PAID' => '1014030', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '77272', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '67', 'REFERRAL DISCOUNT' => '0'),
	739 => array('S.NO.' => '740', 'ID' => '764', 'BRIK OWNER' => 'Grantha Sarvesh Nayak - nayaksarvesh@gmail.com', 'UNIT NUMBER' => 'Row-6/Block4/A-402', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '230000', 'TOTAL INSTALLMENT PENDING' => '320000', 'DISCOUNT ON BRIK' => '50000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	740 => array('S.NO.' => '741', 'ID' => '765', 'BRIK OWNER' => 'Parthasarathi Adak - adakda@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040004', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '389000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 290000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '290000', 'DISCOUNT ON BRIK' => '12090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	741 => array('S.NO.' => '742', 'ID' => '766', 'BRIK OWNER' => 'Santosh Kumar - santoshkumar180385@gmail.com', 'UNIT NUMBER' => 'Row-8/B-304', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '400000', 'DISCOUNT ON BRIK' => '57000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	742 => array('S.NO.' => '743', 'ID' => '767', 'BRIK OWNER' => 'Dr Sandip Kumar Nath - sandipnathin1996@gmail.com', 'UNIT NUMBER' => 'T1-111', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '689000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 590000', 'TOTAL INSTALLMENT PAID' => '210000', 'TOTAL INSTALLMENT PENDING' => '380000', 'DISCOUNT ON BRIK' => '26182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	743 => array('S.NO.' => '744', 'ID' => '768', 'BRIK OWNER' => 'Pranjali Nautiyal - pranjalin3@gmail.com', 'UNIT NUMBER' => 'T3- 503', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1199000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 1050000', 'TOTAL INSTALLMENT PAID' => '1050000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '77272', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '67', 'REFERRAL DISCOUNT' => '0'),
	744 => array('S.NO.' => '745', 'ID' => '769', 'BRIK OWNER' => 'Chayan Roy - contactchayan@yahoo.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '1149000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 1000000', 'TOTAL INSTALLMENT PAID' => '1000000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '50000', 'COINS' => '102', 'REFERRAL DISC' => '0', 'COIN' => '102', 'REFERRAL DISCOUNT' => '0'),
	745 => array('S.NO.' => '746', 'ID' => '770', 'BRIK OWNER' => 'Sucharita Bakshi - Rabinarayan_dash@yahoo.co.in', 'UNIT NUMBER' => 'T7- 807', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 559630', 'TOTAL INSTALLMENT PAID' => '479630', 'TOTAL INSTALLMENT PENDING' => '80000', 'DISCOUNT ON BRIK' => '59727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '45', 'REFERRAL DISCOUNT' => '0'),
	746 => array('S.NO.' => '747', 'ID' => '771', 'BRIK OWNER' => 'Mita Roy Adak - mitaroy9@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040004', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '389000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 290000', 'TOTAL INSTALLMENT PAID' => '115000', 'TOTAL INSTALLMENT PENDING' => '175000', 'DISCOUNT ON BRIK' => '12090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	747 => array('S.NO.' => '748', 'ID' => '772', 'BRIK OWNER' => 'Kalpana Palit - prabhat.palit@gmail.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Mountain Heritage Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AARCM3870G', 'CIN NO.' => 'U68100UP2023PTC190853', 'BRIK VALUE' => '2488454', 'INVESTMENT AMOUNT' => '2090000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 1800000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1800000', 'DISCOUNT ON BRIK' => '398454', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	748 => array('S.NO.' => '749', 'ID' => '773', 'BRIK OWNER' => 'Pratibha Singh - pratibhasingh113@gmail.com', 'UNIT NUMBER' => 'Galaxy 2706 - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '250000', 'TOTAL INSTALLMENT PENDING' => '350000', 'DISCOUNT ON BRIK' => '154227', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	749 => array('S.NO.' => '750', 'ID' => '774', 'BRIK OWNER' => 'Praveen Shukla - praveenshuklahri@gmail.com', 'UNIT NUMBER' => 'T7- 807', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '45', 'REFERRAL DISCOUNT' => '0'),
	750 => array('S.NO.' => '751', 'ID' => '775', 'BRIK OWNER' => 'Amit Gupta - Amitgupta.texmo@gmail.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '1099000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 1 Installments) Amount: 950000', 'TOTAL INSTALLMENT PAID' => '950000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '100000', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '120', 'REFERRAL DISCOUNT' => '0'),
	751 => array('S.NO.' => '752', 'ID' => '776', 'BRIK OWNER' => 'Sandeep Mehta - sandeepmehta67@gmail.com', 'UNIT NUMBER' => 'T3- 503', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1149000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 1000000', 'TOTAL INSTALLMENT PAID' => '900000', 'TOTAL INSTALLMENT PENDING' => '100000', 'DISCOUNT ON BRIK' => '127272', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '67', 'REFERRAL DISCOUNT' => '0'),
	752 => array('S.NO.' => '753', 'ID' => '777', 'BRIK OWNER' => 'Joseph Pallath - josephpallath@gmail.com', 'UNIT NUMBER' => 'T7- 807', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '580000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '59727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '45', 'REFERRAL DISCOUNT' => '0'),
	753 => array('S.NO.' => '754', 'ID' => '778', 'BRIK OWNER' => 'Manoj Soni - kanchanmanojsoni@gmail.com', 'UNIT NUMBER' => 'Galaxy 2706 - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '650000', 'DISCOUNT ON BRIK' => '104227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	754 => array('S.NO.' => '755', 'ID' => '779', 'BRIK OWNER' => 'Ramalakshmi Ravichandran - psravichandran67@yahoo.com', 'UNIT NUMBER' => 'T4-304', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SE2BR SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6092B', 'CIN NO.' => 'U70109UP2022PTC157704', 'BRIK VALUE' => '1019909', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '400000', 'DISCOUNT ON BRIK' => '70909', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	755 => array('S.NO.' => '756', 'ID' => '780', 'BRIK OWNER' => 'Jayasree Chatterjee - shibjoychat@gmail.com', 'UNIT NUMBER' => 'T1-110', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '280000', 'TOTAL INSTALLMENT PENDING' => '320000', 'DISCOUNT ON BRIK' => '54909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	756 => array('S.NO.' => '757', 'ID' => '781', 'BRIK OWNER' => 'Satyanarayan Padhan - satya.padhan@gmail.com', 'UNIT NUMBER' => 'T1-110', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '230000', 'TOTAL INSTALLMENT PENDING' => '370000', 'DISCOUNT ON BRIK' => '54909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	757 => array('S.NO.' => '758', 'ID' => '782', 'BRIK OWNER' => 'GANESHKUMAR RAJARAM - glencydocmra1@gmail.com', 'UNIT NUMBER' => 'Row-8/B-304', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '940000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 821600', 'TOTAL INSTALLMENT PAID' => '100000', 'TOTAL INSTALLMENT PENDING' => '721600', 'DISCOUNT ON BRIK' => '66000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	758 => array('S.NO.' => '759', 'ID' => '783', 'BRIK OWNER' => 'Durgesh Chandan - durgesh.chandan@yahoo.co.in', 'UNIT NUMBER' => 'T7- 401', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 2 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	759 => array('S.NO.' => '760', 'ID' => '784', 'BRIK OWNER' => 'Ponnien Selvi Ramesh - thedarklord160694@gmail.com', 'UNIT NUMBER' => 'Galaxy 2706 - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '480000', 'TOTAL INSTALLMENT PENDING' => '170000', 'DISCOUNT ON BRIK' => '104227', 'COINS' => '210', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	760 => array('S.NO.' => '761', 'ID' => '785', 'BRIK OWNER' => 'GARIMA BARANWAL - Garimaamul@gmail.com', 'UNIT NUMBER' => 'T7- 807', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '45', 'REFERRAL DISCOUNT' => '0'),
	761 => array('S.NO.' => '762', 'ID' => '786', 'BRIK OWNER' => 'Amit Sharma - amit_k_s@live.com', 'UNIT NUMBER' => 'T1-110', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '689000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 590000', 'TOTAL INSTALLMENT PAID' => '210000', 'TOTAL INSTALLMENT PENDING' => '380000', 'DISCOUNT ON BRIK' => '64909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	762 => array('S.NO.' => '763', 'ID' => '787', 'BRIK OWNER' => 'Yeddula Samarateja Reddy - samaratejar@gmail.com', 'UNIT NUMBER' => 'T1-111', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '678030', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 579030', 'TOTAL INSTALLMENT PAID' => '260000', 'TOTAL INSTALLMENT PENDING' => '319030', 'DISCOUNT ON BRIK' => '75879', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	763 => array('S.NO.' => '764', 'ID' => '788', 'BRIK OWNER' => 'Yeddula Samarateja Reddy - samaratejar@gmail.com', 'UNIT NUMBER' => 'Galaxy 2706 - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '410000', 'TOTAL INSTALLMENT PENDING' => '240000', 'DISCOUNT ON BRIK' => '104227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	764 => array('S.NO.' => '765', 'ID' => '789', 'BRIK OWNER' => 'Yeddula Samarateja Reddy - samaratejar@gmail.com', 'UNIT NUMBER' => 'Unit number - 7', 'PROJECT' => 'Golden Sands', 'SPV' => 'ARO 2 BHK SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA7827N', 'CIN NO.' => 'U74999UP2022PTC161905', 'BRIK VALUE' => '2626182', 'INVESTMENT AMOUNT' => '2290000', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 2000000', 'TOTAL INSTALLMENT PAID' => '1200000', 'TOTAL INSTALLMENT PENDING' => '800000', 'DISCOUNT ON BRIK' => '336182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	765 => array('S.NO.' => '766', 'ID' => '790', 'BRIK OWNER' => 'Rohit Kumar Mangal - advocatemangal2005@gmail.com', 'UNIT NUMBER' => 'Galaxy 2703 - 301', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '650000', 'DISCOUNT ON BRIK' => '104227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	766 => array('S.NO.' => '767', 'ID' => '791', 'BRIK OWNER' => 'Rahul Sharma - rahul22269@gmail.com', 'UNIT NUMBER' => 'T1-110', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '380000', 'DISCOUNT ON BRIK' => '74909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	767 => array('S.NO.' => '768', 'ID' => '792', 'BRIK OWNER' => 'Amaresh Mishra - amaresh33@gmail.com', 'UNIT NUMBER' => '705', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '60', 'REFERRAL DISCOUNT' => '0'),
	768 => array('S.NO.' => '769', 'ID' => '793', 'BRIK OWNER' => 'Vinod Kumar - vk669078@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '1149000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 1072828', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1072828', 'DISCOUNT ON BRIK' => '50000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	769 => array('S.NO.' => '770', 'ID' => '794', 'BRIK OWNER' => 'Rahasyamayee Giri - laxyaenagic@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040005', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 290924', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '290924', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	770 => array('S.NO.' => '771', 'ID' => '795', 'BRIK OWNER' => 'Chhaya Soni - manojsoni997@yahoo.in', 'UNIT NUMBER' => 'Row-8/B-304', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 777530', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '777530', 'DISCOUNT ON BRIK' => '57000', 'COINS' => '0', 'REFERRAL DISC' => '22470', 'COIN' => '', 'REFERRAL DISCOUNT' => '22470'),
	771 => array('S.NO.' => '772', 'ID' => '796', 'BRIK OWNER' => 'Pankaj Atri - pankajatri83@gmail.com', 'UNIT NUMBER' => 'T3- 503', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1276272', 'INVESTMENT AMOUNT' => '1119000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 2 Installments) Amount: 970000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '470000', 'DISCOUNT ON BRIK' => '157272', 'COINS' => '100', 'REFERRAL DISC' => '0', 'COIN' => '187', 'REFERRAL DISCOUNT' => '0'),
	772 => array('S.NO.' => '773', 'ID' => '797', 'BRIK OWNER' => 'Aniruddha Yadav - aniruddha.here@icloud.com', 'UNIT NUMBER' => 'Row-8/B-304', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '400000', 'DISCOUNT ON BRIK' => '107181', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	773 => array('S.NO.' => '774', 'ID' => '798', 'BRIK OWNER' => 'Mukesh Kumar Aggarwal - marblecity2011@gmail.com', 'UNIT NUMBER' => 'T1-110', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 598727', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '598727', 'DISCOUNT ON BRIK' => '74909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	774 => array('S.NO.' => '775', 'ID' => '799', 'BRIK OWNER' => 'Choudhury Sephali Dash - sephalidash09@gmail.com', 'UNIT NUMBER' => 'T1-111', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '400000', 'DISCOUNT ON BRIK' => '74909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	775 => array('S.NO.' => '776', 'ID' => '800', 'BRIK OWNER' => 'Sandip Kumar Dhar - sandipkrdhar@yahoo.co.in', 'UNIT NUMBER' => 'Tower Tulip - VA 040004', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '401090', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 302090', 'TOTAL INSTALLMENT PAID' => '90000', 'TOTAL INSTALLMENT PENDING' => '212090', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	776 => array('S.NO.' => '777', 'ID' => '801', 'BRIK OWNER' => 'Prangya Padmini Pati - Pati.prangyapadmini@gmail.com', 'UNIT NUMBER' => 'T1-110', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '430000', 'DISCOUNT ON BRIK' => '74909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	777 => array('S.NO.' => '778', 'ID' => '802', 'BRIK OWNER' => 'Rupali Vikram Pingale - rupalipeer@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1350000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1201000', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '901000', 'DISCOUNT ON BRIK' => '300363', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	778 => array('S.NO.' => '779', 'ID' => '803', 'BRIK OWNER' => 'Ravi Mohan Khanna - ravikhanna1205@gmail.com', 'UNIT NUMBER' => 'T4-304', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SE2BR SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6092B', 'CIN NO.' => 'U70109UP2022PTC157704', 'BRIK VALUE' => '1019909', 'INVESTMENT AMOUNT' => '929000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 780000', 'TOTAL INSTALLMENT PAID' => '220000', 'TOTAL INSTALLMENT PENDING' => '560000', 'DISCOUNT ON BRIK' => '90909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	779 => array('S.NO.' => '780', 'ID' => '804', 'BRIK OWNER' => 'Choudhury Sephali Dash - sephalidash09@gmail.com', 'UNIT NUMBER' => 'T7- 807', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '180000', 'DISCOUNT ON BRIK' => '59727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '0', 'REFERRAL DISCOUNT' => '0'),
	780 => array('S.NO.' => '781', 'ID' => '805', 'BRIK OWNER' => 'Sujata Das - sanjaykumarpatra.adv@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1369000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 1220000', 'TOTAL INSTALLMENT PAID' => '75000', 'TOTAL INSTALLMENT PENDING' => '1145000', 'DISCOUNT ON BRIK' => '281363', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	781 => array('S.NO.' => '782', 'ID' => '806', 'BRIK OWNER' => 'Rajashree Patra - niharkantapatra640@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1369000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 1220000', 'TOTAL INSTALLMENT PAID' => '75000', 'TOTAL INSTALLMENT PENDING' => '1145000', 'DISCOUNT ON BRIK' => '281363', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	782 => array('S.NO.' => '783', 'ID' => '807', 'BRIK OWNER' => 'SAMEEKSHA MAURYA - sameeksha.pkg@gmail.com', 'UNIT NUMBER' => 'T7- 807', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '669000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 570000', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '170000', 'DISCOUNT ON BRIK' => '69727', 'COINS' => '32', 'REFERRAL DISC' => '0', 'COIN' => '45', 'REFERRAL DISCOUNT' => '0'),
	783 => array('S.NO.' => '784', 'ID' => '808', 'BRIK OWNER' => 'Sunita Devi - madhusahu9399459399@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040004', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '389000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 290000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '290000', 'DISCOUNT ON BRIK' => '12090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	784 => array('S.NO.' => '785', 'ID' => '809', 'BRIK OWNER' => 'Shevetambri Udehan - u.sheveta@gmail.com', 'UNIT NUMBER' => 'In Process 1', 'PROJECT' => 'The Vilasya', 'SPV' => 'Leisure Haven Homes Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAFCL8923R', 'CIN NO.' => 'U68100UP2024PTC205620', 'BRIK VALUE' => '3301636', 'INVESTMENT AMOUNT' => '2690000', 'BOOKING AMOUNT PAID' => '249000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 2441000', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '2141000', 'DISCOUNT ON BRIK' => '611636', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	785 => array('S.NO.' => '786', 'ID' => '810', 'BRIK OWNER' => 'Smrutimayee Sahoo - smrutimayeesahoo91@gmail.com', 'UNIT NUMBER' => 'T1-110', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '580000', 'DISCOUNT ON BRIK' => '74910', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	786 => array('S.NO.' => '787', 'ID' => '811', 'BRIK OWNER' => 'Archna Yadav - vikas3361@yahoo.com', 'UNIT NUMBER' => 'Galaxy 2706 - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '500000', 'DISCOUNT ON BRIK' => '159000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	787 => array('S.NO.' => '788', 'ID' => '812', 'BRIK OWNER' => 'Rupesh Kumar - km.rupesh@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '1089000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 1037798', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1037798', 'DISCOUNT ON BRIK' => '248990', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	788 => array('S.NO.' => '789', 'ID' => '813', 'BRIK OWNER' => 'Tanuja Gahtori - jitendra1984@outlook.com', 'UNIT NUMBER' => 'Galaxy 2706 - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '220000', 'TOTAL INSTALLMENT PENDING' => '430000', 'DISCOUNT ON BRIK' => '159000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	789 => array('S.NO.' => '790', 'ID' => '814', 'BRIK OWNER' => 'Sonam Goel - emayank25@gmail.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '1129000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 980000', 'TOTAL INSTALLMENT PAID' => '980000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '112', 'REFERRAL DISCOUNT' => '0'),
	790 => array('S.NO.' => '791', 'ID' => '815', 'BRIK OWNER' => 'Anand Narayanan - Anand.narayananks@gmail.com', 'UNIT NUMBER' => 'Galaxy 2706 - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '260000', 'TOTAL INSTALLMENT PENDING' => '390000', 'DISCOUNT ON BRIK' => '159000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	791 => array('S.NO.' => '792', 'ID' => '816', 'BRIK OWNER' => 'Jyoti S Shukla - jyotishukla199798@gmail.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '1149000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 1000000', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '188990', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '110', 'REFERRAL DISCOUNT' => '0'),
	792 => array('S.NO.' => '793', 'ID' => '817', 'BRIK OWNER' => 'Biplab Sai Behera - biplabsaibehera@gmail.com', 'UNIT NUMBER' => 'T1-110', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '450000', 'DISCOUNT ON BRIK' => '54910', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	793 => array('S.NO.' => '794', 'ID' => '818', 'BRIK OWNER' => 'Santosh Kumar Arya - santosh00140@gmail.com', 'UNIT NUMBER' => 'Galaxy 2706 - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '650000', 'DISCOUNT ON BRIK' => '159000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	794 => array('S.NO.' => '795', 'ID' => '819', 'BRIK OWNER' => 'Sujata Das - sanjaykumarpatra.adv@gmail.com', 'UNIT NUMBER' => 'T1-1205', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '400000', 'DISCOUNT ON BRIK' => '74909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	795 => array('S.NO.' => '796', 'ID' => '820', 'BRIK OWNER' => 'Komma Sivakumar Reddy - sivakumarreddy.komma@gmail.com', 'UNIT NUMBER' => 'T7- 807', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 5 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '500000', 'TOTAL INSTALLMENT PENDING' => '80000', 'DISCOUNT ON BRIK' => '59727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '45', 'REFERRAL DISCOUNT' => '0'),
	796 => array('S.NO.' => '797', 'ID' => '821', 'BRIK OWNER' => 'Mandarapu Srinivas - msrinuhyd@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040005', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 280000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '280000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	797 => array('S.NO.' => '798', 'ID' => '822', 'BRIK OWNER' => 'Niti Vardhan Sharma - ritesh.rgpsa@gmail.com', 'UNIT NUMBER' => 'Galaxy 2706 - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '450000', 'DISCOUNT ON BRIK' => '209000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	798 => array('S.NO.' => '799', 'ID' => '823', 'BRIK OWNER' => 'Gurumoorthy . - garudavahana.narayana@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040003', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '401090', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 302090', 'TOTAL INSTALLMENT PAID' => '90000', 'TOTAL INSTALLMENT PENDING' => '212090', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	799 => array('S.NO.' => '800', 'ID' => '824', 'BRIK OWNER' => 'Shevetambri Udehan - u.sheveta@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040005', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 280000', 'TOTAL INSTALLMENT PAID' => '105000', 'TOTAL INSTALLMENT PENDING' => '175000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	800 => array('S.NO.' => '801', 'ID' => '825', 'BRIK OWNER' => 'Pradeep Kandpal - pradeeppcb005@gmail.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '1129000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 980000', 'TOTAL INSTALLMENT PAID' => '980000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '208990', 'COINS' => '110', 'REFERRAL DISC' => '0', 'COIN' => '110', 'REFERRAL DISCOUNT' => '0'),
	801 => array('S.NO.' => '802', 'ID' => '826', 'BRIK OWNER' => 'Suneet Gyani - Suneetgyani@gmail.com', 'UNIT NUMBER' => 'Row Villa No. 2', 'PROJECT' => 'MVR Casa Villa', 'SPV' => 'LUXE CA VILLA 3BHK PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAECL9764D', 'CIN NO.' => 'U70109UP2022PTC161805', 'BRIK VALUE' => '3243636', 'INVESTMENT AMOUNT' => '2947800', 'BOOKING AMOUNT PAID' => '290000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 2657800', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '2657800', 'DISCOUNT ON BRIK' => '295836', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '0', 'REFERRAL DISCOUNT' => '0'),
	802 => array('S.NO.' => '803', 'ID' => '827', 'BRIK OWNER' => 'Honey Sharma - prashantsharma77@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040003', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '389000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 290000', 'TOTAL INSTALLMENT PAID' => '90000', 'TOTAL INSTALLMENT PENDING' => '200000', 'DISCOUNT ON BRIK' => '12090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	803 => array('S.NO.' => '804', 'ID' => '828', 'BRIK OWNER' => 'Sumant Kumar Diwakar - sumantdiwakar@gmail.com', 'UNIT NUMBER' => 'T1-110', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '450000', 'DISCOUNT ON BRIK' => '54909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	804 => array('S.NO.' => '805', 'ID' => '829', 'BRIK OWNER' => 'Kirtikumar Bhikhabhai Bheda - bhedakirti@gmail.com', 'UNIT NUMBER' => 'T7-701', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => 'NOT LIVE', 'REFERRAL DISCOUNT' => '0'),
	805 => array('S.NO.' => '806', 'ID' => '830', 'BRIK OWNER' => 'Hanuwant Singh Amarawat HUF - hanuwantsinghamarawat@gmail.com', 'UNIT NUMBER' => 'Galaxy 2706 - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '759000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 710000', 'TOTAL INSTALLMENT PAID' => '290000', 'TOTAL INSTALLMENT PENDING' => '420000', 'DISCOUNT ON BRIK' => '149000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	806 => array('S.NO.' => '807', 'ID' => '831', 'BRIK OWNER' => 'Siva Kumar Veparala - sivakumar.shreya@gmail.com', 'UNIT NUMBER' => 'Galaxy 2706 - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '650000', 'DISCOUNT ON BRIK' => '159000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	807 => array('S.NO.' => '808', 'ID' => '832', 'BRIK OWNER' => 'Sanjeev Kumar - Himpowergroup@gmail.com', 'UNIT NUMBER' => 'T7- 807', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '45', 'REFERRAL DISCOUNT' => '0'),
	808 => array('S.NO.' => '809', 'ID' => '833', 'BRIK OWNER' => 'Neeraj Kumar - Neerajsuryan11@gmail.com', 'UNIT NUMBER' => 'Galaxy 2704 - 102', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '650000', 'DISCOUNT ON BRIK' => '104227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	809 => array('S.NO.' => '810', 'ID' => '834', 'BRIK OWNER' => 'Subham Sharma - subbham2295@gmail.com', 'UNIT NUMBER' => 'T1-110', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '100000', 'TOTAL INSTALLMENT PENDING' => '480000', 'DISCOUNT ON BRIK' => '74909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	810 => array('S.NO.' => '811', 'ID' => '835', 'BRIK OWNER' => 'Rachna A Shah - rachanashahrapheal10@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1369000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 1220000', 'TOTAL INSTALLMENT PAID' => '75000', 'TOTAL INSTALLMENT PENDING' => '1145000', 'DISCOUNT ON BRIK' => '', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	811 => array('S.NO.' => '812', 'ID' => '836', 'BRIK OWNER' => 'Ashiesh Arora Huf - ashiesh3006@rediffmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1339000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1190000', 'TOTAL INSTALLMENT PAID' => '270000', 'TOTAL INSTALLMENT PENDING' => '920000', 'DISCOUNT ON BRIK' => '311363', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	812 => array('S.NO.' => '813', 'ID' => '837', 'BRIK OWNER' => 'Khushboo Gupta - guptaankur2007@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1349000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1200000', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '1000000', 'DISCOUNT ON BRIK' => '301363', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	813 => array('S.NO.' => '814', 'ID' => '838', 'BRIK OWNER' => 'Amit R Goswami - amit21980@yahoo.co.in', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1369000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1220000', 'TOTAL INSTALLMENT PAID' => '100000', 'TOTAL INSTALLMENT PENDING' => '1120000', 'DISCOUNT ON BRIK' => '281363', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	814 => array('S.NO.' => '815', 'ID' => '839', 'BRIK OWNER' => 'Shwetha Mruthyunjaya - Mshwetha2020@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1369000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 1220000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1220000', 'DISCOUNT ON BRIK' => '281363', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	815 => array('S.NO.' => '816', 'ID' => '840', 'BRIK OWNER' => 'Akhilesh Rajput - rajputakhilesh1997@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1369000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1220000', 'TOTAL INSTALLMENT PAID' => '100000', 'TOTAL INSTALLMENT PENDING' => '1120000', 'DISCOUNT ON BRIK' => '281363', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	816 => array('S.NO.' => '817', 'ID' => '841', 'BRIK OWNER' => 'Sameer Sud HUF - sameersud@yahoo.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1369000', 'BOOKING AMOUNT PAID' => '148540', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 1220000', 'TOTAL INSTALLMENT PAID' => '75000', 'TOTAL INSTALLMENT PENDING' => '1145000', 'DISCOUNT ON BRIK' => '281363', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	817 => array('S.NO.' => '818', 'ID' => '842', 'BRIK OWNER' => 'Mohini Puri - Atri12mohini@gmail.com', 'UNIT NUMBER' => 'In Process 1', 'PROJECT' => 'The Vilasya', 'SPV' => 'Leisure Haven Homes Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAFCL8923R', 'CIN NO.' => 'U68100UP2024PTC205620', 'BRIK VALUE' => '3301636', 'INVESTMENT AMOUNT' => '2550000', 'BOOKING AMOUNT PAID' => '249000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 2301000', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '1901000', 'DISCOUNT ON BRIK' => '751636', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	818 => array('S.NO.' => '819', 'ID' => '843', 'BRIK OWNER' => 'Rajan Singh - rjnsingh10@gmail.com', 'UNIT NUMBER' => 'In Process 1', 'PROJECT' => 'The Vilasya', 'SPV' => 'Leisure Haven Homes Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAFCL8923R', 'CIN NO.' => 'U68100UP2024PTC205620', 'BRIK VALUE' => '3301636', 'INVESTMENT AMOUNT' => '2749000', 'BOOKING AMOUNT PAID' => '249000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 2500000', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '2300000', 'DISCOUNT ON BRIK' => '552636', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	819 => array('S.NO.' => '820', 'ID' => '844', 'BRIK OWNER' => 'Anirudh Choudhary - ani0020.ac@gmail.com', 'UNIT NUMBER' => 'In Process 1', 'PROJECT' => 'The Vilasya', 'SPV' => 'Leisure Haven Homes Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAFCL8923R', 'CIN NO.' => 'U68100UP2024PTC205620', 'BRIK VALUE' => '3301636', 'INVESTMENT AMOUNT' => '2690000', 'BOOKING AMOUNT PAID' => '249000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 2441000', 'TOTAL INSTALLMENT PAID' => '600000', 'TOTAL INSTALLMENT PENDING' => '1841000', 'DISCOUNT ON BRIK' => '611636', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	820 => array('S.NO.' => '821', 'ID' => '845', 'BRIK OWNER' => 'Gurumoorthy . - garudavahana.narayana@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1369000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1220000', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '920000', 'DISCOUNT ON BRIK' => '281363', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	821 => array('S.NO.' => '822', 'ID' => '846', 'BRIK OWNER' => 'Shaurya Raj Gupta - shaurya8april@gmail.com', 'UNIT NUMBER' => 'In Process 1', 'PROJECT' => 'The Vilasya', 'SPV' => 'Leisure Haven Homes Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAFCL8923R', 'CIN NO.' => 'U68100UP2024PTC205620', 'BRIK VALUE' => '3301636', 'INVESTMENT AMOUNT' => '2600000', 'BOOKING AMOUNT PAID' => '249000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 2351000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '2351000', 'DISCOUNT ON BRIK' => '701636', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	822 => array('S.NO.' => '823', 'ID' => '847', 'BRIK OWNER' => 'Purushottam Modani - purumodani7@gmail.com', 'UNIT NUMBER' => 'In Process 1', 'PROJECT' => 'The Vilasya', 'SPV' => 'Leisure Haven Homes Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAFCL8923R', 'CIN NO.' => 'U68100UP2024PTC205620', 'BRIK VALUE' => '3301636', 'INVESTMENT AMOUNT' => '2550000', 'BOOKING AMOUNT PAID' => '249000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 2301000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '2301000', 'DISCOUNT ON BRIK' => '751636', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	823 => array('S.NO.' => '824', 'ID' => '848', 'BRIK OWNER' => 'Ashok Kumar - Ashokgoyal660@gmail.com', 'UNIT NUMBER' => 'Apex - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Skylevels Stay Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7104J', 'CIN NO.' => 'U68100UP2025PTC219822', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '650000', 'DISCOUNT ON BRIK' => '104227', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	824 => array('S.NO.' => '825', 'ID' => '849', 'BRIK OWNER' => 'Shweta Diwakar - diwakarshweta26@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040004', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 280000', 'TOTAL INSTALLMENT PAID' => '105000', 'TOTAL INSTALLMENT PENDING' => '175000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	825 => array('S.NO.' => '826', 'ID' => '850', 'BRIK OWNER' => 'Pradeep Kumar Barla - pradeepkumarbarla@yahoo.co.in', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1369000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 1220000', 'TOTAL INSTALLMENT PAID' => '100000', 'TOTAL INSTALLMENT PENDING' => '1120000', 'DISCOUNT ON BRIK' => '281363', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	826 => array('S.NO.' => '827', 'ID' => '851', 'BRIK OWNER' => 'Kshitish Kumar Dutta - khitishbdk1975@gmail.com', 'UNIT NUMBER' => 'T1-1114', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '280000', 'TOTAL INSTALLMENT PENDING' => '320000', 'DISCOUNT ON BRIK' => '54909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	827 => array('S.NO.' => '828', 'ID' => '852', 'BRIK OWNER' => 'T Surendran Menon - sunil0505@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1369000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1220000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1220000', 'DISCOUNT ON BRIK' => '281363', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	828 => array('S.NO.' => '829', 'ID' => '853', 'BRIK OWNER' => 'Neha Chaudhary - iitraja2204@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1369000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1220000', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '1020000', 'DISCOUNT ON BRIK' => '281363', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	829 => array('S.NO.' => '830', 'ID' => '854', 'BRIK OWNER' => 'Rajashree Roy - rajashre.roy@gmail.com', 'UNIT NUMBER' => 'T1-1114', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '676569', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 577569', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '577569', 'DISCOUNT ON BRIK' => '77341', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	830 => array('S.NO.' => '831', 'ID' => '855', 'BRIK OWNER' => 'Santosh Kumar Dash - santoshdash@rediffmail.com', 'UNIT NUMBER' => 'T1-1114', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '180000', 'TOTAL INSTALLMENT PENDING' => '400000', 'DISCOUNT ON BRIK' => '74909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	831 => array('S.NO.' => '832', 'ID' => '856', 'BRIK OWNER' => 'Aaryaman Tanwar - verma.kapil@gmail.com', 'UNIT NUMBER' => 'T4-304', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SE2BR SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6092B', 'CIN NO.' => 'U70109UP2022PTC157704', 'BRIK VALUE' => '1019909', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '800000', 'DISCOUNT ON BRIK' => '70909', 'COINS' => '110', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	832 => array('S.NO.' => '833', 'ID' => '857', 'BRIK OWNER' => 'Sonali Mahesh Jalgar - sonalimj15@gmail.com', 'UNIT NUMBER' => 'Row-8/B-304', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '107181', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	833 => array('S.NO.' => '834', 'ID' => '858', 'BRIK OWNER' => 'Suresh Kumar - sureshkumarsingh2907@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1369000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1220000', 'TOTAL INSTALLMENT PAID' => '100000', 'TOTAL INSTALLMENT PENDING' => '1120000', 'DISCOUNT ON BRIK' => '281363', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	834 => array('S.NO.' => '835', 'ID' => '859', 'BRIK OWNER' => 'Susanta Kumar Senapati - senapati.sk@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040003', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '389000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 290000', 'TOTAL INSTALLMENT PAID' => '70000', 'TOTAL INSTALLMENT PENDING' => '220000', 'DISCOUNT ON BRIK' => '12090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	835 => array('S.NO.' => '836', 'ID' => '860', 'BRIK OWNER' => 'Santosh Kumar Sethi - er.sksethicivil@gmail.com', 'UNIT NUMBER' => 'T1-1114', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '100000', 'TOTAL INSTALLMENT PENDING' => '500000', 'DISCOUNT ON BRIK' => '54909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	836 => array('S.NO.' => '837', 'ID' => '861', 'BRIK OWNER' => 'Anirudh Choudhary - ani0020.ac@gmail.com', 'UNIT NUMBER' => 'T1-1114', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '70000', 'TOTAL INSTALLMENT PENDING' => '530000', 'DISCOUNT ON BRIK' => '54909', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	837 => array('S.NO.' => '838', 'ID' => '862', 'BRIK OWNER' => 'Tonika Jain - roshandtn@yahoo.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1300000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1151000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1151000', 'DISCOUNT ON BRIK' => '350363', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	838 => array('S.NO.' => '839', 'ID' => '863', 'BRIK OWNER' => 'Vikash Kumar Pandey - Vikashkrpandey@rediffmail.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '1099000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 950000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '950000', 'DISCOUNT ON BRIK' => '238990', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '0', 'REFERRAL DISCOUNT' => '0'),
	839 => array('S.NO.' => '840', 'ID' => '864', 'BRIK OWNER' => 'Nayan Thapar - rajan.thapar@gmail.com', 'UNIT NUMBER' => 'Tower-8-0304 3rd Floor', 'PROJECT' => 'Rio De Goa', 'SPV' => 'BRIKITT RIO PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AABCZ6471G', 'CIN NO.' => 'U93090UP2020PTC138840', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '1149000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 1000000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1000000', 'DISCOUNT ON BRIK' => '27000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '0', 'REFERRAL DISCOUNT' => '0'),
	840 => array('S.NO.' => '841', 'ID' => '865', 'BRIK OWNER' => 'Aaryaman Tanwar - verma.kapil@gmail.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '1129000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 980000', 'TOTAL INSTALLMENT PAID' => '980000', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '208990', 'COINS' => '110', 'REFERRAL DISC' => '0', 'COIN' => '110', 'REFERRAL DISCOUNT' => '0'),
	841 => array('S.NO.' => '842', 'ID' => '866', 'BRIK OWNER' => 'Nagarjuna Reddy Kamireddy - nagarjuna.k@icloud.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040003', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 280000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '280000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '50', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	842 => array('S.NO.' => '843', 'ID' => '867', 'BRIK OWNER' => 'Munmun Chatterjee - psc2107@gmail.com', 'UNIT NUMBER' => 'T1-1114', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '380000', 'DISCOUNT ON BRIK' => '74909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	843 => array('S.NO.' => '844', 'ID' => '868', 'BRIK OWNER' => 'Ranjiv Kumar - ranjivgoyal@yahoo.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1272180', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1123180', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '923180', 'DISCOUNT ON BRIK' => '378183', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	844 => array('S.NO.' => '845', 'ID' => '869', 'BRIK OWNER' => 'Naveen Kumar Gupta - naveen_adv@yahoo.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1272180', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1123180', 'TOTAL INSTALLMENT PAID' => '100000', 'TOTAL INSTALLMENT PENDING' => '1023180', 'DISCOUNT ON BRIK' => '378183', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	845 => array('S.NO.' => '846', 'ID' => '870', 'BRIK OWNER' => 'Chinari Bhagyashree Patro - badal_patro@rediffmail.com', 'UNIT NUMBER' => 'T1-1114', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '100000', 'TOTAL INSTALLMENT PENDING' => '480000', 'DISCOUNT ON BRIK' => '74909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	846 => array('S.NO.' => '847', 'ID' => '871', 'BRIK OWNER' => 'Vishnu Gupta - meeranaveen492@gmail.com', 'UNIT NUMBER' => 'T7-701', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '671180', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 572180', 'TOTAL INSTALLMENT PAID' => '400000', 'TOTAL INSTALLMENT PENDING' => '172180', 'DISCOUNT ON BRIK' => '49727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => 'NOT LIVE', 'REFERRAL DISCOUNT' => '0'),
	847 => array('S.NO.' => '848', 'ID' => '872', 'BRIK OWNER' => 'Kumar Sudhanshu Shekhar - s.singhsudhanshu01@gmail.com', 'UNIT NUMBER' => 'T1-1114', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '54910', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	848 => array('S.NO.' => '849', 'ID' => '873', 'BRIK OWNER' => 'Tattwaprajnya Pati - tprajnya1990@gmail.com', 'UNIT NUMBER' => 'T1-1114', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '100000', 'TOTAL INSTALLMENT PENDING' => '500000', 'DISCOUNT ON BRIK' => '54909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	849 => array('S.NO.' => '850', 'ID' => '874', 'BRIK OWNER' => 'Abhilasha Rani - abhilasha.rani@gmail.com', 'UNIT NUMBER' => 'T8/Block B305', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '370000', 'TOTAL INSTALLMENT PENDING' => '480000', 'DISCOUNT ON BRIK' => '57181', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	850 => array('S.NO.' => '851', 'ID' => '875', 'BRIK OWNER' => 'Ankit Kumar Bardia - bardiankit@gmail.com', 'UNIT NUMBER' => 'In Process 1', 'PROJECT' => 'The Vilasya', 'SPV' => 'Leisure Haven Homes Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAFCL8923R', 'CIN NO.' => 'U68100UP2024PTC205620', 'BRIK VALUE' => '3301636', 'INVESTMENT AMOUNT' => '2749000', 'BOOKING AMOUNT PAID' => '249000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 2500000', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '2300000', 'DISCOUNT ON BRIK' => '552636', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	851 => array('S.NO.' => '852', 'ID' => '876', 'BRIK OWNER' => 'Dharmendra Jiyalal Soni - dhruvsn30@gmail.com', 'UNIT NUMBER' => 'In Process 1', 'PROJECT' => 'The Vilasya', 'SPV' => 'Leisure Haven Homes Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAFCL8923R', 'CIN NO.' => 'U68100UP2024PTC205620', 'BRIK VALUE' => '3301636', 'INVESTMENT AMOUNT' => '2600000', 'BOOKING AMOUNT PAID' => '249000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 2351000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '2351000', 'DISCOUNT ON BRIK' => '701636', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	852 => array('S.NO.' => '853', 'ID' => '877', 'BRIK OWNER' => 'Debashis Lenka - debashis72@gmail.com', 'UNIT NUMBER' => 'T1-111', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '689000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 590000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '590000', 'DISCOUNT ON BRIK' => '26182', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	853 => array('S.NO.' => '854', 'ID' => '878', 'BRIK OWNER' => 'Rajiv Sharma - rajiv@radmaresearch.com', 'UNIT NUMBER' => 'T4-304', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SE2BR SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6092B', 'CIN NO.' => 'U70109UP2022PTC157704', 'BRIK VALUE' => '1019909', 'INVESTMENT AMOUNT' => '900000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 667600', 'TOTAL INSTALLMENT PAID' => '116600', 'TOTAL INSTALLMENT PENDING' => '551000', 'DISCOUNT ON BRIK' => '119909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	854 => array('S.NO.' => '855', 'ID' => '879', 'BRIK OWNER' => 'Shishpal . - shishpalmor1910@gmail.com', 'UNIT NUMBER' => 'T8/Block B305', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '300000', 'TOTAL INSTALLMENT PENDING' => '550000', 'DISCOUNT ON BRIK' => '57181', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	855 => array('S.NO.' => '856', 'ID' => '880', 'BRIK OWNER' => 'N R Brindha - brindhasuddharsan@gmail.com', 'UNIT NUMBER' => 'In Process 1', 'PROJECT' => 'The Vilasya', 'SPV' => 'Leisure Haven Homes Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAFCL8923R', 'CIN NO.' => 'U68100UP2024PTC205620', 'BRIK VALUE' => '3301636', 'INVESTMENT AMOUNT' => '2790000', 'BOOKING AMOUNT PAID' => '249000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 2541000', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '2341000', 'DISCOUNT ON BRIK' => '511636', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	856 => array('S.NO.' => '857', 'ID' => '881', 'BRIK OWNER' => 'Prashanth Singh - Prashanth.singh21@gmail.com', 'UNIT NUMBER' => 'T8/Block B305', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '945163', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 796163', 'TOTAL INSTALLMENT PAID' => '120000', 'TOTAL INSTALLMENT PENDING' => '676163', 'DISCOUNT ON BRIK' => '111018', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	857 => array('S.NO.' => '858', 'ID' => '882', 'BRIK OWNER' => 'Ashwani Kumar Sharma - ash@esignwebservices.com', 'UNIT NUMBER' => 'T8/Block B305', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '650000', 'DISCOUNT ON BRIK' => '57181', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	858 => array('S.NO.' => '859', 'ID' => '883', 'BRIK OWNER' => 'Hitesh Babulal K-+t- - hitesh_advo@yahoo.com', 'UNIT NUMBER' => 'T8/Block B305', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '700000', 'DISCOUNT ON BRIK' => '57181', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	859 => array('S.NO.' => '860', 'ID' => '884', 'BRIK OWNER' => 'Sumeet Gupta HUF - meetsumeet@gmail.com', 'UNIT NUMBER' => 'In Process 1', 'PROJECT' => 'The Vilasya', 'SPV' => 'Leisure Haven Homes Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAFCL8923R', 'CIN NO.' => 'U68100UP2024PTC205620', 'BRIK VALUE' => '3301636', 'INVESTMENT AMOUNT' => '2790000', 'BOOKING AMOUNT PAID' => '249000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 2541000', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '2341000', 'DISCOUNT ON BRIK' => '511636', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	860 => array('S.NO.' => '861', 'ID' => '885', 'BRIK OWNER' => 'Namami Barua - namami.barua@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040003', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 280000', 'TOTAL INSTALLMENT PAID' => '70000', 'TOTAL INSTALLMENT PENDING' => '210000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	861 => array('S.NO.' => '862', 'ID' => '886', 'BRIK OWNER' => 'Alka Verma - chandra.bbd2005@gmail.com', 'UNIT NUMBER' => 'Apex - 301', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Skylevels Stay Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7104J', 'CIN NO.' => 'U68100UP2025PTC219822', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '729000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 630000', 'TOTAL INSTALLMENT PAID' => '50000', 'TOTAL INSTALLMENT PENDING' => '580000', 'DISCOUNT ON BRIK' => '179000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	862 => array('S.NO.' => '863', 'ID' => '887', 'BRIK OWNER' => 'Preeti Singh - taxsusheel0712@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040003', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '379000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 280000', 'TOTAL INSTALLMENT PAID' => '35000', 'TOTAL INSTALLMENT PENDING' => '245000', 'DISCOUNT ON BRIK' => '22090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	863 => array('S.NO.' => '864', 'ID' => '888', 'BRIK OWNER' => 'Vibhav Damojipurapu - vibhav1983@rediffmail.com', 'UNIT NUMBER' => 'T8/Block B305', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '700000', 'DISCOUNT ON BRIK' => '57181', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	864 => array('S.NO.' => '865', 'ID' => '889', 'BRIK OWNER' => 'Itishree Mishra - me.itishree.mishra@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Skydrone View Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7000R', 'CIN NO.' => 'U68100UP2025PTC219751', 'BRIK VALUE' => '1149409', 'INVESTMENT AMOUNT' => '939000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 840000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '840000', 'DISCOUNT ON BRIK' => '210409', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	865 => array('S.NO.' => '866', 'ID' => '890', 'BRIK OWNER' => 'Parveen Dagar - pd.parveendagar@gmail.com', 'UNIT NUMBER' => 'Apex - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Skylevels Stay Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7104J', 'CIN NO.' => 'U68100UP2025PTC219822', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '729000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 630000', 'TOTAL INSTALLMENT PAID' => '50000', 'TOTAL INSTALLMENT PENDING' => '580000', 'DISCOUNT ON BRIK' => '179000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	866 => array('S.NO.' => '867', 'ID' => '891', 'BRIK OWNER' => 'Rajesh Kumar - rklodha199@gmail.com', 'UNIT NUMBER' => 'Apex - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Skylevels Stay Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7104J', 'CIN NO.' => 'U68100UP2025PTC219822', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '725000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 626000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '626000', 'DISCOUNT ON BRIK' => '183000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	867 => array('S.NO.' => '868', 'ID' => '892', 'BRIK OWNER' => 'Deepak Prakash - officehead33@gmail.com', 'UNIT NUMBER' => 'T7-701', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '400000', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => 'NOT LIVE', 'REFERRAL DISCOUNT' => '0'),
	868 => array('S.NO.' => '869', 'ID' => '893', 'BRIK OWNER' => 'Dalbir Singh - dalbir.marwah@gmail.com', 'UNIT NUMBER' => 'Apex - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Skylevels Stay Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7104J', 'CIN NO.' => 'U68100UP2025PTC219822', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '729000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 630000', 'TOTAL INSTALLMENT PAID' => '130000', 'TOTAL INSTALLMENT PENDING' => '500000', 'DISCOUNT ON BRIK' => '179000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	869 => array('S.NO.' => '870', 'ID' => '894', 'BRIK OWNER' => 'Gurpreet Singh - gsp.gurpreet@gmail.com', 'UNIT NUMBER' => 'Apex - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Skylevels Stay Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7104J', 'CIN NO.' => 'U68100UP2025PTC219822', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '729000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 630000', 'TOTAL INSTALLMENT PAID' => '130000', 'TOTAL INSTALLMENT PENDING' => '500000', 'DISCOUNT ON BRIK' => '179000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	870 => array('S.NO.' => '871', 'ID' => '895', 'BRIK OWNER' => 'Nirmala Chitlange - mmchitlange@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1323180', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 1147360', 'TOTAL INSTALLMENT PAID' => '250000', 'TOTAL INSTALLMENT PENDING' => '897360', 'DISCOUNT ON BRIK' => '327183', 'COINS' => '180', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	871 => array('S.NO.' => '872', 'ID' => '896', 'BRIK OWNER' => 'Ashwani Kumar Sharma - ash@esignwebservices.com', 'UNIT NUMBER' => 'Galaxy 2702 - 201', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '729000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 630000', 'TOTAL INSTALLMENT PAID' => '130000', 'TOTAL INSTALLMENT PENDING' => '500000', 'DISCOUNT ON BRIK' => '179000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	872 => array('S.NO.' => '873', 'ID' => '897', 'BRIK OWNER' => 'Savi . - just.nishant4934@gmail.com', 'UNIT NUMBER' => 'Apex - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Skylevels Stay Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7104J', 'CIN NO.' => 'U68100UP2025PTC219822', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '799000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 700000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '700000', 'DISCOUNT ON BRIK' => '109000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	873 => array('S.NO.' => '874', 'ID' => '898', 'BRIK OWNER' => 'Sarita Kumari - Saritakkandpal@gmail.com', 'UNIT NUMBER' => 'Apex - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Skylevels Stay Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7104J', 'CIN NO.' => 'U68100UP2025PTC219822', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '220000', 'TOTAL INSTALLMENT PENDING' => '430000', 'DISCOUNT ON BRIK' => '159000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	874 => array('S.NO.' => '875', 'ID' => '899', 'BRIK OWNER' => 'Abhilasha Rani - abhilasha.rani@gmail.com', 'UNIT NUMBER' => 'Apex - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Skylevels Stay Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7104J', 'CIN NO.' => 'U68100UP2025PTC219822', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '707130', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 608130', 'TOTAL INSTALLMENT PAID' => '130000', 'TOTAL INSTALLMENT PENDING' => '478130', 'DISCOUNT ON BRIK' => '200870', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	875 => array('S.NO.' => '876', 'ID' => '900', 'BRIK OWNER' => 'Prachi Bansal - ankurbansal_30@yahoo.com', 'UNIT NUMBER' => 'Apex - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Skylevels Stay Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7104J', 'CIN NO.' => 'U68100UP2025PTC219822', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '729000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 630000', 'TOTAL INSTALLMENT PAID' => '130000', 'TOTAL INSTALLMENT PENDING' => '500000', 'DISCOUNT ON BRIK' => '179000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	876 => array('S.NO.' => '877', 'ID' => '901', 'BRIK OWNER' => 'Vikas Yelishala - Vicky2k7@gmail.com', 'UNIT NUMBER' => 'Apex - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Skylevels Stay Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7104J', 'CIN NO.' => 'U68100UP2025PTC219822', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '727226', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 628226', 'TOTAL INSTALLMENT PAID' => '128226', 'TOTAL INSTALLMENT PENDING' => '500000', 'DISCOUNT ON BRIK' => '180774', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	877 => array('S.NO.' => '878', 'ID' => '902', 'BRIK OWNER' => 'Ankur Bhargava - ankur.jupiter@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Skydrone View Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7000R', 'CIN NO.' => 'U68100UP2025PTC219751', 'BRIK VALUE' => '1149409', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '750000', 'DISCOUNT ON BRIK' => '150409', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	878 => array('S.NO.' => '879', 'ID' => '903', 'BRIK OWNER' => 'Ramalakshmi Ravichandran - psravichandran67@yahoo.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Skydrone View Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7000R', 'CIN NO.' => 'U68100UP2025PTC219751', 'BRIK VALUE' => '1149409', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '900000', 'DISCOUNT ON BRIK' => '150409', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	879 => array('S.NO.' => '880', 'ID' => '904', 'BRIK OWNER' => 'Rajeev Sharma - rajeev290477@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Skydrone View Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7000R', 'CIN NO.' => 'U68100UP2025PTC219751', 'BRIK VALUE' => '1149409', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 950000', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '750000', 'DISCOUNT ON BRIK' => '100409', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	880 => array('S.NO.' => '881', 'ID' => '905', 'BRIK OWNER' => 'Debasish Panda HUF - debasishpandamax@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Skydrone View Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7000R', 'CIN NO.' => 'U68100UP2025PTC219751', 'BRIK VALUE' => '1149409', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '900000', 'DISCOUNT ON BRIK' => '150409', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	881 => array('S.NO.' => '882', 'ID' => '906', 'BRIK OWNER' => 'Vishal Kumar - vishalsah1986@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Skydrone View Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7000R', 'CIN NO.' => 'U68100UP2025PTC219751', 'BRIK VALUE' => '1149409', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '100000', 'TOTAL INSTALLMENT PENDING' => '800000', 'DISCOUNT ON BRIK' => '150409', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	882 => array('S.NO.' => '883', 'ID' => '907', 'BRIK OWNER' => 'Mukesh Kumar Aggarwal - marblecity2011@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Skydrone View Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7000R', 'CIN NO.' => 'U68100UP2025PTC219751', 'BRIK VALUE' => '1149409', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '100000', 'TOTAL INSTALLMENT PENDING' => '800000', 'DISCOUNT ON BRIK' => '150409', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	883 => array('S.NO.' => '884', 'ID' => '908', 'BRIK OWNER' => 'Krishna Malini Patra - tusar_cost@rediffmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Skydrone View Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7000R', 'CIN NO.' => 'U68100UP2025PTC219751', 'BRIK VALUE' => '1149409', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '900000', 'DISCOUNT ON BRIK' => '150409', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	884 => array('S.NO.' => '885', 'ID' => '909', 'BRIK OWNER' => 'Prosit Mukherjee - lifestyleimprover2008@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Skydrone View Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7000R', 'CIN NO.' => 'U68100UP2025PTC219751', 'BRIK VALUE' => '1149409', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '850000', 'DISCOUNT ON BRIK' => '200409', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	885 => array('S.NO.' => '886', 'ID' => '910', 'BRIK OWNER' => 'Harsha Vardhan Singh - vharsha747@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Skydrone View Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7000R', 'CIN NO.' => 'U68100UP2025PTC219751', 'BRIK VALUE' => '1149409', 'INVESTMENT AMOUNT' => '1039000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 940000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '940000', 'DISCOUNT ON BRIK' => '110409', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	886 => array('S.NO.' => '887', 'ID' => '911', 'BRIK OWNER' => 'Indu Kumari - ashutoshksingh@yahoo.co.in', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Skydrone View Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7000R', 'CIN NO.' => 'U68100UP2025PTC219751', 'BRIK VALUE' => '1149409', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '850000', 'DISCOUNT ON BRIK' => '200409', 'COINS' => '60', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	887 => array('S.NO.' => '888', 'ID' => '912', 'BRIK OWNER' => 'Deepak Agrawal - theflopshows@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Skydrone View Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7000R', 'CIN NO.' => 'U68100UP2025PTC219751', 'BRIK VALUE' => '1149409', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 950000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '950000', 'DISCOUNT ON BRIK' => '100409', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	888 => array('S.NO.' => '889', 'ID' => '913', 'BRIK OWNER' => 'Nitesh Kumar Agarwal - niteshjindal1985@gmail.com', 'UNIT NUMBER' => 'T8/Block B305', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '929000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 780000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '780000', 'DISCOUNT ON BRIK' => '127181', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	889 => array('S.NO.' => '890', 'ID' => '914', 'BRIK OWNER' => 'Kiran Devi Gupta - vkashyap911@gmail.com', 'UNIT NUMBER' => 'Apex - 301', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Skylevels Stay Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7104J', 'CIN NO.' => 'U68100UP2025PTC219822', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '729000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 630000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '630000', 'DISCOUNT ON BRIK' => '179000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	890 => array('S.NO.' => '891', 'ID' => '915', 'BRIK OWNER' => 'Sumit Mehta - Sumizam8@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1425000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1276000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '1126000', 'DISCOUNT ON BRIK' => '225363', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	891 => array('S.NO.' => '892', 'ID' => '916', 'BRIK OWNER' => 'Gaurav Dua - duag27@gmail.com', 'UNIT NUMBER' => 'T8/Block B305', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '150000', 'TOTAL INSTALLMENT PENDING' => '700000', 'DISCOUNT ON BRIK' => '57181', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	892 => array('S.NO.' => '893', 'ID' => '917', 'BRIK OWNER' => 'Dipika Mundhra - d4karnani@gmail.com', 'UNIT NUMBER' => 'Apex - 301', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Skylevels Stay Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7104J', 'CIN NO.' => 'U68100UP2025PTC219822', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '729000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 630000', 'TOTAL INSTALLMENT PAID' => '100000', 'TOTAL INSTALLMENT PENDING' => '530000', 'DISCOUNT ON BRIK' => '179000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	893 => array('S.NO.' => '894', 'ID' => '918', 'BRIK OWNER' => 'Aashi Verma - aashiverma2308@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Skydrone View Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7000R', 'CIN NO.' => 'U68100UP2025PTC219751', 'BRIK VALUE' => '1149409', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '850000', 'DISCOUNT ON BRIK' => '200409', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	894 => array('S.NO.' => '895', 'ID' => '919', 'BRIK OWNER' => 'Ramalakshmi Ravichandran - psravichandran67@yahoo.com', 'UNIT NUMBER' => 'T1-110', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '54909', 'COINS' => '90', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	895 => array('S.NO.' => '896', 'ID' => '920', 'BRIK OWNER' => 'Sharmistha Rout - arunsai.angul@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'Cancel Briks', 'SPV' => 'In Process', 'SPV ACCOUNT' => 'In Process', 'IFSC' => 'In Process', 'PAN CARD NO.' => 'In Process', 'CIN NO.' => 'In Process', 'BRIK VALUE' => '1', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '580000', 'DISCOUNT ON BRIK' => '74909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	896 => array('S.NO.' => '897', 'ID' => '921', 'BRIK OWNER' => 'Puspalata Mohapatra - puspa.mohapatra95@gmail.com', 'UNIT NUMBER' => 'T7-701', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '400000', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => 'NOT LIVE', 'REFERRAL DISCOUNT' => '0'),
	897 => array('S.NO.' => '898', 'ID' => '922', 'BRIK OWNER' => 'Amol Arun Pisal - amolpisal@yahoo.com', 'UNIT NUMBER' => 'T8/Block B305', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '995000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 846000', 'TOTAL INSTALLMENT PAID' => '146000', 'TOTAL INSTALLMENT PENDING' => '700000', 'DISCOUNT ON BRIK' => '61181', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	898 => array('S.NO.' => '899', 'ID' => '923', 'BRIK OWNER' => 'Ravi Khatri - rv89kh@gmail.com', 'UNIT NUMBER' => 'T3-102', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SUSH1BHK LUXURY SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6757P', 'CIN NO.' => 'U70109UP2022PTC158081', 'BRIK VALUE' => '776791', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 597588', 'TOTAL INSTALLMENT PAID' => '270000', 'TOTAL INSTALLMENT PENDING' => '327588', 'DISCOUNT ON BRIK' => '77791', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	899 => array('S.NO.' => '900', 'ID' => '924', 'BRIK OWNER' => 'Harmeet Sherawat - meetsherawat@rediffmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040003', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '389000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 290000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '290000', 'DISCOUNT ON BRIK' => '12090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	900 => array('S.NO.' => '901', 'ID' => '925', 'BRIK OWNER' => 'Chinmayee Mahapatra - Lkmohapatra1973@gmail.com', 'UNIT NUMBER' => 'T1-1115', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '580000', 'DISCOUNT ON BRIK' => '74909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	901 => array('S.NO.' => '902', 'ID' => '926', 'BRIK OWNER' => 'Anita Mahapatra - anitamahapatra810@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040003', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '359000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 260000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '260000', 'DISCOUNT ON BRIK' => '42090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	902 => array('S.NO.' => '903', 'ID' => '927', 'BRIK OWNER' => 'Moumita Saha - moumita.angel@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040003', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '389000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 290000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '290000', 'DISCOUNT ON BRIK' => '12090', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	903 => array('S.NO.' => '904', 'ID' => '928', 'BRIK OWNER' => 'Abhinav Awasthi - kp.infomediaknp@gmail.com', 'UNIT NUMBER' => 'T7-701', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => 'NOT LIVE', 'REFERRAL DISCOUNT' => '0'),
	904 => array('S.NO.' => '905', 'ID' => '929', 'BRIK OWNER' => 'Susanta Kumar Senapati - senapati.sk@gmail.com', 'UNIT NUMBER' => 'T7- 807', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => 'NOT LIVE', 'REFERRAL DISCOUNT' => '0'),
	905 => array('S.NO.' => '906', 'ID' => '930', 'BRIK OWNER' => 'Chinari Bhagyashree Patro - badal_patro@rediffmail.com', 'UNIT NUMBER' => 'Apex - 301', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Skylevels Stay Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7104J', 'CIN NO.' => 'U68100UP2025PTC219822', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '209000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	906 => array('S.NO.' => '907', 'ID' => '931', 'BRIK OWNER' => 'Dr. Khushboo Harsh Garg - khushboo.garg104@gmail.com', 'UNIT NUMBER' => 'In Process 2', 'PROJECT' => 'The Vilasya', 'SPV' => 'Leisure Haven Homes Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAFCL8923R', 'CIN NO.' => 'U68100UP2024PTC205620', 'BRIK VALUE' => '3301636', 'INVESTMENT AMOUNT' => '2555180', 'BOOKING AMOUNT PAID' => '249000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 2306180', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '2306180', 'DISCOUNT ON BRIK' => '746456', 'COINS' => '120', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	907 => array('S.NO.' => '908', 'ID' => '932', 'BRIK OWNER' => 'Abhishek Roy - abhishek.roy091@gmail.com', 'UNIT NUMBER' => 'In Process 1', 'PROJECT' => 'The Vilasya', 'SPV' => 'Leisure Haven Homes Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAFCL8923R', 'CIN NO.' => 'U68100UP2024PTC205620', 'BRIK VALUE' => '3301636', 'INVESTMENT AMOUNT' => '2780000', 'BOOKING AMOUNT PAID' => '249000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 2531000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '2531000', 'DISCOUNT ON BRIK' => '521636', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	908 => array('S.NO.' => '909', 'ID' => '933', 'BRIK OWNER' => 'Ananta Kumar Patro - anantapatra161971@gmail.com', 'UNIT NUMBER' => 'T1-1115', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '580000', 'DISCOUNT ON BRIK' => '74909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	909 => array('S.NO.' => '910', 'ID' => '934', 'BRIK OWNER' => 'Surjeet Singh Tewatia - sstewatia889@gmail.com', 'UNIT NUMBER' => 'In Process 2', 'PROJECT' => 'The Vilasya', 'SPV' => 'Leisure Haven Homes Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAFCL8923R', 'CIN NO.' => 'U68100UP2024PTC205620', 'BRIK VALUE' => '3301636', 'INVESTMENT AMOUNT' => '2749000', 'BOOKING AMOUNT PAID' => '249000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 2500000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '2500000', 'DISCOUNT ON BRIK' => '552636', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	910 => array('S.NO.' => '911', 'ID' => '935', 'BRIK OWNER' => 'Priyabrat Barad - priyabrat.77@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Skydrone View Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7000R', 'CIN NO.' => 'U68100UP2025PTC219751', 'BRIK VALUE' => '1149409', 'INVESTMENT AMOUNT' => '1049000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 950000', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '750000', 'DISCOUNT ON BRIK' => '100409', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	911 => array('S.NO.' => '912', 'ID' => '936', 'BRIK OWNER' => 'Gaurav Gupta - gaurav.gta@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1399000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1250000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1250000', 'DISCOUNT ON BRIK' => '251363', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	912 => array('S.NO.' => '913', 'ID' => '937', 'BRIK OWNER' => 'Susmita Roy Goswami - roysujit79@gmail.com', 'UNIT NUMBER' => 'T1-1115', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '580000', 'DISCOUNT ON BRIK' => '74909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	913 => array('S.NO.' => '914', 'ID' => '938', 'BRIK OWNER' => 'Neetu Saini - neetusaini@gmail.com', 'UNIT NUMBER' => 'B1', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '1149000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 1000000', 'TOTAL INSTALLMENT PAID' => '200000', 'TOTAL INSTALLMENT PENDING' => '800000', 'DISCOUNT ON BRIK' => '188990', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '0', 'REFERRAL DISCOUNT' => '0'),
	914 => array('S.NO.' => '915', 'ID' => '939', 'BRIK OWNER' => 'Krishna Kr Singh - krish44u4ever@gmail.com', 'UNIT NUMBER' => 'T8/Block B305', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '850000', 'DISCOUNT ON BRIK' => '57181', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	915 => array('S.NO.' => '916', 'ID' => '940', 'BRIK OWNER' => 'Kunal Puri - drkunalpuri@gmail.com', 'UNIT NUMBER' => 'T8/Block B305', 'PROJECT' => 'Aroha De Goa', 'SPV' => 'ADG2BHK Suite Private Limited', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAWCA3819Q', 'CIN NO.' => 'U70109UP2022PTC158092', 'BRIK VALUE' => '1056181', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 850000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '850000', 'DISCOUNT ON BRIK' => '57181', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	916 => array('S.NO.' => '917', 'ID' => '941', 'BRIK OWNER' => 'Ravi Babu Rajana - Ravi_rajana228@yahoo.com', 'UNIT NUMBER' => 'Row-8/Block 2/A-101', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '550000', 'DISCOUNT ON BRIK' => '50000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	917 => array('S.NO.' => '918', 'ID' => '942', 'BRIK OWNER' => 'Rupesh Kumar - km.rupesh@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1299000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1123180', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1123180', 'DISCOUNT ON BRIK' => '378163', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	918 => array('S.NO.' => '919', 'ID' => '943', 'BRIK OWNER' => 'Charu Narang - Ajay12_narang@yahoo.co.in', 'UNIT NUMBER' => 'Apex - 301', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Skylevels Stay Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7104J', 'CIN NO.' => 'U68100UP2025PTC219822', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 10 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '650000', 'DISCOUNT ON BRIK' => '159000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	919 => array('S.NO.' => '920', 'ID' => '944', 'BRIK OWNER' => 'Darshit Bharatkumar Shah - darshit.lic@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040005', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '401090', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 302090', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '302090', 'DISCOUNT ON BRIK' => '77819', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	920 => array('S.NO.' => '921', 'ID' => '945', 'BRIK OWNER' => 'Rika Semalty - rikasemalty@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040005', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '380000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 281000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '281000', 'DISCOUNT ON BRIK' => '98909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	921 => array('S.NO.' => '922', 'ID' => '946', 'BRIK OWNER' => 'Ananya Sharma - ds71174@gmail.com', 'UNIT NUMBER' => 'Apex - 301', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Skylevels Stay Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7104J', 'CIN NO.' => 'U68100UP2025PTC219822', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '650000', 'DISCOUNT ON BRIK' => '159000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	922 => array('S.NO.' => '923', 'ID' => '947', 'BRIK OWNER' => 'Ananya Sharma - ds71174@gmail.com', 'UNIT NUMBER' => 'T7-701', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => 'NOT LIVE', 'REFERRAL DISCOUNT' => '0'),
	923 => array('S.NO.' => '924', 'ID' => '948', 'BRIK OWNER' => 'Neerja Sharma - neerjasharma1964@gmail.com', 'UNIT NUMBER' => 'T7-701', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 559030', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '559030', 'DISCOUNT ON BRIK' => '59727', 'COINS' => '0', 'REFERRAL DISC' => '20970', 'COIN' => 'NOT LIVE', 'REFERRAL DISCOUNT' => '20970'),
	924 => array('S.NO.' => '925', 'ID' => '949', 'BRIK OWNER' => 'Poorva Sharma - Sharma.poorva5@gmail.com', 'UNIT NUMBER' => 'Apex - 301', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Skylevels Stay Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7104J', 'CIN NO.' => 'U68100UP2025PTC219822', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 577530', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '577530', 'DISCOUNT ON BRIK' => '209000', 'COINS' => '0', 'REFERRAL DISC' => '22470', 'COIN' => '', 'REFERRAL DISCOUNT' => '22470'),
	925 => array('S.NO.' => '926', 'ID' => '950', 'BRIK OWNER' => 'Hanuwant Singh Amarawat HUF - hanuwantsinghamarawat@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1325000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1176000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1176000', 'DISCOUNT ON BRIK' => '325363', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	926 => array('S.NO.' => '927', 'ID' => '951', 'BRIK OWNER' => 'Swarnali Nayak - nayak.sudip@gmail.com', 'UNIT NUMBER' => 'T1-1115', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '665000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 566000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '566000', 'DISCOUNT ON BRIK' => '88909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	927 => array('S.NO.' => '928', 'ID' => '952', 'BRIK OWNER' => 'Jagvir Singh - Jagveer_agha@yahoo.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040002', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '399000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '79909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	928 => array('S.NO.' => '929', 'ID' => '953', 'BRIK OWNER' => 'Ashwani Kumar Sharma - ash@esignwebservices.com', 'UNIT NUMBER' => 'In Process 2', 'PROJECT' => 'The Vilasya', 'SPV' => 'Leisure Haven Homes Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAFCL8923R', 'CIN NO.' => 'U68100UP2024PTC205620', 'BRIK VALUE' => '3301636', 'INVESTMENT AMOUNT' => '2890000', 'BOOKING AMOUNT PAID' => '249000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 2641000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '2641000', 'DISCOUNT ON BRIK' => '411636', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	929 => array('S.NO.' => '930', 'ID' => '954', 'BRIK OWNER' => 'Govind Narayan Singh - govind.narayan@gmail.com', 'UNIT NUMBER' => 'In Process 2', 'PROJECT' => 'The Vilasya', 'SPV' => 'Leisure Haven Homes Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAFCL8923R', 'CIN NO.' => 'U68100UP2024PTC205620', 'BRIK VALUE' => '3301636', 'INVESTMENT AMOUNT' => '2790000', 'BOOKING AMOUNT PAID' => '249000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 2541000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '2541000', 'DISCOUNT ON BRIK' => '511636', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	930 => array('S.NO.' => '931', 'ID' => '955', 'BRIK OWNER' => 'Truptimayee Senapati - mrsujit008@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040002', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '449000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 350000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '350000', 'DISCOUNT ON BRIK' => '29909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	931 => array('S.NO.' => '932', 'ID' => '956', 'BRIK OWNER' => 'Aditya Soni - chhayasoni512@gmail.com', 'UNIT NUMBER' => 'T1-1114', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '580000', 'DISCOUNT ON BRIK' => '74909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	932 => array('S.NO.' => '933', 'ID' => '957', 'BRIK OWNER' => 'Sarmista S Padhi Padhi - sarmistha2233@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040010', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '429000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 330000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '330000', 'DISCOUNT ON BRIK' => '49909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	933 => array('S.NO.' => '934', 'ID' => '958', 'BRIK OWNER' => 'Rajiv Sharma - rajiv@radmaresearch.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040002', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '399000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '79909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	934 => array('S.NO.' => '935', 'ID' => '959', 'BRIK OWNER' => 'Santwona Panda - santwna.panda@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040002', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '449000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 350000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '350000', 'DISCOUNT ON BRIK' => '29909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	935 => array('S.NO.' => '936', 'ID' => '960', 'BRIK OWNER' => 'Sourav Agarwal - sourav.asg@gmail.com', 'UNIT NUMBER' => 'T1-1115', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '580000', 'DISCOUNT ON BRIK' => '74910', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	936 => array('S.NO.' => '937', 'ID' => '961', 'BRIK OWNER' => 'Suman Singh - matendra.vikram@shreedevwheels.com', 'UNIT NUMBER' => 'A2', 'PROJECT' => 'The Swiss Village', 'SPV' => 'SEREN VIEW HOMES PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABKCS1453K', 'CIN NO.' => 'U70109UP2023PTC176610', 'BRIK VALUE' => '1337990', 'INVESTMENT AMOUNT' => '1149000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 1000000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1000000', 'DISCOUNT ON BRIK' => '188990', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '0', 'REFERRAL DISCOUNT' => '0'),
	937 => array('S.NO.' => '938', 'ID' => '962', 'BRIK OWNER' => 'Sumeet Kumar - kumarsumeet83@gmail.com', 'UNIT NUMBER' => 'T4-304', 'PROJECT' => 'Sushma Elementa', 'SPV' => 'SE2BR SUITE PVT LTD', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABHCS6092B', 'CIN NO.' => 'U70109UP2022PTC157704', 'BRIK VALUE' => '1019909', 'INVESTMENT AMOUNT' => '949000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 8 Installments) Amount: 800000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '800000', 'DISCOUNT ON BRIK' => '70909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	938 => array('S.NO.' => '939', 'ID' => '963', 'BRIK OWNER' => 'Poonam Jha - amitenjala@gmail.com', 'UNIT NUMBER' => 'Apex - 302', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Skylevels Stay Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7104J', 'CIN NO.' => 'U68100UP2025PTC219822', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '749000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 650000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '650000', 'DISCOUNT ON BRIK' => '159000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	939 => array('S.NO.' => '940', 'ID' => '964', 'BRIK OWNER' => 'Sujit Roy - ssbroy.2014@gmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040002', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '386000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 287000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '287000', 'DISCOUNT ON BRIK' => '92909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	940 => array('S.NO.' => '941', 'ID' => '965', 'BRIK OWNER' => 'Goldi . - goldiaa14@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1369000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1220000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1220000', 'DISCOUNT ON BRIK' => '281363', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	941 => array('S.NO.' => '942', 'ID' => '966', 'BRIK OWNER' => 'Sonal Agrawal - sonal.com@hotmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040002', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '399000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '79909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	942 => array('S.NO.' => '943', 'ID' => '967', 'BRIK OWNER' => 'Suvadeep Chakraborty - suvadeep2003@rediffmail.com', 'UNIT NUMBER' => 'Tower Tulip - VA 040002', 'PROJECT' => 'Vanya Awas', 'SPV' => 'CLOUDTOP RETREAT PVT LTD', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC1912D', 'CIN NO.' => 'U68200UP2023PTC186012', 'BRIK VALUE' => '478909', 'INVESTMENT AMOUNT' => '399000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 9 Installments) Amount: 300000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '300000', 'DISCOUNT ON BRIK' => '79909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	943 => array('S.NO.' => '944', 'ID' => '968', 'BRIK OWNER' => 'Mahavir Devendra Khot - mahavirkhot@gmail.com', 'UNIT NUMBER' => 'Row-8/Block 2/A-101', 'PROJECT' => 'Adora De Goa', 'SPV' => 'BPADG SUITE AND CONDO PRIVATE LIMITED', 'SPV ACCOUNT' => '4.07405E+11', 'IFSC' => 'ICIC0004074', 'PAN CARD NO.' => 'AAJCB8696D', 'CIN NO.' => 'U70200UP2021PTC146513', 'BRIK VALUE' => '699000', 'INVESTMENT AMOUNT' => '649000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 550000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '550000', 'DISCOUNT ON BRIK' => '50000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	944 => array('S.NO.' => '945', 'ID' => '969', 'BRIK OWNER' => 'Ravi Khatri - rv89kh@gmail.com', 'UNIT NUMBER' => 'T7-701', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => 'NOT LIVE', 'REFERRAL DISCOUNT' => '0'),
	945 => array('S.NO.' => '946', 'ID' => '970', 'BRIK OWNER' => 'Love Shrivastava - luv_shri@yahoo.co.uk', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1399000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1250000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1250000', 'DISCOUNT ON BRIK' => '251363', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	946 => array('S.NO.' => '947', 'ID' => '971', 'BRIK OWNER' => 'Rituparna Sen - jeetvisualarts@gmail.com', 'UNIT NUMBER' => 'T7-701', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 3 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '39727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => 'NOT LIVE', 'REFERRAL DISCOUNT' => '0'),
	947 => array('S.NO.' => '948', 'ID' => '972', 'BRIK OWNER' => 'Lakhtariya Parth Narayanbhai - parthlakhtariya24@gmail.com', 'UNIT NUMBER' => 'T1-1115', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 12 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '54909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	948 => array('S.NO.' => '949', 'ID' => '973', 'BRIK OWNER' => 'Pritesh Verma - Pritesh7002@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Hillside Harmony Holiday Homes Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCH4365H', 'CIN NO.' => 'U68100UP2024PTC205854', 'BRIK VALUE' => '1650363', 'INVESTMENT AMOUNT' => '1369000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 7 Installments) Amount: 1220000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '1220000', 'DISCOUNT ON BRIK' => '281363', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	949 => array('S.NO.' => '950', 'ID' => '974', 'BRIK OWNER' => 'Dipika Mundhra - d4karnani@gmail.com', 'UNIT NUMBER' => 'In Process', 'PROJECT' => 'The Vilasya', 'SPV' => 'Skydrone View Private Limited', 'SPV ACCOUNT' => '7.77706E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7000R', 'CIN NO.' => 'U68100UP2025PTC219751', 'BRIK VALUE' => '1149409', 'INVESTMENT AMOUNT' => '999000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 6 Installments) Amount: 900000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '900000', 'DISCOUNT ON BRIK' => '150409', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	950 => array('S.NO.' => '951', 'ID' => '975', 'BRIK OWNER' => 'Madhuchhanda Nayak - Meetpapun@gmail.com', 'UNIT NUMBER' => 'T1-1115', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 13 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '54909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	951 => array('S.NO.' => '952', 'ID' => '976', 'BRIK OWNER' => 'Priyabrata Routray - loni.lala2015@gmail.com', 'UNIT NUMBER' => 'T1-1115', 'PROJECT' => 'Royal Aikyam Puri', 'SPV' => 'Everestedge View Private limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAHCE8200G', 'CIN NO.' => 'U68100UP2023PTC190612', 'BRIK VALUE' => '753909', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '54909', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	952 => array('S.NO.' => '953', 'ID' => '977', 'BRIK OWNER' => 'Rahul Kanhaiyalal Katariya - Rahulkatariya1@gmail.com', 'UNIT NUMBER' => 'Galaxy 2703 - 301', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'CRESTVIEW APARTMENT PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AALCC9707A', 'CIN NO.' => 'U68100UP2024PTC205641', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '699000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 600000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '600000', 'DISCOUNT ON BRIK' => '209000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	953 => array('S.NO.' => '954', 'ID' => '978', 'BRIK OWNER' => 'Ravindra Prasad - ravindra5587@gmail.com', 'UNIT NUMBER' => 'Apex - 301', 'PROJECT' => 'The Himalayan Symphony', 'SPV' => 'Skylevels Stay Private Limited', 'SPV ACCOUNT' => '7.77705E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'ABPCS7104J', 'CIN NO.' => 'U68100UP2025PTC219822', 'BRIK VALUE' => '908000', 'INVESTMENT AMOUNT' => '829000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 11 Installments) Amount: 730000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '730000', 'DISCOUNT ON BRIK' => '79000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '', 'REFERRAL DISCOUNT' => '0'),
	954 => array('S.NO.' => '955', 'ID' => '979', 'BRIK OWNER' => 'Sangita Das - sanjaykumardas1973@yahoo.co.in', 'UNIT NUMBER' => '302', 'PROJECT' => 'Rio De Goa', 'SPV' => 'HAPPY TRAILS LUXURIOUS SUITE PRIVATE LIMITED', 'SPV ACCOUNT' => '3.53105E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCH6483F', 'CIN NO.' => 'U70200UP2023PTC176646', 'BRIK VALUE' => '1176000', 'INVESTMENT AMOUNT' => '1199000', 'BOOKING AMOUNT PAID' => '149000', 'INSTALLMENTS' => '(Total 1 Installments) Amount: 0', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '0', 'DISCOUNT ON BRIK' => '-23000', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '0', 'REFERRAL DISCOUNT' => '0'),
	955 => array('S.NO.' => '956', 'ID' => '980', 'BRIK OWNER' => 'Sukhbir Bajwa - ssukhbirh1968@gmail.com', 'UNIT NUMBER' => 'T7- 807', 'PROJECT' => 'Rio De Goa', 'SPV' => 'Scenic Suites Private Limited', 'SPV ACCOUNT' => '3.53106E+11', 'IFSC' => 'ICIC0003531', 'PAN CARD NO.' => 'AAGCE9743H', 'CIN NO.' => 'U70105UP2022PTC161887', 'BRIK VALUE' => '738727', 'INVESTMENT AMOUNT' => '679000', 'BOOKING AMOUNT PAID' => '99000', 'INSTALLMENTS' => '(Total 4 Installments) Amount: 580000', 'TOTAL INSTALLMENT PAID' => '0', 'TOTAL INSTALLMENT PENDING' => '580000', 'DISCOUNT ON BRIK' => '59727', 'COINS' => '0', 'REFERRAL DISC' => '0', 'COIN' => '45', 'REFERRAL DISCOUNT' => '0'),
);
    }

}
