<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use App\Actions\RU\RU;
use App\Mail\InstallmentPayPartSuccessToClient;
use App\Models\Client;
use App\Models\BrikUnit;
use App\Models\BrikInstallment;
use App\Models\RuPropertyPrice;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;
use App\Models\BrikInstallmentPayment;
use App\Mail\InstallmentPaySuccessToClient;

class installmentPaymentEmail extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:installment-payment-send-email';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sending Emails after installment payments.';

    /**
     * Execute the console command.
     */
    public function handle()
    {
       $this->info('Code execution started.');

       $payments = BrikInstallmentPayment::where('mail_sent', 0)->whereDate('created_at', Carbon::today())->get();

       foreach($payments as $payment)
       {
            $installment = BrikInstallment::find($payment->brik_installment_id);

            if($installment->installment_paid == 1){

                // Complete installment paid -> send installment payment slip
                $installment = BrikInstallment::with(['payments','paymentPlan','paymentPlan.brik_owner','paymentPlan.brik_owner.brik_unit','paymentPlan.brik_owner.brik_unit.project'])->find($payment->brik_installment_id);

                if($installment){
                    if($installment->paymentPlan){
                        if($installment->paymentPlan->brik_owner){
                            $guest = Client::find($installment->paymentPlan->brik_owner->owner_id);

                            if($guest->email){
                                Mail::to($guest->email)->send(new InstallmentPaySuccessToClient($installment, $guest));
                            }

                        }
                    }
                }



            }else{

                // Only fraction payment -> send only acknowedgement slip
               
                $installment = BrikInstallment::with(['payments','paymentPlan','paymentPlan.brik_owner','paymentPlan.brik_owner.brik_unit','paymentPlan.brik_owner.brik_unit.project'])->find($payment->brik_installment_id);

                if($installment){
                    if($installment->paymentPlan){
                        if($installment->paymentPlan->brik_owner){
                            $guest = Client::find($installment->paymentPlan->brik_owner->owner_id);

                            if($guest->email){
                                Mail::to($guest->email)->send(new InstallmentPayPartSuccessToClient($payment, $installment, $guest));
                            }
                        }
                    }
                }
            }

            $upd = BrikInstallmentPayment::find($payment->id);
            $upd->mail_sent = 1;
            $upd->save();
       }

       $this->info('Code execution ended.');
    }


}
