<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;
use App\Mail\InvestIncompleteBooking;
use App\Models\InvestPropertyBooking;

class investIncompleteBookingEmail extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:invest-incomplete-booking-alert-email';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sending Incomplete Invest booking information to sales team.';

    /**
     * Execute the console command.
     */
    public function handle()
    {
       $this->info('Code execution started.');

       $emails = [
        'info@brikitt.com',
		'accounts@brikitt.com'
       ];

       // $invest_bookings = InvestPropertyBooking::where(function ($query) {
                        // $query->whereNull('payment_status')
                            // ->orWhere('payment_status', '!=', 'Success');
                    // })->where('created_at', '>=', "2025-08-05 01:16:00")->get();
					
		$invest_bookings = InvestPropertyBooking::whereNull('payment_status')
		                  ->where('created_at', '>=', Carbon::now()->subMinutes(5))->get();
					
                 

        if($invest_bookings->count() > 0){
            $this->info('Email is preparing');
            Mail::to($emails)->send(new InvestIncompleteBooking($invest_bookings));
        }else{
            $this->info('There is nothing to send.');
        }



       $this->info('Code execution ended.');
    }


}
