<?php

namespace App\Console\Commands;

use App\Actions\RU\RU;
use App\Models\BrikInstallment;
use App\Models\BrikInstallmentPayment;
use App\Models\BrikUnit;
use App\Models\RuPropertyPrice;
use Illuminate\Console\Command;

class temporaryUpdateInstallPaydate extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'temp:update-installment-pay-date';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
       $this->info('Code execution started.');

       $installments = BrikInstallment::where('installment_paid', 1)->whereNotNull('created_at')->get();

       foreach($installments as $installment){

          $paid_date = BrikInstallmentPayment::where('brik_installment_id', $installment->id)->max('date');

          $ins = BrikInstallment::find($installment->id);
          $ins->paid_date = $paid_date;
          $ins->save();

          $this->info('Inst Id: '.$ins->id.' updated');
       }

        $this->info('Code execution ended.');
    }


}
