<?php

namespace App\Console\Commands;

use Carbon\Carbon;

use App\Models\BrikUnit;
use App\Models\BrikUnitRating;
use Illuminate\Console\Command;

class updateRatings extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:update-ratings';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'update rating.(Run Every day Once in cron)';

    /**
     * Execute the console command.
     */
    public function handle()
    {
       $this->info('Code execution started.');
       $units = BrikUnit::get();

       foreach($units as $unit)
       {

            if(BrikUnitRating::where('brik_unit_id', $unit->id)->count() > 0){
                $rating = BrikUnitRating::where('brik_unit_id', $unit->id)->avg('rating');
                $upd = BrikUnit::find($unit->id);
                $upd->rating = $rating;
                $upd->save();
            }
       }

       $this->info('Code execution ended.');
    }




}
