<?php

namespace App\Console\Commands;

use App\Actions\RU\RU;
use App\Models\BookingBooking;
use App\Models\BrikUnit;
use App\Models\RuPropertyPrice;
use Illuminate\Console\Command;
use App\Models\BookingBookingRequest;

class updateRuBookingSync extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */

    protected $signature = 'app:update-ru-booking-sync'; // Run Every 5 mins

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
       $this->info('Code execution started.');

       $booking_requests = BookingBookingRequest::where('booking_status', 'Active')
                            ->where('ru_sync_required', 1)
                            ->where('is_synced', 0)->get();

       foreach($booking_requests as $booking_request){

            if($this->isAllBookingSynced($booking_request)){
                $this->updateStatus($booking_request);
            }else{
                $this->runRuSync($booking_request);
                if($this->isAllBookingSynced($booking_request)){
                    $this->updateStatus($booking_request);
                }
            }

       }

     
    }

    public function isAllBookingSynced($booking_request)
    {
        $cnt = BookingBooking::where('booking_request_id', $booking_request->id)->whereNull('ru_reservation_id')->count();
        if($cnt > 0){
            return false;
        }
        
        return true;
    }

    public function updateStatus($booking_request){

        $req = BookingBookingRequest::find($booking_request->id);
        $req->is_synced = 1;
        $req->save();

    }

    public function runRuSync($booking_request){

        $bookings = BookingBooking::where('booking_request_id', $booking_request->id)->whereNull('ru_reservation_id')->get();
        foreach($bookings as $booking){
            if($booking->pay_by == 'Amount'){
                
                $ru =  new RU;
                $ru->amountBooking($booking);
                
            }

            if($booking->pay_by == 'Coin'){
               
                $ru =  new RU;
                $ru->coinBooking($booking);
                
            }
        }

    }

}
