<?php

namespace App\Filament\Admin\Resources\BookingBookingResource\Pages;

use Filament\Actions;
use App\Actions\RU\RU;
use App\Models\Client;
use App\Models\BookingBooking;
use App\Models\BookingBookingDetail;
use App\Models\BookingBookingRequest;
use App\Models\CoinWalletTransaction;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\EditRecord;
use App\Filament\Admin\Resources\BookingBookingResource;

class EditBookingBooking extends EditRecord
{
    protected static string $resource = BookingBookingResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    protected function getHeaderActions(): array
    {
        return [
             Actions\DeleteAction::make()
            ->action(function ($record) {

                if($record->pay_by == 'Coin')
                {
                    CoinWalletTransaction::where('booking_id', $record->id)->delete();

                    $client = Client::find($this->record->client_id);
                    $client->coins = ($client->coins + $this->record->booking_cost_in_coin);
                    $client->save();
                }

                $delbookreq = BookingBookingRequest::find($record->booking_request_id);
                $delbookreq->delete();

                BookingBookingDetail::where('booking_id', $record->id)->delete();

                Notification::make()
                        ->danger()
                        ->title('Deleted')
                        ->body('Booking Deleted.')
                        ->send();

                $record->delete();

                return redirect(BookingBookingResource::getUrl('index'));
            }),
        ];
    }



    public function afterSave()
    {
        $newReq = BookingBookingRequest::find($this->record->booking_request_id);
        $newReq->brik_unit_id = $this->record->brik_unit_id;
        $newReq->booking_from_date = $this->record->date_check_in;
        $newReq->booking_to_date = $this->record->date_check_out;
        $newReq->date_blocked_from = $this->record->date_check_in;
        $newReq->date_blocked_to = date("Y-m-d", strtotime("-1 day ".$this->record->date_check_out));
        $newReq->booking_status = 'Active';
        $newReq->save();

        if($this->record->pay_by == 'Coin')
        {
            $atCreate = CoinWalletTransaction::where('booking_id', $this->record->id)->first();
            if($atCreate){
               $atCreateClient = Client::find($this->record->client_id);
               $atCreateClient->coins = ($atCreateClient->coins + $atCreate->coin);
               $atCreateClient->save();

               $cointxn = CoinWalletTransaction::find($atCreate->id);
            }else{
               $cointxn = new CoinWalletTransaction;
               $cointxn->booking_id = $this->record->id;
               $cointxn->type = 'Debit';
            }

               $cointxn->coin = $this->record->booking_cost_in_coin;
               $cointxn->save();

            $client = Client::find($this->record->client_id);
            $client->coins = ($client->coins - $this->record->booking_cost_in_coin);
            $client->save();
        }

        if($this->record->pay_by == 'Amount')
        {
            $chk = BookingBookingDetail::where('booking_id', $this->record->id)->first();

            if($chk){
                $ins = BookingBookingDetail::find($chk->id);
            }else{
                $ins = new BookingBookingDetail;
                $ins->booking_id = $this->record->id;
            }

            $ins->from_date = $this->record->date_check_in;
            $ins->to_date = $this->record->date_check_out;
            $ins->price = $this->record->price_per_night;
            $ins->nights = $this->record->booking_night_counts;
            $ins->booking_price = $this->record->booking_cost_in_rupee;
            $ins->save();
        }

        //$this->RUApi();

    }

    // public function RUApi()
    // {
    //     $book = BookingBooking::find($this->record->id);
    //     $bookings = BookingBooking::with(['brik_unit', 'client'])->where('booking_request_id', $book->booking_request_id)->get();

    //             // Add RU Booking API Here

    //             foreach($bookings as $booking){

    //                 if($booking->brik_unit){

    //                     if($booking->brik_unit->ru_property_id){

    //                         if(is_null($booking->ru_reservation_id)){

    //                             if($booking->booking_status == 'Active')
    //                             {

    //                                 if($booking->pay_by == 'Amount'){
    //                                     // Booking By Amount

    //                                     $ru =  new RU;
    //                                     $ru->amountBooking($booking);

    //                                 }

    //                                 if($booking->pay_by == 'Coin'){
    //                                     // Booking By Coin
    //                                     // if booking has not entered in rentals united

    //                                     $ru =  new RU;
    //                                     $ru->coinBooking($booking);

    //                                 }
    //                             }
    //                         }
    //                     }

    //                 }
    //             }
    // }
}
