<?php

namespace App\Filament\Admin\Resources\BookingCalenderResource\Pages;

use Filament\Forms\Set;
use App\Models\BrikUnit;
use Filament\Resources\Pages\Page;
use Filament\Forms\Components\Select;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Concerns\InteractsWithForms;
use App\Filament\Admin\Resources\BookingCalenderResource;

class Calendar extends Page implements HasForms
{
    use InteractsWithForms;

    //protected static bool $isLazy = false;

    protected static string $resource = BookingCalenderResource::class;

    protected static string $view = 'filament.admin.resources.booking-calender-resource.pages.calendar';

    public $brikUnitId;

    public function mount(): void
    {
        $this->form->fill();
    }

    protected function getFormSchema(): array
    {
        return [

            Select::make('brikUnitId')
                ->label('Brik Unit')
                ->live()
                ->options(BrikUnit::where('invest_active', 1)->where('rent_active', 1)->pluck("booking_portal_display_name", "id"))
                ->afterStateUpdated(function(callable $set){
                    $this->dispatch('brikUnitSelected', brikUnitId: $this->brikUnitId);
                }),

        ];
    }
}
