<?php

namespace App\Filament\Admin\Resources\BookingCalenderResource\Widgets;

use App\Models\BrikUnit;
use Livewire\Attributes\On;
use Filament\Widgets\Widget;
use App\Models\BookingBooking;
use Filament\Forms\Components\Select;
use Filament\Tables\Filters\SelectFilter;
use Saade\FilamentFullCalendar\Data\EventData;
use Saade\FilamentFullCalendar\Widgets\FullCalendarWidget;

class CalendarWidget extends FullCalendarWidget
{

    public $brikUnitId = null;


    public function fetchEvents(array $fetchInfo): array
    {

        if($this->brikUnitId){

            return BookingBooking::with(['brik_unit','client'])
                ->where('booking_status', 'Active')
                ->where('brik_unit_id', $this->brikUnitId)
                ->where('date_check_in', '>=', $fetchInfo['start'])
                ->where('date_check_out', '<=', $fetchInfo['end'])
                ->get()
                ->map(
                 fn (BookingBooking $BookingBooking) => EventData::make()
                    ->id($BookingBooking->id)
                    ->title($BookingBooking->client->full_name)
                    ->start($BookingBooking->date_check_in)
                    ->end($BookingBooking->date_check_out)
                    ->url(
                        url: route('rentbooking.receipt', $BookingBooking->id),
                        shouldOpenUrlInNewTab: true
                    )
                )
                ->toArray();

        }else{
            return [];
        }



    }

    #[On('brikUnitSelected')]
    public function handlePropertySelected(string $brikUnitId): void
    {
        $this->brikUnitId = $brikUnitId;
        $this->refreshRecords();
    }



    public static function canView(): bool
    {
        return false;
    }
}
