<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use App\Models\BookingCoupon;
use Filament\Resources\Resource;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Section;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\DatePicker;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\BookingCouponResource\Pages;
use App\Filament\Admin\Resources\BookingCouponResource\RelationManagers;
use Filament\Tables\Columns\IconColumn;

class BookingCouponResource extends Resource
{
    protected static ?string $model = BookingCoupon::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'BOOKING';

    protected static ?string $modelLabel = 'Coupon';

    protected static ?string $pluralModelLabel = 'Coupons';

    protected static ?string $navigationLabel = 'Coupon';

    protected static ?int $navigationSort = 62;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([

                Section::make()->schema([

                    TextInput::make('code')
                    ->required()
                    ->unique(ignoreRecord: true),

                ])->columns(2),

                Section::make()->schema([

                    DatePicker::make('valid_from')
                    ->label('Coupon Valid From')
                    ->required(),

                    DatePicker::make('valid_to')
                    ->label('Coupon Valid To')
                    ->required(),

                ])->columns(2),

                Section::make()->schema([

                    DatePicker::make('booking_valid_from')
                    ->required(),

                    DatePicker::make('booking_valid_to')
                    ->required(),

                ])->columns(2),

                Section::make()->schema([

                    Select::make('discount_mode')
                    ->options([
                        "Rupee" => "Rupee",
                        "Percent" => "Percent",
                    ])
                    ->required(),

                    TextInput::make('value')
                    ->numeric()
                    ->inputMode('decimal')
                    ->required(),

                ])->columns(2),

                Section::make()->schema([

                    Toggle::make('active'),

                ])->columns(2),



            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(self::getModel()::query()->orderByDesc('updated_at'))
            ->columns([
                TextColumn::make('code')
                ->sortable()
                ->searchable(),

                TextColumn::make('valid_from')
                ->label('Coupon Valid From')
                ->date()
                ->sortable()
                ->searchable(),

                TextColumn::make('valid_to')
                ->label('Coupon Valid To')
                ->date()
                ->sortable()
                ->searchable(),

                TextColumn::make('booking_valid_from')
                ->date()
                ->sortable()
                ->searchable(),

                TextColumn::make('booking_valid_to')
                ->date()
                ->sortable()
                ->searchable(),

                TextColumn::make('discount_mode')
                ->sortable()
                ->searchable(),

                TextColumn::make('value')
                ->sortable()
                ->searchable(),

                IconColumn::make('active')
                ->boolean()

            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make(),
                ])
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBookingCoupons::route('/'),
            'create' => Pages\CreateBookingCoupon::route('/create'),
            'edit' => Pages\EditBookingCoupon::route('/{record}/edit'),
        ];
    }
}
