<?php

namespace App\Filament\Admin\Resources\BrikAnnualMaintenanceResource\Pages;

use Filament\Actions;
use App\Models\Client;
use App\Models\BrikOwner;
use Illuminate\Support\Facades\DB;
use App\Models\CashWalletTransaction;
use Filament\Resources\Pages\CreateRecord;
use App\Filament\Admin\Resources\BrikAnnualMaintenanceResource;

class CreateBrikAnnualMaintenance extends CreateRecord
{
    protected static string $resource = BrikAnnualMaintenanceResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    protected function afterCreate()
    {
        
        if($this->record->annual_maintenance_referal_discount)
		{

            $annual_maintenance_referal_discount = $this->record->annual_maintenance_referal_discount;

            $brik_owner = BrikOwner::find($this->record->brik_owner_id);

                if($brik_owner)
				{
					$client_id = $brik_owner->owner_id;

                    $owner = Client::find($client_id);

                    if($owner)
                    {
						$this->cashWalletTransactionAM($client_id, $this->record->id, $annual_maintenance_referal_discount);
                    }
                }
        }
    }

    protected function cashWalletTransactionAM($client_id, $annual_maintanance_id, $amount)
    {
        $qry = CashWalletTransaction::where('category', 'Annual Maintenance Referral Discount')
        ->where('client_id', $client_id)
        ->where('brik_annual_maintanance_id', $annual_maintanance_id);
        
        if($qry->count() > 0){
            
            $upd = CashWalletTransaction::find($qry->first()->id);
            $upd->amount = $amount;
            $upd->signed_amount = (-1) * $amount;
            $upd->save();

        }else{

            $ins = new CashWalletTransaction;
            $ins->brik_annual_maintanance_id = $annual_maintanance_id;
            $ins->category = 'Annual Maintenance Referral Discount';
            $ins->client_id = $client_id;
            $ins->amount = $amount;
            $ins->type = 'Debit';
            $ins->date = date("Y-m-d");
            $ins->signed_amount = (-1) * $amount;
            $ins->save();

        }

        return;
    }
}
