<?php

namespace App\Filament\Admin\Resources\BrikAnnualMaintenanceResource\Pages;

use Filament\Actions;
use App\Models\Client;
use App\Models\BrikOwner;
use Filament\Resources\Pages\EditRecord;
use App\Filament\Admin\Resources\BrikAnnualMaintenanceResource;
use App\Models\CashWalletTransaction;

class EditBrikAnnualMaintenance extends EditRecord
{
    protected static string $resource = BrikAnnualMaintenanceResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    public $old_referal_discount;
    public $curr_referal_discount;

    protected function beforeSave()
    {
        $this->old_referal_discount = is_null($this->record->annual_maintenance_referal_discount) ? 0 : (float)$this->record->annual_maintenance_referal_discount;
    }

    protected function afterSave()
    {
        $this->curr_referal_discount = is_null($this->record->annual_maintenance_referal_discount) ? 0 : (float)$this->record->annual_maintenance_referal_discount;

        $referal_discount_diff = $this->curr_referal_discount - $this->old_referal_discount;

        if($referal_discount_diff){

                $brik_owner = BrikOwner::find($this->record->brik_owner_id);

                if($brik_owner){

                    $owner = Client::find($brik_owner->owner_id);

                    if($owner){

                        $this->cashWalletTransactionAM($owner->id, $this->record->id, $this->record->annual_maintenance_referal_discount);
						$this->fillForm();
                        
                    }
                }
            
        }

    }

    protected function cashWalletTransactionAM($client_id, $annual_maintanance_id, $amount)
    {
        $qry = CashWalletTransaction::where('category', 'Annual Maintenance Referral Discount')
        ->where('client_id', $client_id)
        ->where('brik_annual_maintanance_id', $annual_maintanance_id);
        
        if($qry->count() > 0){
            
            $upd = CashWalletTransaction::find($qry->first()->id);
            $upd->amount = $amount;
            $upd->signed_amount = (-1) * $amount;
            $upd->save();

        }else{

            $ins = new CashWalletTransaction;
            $ins->brik_annual_maintanance_id = $annual_maintanance_id;
            $ins->category = 'Annual Maintenance Referral Discount';
            $ins->client_id = $client_id;
            $ins->amount = $amount;
            $ins->type = 'Debit';
            $ins->date = date("Y-m-d");
            $ins->signed_amount = (-1) * $amount;
            $ins->save();

        }

        return;
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }
}
