<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Get;
use Filament\Forms\Set;
use App\Models\BrikUnit;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Filament\Resources\Resource;
use App\Models\BrikConstuctionImage;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Section;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\FileUpload;
use Illuminate\Database\Eloquent\Builder;
use App\Actions\Utility\SelectDymanicNames;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\BrikConstuctionImageResource\Pages;
use App\Filament\Admin\Resources\BrikConstuctionImageResource\RelationManagers;

class BrikConstuctionImageResource extends Resource
{
    protected static ?string $model = BrikConstuctionImage::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'BRIK';

    protected static ?string $modelLabel = 'Construction Image';

    protected static ?string $pluralModelLabel = 'Construction Images';

    protected static ?string $navigationLabel = 'Construction Image';

    protected static ?int $navigationSort = 25;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
            Section::make()->schema([

                TextInput::make('tag')
                    ->default('Construction Update month - year')
                    ->required(),

                Select::make('brik_unit_id')
                    ->label('Brik Unit')
                    ->options(SelectDymanicNames::brikUnit())
                    ->required(),


                FileUpload::make('images')
                    ->image()
                    ->multiple()
                    ->directory('images/brik/construction'),
                    //->required(),

				FileUpload::make('pdfs')
                    ->label('Documents (in PDF)')
                    ->multiple()
                    ->directory('pdfs/brik/construction'),
                    //->required(),
            ])
        ])
        ->columns(1);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(self::getModel()::query()->orderByDesc('updated_at'))
            ->columns([
                TextColumn::make('tag')
                ->sortable()
                ->searchable(),

                TextColumn::make('unit.unit_name')
                ->sortable()
                ->searchable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make(),
                ])
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBrikConstuctionImages::route('/'),
            'create' => Pages\CreateBrikConstuctionImage::route('/create'),
            'edit' => Pages\EditBrikConstuctionImage::route('/{record}/edit'),
        ];
    }
}
