<?php

namespace App\Filament\Admin\Resources\BrikOwnerResource\Pages;

use Filament\Actions;
use App\Models\Client;
use App\Models\BrikOwner;
use App\Models\ReferralInsentive;
use App\Models\CashWalletTransaction;
use App\Models\CoinWalletTransaction;
use App\Actions\Utility\FinancialYear;
use App\Models\ReferralInsentiveConfig;
use Filament\Resources\Pages\CreateRecord;
use App\Filament\Admin\Resources\BrikOwnerResource;

class CreateBrikOwner extends CreateRecord
{
    protected static string $resource = BrikOwnerResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    //protected $owner_coins = 0;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // $this->owner_coins = $data["owner_coins_credited"] ?? 0; 

        $ownership = $this->getAutoOwnerNumber();
        $data['ownership_sq'] = $ownership['ownership_sq'];
        $data['ownership_number'] = $ownership['ownership_number'];

        return $data;
    }

    public function afterCreate()
    {
        if(!is_null($this->record->referrer_id))
        {
            if(is_null($this->record->referral_insentive_id))
            {

                $percent = 0;
                $incentiveConfig = ReferralInsentiveConfig::find(1);
                if($incentiveConfig){
                    $percent = $incentiveConfig->incentive_percent;
                }

                $incentive = 0;
                if($percent > 0){
                    $incentive = $this->record->invested_amount * ($percent / 100);
                }

                $ins = new ReferralInsentive;
                $ins->brik_owner_id = $this->record->id;
                $ins->referrer_id = $this->record->referrer_id;
                $ins->amount = $incentive;
                $ins->save();

                
                $this->cashWalletTransactionInsentive($ins->id, $ins->referrer_id, $ins->brik_owner_id, $ins->amount);
            }
        }
        
    }

    public function getAutoOwnerNumber()
    {
        $maxsq = BrikOwner::max('ownership_sq');
        $new_sq = $maxsq + 1;

        $prefix = 'BRK';
        $new_owner_number = $prefix.''.str_pad($new_sq, 5, '0', STR_PAD_LEFT);

        return [ 
            "ownership_sq" => $new_sq,
            "ownership_number" => $new_owner_number,
        ];

    }

    // public function calculateCoinsForOwner($total_coins, $buy_date)
    // {
    //     $permonthcoins = $total_coins / 12;

    //     $buy_datets = strtotime($buy_date);

    //     $buy_first_date = date("Y-m-01", strtotime($buy_date));

    //     $buy_first_datets = strtotime($buy_first_date);

    //     $buy_month = date('m', $buy_datets);

    //     if($buy_month <= 3)
	// 	{
	// 		$new_date = date("Y-03-31", $buy_datets);
    //         $new_datets = strtotime($new_date);
	// 	}
	// 	elseif($buy_month > 3)
	// 	{
	// 		$new_date = date("Y-03-31", strtotime("+1 year", $buy_datets));
    //         $new_datets = strtotime($new_date);
	// 	}

    //     $diffdays = round(($new_datets - $buy_first_datets) / (60 * 60 * 24));

    //     $month = round($diffdays/30);
        
       
    //     $date = date('d', $buy_datets);

       
    //     if((int)$date > 15){
    //         $month = $month - 0.5;
    //     }

    //     $coins = round($permonthcoins * $month);

    //     return $coins;
        
    // }

    protected function cashWalletTransactionInsentive($reffer_ins_id, $client_id, $brik_owner_id, $amount)
    {
        $qry = CashWalletTransaction::where('category', 'Referral Insentive')
        ->where('client_id', $client_id)
        ->where('brik_owner_id', $brik_owner_id)
        ->where('referral_insentive_id', $reffer_ins_id);
        
        if($qry->count() > 0){
            
            $upd = CashWalletTransaction::find($qry->first()->id);
            $upd->amount = $amount;
            $upd->signed_amount = $amount;
            $upd->save();

        }else{

            $ins = new CashWalletTransaction;
            $ins->referral_insentive_id = $reffer_ins_id;
            $ins->brik_owner_id = $brik_owner_id;
            $ins->category = 'Referral Insentive';
            $ins->client_id = $client_id;
            $ins->amount = $amount;
            $ins->type = 'Credit';
            $ins->date = date("Y-m-d");
            $ins->signed_amount = $amount;
            $ins->save();

        }

        return;
    }

    

}
