<?php

namespace App\Filament\Admin\Resources\BrikOwnerResource\Pages;

use Filament\Actions;
use App\Models\ReferralInsentive;
use App\Models\CashWalletTransaction;
use App\Models\ReferralInsentiveConfig;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\EditRecord;
use Illuminate\Contracts\Support\Htmlable;
use App\Actions\Utility\EditPageHeaderNames;
use App\Filament\Admin\Resources\BrikOwnerResource;

class EditBrikOwner extends EditRecord
{
    protected static string $resource = BrikOwnerResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    public function afterSave()
    {
        $this->addReferrer();
    }



    public function getTitle(): string | Htmlable
    {
        //return $this->record->select_name;
        return EditPageHeaderNames::brikowner($this->record->id);
    }

    protected function addReferrer()
    {

        if(!is_null($this->record->referrer_id))
        {
            if(is_null($this->record->referral_insentive_id))
            {

                    $percent = 0;
                    $incentiveConfig = ReferralInsentiveConfig::find(1);
                    if($incentiveConfig){
                        $percent = $incentiveConfig->incentive_percent;
                    }

                    $incentive = 0;
                    if($percent > 0){
                        $incentive = $this->record->invested_amount * ($percent / 100);
                    }

                    $refIns = ReferralInsentive::where('brik_owner_id', $this->record->id)->first();
                    //->where('referrer_id', $this->record->referrer_id)->first();

                    if($refIns){

                        if($refIns->referrer_id != $this->record->referrer_id){

                            $ins = ReferralInsentive::find($refIns->id);
                            $ins->referrer_id = $this->record->referrer_id;
                            $ins->amount = $incentive;
                            $ins->save();

                            $this->cashWalletTransactionInsentive($ins->id, $ins->referrer_id, $ins->brik_owner_id, $ins->amount);

                        }

                    }else{

                        $ins = new ReferralInsentive;
                        $ins->brik_owner_id = $this->record->id;
                        $ins->referrer_id = $this->record->referrer_id;
                        $ins->amount = $incentive;
                        $ins->save();

                        $this->cashWalletTransactionInsentive($ins->id, $ins->referrer_id, $ins->brik_owner_id, $ins->amount);

                    }

            }
        }
    }

    protected function cashWalletTransactionInsentive($reffer_ins_id, $client_id, $brik_owner_id, $amount)
    {
        $olds = CashWalletTransaction::where('category', 'Referral Insentive')
        ->where('client_id','!=' ,$client_id)
        ->where('brik_owner_id', $brik_owner_id)
        ->where('referral_insentive_id', $reffer_ins_id)
        ->get();

        foreach($olds as $old){

            $oldupd = CashWalletTransaction::find($old->id);
            $oldupd->amount = 0;
            $oldupd->signed_amount = 0;
            $oldupd->save();

        }



        $qry = CashWalletTransaction::where('category', 'Referral Insentive')
        ->where('client_id', $client_id)
        ->where('brik_owner_id', $brik_owner_id)
        ->where('referral_insentive_id', $reffer_ins_id);

        if($qry->count() > 0){

            $upd = CashWalletTransaction::find($qry->first()->id);
            $upd->amount = $amount;
            $upd->signed_amount = $amount;
            $upd->save();

        }else{

            $ins = new CashWalletTransaction;
            $ins->referral_insentive_id = $reffer_ins_id;
            $ins->brik_owner_id = $brik_owner_id;
            $ins->category = 'Referral Insentive';
            $ins->client_id = $client_id;
            $ins->amount = $amount;
            $ins->type = 'Credit';
            $ins->date = date("Y-m-d");
            $ins->signed_amount = $amount;
            $ins->save();

        }

        return;
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make()
             ->action(function ($record) {

                if ($record->childRecordCounts() > 0 ) {
                    Notification::make()
                        ->danger()
                        ->title('Brik Owner is in use')
                        ->body('Cannot delete this record because related records exist.')
                        ->send();

                        return;
                }

                Notification::make()
                        ->danger()
                        ->title('Deleted')
                        ->body('Deleted Brik Owner record.')
                        ->send();

                $record->delete();

                return redirect(BrikOwnerResource::getUrl('index'));
            }),
        ];
    }
}
