<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use App\Models\Client;
use Filament\Forms\Get;
use Filament\Forms\Set;
use Filament\Forms\Form;
use App\Models\BrikOwner;
use Filament\Tables\Table;
use App\Models\BrikInstallment;
use Filament\Resources\Resource;
use App\Models\BrikPaymentmyplan;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Textarea;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Notifications\Notification;
use Filament\Forms\Components\DatePicker;
use Illuminate\Database\Eloquent\Builder;
use App\Actions\Utility\SelectDymanicNames;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\BrikPaymentmyplanResource\Pages;
use App\Filament\Admin\Resources\BrikPaymentmyplanResource\RelationManagers;

class BrikPaymentmyplanResource extends Resource
{
    protected static ?string $model = BrikPaymentmyplan::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'BRIK OWNER';

    protected static ?string $modelLabel = 'Payment Plan';

    protected static ?string $pluralModelLabel = 'Payment Plans';

    protected static ?string $navigationLabel = 'Payment Plan';


    protected static ?int $navigationSort = 46;

    public static function form(Form $form): Form
    {
        return $form
        ->schema([
            Section::make()->schema([

               Select::make('brik_owner_id')
                ->live()
                ->label('Brik Owner')
                ->options(function(Get $get){
					//return BrikOwner::query()->pluck('select_name', 'id');
                    //brikowner_paymentplan($planid)
                    $owners = SelectDymanicNames::brikowner_paymentplan($get('id'));
                    return $owners;
                    // if (is_null($get('id'))) {
                    //     return BrikOwner::whereNull('paymentmyplan_id')->pluck('select_name', 'id');
                    // }else{
                    //     return BrikOwner::where('paymentmyplan_id', $get('id'))->pluck('select_name', 'id');
                    // }
                })

                ->afterStateUpdated(function(Set $set, $state, Get $get){
                    self::fillBrikOwnInfo($set, $state);
                })
                ->afterStateHydrated(function(Set $set, $state, Get $get){
                    self::fillBrikOwnInfo($set, $state);
                })
                ->searchable()
                ->required()
                ->columnSpanFull(),

               TextInput::make('brik_value')
                ->readOnly(),

               TextInput::make('invested_amount')
                ->numeric()
                ->inputMode('decimal'),

               TextInput::make('brik_count')
                ->numeric(),

               TextInput::make('booking_amount')
                ->label('Booking Amount (Without GST)')
                ->required()
                ->numeric()
                ->inputMode('decimal'),

               TextInput::make('discount_booking')
                ->label('Discount on Booking Amount')
                ->numeric()
                ->inputMode('decimal'),

               TextInput::make('booking_amount_paid')
                ->label('Booking Amount (With GST)')
                ->required()
                ->numeric()
                ->inputMode('decimal'),

               TextInput::make('booking_amount_balance')
                ->label('Balance Amount (Booking Amount)')
                ->numeric()
                ->inputMode('decimal'),

               DatePicker::make('payment_date')
               ->label('Payment Date (Booking Amount)'),

               TextInput::make('discount_brik')
               ->label('Discount on Brik Value')
               ->numeric()
               ->inputMode('decimal'),





            //   Section::make()->schema([

            //     TextInput::make('brik_sale_referal_discount')
            //     ->lte('wallet_current_balance')
            //     ->numeric()
            //     ->inputMode('decimal'),

            //     TextInput::make('wallet_current_balance')
            //     ->readonly()

            //   ])->columns(2),

            TextInput::make('no_of_installments')
                ->required()
                ->numeric(),

			Toggle::make('gst_paid')
               ->columnSpanFull(),

               // TextInput::make('plan_tenure')
                // ->label('Plan Tenure (In Months)')
                // ->numeric(),

               Textarea::make('disclaimer')
                ->columnSpanFull(),






            ])->columns(2),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(self::getModel()::query()->orderByDesc('updated_at'))
            ->columns([

                TextColumn::make('brik_owner.ownership_number')
				->label('Owner ID')
                ->sortable()
                ->searchable(),

				TextColumn::make('brik_owner.owner.print_name')
				->label('Owner Name')
                ->sortable()
                ->searchable(),

				TextColumn::make('brik_owner.owner.email')
				->label('Owner Email')
                ->sortable()
                ->searchable(),

				TextColumn::make('brik_owner.brik_unit.project.project_name')
				->label('Project')
                ->sortable()
                ->searchable(),

				TextColumn::make('brik_owner.brik_unit.unit_number')
				->label('Unit Number')
                ->sortable()
                ->searchable(),

                TextColumn::make('invested_amount')
                ->sortable()
                ->searchable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make()
					->action(function ($record) {

                        $brikinstcnt = BrikInstallment::where('payment_plan_id', $record->id)->where(function($query){
							$query->where('installment_paid', 1)
							->orWhere('active', 1);
						})->count();

                        if ($brikinstcnt > 0 ) {
                            Notification::make()
                                ->danger()
                                ->title('Payment Plan already has ACTIVE/PAID Installment.')
                                ->body('Cannot delete this record because related records exist.')
                                ->send();

                                return;
                        }

                        Notification::make()
                                ->danger()
                                ->title('Deleted')
                                ->body('Deleted Payment Plan record.')
                                ->send();

                        $upd = BrikOwner::find($record->brik_owner_id);
                        $upd->paymentmyplan_id = null;
                        $upd->save();

						BrikInstallment::where('payment_plan_id', $record->id)->delete();
                        $record->delete();
                    }),
                ])
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->paginated([10, 25, 50, 100]);
    }

    public static function getTable(Table $table): Table
    {
        return $table
            ->query(self::getModel()::query()->orderByDesc('created_at'));
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBrikPaymentmyplans::route('/'),
            'create' => Pages\CreateBrikPaymentmyplan::route('/create'),
            'edit' => Pages\EditBrikPaymentmyplan::route('/{record}/edit'),
        ];
    }

    public static function fillBrikOwnInfo(&$set, &$state)
    {
        $brik_owner = BrikOwner::with(['brik_unit'])->find($state);
        if($brik_owner){

            $set('invested_amount', $brik_owner->invested_amount);
            $set('brik_count', $brik_owner->ownership);
			$set('payment_date', $brik_owner->brik_buy_date);

            if($brik_owner->brik_unit){
                $set('brik_value', $brik_owner->brik_unit->brik_value);
                $discount_brik = ($brik_owner->brik_unit->brik_value - $brik_owner->invested_amount);
                $set('discount_brik', $discount_brik);
            }

        }
    }

    public static function getBrikValue(&$set, &$state)
    {
        $brik_value = 0;
        $brik_owner = BrikOwner::with(['brik_unit'])->find($state);
        if($brik_owner){
            if($brik_owner->brik_unit){
                $brik_value = $brik_owner->brik_unit->brik_value;
            }
        }
        $set('brik_value', $brik_value);
    }
}
