<?php

namespace App\Filament\Admin\Resources\BrikPaymentmyplanResource\Pages;

use Filament\Actions;
use App\Models\BrikOwner;
use App\Models\BrikInstallment;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\EditRecord;
use App\Filament\Admin\Resources\BrikPaymentmyplanResource;

class EditBrikPaymentmyplan extends EditRecord
{
    protected static string $resource = BrikPaymentmyplanResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make()
			->action(function ($record) {

                        $brikinstcnt = BrikInstallment::where('payment_plan_id', $record->id)->where(function($query){
							$query->where('installment_paid', 1)
							->orWhere('active', 1);
						})->count();
						
						
                       
                        if ($brikinstcnt > 0 ) {
                            Notification::make()
                                ->danger()
                                ->title('Payment Plan already has ACTIVE/PAID Installment.')
                                ->body('Cannot delete this record because related records exist.')
                                ->send();

                                return;
                        }

                        Notification::make()
                                ->danger()
                                ->title('Deleted')
                                ->body('Deleted Payment Plan record.')
                                ->send();

                        $upd = BrikOwner::find($record->brik_owner_id);
                        $upd->paymentmyplan_id = null;
                        $upd->save(); 

                        BrikInstallment::where('payment_plan_id', $record->id)->delete();

                        $record->delete();
						
						
						return redirect(BrikPaymentmyplanResource::getUrl('index'));
                    }),
        ];
    }
}
