<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Get;
use Filament\Forms\Set;
use App\Models\BrikCity;
use Filament\Forms\Form;
use App\Models\BrikState;
use Filament\Tables\Table;
use App\Models\BrikProject;
use Filament\Resources\Resource;
use Illuminate\Support\Collection;
use Filament\Forms\Components\Grid;
use Filament\Forms\Components\Tabs;
use Livewire\Component as Livewire;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Tabs\Tab;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Notifications\Notification;
use Illuminate\Database\Eloquent\Builder;
use Filament\Forms\Components\MarkdownEditor;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\BrikProjectResource\Pages;
use App\Filament\Admin\Resources\BrikProjectResource\RelationManagers;

class BrikProjectResource extends Resource
{
    protected static ?string $model = BrikProject::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $modelLabel = ' Project';

    protected static ?string $pluralModelLabel = 'Projects';

    protected static ?string $navigationGroup = 'BRIK';

    protected static ?string $navigationLabel = 'Project';

    protected static ?int $navigationSort = 21;

    public static function form(Form $form): Form
    {
        return $form
        ->schema([
                Section::make()
                    ->schema([
                        Tabs::make('Project Details')
                            ->columnSpan(2) // Ensures full width
                            ->tabs([
                                Tab::make('Investment')
                                    ->schema([
                                            TextInput::make('project_name')
                                                    ->required(),

                                            Select::make('projectManager')
                                                    ->relationship('projectManager', 'name'),


                                            MarkdownEditor::make('invest_description')
                                            ->label('Description')
                                            ->columnSpan(2),

                                    ])->columns(2),

                                Tab::make('Rental')
                                    ->schema([

                                        MarkdownEditor::make('rent_description')
                                        ->label('Description')
                                        ->columnSpan(2),

                                        Select::make('houseRule')
                                        ->relationship('houseRule', 'title'),

                                        Select::make('cancellationPolicy')
                                        ->relationship('cancellationPolicy', 'title'),

                                        Select::make('safetyAndProperty')
                                        ->relationship('safetyAndProperty', 'title'),

                                        Select::make('petsFriendly')
                                        ->relationship('petsFriendly', 'title'),

                                        Toggle::make('pets_allowed')->columnSpan(2),

                                    ])->columns(2),

                                Tab::make('Common')
                                    ->schema([

                                         TextInput::make('address')->required(),


                                        Select::make('state_id')
                                            ->label('State')
                                            ->options(BrikState::query()->pluck('name', 'id'))
                                            ->live()
                                            ->required(),

                                        Select::make('city_id')
                                            ->label('City')
                                            ->options(fn (Get $get): Collection => BrikCity::query()
                                                ->where('brik_state_id', $get('state_id'))
                                                ->pluck('name', 'id'))
											->required(),



                                        TextInput::make('pin'),

                                        TextInput::make('lat')->label('Latitude'),

                                        TextInput::make('lng')->label('Longitude'),
                                    ])->columns(2),
                            ]),
                    ])
                    ->columnSpanFull(), // Makes the whole section full width
            ])
            ->columns(1);


        // ->schema([
        //     Section::make()->schema([

        //         TextInput::make('project_name')->required(),

        //         Select::make('projectManager')->relationship('projectManager', 'name'),

        //         MarkdownEditor::make('description')->columnSpan(2),


        //     ])->columns(2),

        //     Section::make()->schema([

        //         TextInput::make('address')->required(),


        //         Select::make('state_id')
        //             ->label('State')
        //             ->options(BrikState::query()->pluck('name', 'id'))
        //             ->live()
        //             ->required(),

        //         Select::make('city_id')
        //             ->label('City')
        //             ->options(fn (Get $get): Collection => BrikCity::query()
        //                 ->where('brik_state_id', $get('state_id'))
        //                 ->pluck('name', 'id')),



        //         TextInput::make('pin'),

        //         TextInput::make('lat')->label('Latitude'),

        //         TextInput::make('lng')->label('Longitude'),


        //     ])->columns(2),

        //     Section::make()->schema([

        //         Select::make('houseRule')->relationship('houseRule', 'title'),

        //         Select::make('cancellationPolicy')->relationship('cancellationPolicy', 'title'),

        //         Select::make('safetyAndProperty')->relationship('safetyAndProperty', 'title'),

        //         Select::make('petsFriendly')->relationship('petsFriendly', 'title'),


        //     ])->columns(2),
        //     Section::make()->schema([


        //         Toggle::make('pets_allowed')


        //     ])->columns(3)
        // ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(self::getModel()::query()->orderByDesc('updated_at'))
            ->columns([

                TextColumn::make('project_name')
                ->sortable()
                ->searchable(),

                TextColumn::make('projectManager.name')
                ->sortable()
                ->searchable(),

                TextColumn::make('city.name')
                ->sortable()
                ->searchable()

            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make()
                    ->action(function ($record) {

                        if ($record->childRecordCounts() > 0 ) {
                            Notification::make()
                                ->danger()
                                ->title('Project is in use')
                                ->body('Cannot delete this record because related records exist.')
                                ->send();

                                return;
                        }

                        Notification::make()
                                ->danger()
                                ->title('Deleted')
                                ->body('Deleted Project record.')
                                ->send();

                        $record->delete();
                    }),
                ])
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->paginated([10, 25, 50, 100]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBrikProjects::route('/'),
            'create' => Pages\CreateBrikProject::route('/create'),
            'edit' => Pages\EditBrikProject::route('/{record}/edit'),
        ];
    }
}
