<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use App\Models\BrikPropertyType;
use Filament\Resources\Resource;
use Filament\Forms\Components\Section;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Notifications\Notification;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\BrikPropertyTypeResource\Pages;
use App\Filament\Admin\Resources\BrikPropertyTypeResource\RelationManagers;

class BrikPropertyTypeResource extends Resource
{
    protected static ?string $model = BrikPropertyType::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'MASTER';

    protected static ?string $modelLabel = 'Type';

    protected static ?string $pluralModelLabel = 'Types';

    protected static ?string $navigationLabel = 'Type';

    protected static ?int $navigationSort = 3;

    public static function form(Form $form): Form
    {
        return $form
        ->schema([
            Section::make()->schema([
                TextInput::make('name')->required()->unique(ignoreRecord: true),
                TextInput::make('complimentary_per_night_inr')
                ->label('Complimentary Per Nihgt INR')
                ->numeric(),
            ])
        ])
        ->columns(1);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(self::getModel()::query()->orderByDesc('updated_at'))
            ->columns([

                TextColumn::make('name')
                ->sortable()
                ->searchable(),

                TextColumn::make('complimentary_per_night_inr')
                ->label('Complimentary Per Nihgt INR')
                ->sortable()
                ->searchable(),


            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make()
                    ->action(function ($record) {

                        if ($record->childRecordCounts() > 0 ) {
                            Notification::make()
                                ->danger()
                                ->title('Type is in use')
                                ->body('Cannot delete this record because related records exist.')
                                ->send();

                                return;
                        }

                        Notification::make()
                                ->danger()
                                ->title('Deleted')
                                ->body('Deleted Type record.')
                                ->send();

                        $record->delete();

                    }),
                ])
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBrikPropertyTypes::route('/'),
            'create' => Pages\CreateBrikPropertyType::route('/create'),
            'edit' => Pages\EditBrikPropertyType::route('/{record}/edit'),
        ];
    }
}
