<?php

namespace App\Filament\Admin\Resources\BrikPropertyTypeResource\Pages;

use Filament\Actions;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\EditRecord;
use App\Filament\Admin\Resources\BrikPropertyTypeResource;

class EditBrikPropertyType extends EditRecord
{
    protected static string $resource = BrikPropertyTypeResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make()
            ->action(function ($record) {

                if ($record->childRecordCounts() > 0 ) {
                    Notification::make()
                        ->danger()
                        ->title('Type is in use')
                        ->body('Cannot delete this record because related records exist.')
                        ->send();

                        return;
                }

                Notification::make()
                        ->danger()
                        ->title('Deleted')
                        ->body('Deleted Type record.')
                        ->send();

                $record->delete();

                
                return redirect(BrikPropertyTypeResource::getUrl('index'));

            }),
        ];
    }
}
