<?php

namespace App\Filament\Admin\Resources\BrikSafetyandpropertyResource\Pages;

use Filament\Actions;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\EditRecord;
use App\Filament\Admin\Resources\BrikSafetyandpropertyResource;

class EditBrikSafetyandproperty extends EditRecord
{
    protected static string $resource = BrikSafetyandpropertyResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make()
            ->action(function ($record) {
                        
                if ($record->childRecordCounts() > 0 ) {
                    Notification::make()
                        ->danger()
                        ->title('Safty & Property is in use')
                        ->body('Cannot delete this record because related records exist.')
                        ->send();

                        return;
                }

                Notification::make()
                        ->danger()
                        ->title('Deleted')
                        ->body('Deleted Safty & Property record.')
                        ->send();

                $record->delete();

                return redirect(BrikSafetyandpropertyResource::getUrl('index'));
            }),
        ];
    }
}
