<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use App\Models\BrikState;
use Filament\Tables\Table;
use Filament\Resources\Resource;
use Filament\Forms\Components\Section;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Notifications\Notification;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\BrikStateResource\Pages;
use App\Filament\Admin\Resources\BrikStateResource\RelationManagers;

class BrikStateResource extends Resource
{
    protected static ?string $model = BrikState::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'MASTER';

    protected static ?string $modelLabel = 'State';
    
    protected static ?string $pluralModelLabel = 'States';

    protected static ?string $navigationLabel = 'State';

    protected static ?int $navigationSort = 4;

    public static function form(Form $form): Form
    {
        return $form
        ->schema([
            Section::make()->schema([
                TextInput::make('name')->required()->live(onBlur: true)->unique(ignoreRecord: true),
            ])
        ])
        ->columns(1);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(self::getModel()::query()->orderByDesc('updated_at'))
            ->columns([
                TextColumn::make('name')
                ->sortable()
                ->searchable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make()
                    ->action(function ($record) {

                        if ($record->childRecordCounts() > 0 ) {
                            Notification::make()
                                ->danger()
                                ->title('State is in use')
                                ->body('Cannot delete this record because related records exist.')
                                ->send();

                                return;
                        }

                        Notification::make()
                                ->danger()
                                ->title('Deleted')
                                ->body('Deleted state record.')
                                ->send();

                        $record->delete();

                    }),
                ])
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make()->action(function ($records) {
                        return self::bulkdelete($records);
                    }),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBrikStates::route('/'),
            'create' => Pages\CreateBrikState::route('/create'),
            'edit' => Pages\EditBrikState::route('/{record}/edit'),
        ];
    }

    public static function bulkdelete($records){
        $success = 0;
        $failed = 0;
        foreach($records as $record){
            if ($record->childRecordCounts() > 0 ) {
                $failed ++;
            }else{
                $success ++;
                $record->delete();
            }
        }

        
            Notification::make()
                ->danger()
                ->title("{$success} records deleted, {$failed} records not deleted.")
                ->body("{$success} records deleted, {$failed} records not deleted.")
                ->send();
        
    }
}
