<?php

namespace App\Filament\Admin\Resources;

use App\Models\Spv;
use Filament\Forms;
use Filament\Tables;
use Filament\Tables\Actions\ReplicateAction;
use Filament\Forms\Get;
use Filament\Forms\Set;
use App\Models\BrikBrik;
use App\Models\BrikUnit;
use Filament\Forms\Form;
use Filament\Tables\Table;
use App\Models\BrikProject;
use Filament\Resources\Resource;
use Illuminate\Support\Collection;
use Filament\Forms\Components\Tabs;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Tabs\Tab;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Filament\Notifications\Notification;
use Filament\Tables\Filters\SelectFilter;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\FileUpload;
use Illuminate\Database\Eloquent\Builder;
use App\Actions\Utility\SelectDymanicNames;
use Filament\Forms\Components\MarkdownEditor;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\BrikUnitResource\Pages;
use App\Filament\Admin\Resources\BrikUnitResource\RelationManagers;

class BrikUnitResource extends Resource
{
    protected static ?string $model = BrikUnit::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'BRIK';

    protected static ?string $modelLabel = 'Unit Number';

    protected static ?string $pluralModelLabel = 'Unit Numbers';

    protected static ?string $navigationLabel = 'Unit Number';

    protected static ?int $navigationSort = 24;

    public static function form(Form $form): Form
    {
        return $form
        ->schema([
            //Section::make()
               // ->schema([
                    Tabs::make('Project Details')
                        ->columnSpan(2) // Ensures full width
                        ->tabs([
                            Tab::make('Investment')
                                ->schema([


                                    Select::make('project_id')
                                        ->label('Project')
                                        ->options(function(){
                                            return BrikProject::query()->pluck('project_name', 'id');
                                        })
                                        ->live()
                                        ->disabledOn('edit')
                                        ->afterStateUpdated(function(Set $set, $state, Get $get){
                                            //if (is_null($get('id'))) {
                                                self::unsetUnitTypeValues($set, $state);
                                            //}
                                        })
                                        ->required(),

                                    Select::make('brik_id')
                                        ->label('Unit Type')
                                        ->required()
                                        ->live()
                                        ->disabledOn('edit')
                                        ->afterStateUpdated(function(Set $set, $state, Get $get){
                                            //if (is_null($get('id'))) {
                                                self::fillFromUnitType($set, $state);
                                            //}
                                        })
                                        ->options(
                                            function (Get $get){
                                            //   return  BrikBrik::query()->where('brik_project_id', $get('project_id'))
                                            //   ->pluck('brik_name', 'id');
                                            $briks = SelectDymanicNames::brik_project($get('project_id'));
                                            return $briks;

                                        }),


                                    Section::make()->schema([

                                        // Added Fields
                                        TextInput::make('property_area')->suffix('Sq ft'),

                                        //Select::make('brikManager')->relationship('brikManager', 'name'),

                                        TextInput::make('brik_value')->numeric()->inputMode('decimal')->required(),
                                        TextInput::make('capital_gain')->suffix('%'),
                                        TextInput::make('irr')->label('IRR')->suffix('%'),
                                        TextInput::make('pe_ratio')->label('PE Ratio')->numeric(),

                                        TextInput::make('per_night_coin')->label('Per night Coin')->numeric()->required(),
                                        TextInput::make('total_coins_per_brik')->label('Total coins per brik')->numeric(),

                                    // End Added Fields
                                    ])->columns(2),

                                    Select::make('spv_id')
                                    ->label('Spv')
                                    ->options(Spv::query()->pluck('spv_name', 'id'))
                                    ->live()
                                    ->required(),

                                    Select::make('possession')
                                        ->live()
                                        ->options([
                                            "Possession Date" => "Possession Date",
                                            "Ready To Move" => "Ready To Move"
                                        ]),

                                    DatePicker::make('date_of_possession')
                                    ->required()
                                    ->hidden(fn (Get $get): bool => $get('possession') != 'Possession Date'),



                                    FileUpload::make('invest_cover_image')
                                    ->label('Cover Image')
                                    ->image()
                                    ->directory('images/brik')
                                    ->imageEditor()
                                    ->columnSpan(2),

                                    FileUpload::make('invest_gallery_images')
                                    ->label('Gallery Images')
                                    ->image()
                                    ->multiple()
                                    ->directory('images/brik')
                                    ->columnSpan(2),

									FileUpload::make('allotment_letter_file')
									->label('Allotment letter Upload')
									->rules(['mimes:pdf', 'max:10000'])
									->directory('documents/brik_unit/allotment_letter'),

									FileUpload::make('registry_file')
									->label('Registry Copy Upload')
									->rules(['mimes:pdf', 'max:10000'])
									->directory('documents/spv/tan'),

                                    Toggle::make('invest_active')
                                    ->label('Live')
                                    ->live()
                                    ->columnSpan(1),

                                    Section::make()->schema([

                                        DatePicker::make('go_live_date')
                                        ->required(fn (Get $get): bool => $get('invest_active'))


                                    ])
                                    ->hidden(fn (Get $get): bool => !$get('invest_active'))
                                    ->columns(2),


                                ])->columns(2),

                            Tab::make('Rental')
                                ->schema([

                                    Section::make()->schema([

                                        TextInput::make('ru_property_id')
                                        ->label('RU Property ID')

                                        ->numeric(),

                                    ])->columns(2),

                                    TextInput::make('booking_portal_display_name'),
									
									MarkdownEditor::make('rent_description')
                                        ->label('Description')
                                        ->columnSpan(2),

									TextInput::make('per_night_inr')
									->label('Per night INR')
									->live()
									->numeric()
									->inputMode('decimal')
									->required(function(Get $get){
										if($get('rent_active')){
											return true;
										}else{
											return false;
										}
									}),

                                    TextInput::make('property_view'),
									
									TextInput::make('gst_percent')
                                     ->numeric()
                                     ->default(18)
                                     ->suffix('%')
                                     ->required(function(Get $get){
										if($get('rent_active')){
											return true;
										}else{
											return false;
										}
									}),

                                    FileUpload::make('rent_cover_image')
                                    ->label('Cover Image')
                                    ->image()
                                    ->directory('images/brik')
                                    ->imageEditor()
                                    ->columnSpan(2),

                                    FileUpload::make('rent_gallery_images')
                                    ->label('Gallery Images')
                                    ->image()
                                    ->multiple()
                                    ->directory('images/brik')
                                    ->columnSpan(2),

                                    Toggle::make('newly_launched'),
                                    Toggle::make('managed_property'),


                                    Toggle::make('rent_active')->live()->label('Active')->columnSpan(1)


                                ])->columns(2),

                            Tab::make('Common')
                                ->schema([

                                    TextInput::make('unit_number')->required(),
                                    TextInput::make('property_view'),

                                    FileUpload::make('property_video')
                                    ->rules(['mimes:mp4,mov,ogg,qt', 'max:20000'])
                                    ->directory('videos/spv/property_videos'),

                                    FileUpload::make('view_360')
                                    ->rules(['mimes:mp4,mov,ogg,qt', 'max:20000'])
                                    ->directory('videos/spv/view_360'),


                                ])->columns(2),
                        ]),
                // ])
                // ->columnSpanFull(),
        ])
        ->columns(1);
        // ->schema([
        //     Section::make()->schema([

        //         Select::make('project_id')
        //             ->label('Project')
        //             ->options(BrikProject::query()->pluck('project_name', 'id'))
        //             ->live()
        //             ->required(),

        //         Select::make('brik_id')
        //             ->label('Unit Type')
        //             ->required()
        //             ->options(fn (Get $get): Collection => BrikBrik::query()
        //                 ->where('brik_project_id', $get('project_id'))
        //                 ->pluck('brik_name', 'id')),

        //         TextInput::make('unit_number')->required(),


        //     ])->columns(3),

        //     Section::make()->schema([


        //         TextInput::make('booking_portal_display_name')->required(),
        //         TextInput::make('property_view'),

        //         Select::make('possession')
        //         ->live()
        //         ->options([
        //             "Possession Date" => "Possession Date",
        //             "Ready To Move" => "Ready To Move"
        //         ]),

        //         DatePicker::make('date_of_possession')
        //         ->required()
        //         ->hidden(fn (Get $get): bool => $get('possession') != 'Possession Date'),


        //     ])->columns(2),
        //     Section::make()->schema([

        //         FileUpload::make('spv_cover_image')
        //             ->label('Cover image')
        //             ->image()
        //             ->directory('images/spv/cover_images'),

        //         FileUpload::make('property_video')
        //             ->rules(['mimes:mp4,mov,ogg,qt', 'max:20000'])
        //             ->directory('videos/spv/property_videos'),

        //         FileUpload::make('view_360')
        //             ->rules(['mimes:mp4,mov,ogg,qt', 'max:20000'])
        //             ->directory('videos/spv/view_360')
        //             ->columnSpan(2)


        //     ])->columns(2),
        //     Section::make()->schema([

        //         Toggle::make('newly_launched'),
        //         Toggle::make('managed_property')

        //     ])->columns(3),
        //     Section::make()->schema([

        //         Toggle::make('active')

        //     ])->columns(3)
        // ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(self::getModel()::query()->orderByDesc('updated_at'))
            ->columns([

                TextColumn::make('project.project_name')
                ->sortable()
                ->searchable(),

				TextColumn::make('brik.propertyType.name')
				->label('type')
                ->sortable()
                ->searchable(),

				TextColumn::make('brik.type.name')
				->label('Category')
                ->sortable()
                ->searchable(),

                // TextColumn::make('brik.property_name')
				// ->label('Unit Type')
                // ->sortable()
                // ->searchable(),



                // TextColumn::make('unit_name')
				// ->label('Unit No.')
                // ->sortable()
                // ->searchable(),

                TextColumn::make('unit_number')
                ->sortable()
                ->searchable(),

				 TextColumn::make('spv.spv_name')
                ->sortable()
                ->searchable(),

				 TextColumn::make('booking_portal_display_name')
                ->searchable(),

            ])
            ->filters([

                SelectFilter::make('project_id')
                ->label('Project')
                ->options(BrikProject::all()->pluck('project_name', 'id'))
                ->multiple(),

                SelectFilter::make('brik.propertyType')
                ->label('Type')
                ->relationship('brik.propertyType', 'name'),

                SelectFilter::make('brik.type')
                ->label('Category')
                ->relationship('brik.type', 'name'),

                SelectFilter::make('spv_id')
                ->label('SPV')
                ->options(Spv::all()->pluck('spv_name', 'id')),

            ])
            ->actions([
               Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make()
                    ->action(function ($record) {

                        if ($record->childRecordCounts() > 0 ) {
                            Notification::make()
                                ->danger()
                                ->title('Brik Unit is in use')
                                ->body('Cannot delete this record because related records exist.')
                                ->send();

                                return;
                        }

                        Notification::make()
                                ->danger()
                                ->title('Deleted')
                                ->body('Deleted Brik Unit record.')
                                ->send();

                        $record->delete();
                    }),
					ReplicateAction::make(),
                ])
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->paginated([10, 25, 50, 100]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBrikUnits::route('/'),
            'create' => Pages\CreateBrikUnit::route('/create'),
            'edit' => Pages\EditBrikUnit::route('/{record}/edit'),
        ];
    }

    public static function fillFromUnitType(&$set, &$state)
    {
        $brik = BrikBrik::find($state);
        $property_area = $brik ? $brik->property_area : '';
        $brik_value = $brik ? $brik->brik_value : '';
        $capital_gain = $brik ? $brik->capital_gain : '';
        $irr = $brik ? $brik->irr : '';
        $pe_ratio = $brik ? $brik->pe_ratio : '';
        $per_night_coin = $brik ? $brik->per_night_coin : '';
        $total_coins_per_brik = $brik ? $brik->total_coins_per_brik : '';
        $per_night_inr = $brik ? $brik->per_night_inr : '';
        $set('property_area', $property_area);
        $set('brik_value', $brik_value);
        $set('capital_gain', $capital_gain);
        $set('irr', $irr);
        $set('pe_ratio', $pe_ratio);
        $set('per_night_coin', $per_night_coin);
        $set('total_coins_per_brik', $total_coins_per_brik);
        $set('per_night_inr', $per_night_inr);
    }

    public static function unsetUnitTypeValues(&$set, &$state)
    {
        $set('brik_id', '');
        $set('property_area', '');
        $set('brik_value', '');
        $set('capital_gain', '');
        $set('irr', '');
        $set('pe_ratio', '');
        $set('per_night_coin', '');
        $set('total_coins_per_brik', '');
        $set('per_night_inr', '');
    }
}
