<?php

namespace App\Filament\Admin\Resources\BrikUnitResource\Pages;

use Filament\Actions;
use App\Models\BrikBrik;
use App\Models\BrikUnit;
use App\Models\BrikProject;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\EditRecord;
use Illuminate\Contracts\Support\Htmlable;
use App\Actions\Utility\EditPageHeaderNames;
use App\Filament\Admin\Resources\BrikUnitResource;

class EditBrikUnit extends EditRecord
{
    protected static string $resource = BrikUnitResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    public function getTitle(): string | Htmlable
    {
        return EditPageHeaderNames::brikUnit($this->record->id);
        //return $this->record->unit_name;
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        if(array_key_exists("brik_id",$data)){
            $brik = BrikBrik::find($data['brik_id']);
            if($brik){
                $data['unit_name'] = $brik->brik_name.' - '.$data['unit_number']; 
            }else{
                $data['unit_name'] = $data['unit_number'];
            }
        }
        
        return $data;
    }

    protected function afterSave()
    {
        $brik = BrikBrik::find($this->record->brik_id);
        $project = BrikProject::find($this->record->project_id);
        BrikUnit::where('id', $this->record->id)->update([
            "city_id" => $project->city_id,
            "adults_capacity" => $brik->adults_capacity,
            "children_capacity" => $brik->children_capacity,
            "infent_capacity" => $brik->infent_capacity,
            "pet_capacity" => $brik->pet_capacity,
        ]);
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make()
            ->action(function ($record) {
                        
                if ($record->childRecordCounts() > 0 ) {
                    Notification::make()
                        ->danger()
                        ->title('Brik Unit is in use')
                        ->body('Cannot delete this record because related records exist.')
                        ->send();

                        return;
                }

                Notification::make()
                        ->danger()
                        ->title('Deleted')
                        ->body('Deleted Brik Unit record.')
                        ->send();

                $record->delete();
				
				return redirect(BrikUnitResource::getUrl('index'));
            }),
        ];
    }
}
