<?php

namespace App\Filament\Admin\Resources;

use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use Filament\Tables\Table;
use App\Models\BrikittPage;
use Filament\Resources\Resource;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Textarea;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\TextInput;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\BrikittPageResource\Pages;
use App\Filament\Admin\Resources\BrikittPageResource\RelationManagers;

class BrikittPageResource extends Resource
{
    protected static ?string $model = BrikittPage::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationGroup = 'INVESTMENT PORTAL CMS';

    protected static ?string $modelLabel = 'SEO Page';

    protected static ?string $pluralModelLabel = 'SEO Pages';

    protected static ?string $navigationLabel = 'SEO Page';

    protected static ?int $navigationSort = 51;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make('SEO Meta Tags')
                        ->schema([
                            TextInput::make('page_uri')
                            ->unique()
                            ->required()
                            ->prefix(env('FRONTEND_APP_URL')),

                            TextInput::make('meta_title'),
                            TextInput::make('meta_author'),
                            Textarea::make('meta_description'),
                            Textarea::make('meta_keywords'),
                            TextInput::make('meta_og_locale'),
                            TextInput::make('meta_og_type'),
                            TextInput::make('meta_og_title'),
                            Textarea::make('meta_og_description'),

                            TextInput::make('meta_og_url')
                            ->prefix(env('FRONTEND_APP_URL')),

                            TextInput::make('meta_og_site_name'),

                            TextInput::make('meta_og_image')
                            ->prefix(env('FRONTEND_APP_URL')),

                            TextInput::make('meta_og_image_secure_url')
                            ->prefix(env('FRONTEND_APP_URL')),

                            TextInput::make('meta_og_image_width'),
                            TextInput::make('meta_og_image_height'),
                            TextInput::make('meta_og_image_alt'),
                            TextInput::make('meta_og_image_type'),
                            TextInput::make('meta_article_publisher'),
                            TextInput::make('meta_twitter_card'),
                            TextInput::make('meta_twitter_title'),
                            Textarea::make('meta_twitter_description'),

                            TextInput::make('meta_twitter_site')
                            ->prefix(env('FRONTEND_APP_URL')),

                            TextInput::make('meta_twitter_creator'),

                            TextInput::make('meta_twitter_image')
                            ->prefix(env('FRONTEND_APP_URL')),

                        ])
                        ->columnSpan(2)
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([

                TextColumn::make('page_uri')
                ->searchable(),

            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBrikittPages::route('/'),
            'create' => Pages\CreateBrikittPage::route('/create'),
            'edit' => Pages\EditBrikittPage::route('/{record}/edit'),
        ];
    }
}
