<?php

namespace App\Filament\Admin\Resources\InvestBlogResource\Pages;

use App\Filament\Admin\Resources\InvestBlogResource;
use App\Models\InvestMetadataBlog;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;

class CreateInvestBlog extends CreateRecord
{
    protected static string $resource = InvestBlogResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    public function afterCreate()
    {
        $record = [
            'invest_blog_id' => $this->record->id,
            'meta_title' => $this->record->title,
            'meta_author' => 'Brikitt',
            'meta_description' =>  null,
            'meta_keywords' => null,
            'meta_og_locale' => 'en_US',
            'meta_og_type' => 'article',
            'meta_og_title' => $this->record->title,
            'meta_og_description' => null,
            'meta_og_url' => env("FRONTEND_APP_URL").$this->record->slug,
            'meta_og_site_name' => 'Brikitt',
            'meta_og_image' => env("APP_URL").'storage/'.$this->record->image,
            'meta_og_image_secure_url' => env("APP_URL").'storage/'.$this->record->image,
            'meta_og_image_width' => 420,
            'meta_og_image_height' => 320,
            'meta_og_image_alt' => 'Holiday Home',
            'meta_og_image_type' => null,
            'meta_article_publisher' => 'https://www.facebook.com/brikitt',
            'meta_twitter_card' => 'Holiday Home',
            'meta_twitter_title' => $this->record->title,
            'meta_twitter_description' => null,
            'meta_twitter_site' => env("FRONTEND_APP_URL").'projects/'.$this->record->slug,
            'meta_twitter_creator' => '@brik_itt',
            'meta_twitter_image' => env("APP_URL").'storage/'.$this->record->image,
        ];

        InvestMetadataBlog::create($record);


    }
}
