<?php

namespace App\Filament\Admin\Resources\InvestPropertyDetailResource\Pages;

use Filament\Actions;
use App\Models\BrikBrik;
use App\Models\BrikProject;
use Filament\Resources\Pages\EditRecord;
use App\Models\InvestPropertyMetadataDetail;
use App\Filament\Admin\Resources\InvestPropertyDetailResource;

class EditInvestPropertyDetail extends EditRecord
{
    protected static string $resource = InvestPropertyDetailResource::class;

    protected function getRedirectUrl(): string
    {
         return static::getResource()::getUrl('index');
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }

    public function afterSave()
    {
	    //dd($this->record);
        $project = BrikProject::find($this->record->brik_project_id);
        $brik = BrikBrik::find($this->record->brik_id);

        $image_mime = null;
        if($this->record->cover_image)
        {
            try
            {
                $image_mime = mime_content_type(env("APP_URL").'storage/'.$this->record->cover_image);
            }catch(\Exception $e){

            }

        }




        $record = [
            'invest_property_detail_id' => $this->record->id,
            'meta_title' => $this->record->invest_portal_display_name,
            'meta_author' => 'Brikitt',
            'meta_description' => $project ? $project->invest_description : null,
            'meta_keywords' => null,
            'meta_og_locale' => 'en_US',
            'meta_og_type' => 'article',
            'meta_og_title' => $this->record->invest_portal_display_name,
            'meta_og_description' => $project ? $project->invest_description : null,
            'meta_og_url' => env("FRONTEND_APP_URL").'projects/'.$this->record->slug,
            'meta_og_site_name' => 'Brikitt',
            'meta_og_image' => env("APP_URL").'storage/'.$this->record->cover_image,
            'meta_og_image_secure_url' => env("APP_URL").'storage/'.$this->record->cover_image,
            'meta_og_image_width' => 420,
            'meta_og_image_height' => 320,
            'meta_og_image_alt' => 'Holiday Home',
            'meta_og_image_type' => $image_mime ? $image_mime : null,
            'meta_article_publisher' => 'https://www.facebook.com/brikitt',
            'meta_twitter_card' => 'Holiday Home',
            'meta_twitter_title' => $this->record->invest_portal_display_name,
            'meta_twitter_description' => $project ? $project->invest_description : null,
            'meta_twitter_site' => env("FRONTEND_APP_URL").'projects/'.$this->record->slug,
            'meta_twitter_creator' => '@brik_itt',
            'meta_twitter_image' => env("APP_URL").'storage/'.$this->record->cover_image,
        ];

		if(InvestPropertyMetadataDetail::where('invest_property_detail_id', $this->record->id)->count() === 0){

              InvestPropertyMetadataDetail::create($record);

		}

    }
}
