<?php

namespace App\Filament\Admin\Resources\InvestPropertyDetailResource\Pages;

use Filament\Forms;
use Filament\Tables;
use Filament\Actions;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Filament\Resources\Pages\Page;
use App\Models\InvestPropertyDetail;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Notifications\Notification;
use Illuminate\Database\Eloquent\Builder;
use App\Models\InvestPropertyMetadataDetail;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Admin\Resources\InvestPropertyDetailResource;

class EditInvestPropertyMetadata extends Page
{
    protected static string $resource = InvestPropertyDetailResource::class;

    //protected static string $slug = 'edit-relation/{recordId}';


    protected static string $view = 'filament.admin.resources.invest-property-detail-resource.pages.editmetadata';

    public $record;
    public $relatedRecordId;
    public InvestPropertyMetadataDetail $relatedRecord;

    public $meta_title;
    public $meta_author;
    public $meta_description;
    public $meta_keywords;
    public $meta_og_locale;
    public $meta_og_type;
    public $meta_og_title;
    public $meta_og_description;
    public $meta_og_url;
    public $meta_og_site_name;
    public $meta_og_image;
    public $meta_og_image_secure_url;
    public $meta_og_image_width;
    public $meta_og_image_height;
    public $meta_og_image_alt;
    public $meta_og_image_type;
    public $meta_article_publisher;
    public $meta_twitter_card;
    public $meta_twitter_title;
    public $meta_twitter_description;
    public $meta_twitter_site;
    public $meta_twitter_creator;
    public $meta_twitter_image;



    public function mount($record)
    {
        $this->record = $record;
        //dd($this->record);
        $this->relatedRecord = InvestPropertyDetail::findOrFail($record)->invest_metadata;
        $this->form->fill($this->relatedRecord->toArray());
    }

    protected function getFormSchema(): array
    {
        return [
            Section::make('SEO Meta Tags')
                        ->schema([

                            TextInput::make('meta_title'),
                            TextInput::make('meta_author'),
                            Textarea::make('meta_description'),
                            Textarea::make('meta_keywords'),
                            TextInput::make('meta_og_locale'),
                            TextInput::make('meta_og_type'),
                            TextInput::make('meta_og_title'),
                            Textarea::make('meta_og_description'),
                            TextInput::make('meta_og_url'),
                            TextInput::make('meta_og_site_name'),
                            TextInput::make('meta_og_image'),
                            TextInput::make('meta_og_image_secure_url'),
                            TextInput::make('meta_og_image_width'),
                            TextInput::make('meta_og_image_height'),
                            TextInput::make('meta_og_image_alt'),
                            TextInput::make('meta_og_image_type'),
                            TextInput::make('meta_article_publisher'),
                            TextInput::make('meta_twitter_card'),
                            TextInput::make('meta_twitter_title'),
                            Textarea::make('meta_twitter_description'),
                            TextInput::make('meta_twitter_site'),
                            TextInput::make('meta_twitter_creator'),
                            TextInput::make('meta_twitter_image'),

                        ])
                        ->columnSpan(2)
        ];
    }

    public function submit()
    {
        $this->relatedRecord->fill($this->form->getState())->save();

        Notification::make()
            ->success()
            ->title('Saved')
            ->body('Property metadata saved successfully.')
            ->send();

        return redirect(static::getResource()::getUrl('index'));
    }


// public static function getUrl($parameters = []): string
// {
//     return static::getResource()::getUrl('edit-relation', $parameters);
// }
}
